unit Inface;
{
  Inface component unit for Digital Signal Analyser
  Researched and Developed by Boo Khan Ming

  E-mail: bookm@tm.net.my
  WWW:    http://come.to/khanming
}

interface

const
  ResetRegister=$06;
  ReadDataRegister=$0a;
  WriteCommandRegister=$0c;
  WriteBufferRegister=$0c;
  DataAvailableRegister=$0e;

  ChannelRegister=$02;
  MasterRegister=$22;
  VoiceRegister=$04;
  MIDIRegister=$26;
  CDRegister=$28;
  LineRegister=$2e;
  MicRegister=$0a;

var
  MasterSignal,SlaveSignal:boolean;

function AutoDetectSoundCard(var BasePort:word):boolean;
procedure ResetDSP;
procedure OutputDataDSP(Data:byte);
function InputDataDSP:byte;
procedure CheckDSPVersion(var Major,Minor:byte);
function CheckSoundCardType:string;

procedure NewTimerHandler; interrupt;
procedure ChangeTimerFrequency(Frequency:word);
procedure StartTimerHandler(NewInterruptVector:pointer;Frequency:word);
procedure RestoreTimerHandler;

procedure ResetVolumeSettings;
procedure ChangeMasterVolume(Left,Right:byte);
procedure ChangeVoiceVolume(Left,Right:byte);
procedure ChangeMIDIVolume(Left,Right:byte);
procedure ChangeCDVolume(Left,Right:byte);
procedure ChangeLineVolume(Left,Right:byte);
procedure ChangeMicVolume(Balance:byte);
procedure CheckMasterVolume(var Left,Right:byte);
procedure CheckVoiceVolume(var Left,Right:byte);
procedure CheckMIDIVolume(var Left,Right:byte);
procedure CheckCDVolume(var Left,Right:byte);
procedure CheckLineVolume(var Left,Right:byte);
procedure CheckMicVolume(var Balance:byte);


implementation

uses DOS;

const
  TemporaryInterruptVector=100;

var
  Counter:word;
  SoundCardBasePort:word;

function AutoDetectSoundCard(var BasePort:word):boolean;
const
  RetryTime1=10;
  RetryTime2=100;

var
  Counter1,Counter2:word;
  Found:boolean;

begin
  BasePort:=$210;
  Found:=False;
  Counter1:=RetryTime1;

  while (BasePort<=$260) and (not Found) do
  begin
    Port[BasePort+ResetRegister]:=1;
    Port[BasePort+ResetRegister]:=0;

    while (Counter2>RetryTime2) and (Port[BasePort+DataAvailableRegister]<128) do
      Dec(Counter2);

    if (Counter2=0) or (Port[BasePort+$a]<>$aa) then
    begin
      Dec(Counter1);

      if Counter1=0 then
      begin
        Counter1:=RetryTime1;
        BasePort:=BasePort+$10;
      end;
    end
    else
    begin
      Found:=True;
      SoundCardBasePort:=BasePort;
    end;
  end;

  AutoDetectSoundCard:=Found;
end;

procedure ResetDSP;
begin
  Port[SoundCardBasePort+ResetRegister]:=1;
  Port[SoundCardBasePort+ResetRegister]:=0;

  while (Port[SoundCardBasePort+DataAvailableRegister] and 128)=0 do;
  while not (Port[SoundCardBasePort+ReadDataRegister]=$aa) do;
end;

procedure OutputDataDSP(Data:byte);
begin
  while (Port[SoundCardBasePort+WriteBufferRegister] and 128)<>0 do;
  Port[SoundCardBasePort+WriteCommandRegister]:=Data;
end;

function InputDataDSP:byte;
begin
  while (Port[SoundCardBasePort+DataAvailableRegister] and 128)=0 do;
  InputDataDSP:=Port[SoundCardBasePort+ReadDataRegister];
end;

procedure CheckDSPVersion(var Major,Minor:byte);
begin
  OutputDataDSP($e1);
  Major:=InputDataDSP;
  Minor:=InputDataDSP;
end;

function CheckSoundCardType:string;
var
  Major,Minor:byte;

begin
  CheckDSPVersion(Major,Minor);

  case Major of
    1:CheckSoundCardType:='Sound Blaster';
    2:CheckSoundCardType:='Sound Blaster 2.x';
    3:CheckSoundCardType:='Sound Blaster Pro';
    4:CheckSoundCardType:='Sound Blaster 16';
    else
      CheckSoundCardType:='Sound Blaster 16 or newer';
  end;
end;

procedure ChangeTimerFrequency(Frequency:word);
var
  Counter:word;

begin
  Inline($fa);
  Counter:=1193180 div Frequency;

  Port[$43]:=$36;
  Port[$40]:=Lo(Counter);
  Port[$40]:=Hi(Counter);

  Inline($fb);
end;

procedure StartTimerHandler(NewInterruptVector:pointer;Frequency:word);
var
  OldInterruptVector:pointer;

begin
  Inline($fa);

  GetIntVec(8,OldInterruptVector);
  SetIntVec(TemporaryInterruptVector,OldInterruptVector);
  SetIntVec(8,NewInterruptVector);

  ChangeTimerFrequency(Frequency);

  Inline($fb);
end;

procedure RestoreTimerHandler;
var
  OldInterruptVector:pointer;

begin
  Inline($fa);

  Port[$43]:=$36;
  Port[$40]:=0;
  Port[$40]:=0;

  GetIntVec(TemporaryInterruptVector,OldInterruptVector);
  SetIntVec(8,OldInterruptVector);

  Inline($fb);
end;

procedure NewTimerHandler; {interrupt;}
var
  Register:Registers;

begin
  Dec(Counter);
  if Counter=0 then
  begin
    Intr(TemporaryInterruptVector,Register);
    Counter:=100 div 18;
  end
  else
    Port[$20]:=$20;

  MasterSignal:=not MasterSignal;
end;

procedure ResetVolumeSettings;
begin
  Port[SoundCardBasePort+$04]:=0;
  Port[SoundCardBasePort+$05]:=0;
end;

procedure ChangeVolumeSettings(Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=ChannelRegister;
  Port[SoundCardBasePort+$05]:=(Left shl 4)+Right;
end;

procedure ChangeMasterVolume(Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=MasterRegister;
  Port[SoundCardBasePort+$05]:=(Left shl 4)+Right;
end;

procedure ChangeVoiceVolume(Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=VoiceRegister;
  Port[SoundCardBasePort+$05]:=(Left shl 4)+Right;
end;

procedure ChangeMIDIVolume(Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=MIDIRegister;
  Port[SoundCardBasePort+$05]:=(Left shl 4)+Right;
end;

procedure ChangeCDVolume(Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=CDRegister;
  Port[SoundCardBasePort+$05]:=(Left shl 4)+Right;
end;

procedure ChangeLineVolume(Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=LineRegister;
  Port[SoundCardBasePort+$05]:=(Left shl 4)+Right;
end;

procedure ChangeMicVolume(Balance:byte);
begin
  Port[SoundCardBasePort+$04]:=MicRegister;
  Port[SoundCardBasePort+$05]:=Balance;
end;

procedure CheckMasterVolume(var Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=MasterRegister;
  Left:=(Port[SoundCardBasePort+$05] and $f0) shr 4;
  Right:=Port[SoundCardBasePort+$05] and $0f;
end;

procedure CheckVoiceVolume(var Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=VoiceRegister;
  Left:=(Port[SoundCardBasePort+$05] and $f0) shr 4;
  Right:=Port[SoundCardBasePort+$05] and $0f;
end;

procedure CheckMIDIVolume(var Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=MIDIRegister;
  Left:=(Port[SoundCardBasePort+$05] and $f0) shr 4;
  Right:=Port[SoundCardBasePort+$05] and $0f;
end;

procedure CheckCDVolume(var Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=CDRegister;
  Left:=(Port[SoundCardBasePort+$05] and $f0) shr 4;
  Right:=Port[SoundCardBasePort+$05] and $0f;
end;

procedure CheckLineVolume(var Left,Right:byte);
begin
  Port[SoundCardBasePort+$04]:=LineRegister;
  Left:=(Port[SoundCardBasePort+$05] and $f0) shr 4;
  Right:=Port[SoundCardBasePort+$05] and $0f;
end;

procedure CheckMicVolume(var Balance:byte);
begin
  Port[SoundCardBasePort+$04]:=MicRegister;
  Balance:=Port[SoundCardBasePort+$05];
end;

begin
  SoundCardBasePort:=$220;
end.