unit Error;
{
  Error component unit for Digital Signal Analyser
  Researched and Developed by Boo Khan Ming

  E-mail: bookm@tm.net.my
  WWW:    http://come.to/khanming
}

interface

implementation

uses Outface;

var
  OldExitProcPtr:pointer;
  ErrorMessage:string;

{$F+} procedure ErrorInterceptHandler; {$F-}
begin
  ExitProc:=OldExitProcPtr;

  if ErrorAddr<>nil then
  begin
    case ExitCode of
      1:ErrorMessage:='Invalid function number';
      2:ErrorMessage:='File not found';
      3:ErrorMessage:='Path not found';
      4:ErrorMessage:='Too many open files';
      5:ErrorMessage:='File access denied';
      6:ErrorMessage:='Invalid file handle';
      12:ErrorMessage:='Invalid file access code';
      15:ErrorMessage:='Invalid drive number';
      16:ErrorMessage:='Cannot remove current directory';
      17:ErrorMessage:='Cannot rename across drives';
      18:ErrorMessage:='No more files';
      100:ErrorMessage:='Disk read error';
      101:ErrorMessage:='Disk write error';
      102:ErrorMessage:='File not assigned';
      103:ErrorMessage:='File not open';
      104:ErrorMessage:='File not open for input';
      105:ErrorMessage:='File not open for output';
      106:ErrorMessage:='Invalid numeric format';
      150:ErrorMessage:='Disk is write-protected';
      151:ErrorMessage:='Bad drive request struct length';
      152:ErrorMessage:='Drive not ready';
      154:ErrorMessage:='CRC error in data';
      156:ErrorMessage:='Disk seek error';
      157:ErrorMessage:='Unknown media type';
      158:ErrorMessage:='Sector Not Found';
      159:ErrorMessage:='Printer out of paper';
      160:ErrorMessage:='Device write fault';
      161:ErrorMessage:='Device read fault';
      162:ErrorMessage:='Hardware failure';
      200:ErrorMessage:='Division by zero';
      201:ErrorMessage:='Range check error';
      202:ErrorMessage:='Stack overflow error';
      203:ErrorMessage:='Heap overflow error';
      204:ErrorMessage:='Invalid pointer operation';
      205:ErrorMessage:='Floating point overflow';
      206:ErrorMessage:='Floating point underflow';
      207:ErrorMessage:='Invalid floating point operation';
      208:ErrorMessage:='Overlay manager not installed';
      209:ErrorMessage:='Overlay file read error';
      210:ErrorMessage:='Object not initialized';
      211:ErrorMessage:='Call to abstract method';
      212:ErrorMessage:='Stream registration error';
      213:ErrorMessage:='Collection index out of range';
      214:ErrorMessage:='Collection overflow error';
      215:ErrorMessage:='Arithmetic overflow error';
      216:ErrorMessage:='General Protection fault';
      else
        ErrorMessage:='';
    end;

    asm
      mov  ax, 0003h
      int  10h
    end;

    WriteLn('Execution aborted at memory location ',HexadecimalValue(Seg(ErrorAddr^)),':',HexadecimalValue(Ofs(ErrorAddr^)));
    WriteLn('Error ',ExitCode,': ',ErrorMessage);

    Halt(ExitCode);
  end;

  ExitCode:=0;
  ErrorAddr:=nil;
end;

begin
  OldExitProcPtr:=ExitProc;
  ExitProc:=@ErrorInterceptHandler;
end.