{
  Digital Signal Analyser
  Official Release 1 (1999.9)
  Researched and Developed by Boo Khan Ming

  E-mail: bookm@tm.net.my
  WWW:    http://come.to/khanming

  This program was developed for my college computer engineering
  Project B (PS307) module.
}

uses CRT,DOS,Outface,Inface,Profile,Error;

const
  ProductName='Digital Signal Analyser (Boo Khan Ming)';
  ProductRevision='Official Release 1 (1999.9)';
  ProductAuthor='Researched and Developed by Boo Khan Ming.';
  HelpFileName='README.TXT';
  SettingsFileName='DSA.INI';
  StorageBufferFileName='DSA.SBF';
  ImageFileName='DSA.IMG';
  SideBarItem=2;
  WaveDisplayWidth=63;
  WaveDisplayHeight=21;
  SamplingRateTable:array [1..15] of word=(50000,20000,10000,5000,2000,1000,
                                           500,200,100,50,20,10,5,2,1);

type
  StorageBufferType=array [0..63999] of byte;

var
  MenuItemArray:MenuItemArrayType;
  Counter:word;
  TextString:string;
  Status:byte;
  KeyCode:byte;
  ShiftKey,CtrlKey,AltKey:boolean;
  StorageBuffer:^StorageBufferType;
  StorageBufferSize:longint;
  StorageBufferSegmentIndex:word;
  StorageBufferIndex:longint;
  StorageBufferAccessIndex:longint;
  StorageBufferFile:file;
  UserFile:file;
  UserFileName:string;
  AccessStatus:word;
  Mode:byte;
  SamplingRateIndex:byte;
  Frequency,Voltage,CompareVoltage:real;
  FrequencyLength:word;
  NewAmplitudeValue,OldAmplitudeValue:byte;
  MaximumVoltageLevel:real;
  SoundCardBasePort:word;
  MixerEnabled:boolean;
  MajorVersion,MinorVersion:byte;
  MajorVersionString,MinorVersionString:string;
  NewSideBarIndex,OldSideBarIndex:byte;
  Left,Right:byte;
  InputSensitivity,OutputSensitivity,OverallSensitivity:byte;
  WaveDisplayTable:array [1..WaveDisplayWidth] of byte;
  VerticalRetraceEnabled:boolean;
  FirstTimeUser:boolean;
  OfflineModeEnabled:boolean;
  FreeDiskSpace:longint;
  SolidWaveDisplay:boolean;
  ControlBreakInterruptVector:pointer;
  P:PathStr;
  DefaultFolder:DirStr;
  N:NameStr;
  E:ExtStr;

{ ------------------------------------------------------------------------- }

function CompareValue(Value1,Value2:byte):byte;
begin
  if Value1>Value2 then
    CompareValue:=Value1
  else
    CompareValue:=Value2;
end;

procedure ActivateFrame;
begin
  ChangeTextAppearance(8,9);
end;

procedure InactivateFrame;
begin
  ChangeTextAppearance(9,8);
end;

{ ------------------------------------------------------------------------- }

procedure UpdateOfflineModeWaveDisplay(StartIndex:longint);
var
  Counter:word;
  Loop:byte;
  Position:byte;

begin
  ChangeTextRegion(2,3,64,24);
  TextColor(WaveDisplayPanelFrontColor);
  TextBackground(WaveDisplayPanelBackColor);
  ClearTextContent;

  for Counter:=1 to WaveDisplayWidth do
  begin
    Position:=WaveDisplayHeight-Trunc(StorageBuffer^[StartIndex+Counter-1]/256*WaveDisplayHeight)+1;
    ChangeTextOffset(Counter,Position);
    InsertText(Chr(219));

    if SolidWaveDisplay then
    begin
      if Position<12 then
      begin
        for Loop:=Position to 12 do
        begin
          ChangeTextOffset(Counter,Loop);
          InsertText(Chr(219));
        end;
      end
      else
      if Position>12 then
      begin
        for Loop:=12 to Position do
        begin
          ChangeTextOffset(Counter,Loop);
          InsertText(Chr(219));
        end
      end;
    end;
  end;
end;

procedure UpdateOnlineModeWaveDisplay(Direction:boolean;NewAmplitudeValue:byte);
var
  Counter:word;
  Loop:byte;
  Position:byte;

begin
  ChangeTextRegion(2,3,64,24);
  TextColor(WaveDisplayPanelFrontColor);
  TextBackground(WaveDisplayPanelBackColor);
  ClearTextContent;

  { Left to Right }
  if Direction then
  begin
    for Counter:=WaveDisplayWidth downto 2 do
      WaveDisplayTable[Counter]:=WaveDisplayTable[Counter-1];

    WaveDisplayTable[1]:=NewAmplitudeValue;
  end
  else
  { Right to Left }
  begin
    for Counter:=1 to WaveDisplayWidth-1 do
      WaveDisplayTable[Counter]:=WaveDisplayTable[Counter+1];

    WaveDisplayTable[WaveDisplayWidth]:=NewAmplitudeValue;
  end;

  for Counter:=1 to WaveDisplayWidth do
  begin
    Position:=WaveDisplayHeight-Trunc(WaveDisplayTable[Counter]/256*WaveDisplayHeight)+1;
    ChangeTextOffset(Counter,Position);
    InsertText(Chr(219));

    if SolidWaveDisplay then
    begin
      if Position<12 then
      begin
        for Loop:=Position to 12 do
        begin
          ChangeTextOffset(Counter,Loop);
          InsertText(Chr(219));
        end;
      end
      else
      if Position>12 then
      begin
        for Loop:=12 to Position do
        begin
          ChangeTextOffset(Counter,Loop);
          InsertText(Chr(219));
        end
      end;
    end;
  end;

  if VerticalRetraceEnabled then
    VerticalRetrace;
end;

procedure UpdateDirectionStatus;
begin
  ChangeTextRegion(1,25,80,25);

  TextColor(SideBarInactiveSelectionFrontColor);
  TextBackground(SideBarInactiveSelectionBackColor);

  ChangeTextOffset(2,1);
  InsertText(Chr(17));
  ChangeTextOffset(64,1);
  InsertText(Chr(16));

  if StorageBufferSize<=WaveDisplayWidth then
    Exit;

  TextColor(SideBarActiveSelectionFrontColor);
  TextBackground(SideBarActiveSelectionBackColor);

  if StorageBufferIndex>0 then
  begin
    ChangeTextOffset(2,1);
    InsertText(Chr(17));
  end;

  if StorageBufferIndex<=StorageBufferSize-WaveDisplayWidth then
  begin
    ChangeTextOffset(64,1);
    InsertText(Chr(16));
  end;
end;

procedure UpdateStatusDisplay(Mode:byte);
begin
  ChangeTextRegion(66,19,80,24);
  TextColor(SideBarFrontColor);
  TextBackground(SideBarBackColor);
  ClearTextContent;

  case Mode of
    1:
    begin
      InsertNewText('Size');
      TextColor(SideBarActiveElementFrontColor);
      TextBackground(SideBarActiveElementBackColor);
      InsertNewText(ShortenNumber(StorageBufferSize));
      TextColor(SideBarFrontColor);
      TextBackground(SideBarBackColor);
      InsertNewText('');
      InsertNewText('Index');
      TextColor(SideBarActiveElementFrontColor);
      TextBackground(SideBarActiveElementBackColor);
      InsertNewText(ShortenNumber(StorageBufferIndex));
    end;
    2:
    begin
      InsertNewText('Voltage');
      TextColor(SideBarActiveElementFrontColor);
      TextBackground(SideBarActiveElementBackColor);
      Str(NewAmplitudeValue,TextString);
      InsertNewText(NormalizeNumber(Voltage)+'V');
      TextColor(SideBarFrontColor);
      TextBackground(SideBarBackColor);
      InsertNewText('');
      InsertNewText('Frequency');
      TextColor(SideBarActiveElementFrontColor);
      TextBackground(SideBarActiveElementBackColor);
      InsertNewText(NormalizeNumber(Frequency)+'Hz');
    end;
  end;
end;

procedure UpdateModeDisplay(Mode:byte);
begin
  ChangeTextRegion(66,13,80,24);
  TextColor(SideBarFrontColor);
  TextBackground(SideBarBackColor);
  ClearTextContent;

  InsertNewText('Mode');
  TextColor(SideBarActiveElementFrontColor);
  TextBackground(SideBarActiveElementBackColor);

  case Mode of
    1:
    begin
      InsertNewText('Offline');
      TextColor(SideBarFrontColor);
      TextBackground(SideBarBackColor);
      InsertNewText('');
      InsertNewText('Sampling Rate');
      TextColor(SideBarActiveElementFrontColor);
      TextBackground(SideBarActiveElementBackColor);
      InsertNewText(NormalizeNumber(SamplingRateTable[SamplingRateIndex])+'Hz');
    end;
    2:
    begin
      InsertNewText('Online');
      TextColor(SideBarFrontColor);
      TextBackground(SideBarBackColor);
      InsertNewText('');
      InsertNewText('Sampling Rate');
      TextColor(SideBarActiveElementFrontColor);
      TextBackground(SideBarActiveElementBackColor);
      InsertNewText(NormalizeNumber(SamplingRateTable[SamplingRateIndex])+'Hz');
    end;
  end;
end;

procedure UpdateSideBar(NewIndex,OldIndex:byte);

  procedure RefreshSideBar(Index:byte);
  begin
    case Index of
      1:InsertNewText(' '+Chr(17)+'     Options');
      2:InsertNewText(' '+Chr(17)+'        Help');
    end;
  end;

begin
  if (OldIndex=NewIndex)
  or (not OldIndex in [1..SideBarItem]) or (not NewIndex in [1..SideBarItem]) then
    Exit;

  ChangeTextRegion(65,3,80,12);
  TextColor(SideBarInactiveSelectionFrontColor);
  TextBackground(SideBarInactiveSelectionBackColor);

  ChangeTextOffset(1,((OldIndex-1)*2)+1);
  RefreshSideBar(OldIndex);

  TextColor(SideBarActiveSelectionFrontColor);
  TextBackground(SideBarActiveSelectionBackColor);

  ChangeTextOffset(1,((NewIndex-1)*2)+1);
  RefreshSideBar(NewIndex);
end;

procedure OpenSideBar;
begin
  SketchWindow(65,3,80,24,SideBarInactiveSelectionFrontColor,SideBarInactiveSelectionBackColor);

  InsertNewText(' '+Chr(17)+'     Options');
  InsertNewText('');
  InsertNewText(' '+Chr(17)+'        Help');
  InsertNewText('');
end;

{ ------------------------------------------------------------------------- }

procedure DisplayInformation;
begin
  InactivateFrame;

  OpenFrame(52,14,'Information');

  InsertNewText(ProductName);
  InsertNewText(ProductRevision);
  InsertNewText(ProductAuthor);
  InsertNewText('');
  InsertText('E-mail: ');
  TextColor(12);
  TextBackground(FrameSurfaceBackColor);
  InsertNewText('bookm@tm.net.my');
  TextColor(FrameSurfaceFrontColor);
  TextBackground(FrameSurfaceBackColor);
  InsertText('WWW:    ');
  TextColor(12);
  TextBackground(FrameSurfaceBackColor);
  InsertNewText('http://come.to/khanming');
  InsertNewText('');
  TextColor(FrameSurfaceFrontColor);
  TextBackground(FrameSurfaceBackColor);
  InsertNewText('This program was developed for my college');
  InsertNewText('computer engineering Project B (PS307) module.');
  InsertNewMultipleText(196,50);
  InsertNewText('Sound Card');
  InsertText(Chr(7)+' Model:        ');
  TextColor(12);
  TextBackground(FrameSurfaceBackColor);
  InsertNewText(CheckSoundCardType);
  TextColor(FrameSurfaceFrontColor);
  TextBackground(FrameSurfaceBackColor);
  InsertText(Chr(7)+' DSP Version:  ');
  TextColor(12);
  TextBackground(FrameSurfaceBackColor);
  InsertNewText(MajorVersionString+'.'+MinorVersionString);
  TextColor(FrameSurfaceFrontColor);
  TextBackground(FrameSurfaceBackColor);
  InsertText(Chr(7)+' Port Address: ');
  TextColor(12);
  TextBackground(FrameSurfaceBackColor);
  InsertNewText(HexadecimalValue(SoundCardBasePort)+'H');
  TextColor(FrameSurfaceFrontColor);
  TextBackground(FrameSurfaceBackColor);

  repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
end;

procedure DisplayHelp;
const
  MaxHelpLine=500;
  DisplayHeight=17;
  DisplayWidth=70;

type
  HelpBufferType=array [1..MaxHelpLine] of string[DisplayWidth];

var
  HelpFile:text;
  HelpBuffer:^HelpBufferType;
  HelpBufferIndex,HelpBufferSize,OldHelpBufferIndex:word;
  HelpLine:string;
  KeyCode:byte;
  Counter:word;

begin
  PushScreen;
  InactivateFrame;

  if MaxAvail<MaxHelpLine*DisplayWidth then
  begin
    OpenErrorFrame(40,4,'Help Unavailable');
    InsertNewText('Insufficient memory.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];

    PopScreen;
    Exit;
  end;

  {$I-}
  Assign(HelpFile,DefaultFolder+HelpFileName);
  Reset(HelpFile);
  {$I+}
  if IOResult<>0 then
  begin
    OpenErrorFrame(40,4,'Help Unavailable');
    InsertNewText('Unable to open help file.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];

    PopScreen;
    Exit;
  end;

  OpenFrame(DisplayWidth+1,DisplayHeight+1,'Help');

  New(HelpBuffer);
  HelpBufferIndex:=1;

  while (not EOF(HelpFile)) and (HelpBufferIndex<MaxHelpLine) do
  begin
    ReadLn(HelpFile,HelpLine);
    HelpBuffer^[HelpBufferIndex]:=HelpLine;

    while Length(HelpLine)>DisplayWidth do
    begin
      Inc(HelpBufferIndex);
      HelpLine:=Copy(HelpLine,DisplayWidth+1,Length(HelpLine));
      HelpBuffer^[HelpBufferIndex]:=Copy(HelpLine,1,Length(HelpLine));
    end;

    Inc(HelpBufferIndex);
  end;

  HelpBufferSize:=HelpBufferIndex;
  HelpBufferIndex:=1;
  KeyCode:=0;

  for Counter:=1 to DisplayHeight+1 do
    InsertNewText(HelpBuffer^[Counter]);

  repeat
    if Keypressed then
    begin
      KeyCode:=GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey);

      OldHelpBufferIndex:=HelpBufferIndex;

      case KeyCode of
        72: { Up }
        if HelpBufferIndex>1 then
        begin
          Dec(HelpBufferIndex);
        end;
        80: { Down }
        if HelpBufferIndex<HelpBufferSize-DisplayHeight-1 then
        begin
          Inc(HelpBufferIndex);
        end;
        71:HelpBufferIndex:=1;
        79:HelpBufferIndex:=HelpBufferSize-DisplayHeight-1;
        73: { Page Up }
        begin
          if HelpBufferIndex>DisplayHeight then
            Dec(HelpBufferIndex,DisplayHeight+1)
          else
            HelpBufferIndex:=1;
        end;
        81: { Page Down }
        begin
          if (HelpBufferIndex<HelpBufferSize-(DisplayHeight*2)-1)
          and (HelpBufferSize>(DisplayHeight*2)) then
            Inc(HelpBufferIndex,DisplayHeight+1)
          else
            HelpBufferIndex:=HelpBufferSize-DisplayHeight-1;
        end;
      end;

      if OldHelpBufferIndex<>HelpBufferIndex then
      begin
        ClearTextContent;
        ChangeTextOffset(1,1);

        for Counter:=HelpBufferIndex to HelpBufferIndex+DisplayHeight do
          InsertNewText(HelpBuffer^[Counter]);
      end;
    end;

  until KeyCode=1;

  Close(HelpFile);
  Dispose(HelpBuffer);

  PopScreen;
end;

{ ------------------------------------------------------------------------- }

procedure ChangeSamplingRate;
begin
  InactivateFrame;

  OpenFrame(15,15,'Sampling Rate');

  MenuItemArray[1]:='  50 KHz  ';
  MenuItemArray[2]:='  20 KHz  ';
  MenuItemArray[3]:='  10 KHz  ';
  MenuItemArray[4]:='  5 KHz   ';
  MenuItemArray[5]:='  2 KHz   ';
  MenuItemArray[6]:='  1 KHz   ';
  MenuItemArray[7]:='  500 Hz  ';
  MenuItemArray[8]:='  200 Hz  ';
  MenuItemArray[9]:='  100 Hz  ';
  MenuItemArray[10]:='  50 Hz   ';
  MenuItemArray[11]:='  20 Hz   ';
  MenuItemArray[12]:='  10 Hz   ';
  MenuItemArray[13]:='  5 Hz    ';
  MenuItemArray[14]:='  2 Hz    ';
  MenuItemArray[15]:='  1 Hz    ';

  MenuItemArray[SamplingRateIndex]:=Chr(7)+Copy(MenuItemArray[SamplingRateIndex],
                                                2,Length(MenuItemArray[SamplingRateIndex]));

  Status:=OpenMenu(MenuItemArray,15,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                   MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

  if Status<>255 then
  begin
    SamplingRateIndex:=Status;
    ChangeTimerFrequency(SamplingRateTable[SamplingRateIndex]);
  end;
end;

procedure AdjustInputSensitivity;
begin
  InactivateFrame;

  if not MixerEnabled then
  begin
    OpenErrorFrame(40,4,'Feature Unavailable');
    InsertNewText('This feature is unsupported by sound');
    InsertNewText('card on this computer.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
    Exit;
  end;

  OpenFrame(20,8,'Input Sensitivity');
  MenuItemArray[1]:='  0  ';
  MenuItemArray[2]:='  1  ';
  MenuItemArray[3]:='  2  ';
  MenuItemArray[4]:='  3  ';
  MenuItemArray[5]:='  4  ';
  MenuItemArray[6]:='  5  ';
  MenuItemArray[7]:='  6  ';
  MenuItemArray[8]:='  7  ';

  MenuItemArray[InputSensitivity+1]:=Chr(7)+Copy(MenuItemArray[InputSensitivity+1],
                                                2,Length(MenuItemArray[InputSensitivity+1]));

  Status:=OpenMenu(MenuItemArray,8,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                   MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

  if Status<>255 then
  begin
    InputSensitivity:=Status-1;
    ChangeMicVolume(InputSensitivity);
  end;
end;

procedure AdjustOutputSensitivity;
begin
  InactivateFrame;

  if not MixerEnabled then
  begin
    OpenErrorFrame(40,4,'Feature Unavailable');
    InsertNewText('This feature is unsupported by sound');
    InsertNewText('card on this computer.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
    Exit;
  end;

  OpenFrame(20,16,'Output Sensitivity');
  MenuItemArray[1]:='  0   ';
  MenuItemArray[2]:='  1   ';
  MenuItemArray[3]:='  2   ';
  MenuItemArray[4]:='  3   ';
  MenuItemArray[5]:='  4   ';
  MenuItemArray[6]:='  5   ';
  MenuItemArray[7]:='  6   ';
  MenuItemArray[8]:='  7   ';
  MenuItemArray[9]:='  8   ';
  MenuItemArray[10]:='  9   ';
  MenuItemArray[11]:='  10  ';
  MenuItemArray[12]:='  11  ';
  MenuItemArray[13]:='  12  ';
  MenuItemArray[14]:='  13  ';
  MenuItemArray[15]:='  14  ';
  MenuItemArray[16]:='  15  ';

  MenuItemArray[OutputSensitivity+1]:=Chr(7)+Copy(MenuItemArray[OutputSensitivity+1],
                                                2,Length(MenuItemArray[OutputSensitivity+1]));

  Status:=OpenMenu(MenuItemArray,16,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                   MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

  if Status<>255 then
  begin
    OutputSensitivity:=Status-1;
    ChangeVoiceVolume(OutputSensitivity,OutputSensitivity);
  end;
end;

procedure AdjustOverallSensitivity;
begin
  InactivateFrame;

  if not MixerEnabled then
  begin
    OpenErrorFrame(40,4,'Feature Unavailable');
    InsertNewText('This feature is unsupported by sound');
    InsertNewText('card on this computer.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
    Exit;
  end;

  OpenFrame(20,16,'Overall Sensitivity');
  MenuItemArray[1]:='  0   ';
  MenuItemArray[2]:='  1   ';
  MenuItemArray[3]:='  2   ';
  MenuItemArray[4]:='  3   ';
  MenuItemArray[5]:='  4   ';
  MenuItemArray[6]:='  5   ';
  MenuItemArray[7]:='  6   ';
  MenuItemArray[8]:='  7   ';
  MenuItemArray[9]:='  8   ';
  MenuItemArray[10]:='  9   ';
  MenuItemArray[11]:='  10  ';
  MenuItemArray[12]:='  11  ';
  MenuItemArray[13]:='  12  ';
  MenuItemArray[14]:='  13  ';
  MenuItemArray[15]:='  14  ';
  MenuItemArray[16]:='  15  ';

  MenuItemArray[OverallSensitivity+1]:=Chr(7)+Copy(MenuItemArray[OverallSensitivity+1],
                                                2,Length(MenuItemArray[OverallSensitivity+1]));

  Status:=OpenMenu(MenuItemArray,16,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                   MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

  if Status<>255 then
  begin
    OverallSensitivity:=Status-1;
    ChangeMasterVolume(OverallSensitivity,OverallSensitivity);
  end;
end;

{ ------------------------------------------------------------------------- }

procedure OpenFile;
var
  Status:boolean;
  ReadStatus,WriteStatus:word;

begin
  InactivateFrame;
  OpenFrame(60,5,'Open File');

  GetDir(0,TextString);
  InsertNewText('Current Folder: '+TextString);

  CursorOn;
  Status:=AcquireStringInput(1,3,48,'File Name ',UserFileName);
  CursorOff;

  if Status then
  begin
    {$I-}
    Assign(UserFile,UserFileName);
    Reset(UserFile,1);
    {$I+}
    if IOResult<>0 then
    begin
      InactivateFrame;
      OpenErrorFrame(40,4,'File Access Error');
      InsertNewText('Unable to open file.');

      repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
      Exit;
    end;

    Reset(StorageBufferFile,1);

    repeat
      BlockRead(UserFile,StorageBuffer^,64000,ReadStatus);
      BlockWrite(StorageBufferFile,StorageBuffer^,ReadStatus,WriteStatus);
    until (ReadStatus=0) or (WriteStatus<>ReadStatus);

    StorageBufferSize:=FileSize(UserFile);
    StorageBufferSegmentIndex:=0;
    StorageBufferIndex:=0;

    Close(UserFile);

    PopScreen;

    UpdateDirectionStatus;
    UpdateOfflineModeWaveDisplay(StorageBufferIndex);

    PushScreen;
  end;
end;

procedure SaveAsFile;
var
  Status:boolean;
  ReadStatus,WriteStatus:word;

begin
  if StorageBufferSize=0 then
  begin
    InactivateFrame;
    OpenErrorFrame(40,4,'Storage Buffer Empty');
    InsertNewText('Unable to save as file.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
    Exit;
  end;

  InactivateFrame;
  OpenFrame(60,5,'Save As File');

  GetDir(0,TextString);
  InsertNewText('Current Folder: '+TextString);

  CursorOn;
  Status:=AcquireStringInput(1,3,48,'File Name ',UserFileName);
  CursorOff;

  if Status then
  begin
    {$I-}
    Assign(UserFile,UserFileName);
    Rewrite(UserFile,1);
    {$I+}
    if IOResult<>0 then
    begin
      InactivateFrame;
      OpenErrorFrame(40,4,'File Access Error');
      InsertNewText('Unable to create file.');

      repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
      Exit;
    end;

    Reset(StorageBufferFile,1);

    repeat
      BlockRead(StorageBufferFile,StorageBuffer^,64000,ReadStatus);
      BlockWrite(UserFile,StorageBuffer^,ReadStatus,WriteStatus);
    until (ReadStatus=0) or (WriteStatus<>ReadStatus);

    Close(UserFile);
  end;
end;

{ ------------------------------------------------------------------------- }

function FetchCode(Index:longint):byte;
begin
  FetchCode:=0;

  if Index>StorageBufferSize then
    Exit;

  if (Index div 64000)<>StorageBufferSegmentIndex then
  begin
    {StorageBufferSegmentIndex:=Index div 64000;}
    Inc(StorageBufferSegmentIndex);
    {StorageBufferAccessIndex:=StorageBufferSegmentIndex*64000;
    Seek(StorageBufferFile,StorageBufferAccessIndex);}
    BlockRead(StorageBufferFile,StorageBuffer^,64000,AccessStatus);
  end;

  FetchCode:=StorageBuffer^[Index mod 64000];
end;

procedure StoreCode(Index:longint;Code:byte;Finish:boolean);
begin
  if (Index div 64000)<>StorageBufferSegmentIndex then
  begin
    {StorageBufferAccessIndex:=StorageBufferSegmentIndex*64000;
    Seek(StorageBufferFile,StorageBufferAccessIndex);}
    BlockWrite(StorageBufferFile,StorageBuffer^,64000,AccessStatus);
    {StorageBufferSegmentIndex:=Index div 64000;}
    Inc(StorageBufferSegmentIndex);
  end
  else
  begin
    StorageBuffer^[Index mod 64000]:=Code;

    if Finish then
    begin
      {Seek(StorageBufferFile,StorageBufferSegmentIndex*64000);}
      BlockWrite(StorageBufferFile,StorageBuffer^,Index mod 64000,AccessStatus);
    end;
  end;
end;

procedure RecordSample;
begin
  FreeDiskSpace:=DiskFree(0);

  if FreeDiskSpace=0 then
  begin
    InactivateFrame;
    OpenErrorFrame(40,4,'Disk Full');
    InsertNewText('Unable to record sample.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
    Exit;
  end;

  StorageBufferIndex:=0;
  StorageBufferSegmentIndex:=0;

  Reset(StorageBufferFile,1);

  PopScreen;
  PushScreen;
  OpenFrame(40,4,'Recording Sample');
  InsertNewText('Press any key to stop recording.');

  repeat
    Port[SoundCardBasePort+WriteBufferRegister]:=$20;
    repeat until Port[SoundCardBasePort+DataAvailableRegister]>=128;

    StoreCode(StorageBufferIndex,Port[SoundCardBasePort+ReadDataRegister],False);
    Inc(StorageBufferIndex);

    if (StorageBufferIndex mod 1024)=0 then
    begin
      StorageBufferSize:=StorageBufferIndex;
      UpdateStatusDisplay(Mode);
    end;

    repeat until SlaveSignal=not MasterSignal;
    SlaveSignal:=MasterSignal;

  until (StorageBufferIndex>=FreeDiskSpace) or (Keypressed);

  StoreCode(StorageBufferIndex,Port[SoundCardBasePort+ReadDataRegister],True);

  StorageBufferSize:=StorageBufferIndex;
  StorageBufferIndex:=0;

  PopScreen;

  UpdateDirectionStatus;
  UpdateOfflineModeWaveDisplay(StorageBufferIndex);

  PushScreen;
end;

procedure PlaySample;
begin
  if (StorageBufferSize=0) then
  begin
    InactivateFrame;
    OpenErrorFrame(40,4,'Storage Buffer Empty');
    InsertNewText('Unable to play sample.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
    Exit;
  end;

  StorageBufferIndex:=0;
  StorageBufferSegmentIndex:=0;

  PopScreen;
  PushScreen;
  OpenFrame(40,4,'Playing Sample');
  InsertNewText('Press any key to stop playing.');

  Reset(StorageBufferFile,1);
  BlockRead(StorageBufferFile,StorageBuffer^,64000,AccessStatus);

  repeat
    Port[SoundCardBasePort+WriteBufferRegister]:=$10;
    repeat until Port[SoundCardBasePort+WriteBufferRegister]<128;

    Port[SoundCardBasePort+WriteBufferRegister]:=FetchCode(StorageBufferIndex);
    Inc(StorageBufferIndex);

    if (StorageBufferIndex mod 1024)=0 then
      UpdateStatusDisplay(Mode);

    repeat until SlaveSignal=not MasterSignal;
    SlaveSignal:=MasterSignal;

  until (StorageBufferIndex>=StorageBufferSize) or (Keypressed);

  StorageBufferIndex:=0;
end;

{ ------------------------------------------------------------------------- }

procedure OpenOptionsMenu;
begin
  PushScreen;
  InactivateFrame;

  case Mode of
    1: { Offline Mode }
    begin
      OpenFrame(30,16,'Options');

      MenuItemArray[1]:='  Online Mode                 ';
      MenuItemArray[2]:=Chr(7)+' Offline Mode                ';
      MenuItemArray[3]:='';
      MenuItemArray[4]:='  Open File                   ';
      MenuItemArray[5]:='  Save As File                ';
      MenuItemArray[6]:='';
      MenuItemArray[7]:='  Record                      ';
      MenuItemArray[8]:='  Playback                    ';
      MenuItemArray[9]:='';
      MenuItemArray[10]:='  Change Sampling Rate        ';
      MenuItemArray[11]:='';
      MenuItemArray[12]:='  Adjust Input Sensitivity    ';
      MenuItemArray[13]:='  Adjust Output Sensitivity   ';
      MenuItemArray[14]:='  Adjust Overall Sensitivity  ';
      MenuItemArray[15]:='';
      MenuItemArray[16]:='  Information                 ';

      Status:=OpenMenu(MenuItemArray,16,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                       MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

      case Status of
        1:Mode:=2;
        4:OpenFile;
        5:SaveAsFile;
        7:RecordSample;
        8:PlaySample;
        10:ChangeSamplingRate;
        12:AdjustInputSensitivity;
        13:AdjustOutputSensitivity;
        14:AdjustOverallSensitivity;
        16:DisplayInformation;
      end;
    end;
    2: { Online Mode }
    begin
      OpenFrame(30,10,'Options');

      MenuItemArray[1]:=Chr(7)+' Online Mode                 ';
      MenuItemArray[2]:='  Offline Mode                ';
      MenuItemArray[3]:='';
      MenuItemArray[4]:='  Change Sampling Rate        ';
      MenuItemArray[5]:='';
      MenuItemArray[6]:='  Adjust Input Sensitivity    ';
      MenuItemArray[7]:='  Adjust Output Sensitivity   ';
      MenuItemArray[8]:='  Adjust Overall Sensitivity  ';
      MenuItemArray[9]:='';
      MenuItemArray[10]:='  Information                 ';

      Status:=OpenMenu(MenuItemArray,10,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                       MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

      case Status of
        2:
        if OfflineModeEnabled then
          Mode:=1
        else
        begin
          InactivateFrame;

          OpenErrorFrame(40,4,'Offline Mode Unavailable');
          InsertNewText('Offline mode has been disabled.');

          repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];
        end;
        4:ChangeSamplingRate;
        6:AdjustInputSensitivity;
        7:AdjustOutputSensitivity;
        8:AdjustOverallSensitivity;
        10:DisplayInformation;
      end;
    end;
  end;

  PopScreen;
end;

procedure NewControlBreakInterruptHandler; far; assembler;
asm
  iret
end;

{ ========================================================================= }

begin
  (* Identify sound card *)
  if not AutoDetectSoundCard(SoundCardBasePort) then
  begin
    WriteLn('This program requires Sound Blaster or compatible sound card.');
    WriteLn('For further assistance, please e-mail to <bookm@tm.net.my>');
    Halt(255);
  end;

  CheckDSPVersion(MajorVersion,MinorVersion);

  if MajorVersion>=2 then
    MixerEnabled:=True
  else
    MixerEnabled:=False;

  Str(MajorVersion,MajorVersionString);
  Str(MinorVersion,MinorVersionString);

  (* Determine sound card volume settings *)
  CheckMasterVolume(Left,Right);
  OverallSensitivity:=CompareValue(Left,Right);
  CheckVoiceVolume(Left,Right);
  OutputSensitivity:=CompareValue(Left,Right);
  CheckMicVolume(InputSensitivity);

  P:=ParamStr(0);
  FSplit(P,DefaultFolder,N,E);

  (* Retrieve user settings *)
  SamplingRateIndex:=ReadProfileByte(DefaultFolder+SettingsFileName,'Settings','SamplingRateIndex');
  Mode:=ReadProfileByte(DefaultFolder+SettingsFileName,'Settings','Mode');
  VerticalRetraceEnabled:=not ReadProfileBoolean(DefaultFolder+SettingsFileName,'Settings','VerticalRetraceDisabled');
  MaximumVoltageLevel:=ReadProfileReal(DefaultFolder+SettingsFileName,'Settings','MaximumVoltageLevel');
  SolidWaveDisplay:=not ReadProfileBoolean(DefaultFolder+SettingsFileName,'Settings','OutlinedWaveDisplay');
  FirstTimeUser:=not ReadProfileBoolean(DefaultFolder+SettingsFileName,'User','RegularUser');

  (* Validate user settings *)
  if not (Mode in [1..2]) then
    Mode:=2;
  if not (SamplingRateIndex in [1..15]) then
    SamplingRateIndex:=12;
  if (MaximumVoltageLevel=0) or (MaximumVoltageLevel>5) then
    MaximumVoltageLevel:=0.5;

  (* General variables initialization *)
  StorageBufferSize:=0;
  StorageBufferIndex:=0;

  Frequency:=0;
  Voltage:=0;
  NewAmplitudeValue:=0;
  OldAmplitudeValue:=1;
  KeyCode:=0;
  NewSideBarIndex:=1;
  OldSideBarIndex:=2;
  OfflineModeEnabled:=True;

  GetIntVec($1B,ControlBreakInterruptVector);
  SetIntVec($1B,Addr(NewControlBreakInterruptHandler));

  (* Open startup image *)
  if OpenPicture(DefaultFolder+ImageFileName,0)=0 then
    GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey);

  (* Install timer (for sound card access) *)
  StartTimerHandler(@NewTimerHandler,SamplingRateTable[SamplingRateIndex]);

  (* Display user interface screen *)
  PrepareScreen;
  OpenScreen(ProductName);
  OpenSideBar;
  UpdateModeDisplay(Mode);
  UpdateStatusDisplay(Mode);
  UpdateDirectionStatus;
  UpdateSideBar(NewSideBarIndex,OldSideBarIndex);

  (* Set up storage buffer (for offline mode) *)
  {$I-}
  Assign(StorageBufferFile,StorageBufferFileName);
  Rewrite(StorageBufferFile,1);
  {$I+}
  if IOResult<>0 then
  begin
    OfflineModeEnabled:=False;
    Mode:=2;

    PushScreen;

    OpenErrorFrame(40,4,'Offline Mode Unavailable');
    InsertNewText('Unable to access storage buffer file.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];

    PopScreen;
  end;

  if MaxAvail<64000 then
  begin
    OfflineModeEnabled:=False;
    Mode:=2;

    PushScreen;

    OpenErrorFrame(40,4,'Offline Mode Unavailable');
    InsertNewText('Insufficient memory to allocate');
    InsertNewText('storage buffer.');

    repeat until GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey) in [1,28];

    PopScreen;
  end;

  New(StorageBuffer);
  FillChar(StorageBuffer^,64000,127);

  if Mode=1 then
  begin
    UpdateDirectionStatus;
    UpdateOfflineModeWaveDisplay(StorageBufferIndex);
  end;

  (* Events processing *)
  repeat

    (* Online mode samples acquisition *)
    if Mode=2 then
    begin
      Port[SoundCardBasePort+WriteBufferRegister]:=$20;
      repeat until Port[SoundCardBasePort+DataAvailableRegister]>=128;
      NewAmplitudeValue:=Port[SoundCardBasePort+ReadDataRegister];

      repeat until SlaveSignal=not MasterSignal;
      SlaveSignal:=MasterSignal;

      CompareVoltage:=(NewAmplitudeValue-128)/128*MaximumVoltageLevel;

      if CompareVoltage=0 then
        Voltage:=0
      else
      if Voltage<CompareVoltage then
        Voltage:=CompareVoltage;

      if NewAmplitudeValue<>OldAmplitudeValue then
      begin
        UpdateOnlineModeWaveDisplay(False,NewAmplitudeValue);
        UpdateStatusDisplay(Mode);
      end;
    end;

    (* Keyboard events *)
    if Keypressed then
    begin
      KeyCode:=GetKeyboardShiftStatus(ShiftKey,CtrlKey,AltKey);

      case KeyCode of
        1: { Escape }
        begin
          PushScreen;
          InactivateFrame;

          OpenCautionFrame(20,3,'Exit Now?');

          MenuItemArray[1]:='  Yes  ';
          MenuItemArray[2]:='  No   ';

          Status:=OpenMenu(MenuItemArray,2,MenuSurfaceFrontColor,MenuSurfaceBackColor,
                           MenuSelectionBarFrontColor,MenuSelectionBarBackColor);

          KeyCode:=Status;
          PopScreen;
        end;
        45: { Alt-X }
        if (not CtrlKey) and (not ShiftKey) and (AltKey) then
        begin
          KeyCode:=1;
        end;
        104: { Alt-F1 }
        if (not CtrlKey) and (not ShiftKey) and (AltKey) then
        begin
          PushScreen;
          DisplayInformation;
          PopScreen;
        end;
        59: { F1 }
        begin
          DisplayHelp;
        end;
        72: { Up }
        begin
          OldSideBarIndex:=NewSideBarIndex;
          Dec(NewSideBarIndex);
        end;
        80: { Down }
        begin
          OldSideBarIndex:=NewSideBarIndex;
          Inc(NewSideBarIndex);
        end;
        71: { Home }
        begin
          OldSideBarIndex:=NewSideBarIndex;
          NewSideBarIndex:=1;
        end;
        79: { End }
        begin
          OldSideBarIndex:=NewSideBarIndex;
          NewSideBarIndex:=SideBarItem;
        end;
        75: { Left }
        if StorageBufferSize>WaveDisplayWidth then
        begin
          if (not CtrlKey) and (ShiftKey) and (not AltKey) then
          begin
            if StorageBufferIndex>WaveDisplayWidth then
              Dec(StorageBufferIndex,WaveDisplayWidth)
            else
              StorageBufferIndex:=0;
          end
          else
          if StorageBufferIndex>0 then
            Dec(StorageBufferIndex);

          UpdateDirectionStatus;
          UpdateStatusDisplay(Mode);
          UpdateOfflineModeWaveDisplay(StorageBufferIndex);
        end;
        77: { Right }
        if StorageBufferSize>WaveDisplayWidth then
        begin
          if (not CtrlKey) and (ShiftKey) and (not AltKey) then
          begin
            if StorageBufferIndex<=StorageBufferSize-(WaveDisplayWidth*2) then
              Inc(StorageBufferIndex,WaveDisplayWidth)
            else
              StorageBufferIndex:=StorageBufferSize-WaveDisplayWidth+1;
          end
          else
          if StorageBufferIndex<=StorageBufferSize-WaveDisplayWidth then
            Inc(StorageBufferIndex);

          UpdateDirectionStatus;
          UpdateStatusDisplay(Mode);
          UpdateOfflineModeWaveDisplay(StorageBufferIndex);
        end;
        28: { Enter }
        begin
          case NewSideBarIndex of
            1:OpenOptionsMenu;
            2:DisplayHelp;
          end;

          ClearKeyboardBuffer;

          UpdateModeDisplay(Mode);
          UpdateStatusDisplay(Mode);

          if Mode=1 then
          begin
            UpdateDirectionStatus;
            UpdateOfflineModeWaveDisplay(StorageBufferIndex);
          end;
        end;
      end;

      if NewSideBarIndex>SideBarItem then
        NewSideBarIndex:=1;
      if NewSideBarIndex<1 then
        NewSideBarIndex:=SideBarItem;

      UpdateSideBar(NewSideBarIndex,OldSideBarIndex);
    end;
  until KeyCode=1;

  (* Store user settings *)
  WriteProfileByte(DefaultFolder+SettingsFileName,'Settings','SamplingRateIndex',SamplingRateIndex);
  WriteProfileByte(DefaultFolder+SettingsFileName,'Settings','Mode',Mode);
  WriteProfileBoolean(DefaultFolder+SettingsFileName,'Settings','VerticalRetraceDisabled',not VerticalRetraceEnabled);
  WriteProfileReal(DefaultFolder+SettingsFileName,'Settings','MaximumVoltageLevel',MaximumVoltageLevel);
  WriteProfileBoolean(DefaultFolder+SettingsFileName,'Settings','OutlinedWaveDisplay',not SolidWaveDisplay);
  WriteProfileBoolean(DefaultFolder+SettingsFileName,'User','RegularUser',not FirstTimeUser);

  SetIntVec($1B,ControlBreakInterruptVector);

  (* Safe shut down *)
  Dispose(StorageBuffer);
  Close(StorageBufferFile);
  Erase(StorageBufferFile);
  RestoreTimerHandler;
  ShutScreen;
end.
