#include "teleso.h"
#include "vga.h"
#include "3d.h"
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

unsigned char hlavicka[32];
unsigned char paleta[768];
char *povrch;

int main (int argc, char **argv)
 {
  // 1. GEO, 2. TEX
  if (argc < 3) return 1;
  TTeleso *T = NacitajTeleso (argv[1]);
  int PocetBodov = sqrt(T->PocetBodov);
  FILE *f = fopen (argv[2], "rb");
  fread (hlavicka, 1, 32, f);
  fread (paleta, 1, 768, f);
  for (int p=0; p<768; p++) paleta[p] >>= 2;
  int Sirka = (hlavicka[8] << 8) + hlavicka[9];
  int Vyska = (hlavicka[10] << 8) + hlavicka[11];
  povrch = (char *) malloc (Sirka * Vyska);
  fread (povrch, 1, Sirka * Vyska, f);
  fclose (f);
  PriradTexturu (T, Sirka, Vyska, PocetBodov);
  SetGraphicsMode ();
  SetPalette (paleta);
//  KresliTeleso (T, povrch, Sirka);
  RotujTeleso (T, povrch, Sirka);
  getch();
  SetTextMode ();
  return 0;
 }
