#include "vga.h"
#include <dpmi.h>
#include <string.h>
#include <sys/farptr.h>
#include <sys/movedata.h>
#include <go32.h>
#include <pc.h>

#define ABS(a)   ((a < 0) ? -a : a)
#define SGN(a)   ((a < 0) ? -1 : 1)

void SetGraphicsMode ()
 {
  __dpmi_regs regs;
  memset (&regs, 0, sizeof regs);
  regs.x.ax = 0x13;
  __dpmi_int (0x10, &regs);
  _farsetsel (_dos_ds);
 }

void SetPixel (int X, int Y, char Color)
 {
  int offset = (Y<<8) + (Y<<6) + X;
  _farnspokeb (0xA0000+offset, Color);
 }

void Line (int x1, int y1, int x2, int y2, int c)
{
   int d, x, y, ax, ay, sx, sy, dx, dy;

   dx = x2-x1;
   ax = ABS(dx) << 1;
   sx = SGN(dx);
   dy = y2-y1;
   ay = ABS(dy) << 1;
   sy = SGN(dy);

   x = x1;
   y = y1;
   if( ax > ay )
   {
      d = ay - (ax >> 1);
      while( x != x2 )
      {
         SetPixel( x, y, c );
	 if( d >= 0 )
         {
            y += sy;
	    d -= ax;
         }
	 x += sx;
	 d += ay;
      }
   }
   else
   {
      d = ax - (ay >> 1);
      while( y != y2 )
      {
         SetPixel( x, y, c );
	 if( d >= 0 )
         {
            x += sx;
	    d -= ay;
         }
	 y += sy;
	 d += ax;
      }
   }
}
void ClearScreen (char Color)
 {
//  memset (0xA0000, Color, 64000);
  for (int i=0; i<200; i++)
    for (int j=0; j<320; j++)
    SetPixel(j,i,Color);
 }

/*
void UseVirtual ()
 {
  _dosmemputl (video, 64000, 0xA0000);
 }
*/

void DrawPlain (void *Plain, int Y, int Height)
 {
  int Count = (Height<<6) + (Height<<4);
  int Off = (Y<<8) + (Y<<6);
  _dosmemputl (&((char *)Plain)[Off], Count, 0xA0000);
 }

void SetPalette (void *Palette)
 {
  for (int i=0; i < 256; i++)
   {
    outportb (0x03C8, i);
    outportb (0x03C9, ((char *)Palette)[(i << 1) + i]);
    outportb (0x03C9, ((char *)Palette)[(i << 1) + i + 1]);
    outportb (0x03C9, ((char *)Palette)[(i << 1) + i + 2]);
   }
 }

void WaitRetrace ()
 {
  char ch;
  do
   {
    ch = inportb (0x3DA);
   }
  while (!(ch & 8));
  do
   {
    ch = inportb (0x3DA);
   }
  while ((ch & 8));
 }

void SetTextMode()
 {
  __dpmi_regs regs;
  memset (&regs, 0, sizeof regs);
  regs.x.ax = 0x03;
  __dpmi_int (0x10, &regs);
 }

