#include "teleso.h"
#include <alloc.h>
#include <stdio.h>
#include <math.h>
#include <process.h>

TTeleso *VytvorTeleso (int pBodov, int pPloch, int pHran)
 {
  TTeleso *T;
  unsigned long Mem;

  T=(TTeleso *) malloc (sizeof(TTeleso));
  T->PocetBodov=pBodov;
  T->PocetPloch=pPloch;
  T->PocetHran=pHran;
  T->Body=(TVektor *) malloc (sizeof(TVektor)*pBodov);
  T->X_Sur = (short int *) malloc (sizeof (short int) * pBodov);
  T->Y_Sur = (short int *) malloc (sizeof (short int) * pBodov);
  if (pPloch!=0)
   {
    T->Normaly=(TVektor *) malloc (sizeof(TVektor)*pPloch);
    T->Plochy=(TPlocha *) malloc (sizeof(TPlocha)*pPloch);
   }
  return T;
 }

TTeleso *NacitajTeleso (char name[])
 {
  TTeleso *T;
  FILE *Subor;
  int B,P,i,j;
  float FP;
  TVektor *B1, *B2;

  B1=(TVektor *) malloc (sizeof(TVektor));
  B2=(TVektor *) malloc (sizeof(TVektor));
  Subor=fopen(name,"rt");
  fscanf (Subor,"%d",&B);                   // Pocet bodov
  fscanf (Subor,"%d",&P);                   // Pocet ploch
  fscanf (Subor,"%d",&i);                   // Pocet hran
  T=VytvorTeleso (B,P,i);
  B1->X=0;
  B1->Y=0;
  B1->Z=0;

// Nacitanie bodov
  for (i=0;i<T->PocetBodov;i++)
   {
    fscanf(Subor,"%f",&FP);
    T->Body[i].X = FP;
    fscanf(Subor,"%f",&FP);
    T->Body[i].Y = FP;
    fscanf(Subor,"%f",&FP);
    T->Body[i].Z = FP;
   }

// Nacitanie ploch
  for (i=0;i<T->PocetPloch;++i)
   {
    fscanf (Subor,"%d",&P);
    T->Plochy[i].Okraj=(short int *) malloc (P * sizeof(short int));
    if (T->Plochy[i].Okraj == NULL)
     {
      printf ("NULL == TTeleso->Plochy[%d].Okraj\n",i);
      exit(0);
     }
    T->Plochy[i].PocetBodov = P;
    T->Plochy[i].Svetlost = 1;
    for (j=0; j<P; j++)
     {
      fscanf(Subor,"%d",&B);
      T->Plochy[i].Okraj[j]=--B;
     }

// Normaly ploch - viditelnost
    int m=0;
    do
     {
      *B1=T->Body[T->Plochy[i].Okraj[m+1]];
      OdcitajVektory (B1,&T->Body[T->Plochy[i].Okraj[m]]);
      m++;
     }
    while (((B1->X==0) && (B1->Y==0) && (B1->Z==0)));
    NormalizujVektor (B1,B1);
    do
     {
      *B2=T->Body[T->Plochy[i].Okraj[m+1]];
      OdcitajVektory (B2,&T->Body[T->Plochy[i].Okraj[m]]);
      m++;
     }
    while (((B2->X==0) && (B2->Y==0) && (B2->Z==0)));
    NormalizujVektor (B2,B2);
    VektorovySucin (B1,B2,&T->Normaly[i]);
    NormalizujVektor (&T->Normaly[i],&T->Normaly[i]); // Nepreteka
   }
  fclose(Subor);
  free (B2);
  free (B1);
  return(T);
 }

void ZrusTeleso (TTeleso *T)
 {
  free (T->Body);
  free (T->Normaly);
  for (int i=0; i<T->PocetPloch; i++)
   {
    free (T->Plochy[i].Okraj);
   }
  free (T->Plochy);
  free (T);
 }

void PriradTexturu (TTeleso *T, int Sirka, int Vyska, int PocetBodov)
 {
  int Bod = 0;
  float dx, dy;
  float X, Y = 0;
  dx = float(Sirka-1) / (PocetBodov-1);
  dy = float(Vyska-1) / (PocetBodov-1);
  for (int i=0; i<PocetBodov; i++)
   {
    X = 0;
    for (int j=0; j<PocetBodov; j++)
     {
      T->X_Sur[Bod] = X;
      T->Y_Sur[Bod] = Y;
      X += dx;
      Bod++;
     }
    Y += dy;
   }
 }
