#include "3d.h"
#include "matica.h"
#include "teleso.h"
#include "textura.h"
#include "vektor.h"
#include "vga.h"

#include <stdio.h>
#include <alloc.h>
#include <conio.h>
#include <math.h>
#include <dos.h>

#define LCol 30

TMatica *VytvorX_Os_Maticu (void)
 {
  TMatica *M;
  M = VytvorMaticu (3,3);
  M->M[0][0]=1;
  M->M[0][1]=0;
  M->M[0][2]=0;
  M->M[1][0]=0;
  M->M[2][0]=0;
  return M;
 }

TMatica *VytvorY_Os_Maticu (void)
 {
  TMatica *M;
  M = VytvorMaticu (3,3);
  M->M[1][1]=1;
  M->M[0][1]=0;
  M->M[1][2]=0;
  M->M[1][0]=0;
  M->M[2][1]=0;
  return M;
 }

TMatica *VytvorZ_Os_Maticu (void)
 {
  TMatica *M;
  M = VytvorMaticu (3,3);
  M->M[2][2]=1;
  M->M[0][2]=0;
  M->M[1][2]=0;
  M->M[2][1]=0;
  M->M[2][0]=0;
  return M;
 }

TMatica *VytvorXYZ_Os_Maticu (void)
 {
  TMatica *M;

  M = VytvorMaticu (3,3);
  return M;
 }

void PrepocetX_Os_Matice (TMatica *M, float Uhol)
 {
  float Cos, Sin;
  Cos = cos (Uhol);
  Sin = sin (Uhol);
  M->M[1][1] = Cos;
  M->M[1][2] = -Sin;
  M->M[2][1] = Sin;
  M->M[2][2] = Cos;
 }

void PrepocetY_Os_Matice (TMatica *M, float Uhol)
 {
  float Cos, Sin;
  Cos = cos (Uhol);
  Sin = sin (Uhol);
  M->M[0][0] = Cos;
  M->M[2][0] = -Sin;
  M->M[0][2] = Sin;
  M->M[2][2] = Cos;
 }

void PrepocetZ_Os_Matice (TMatica *M, float Uhol)
 {
  float Cos, Sin;
  Cos = cos (Uhol);
  Sin = sin (Uhol);
  M->M[1][1] = Cos;
  M->M[0][1] = -Sin;
  M->M[1][0] = Sin;
  M->M[0][0] = Cos;
 }

void PrepocetXYZ_Os_Matice (TMatica *M, float a, float b, float c)
 {
  float cosa, sina, cosb, sinb, cosc, sinc, sab, cac, csac;
  cosa = cos (a);
  sina = sin (a);
  cosb = cos (b);
  sinb = sin (b);
  cosc = cos (c);
  sinc = sin (c);
  sab = sina * sinb;
  cac = cosa * cosc;
  csac = cosa * sinc;
  M->M[0][0] = cosb * cosc;
  M->M[0][1] = -cosb * sinc;
  M->M[0][2] = sinb;
  M->M[1][0] = sab * cosc + csac;
  M->M[1][1] = cac - sab * sinc;
  M->M[1][2] = -sina * cosb;
  M->M[2][0] = sina * sinc - cac * sinb;
  M->M[2][1] = sinb * csac + sina * cosc;
  M->M[2][2] = cosa * cosb;
 }

void TransformujBod (TMatica *M, TVektor *B, TVektor *V)
 {
  float x,y,z;

  x = M->M[0][0]*B->X + M->M[1][0]*B->Y + M->M[2][0]*B->Z;
  y = M->M[0][1]*B->X + M->M[1][1]*B->Y + M->M[2][1]*B->Z;
  z = M->M[0][2]*B->X + M->M[1][2]*B->Y + M->M[2][2]*B->Z;
  V->X = x;
  V->Y = y;
  V->Z = z;
 }

void KresliTeleso (TTeleso *T, char *Tx, int Sirka)
 {
  int x1,y1,x2,y2;
  int v1,v2,vt;
  char c;
  float U;
  TTexturePoint p[4];

  for (int i=0; i<T->PocetPloch; i++)
   {
    if (T->Plochy[i].Svetlost>=0)
     {
      for (int j=0; j<T->Plochy[i].PocetBodov; ++j)
       {
        int k = T->Plochy[i].Okraj[j];
	p[j].X = -T->Body[k].X-St_X;
	p[j].Y = T->Body[k].Z-St_Y;
        p[j].SX = T->X_Sur[k];
        p[j].SY = T->Y_Sur[k];
       }
      Textura (Tx, Sirka, 4, p);
     }
   }
 }

void KresliTeleso2 (TTeleso *T, char *Tx, int Sirka)
 {
  int x1,y1,x2,y2;
  int v1,v2,vt;
  char c;
  float U;
  TTexturePoint p[4];

  for (int i=0; i<T->PocetPloch; i++)
   {
    if (T->Plochy[i].Svetlost>=0)
     {
      if (5*T->Body[T->Plochy[i].Okraj[0]].X+2*T->Body[T->Plochy[i].Okraj[0]].Y-3*T->Body[T->Plochy[i].Okraj[0]].Z>0)
       {
        for (int j=0; j<T->Plochy[i].PocetBodov; ++j)
         {
          int k = T->Plochy[i].Okraj[j];
    	  p[j].X = -T->Body[k].X-St_X;
  	  p[j].Y = T->Body[k].Z-St_Y;
          p[j].SX = T->X_Sur[k];
          p[j].SY = T->Y_Sur[k];
         }
        Textura (Tx, Sirka, 4, p);
       }
      else
       {
        int k,l;
        for (int j=0; j<T->Plochy[i].PocetBodov-1; ++j)
         {
          k = T->Plochy[i].Okraj[j];
          l = T->Plochy[i].Okraj[j+1];
    	  Line (-T->Body[k].X-St_X, T->Body[k].Z-St_Y, -T->Body[l].X-St_X, T->Body[l].Z-St_Y, LCol);
         }
        k = T->Plochy[i].Okraj[0];
 	Line (-T->Body[k].X-St_X, T->Body[k].Z-St_Y, -T->Body[l].X-St_X, T->Body[l].Z-St_Y, LCol);
       }
     }
   }
 }

void KresliTeleso3 (TTeleso *T)
 {
  int x1,y1,x2,y2;
  int v1,v2,vt;
  char c;
  float U;
  TTexturePoint p[4];

  for (int i=0; i<T->PocetPloch; i++)
   {
    if (T->Plochy[i].Svetlost>=0)
     {
      for (int j=0; j<T->Plochy[i].PocetBodov; ++j)
       {
        int k = T->Plochy[i].Okraj[j];
	SetPixel(-T->Body[k].X-St_X, T->Body[k].Z-St_Y, 1);
       }
     }
   }
 }

void RotujTeleso (TTeleso *T, char *Tx, int Sirka)
 {
  TMatica *M, *N, *O, *Q, *R;
  float da,db,dc;
  TTeleso *V;
  TVektor *B,P;
  int i;
  int Bd;

  N = VytvorY_Os_Maticu();
  O = VytvorY_Os_Maticu();
  Q = VytvorZ_Os_Maticu();
  R = VytvorZ_Os_Maticu();
  PrepocetY_Os_Matice (N, 0.701);
  PrepocetY_Os_Matice (O, -0.701);
  PrepocetZ_Os_Matice (Q, -2);
  PrepocetZ_Os_Matice (R, 2);
  M = VytvorXYZ_Os_Maticu();
  da = 0;
  db = 0;
  dc = -0.015;
//  db = 0.025;
//  dc = 0.001;
  PrepocetXYZ_Os_Matice (M, da, db, dc);
/*
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (M,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (M,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (N,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (N,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (Q,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (Q,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
  KresliTeleso3(T);
  getch();
*/
  while (!kbhit())
   {
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (M,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (M,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (N,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (N,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (Q,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (Q,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
//    ClearScreen(0);
    KresliTeleso (T, Tx, Sirka);
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (R,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (R,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
    for (i=0; i<T->PocetBodov; i++)
     {
      TransformujBod (O,&T->Body[i],&T->Body[i]);
     }
    for (i=0; i<T->PocetPloch; i++)
     {
      TransformujBod (O,&T->Normaly[i],&T->Normaly[i]);
      T->Plochy[i].Svetlost=T->Normaly[i].Y;
     }
//    delay(10);
   }
  free (M);
 }

