<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
  version="1.0"
  xmlns:sm="http://www.sitemaps.org/schemas/sitemap/0.9"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:mobile="http://www.google.com/schemas/sitemap-mobile/1.0"
  xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
  xmlns:video="http://www.google.com/schemas/sitemap-video/1.1"
  xmlns:news="http://www.google.com/schemas/sitemap-news/0.9"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml">
 
<xsl:output method="html" indent="yes" encoding="UTF-8"/>
<xsl:variable name="tot"><xsl:value-of select="count(sm:urlset/sm:url)"/></xsl:variable>

<xsl:template match="/">
	<html>
	<head><title>XML Sitemap</title>
	<style type="text/css">
body {background-color: #DDD;
	font: normal 80%  "Trebuchet MS", "Helvetica", sans-serif;margin:0;}
a:link {color: #0180AF;text-decoration: underline;}
a:hover {color: #666;}
h1 {
	font-size:32px;padding:20px;text-align:left;
	background-color:#fff;color:#00AEEF;margin:0px;}
h3 {
	font-size:12px;padding:10px;background-color:#B8DCE9;
	color:black;margin:0px;}
th {
	font-size:14px;padding:4px;text-align:center;background-color:#00AEEF;
	color:#fff;font-weight:normal;}
td{font-size:14px;padding:2px;text-align:left;}
tr {background: #fff}
tr:nth-child(odd) {background: #f0f0f0}
.footer {padding:10px;background-color:#B8DCE9;color:black;}
.head2 {}
@media (max-width: 640px) {
.head2 {display:table-row;}
}
	</style>
	</head>
	<body><h1>XML Sitemap</h1>
	<xsl:apply-templates />
	</body></html>
</xsl:template>
 
<xsl:template match="sm:urlset">
	<table cellpadding="20" cellspacing="0">
	<tr><th colspan="3"><h3>
	Total URLs in this sitemap file: <xsl:value-of select="$tot"/>
	</h3></th></tr>
	<tr class="head2"><th></th><th>URL</th><th>Lastmod</th></tr>
	<xsl:for-each select="sm:url">
		<xsl:variable name="loc"><xsl:value-of select="sm:loc"/></xsl:variable>
		<xsl:variable name="lst"><xsl:value-of select="sm:lastmod"/></xsl:variable>
		<xsl:variable name="pno"><xsl:value-of select="position()"/></xsl:variable>
		<tr>
		<td><xsl:value-of select="$pno"/></td>
		<td><a href="{$loc}" target="sitemap">
		<xsl:value-of select="sm:loc"/></a></td>
		<td><xsl:value-of select="$lst"/></td>
		</tr>
	</xsl:for-each>
	<tr><th colspan="2" class="footer">
	<a href="http://stofko.aspone.cz/SiteMap/index.html" target="sitemap">
	Sitemap freeware from Branislav Štofko</a></th>
	<th class="footer">V.19.12</th></tr>
	</table>
</xsl:template>
</xsl:stylesheet>