#define EXPORT		__declspec( dllexport )


extern "C" {
	class Plugin * WINAPI GetPluginClass( class DskClass * dsk, DWORD DskVer, DWORD * reserved );
		// Exchange classes
		// main version = HIWORD(DskVer), minor version = LOWORD(DskVer), e.g. 0x00020006
}


#ifndef DWORD
	#define DWORD unsigned long
	#define WORD unsigned short
	#define BYTE unsigned char
	#define BOOL int
#endif


#pragma pack( push )
#pragma pack(1)
struct PluginData {
	WORD fncID;			// number passed to Run function
	BYTE HotKey;			// ignore
	BYTE Modifiers;			// ignore
	WORD fncFlags;			// see below, set to zero to enable everything
	char * fncName;			// function name (used in options)
};

// fncFlags:
#define FF_DISABLESTARTUPCHK		1	// Disable "Run on startup" checkbox in options
#define FF_NOMOUSEACTION		2		// Function cannot be executed by clicking onto the tray icon or by middle button
#define FF_DISABLERUNNOW	4		// Disable "Run now" button
#define FF_NOCONFIGUREBUTTON	8		// Disable "configure function" button
#define FF_ENABLEOSD				16	// Enable "Display OSD" checkbox

#define FF_SETOSD					0x2000	// Set OSD to on
#define FF_PLUGINSMENU		0x8000	// Insert into menu Plugins


#define flgDISPOSD	0x80000000		// display OSD flag for 'Run' function, user checked 'Display OSD'



#pragma pack(1)
struct EnumData {
	const char * PluginName;
	int plgDataCount;							// number of plgData structures
	const PluginData * plgData;
};






#define OSDflg_NORMAL		0		// ignore 'Value', display only string 'Text'
#define OSDflg_VALUE		1		// display 'Value' after string 'Text'
#define OSDflg_BOOL			2		// display 'Value' after string 'Text' as BOOL - 'on' (1) or 'off' (0)
#define OSDflg_PROGRESS	3		// display simple progress bar, min = 0, max = 31. Try to fit 'Value' between these numbers






// Plugin:
// Create 1 instance of this class and return it in GetPluginClass function
// Then implement functions you want

#pragma pack(1)
class Plugin
{
public:
	virtual char * Init( WORD plgID ) = 0;
		// Init your plugin
		// 'plgID' is id of your plugin, it's always the same (even if you restart RrrDsk - it is stored in .ini file)
		// return pointer to plugin name
		// functions you export should be registered here (DskClass::RegisterFunctions(...);)
		// this is the only one function you must implement

	virtual void Unload( DWORD reason ) {}
		// called when the plugin is going to be unloaded
		// destroy windows, dialogs, and so on
		// 'reason':
			// 0 == program exit
			// 1 == error occured while initializing

	virtual void PluginsInitialized( void ) {}
		// called after all plugins have been initialized; you may want to get their functions (do it here)

	virtual BOOL Run( WORD fncID, DWORD flags, long param ) {return true;}
		// execute function given by 'fncID'  (the same 'fncID' you use in DskClass::RegisterFunctions)
		// return whatever you want
		// 'flags' =
			// 0 - called on startup
			// 1 - called via hot key
			// 2 - called via tray click
			// 3 - called via middle click,  'param' is HWND of the window which would receive mouse click
							// otherwise 'param' is zero (if called by RrrDsk.exe)
			// 4 - called via 'Run now' button
			// 5 - called from popup menu
			// flgDISPOSD - display OSD

	virtual void Configure( HWND hOwner, WORD fncID, BOOL DlgExit=false ) {}
		// configure your plugin or save settings
		// 'hOwner' - owner window (Options dialog box window)
		// 'DlgExit' == true:
			// called when Options dialog box is being closed
			// 'fncID' is a bool value:    true - OK button in Options was clicked,    false - Cancel button was clicked
		// 'DlgExit' == false:
			// called when user clicked the Configure button
			// 'fncID' =
				// 0xFFFF - user clicked "configure plugin" button
				// otherwise user clicked "configure function" button and 'fncID' is id of selected function in the listbox in Options
};




// DskClass:
// class you receive as a parameter in GetPluginClass function,
// you may use some of its functions (but you don't have to)

#pragma pack(1)
class DskClass
{
public:
	virtual BOOL Run( WORD plgID, WORD fncID, DWORD flags, long param ) = 0;
		// run function 'fncID' in plugin 'plgID', 'flags' and 'param' - see Run function in class Plugin

	virtual BOOL RegisterFunctions( WORD count, PluginData * plgData ) = 0;
		// registers your functions
		// you can call it more than once, but always register all functions in one call (previously registered functions are automatically unregistered)
		// 'plgData' - PluginData for those 'count' functions  (points to 'count' PluginData structures)

	virtual BOOL EnumPlugins( WORD plgID, EnumData * ed ) = 0;
		// call in a loop to enum plugins
		// plgID = 0 for RrrDsk.exe
		// if plugin with 'plgID' is not loaded, all members of 'ed' are set to zero. Return value is true.
		// returns false if there are no more plugins (invalid 'plgID')
		// do not modify items passed in the structure !

	virtual DWORD ChooseFunction( HWND hOwner, WORD plgID=0xFFFF ) = 0;
		// invoke 'Choose function' dialog box
		// if 'plgID' is specified, user can choose only from functions registered by this plugin
		// return value:
			// selected plugin ID is in HIWORD and selected function ID in LOWORD
			// -1, if user pressed cancel, or invalid 'hOwner' window

	virtual char * GetPluginName( WORD plgID ) = 0;
		// returns plugin name
		// NULL if error
		// do not free pointer returned by this function

	virtual char * GetFncName( WORD plgID, WORD fncID ) = 0;
		// returns name of function 'fncID'
		// NULL if error
		// do not free pointer returned by this function



		// Functions for storing data in .ini file
			// they return false if:
				// - an error occured or
				// - no data found in .ini file
	virtual BOOL ReadString( const char * item_name, char * string, DWORD size ) = 0;
	virtual BOOL ReadNumber( const char * item_name, long * number ) = 0;
	virtual BOOL ReadBin( const char * item_name, char * buf, DWORD size ) = 0;
			// 'size' - size of 'string' (or 'buf')

	virtual BOOL WriteString( const char * item_name, char * string ) = 0;
	virtual BOOL WriteNumber( const char * item_name, long number ) = 0;
	virtual BOOL WriteBin( const char * item_name, char * buf, DWORD count ) = 0;
			// 'count' - number of bytes to write

	virtual BOOL DeleteItem( const char * item_name ) = 0;



		// OSD Function
	virtual void DisplayOSD( char * Text, long Value, DWORD Flags=OSDflg_NORMAL, DWORD TxtColor=-1, DWORD BkColor=-1, long Timeout=-1 ) = 0;
			// length of string 'Text' is limited to 100
			// Flags:
					// OSDflg_NORMAL - ignore 'Value', display only string 'Text'
					// OSDflg_VALUE - display 'Value' after string 'Text'
					// OSDflg_BOOL - display 'Value' after string 'Text' as BOOL - 'on' (1) or 'off' (0)
					// OSDflg_PROGRESS - display simple progress bar, min = 0, max = 31. Try to fit 'Value' between these numbers
			// -1 in 'TxtColor', 'BkColor', 'Timeout' means default values
};

#pragma pack( pop )

