//						Execute plugin for Rrr Desktop,  v1.1,  R. Strycek,  11 / 2001 - 4 / 2002


#include <windows.h>
#include <commdlg.h>
#include <shlobj.h>
#include "resource.h"
#include "Execute.h"





typedef struct {
	int ss;
	char * str_ss;
} SHOWSTATES;


SHOWSTATES ShowState[12] = {
	SW_SHOWDEFAULT, "SW_SHOWDEFAULT", SW_SHOW, "SW_SHOW", SW_RESTORE, "SW_RESTORE", SW_MINIMIZE, "SW_MINIMIZE",
	SW_MAXIMIZE, "SW_MAXIMIZE", SW_HIDE, "SW_HIDE", SW_SHOWMAXIMIZED, "SW_SHOWMAXIMIZED",
	SW_SHOWMINIMIZED, "SW_SHOWMINIMIZED", SW_SHOWMINNOACTIVE, "SW_SHOWMINNOACTIVE", SW_SHOWNA, "SW_SHOWNA",
	SW_SHOWNOACTIVATE, "SW_SHOWNOACTIVATE", SW_SHOWNORMAL, "SW_SHOWNORMAL"
};



const char STR_filter[] = "All files\0*.*\0";



HINSTANCE hInstance;
MyPlugin pl;
DskClass * dsk;
HWND hOkno, hOkno2;
HWND hlb;


long pocet, index = -1;
char tmp[MAX_PATH];
char tmp_id[16];






BOOL CALLBACK ExecuteDlgProc_Config( HWND hDialog, UINT msg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ExecuteDlgProc_Add( HWND hDialog, UINT msg, WPARAM wParam, LPARAM lParam );

BOOL FillListbox();
void Register();
WORD FindID();

int AddDialogBox( HWND hOwner, long id );
void WriteEdit( HWND he, char c );

void OnBrowseFile( HWND hOwner );
void OnBrowse( HWND hOwner );




BOOL APIENTRY DllMain( HANDLE hinstDLL, DWORD fdwReason, LPVOID lpvReserved )
{
	hInstance = (HINSTANCE) hinstDLL;
	return true;
}





extern "C" class Plugin * WINAPI GetPluginClass( class DskClass * dsk, DWORD DskVer, DWORD * reserved )
{
	::dsk = dsk;
	return &pl;
}




char * MyPlugin::Init( WORD plgID )
{
	pocet = 0; dsk->ReadNumber( INI_POCET, &pocet );
	Register();
	hOkno = hOkno2 = NULL;

	return (char *) plgName;
}





void MyPlugin::Unload( DWORD reason )
{
	if( hOkno2 ) {EndDialog( hOkno2, 0 ); hOkno2 = NULL;}
	if( hOkno ) {EndDialog( hOkno, 0 ); hOkno = NULL;}
}






void MyPlugin::Configure( HWND hOwner, WORD fncID, BOOL DlgExit )
{
	if( DlgExit == false ) {
		if( hOkno ) {SetForegroundWindow( hOkno ); return;}

		if( fncID < pocet ) {
			if( AddDialogBox(hOwner, fncID) ) Register();
		}
		else {
			DialogBox( hInstance, MAKEINTRESOURCE(IDD_EXECUTE_CONFIG), hOwner, (DLGPROC) ExecuteDlgProc_Config );
			hOkno = NULL;
		}
	}
}







int AddDialogBox( HWND hOwner, long id )
{
	if( hOkno2 ) {SetForegroundWindow( hOkno2 ); return -1;}

	int ret = DialogBoxParam( hInstance, MAKEINTRESOURCE(IDD_EXECUTE_ADD), hOwner, (DLGPROC) ExecuteDlgProc_Add, id );
	hOkno2 = NULL;

	return ret;
}







BOOL MyPlugin::Run( WORD fncID, DWORD flags, long param )
{
	if( fncID < pocet ) {
		char arg[MAX_PATH], dir[MAX_PATH];
		int show = 0;

		*tmp = 0;
		wsprintf( tmp_id+1, "%ld", fncID );
		*tmp_id = INI_PROG; dsk->ReadString( tmp_id, tmp, MAX_PATH );

		if( *tmp ) {
			*arg = *dir = 0;
			*tmp_id = INI_ARG; dsk->ReadString( tmp_id, arg, MAX_PATH );
			*tmp_id = INI_DIR; dsk->ReadString( tmp_id, dir, MAX_PATH );

			long show;
			*tmp_id = INI_SHOWSTATE;
			if( ! dsk->ReadNumber(tmp_id, &show) ) show = SW_SHOWDEFAULT;

			return (BOOL) ShellExecute( NULL, NULL, tmp, arg, dir, show );

		}
	}

	return false;
}























BOOL CALLBACK ExecuteDlgProc_Config( HWND hDialog, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg ) {
		case WM_INITDIALOG:
			hOkno = hDialog;
			hlb = GetDlgItem( hDialog, IDC_LIST1 );
			FillListbox();
			SendMessage( hlb, LB_SETCURSEL, 0, 0 );
		return true;


		case WM_COMMAND:
			switch( LOWORD(wParam) ) {
				case IDCB_ADD: AddDialogBox( hDialog, -1 ); break;

				case IDCB_EDIT: {
					index = SendMessage( hlb, LB_GETCURSEL, 0, 0 );
					long id = SendMessage( hlb, LB_GETITEMDATA, index, 0 );
					AddDialogBox( hDialog, id );
					index = -1;
				}
				break;


				case IDCB_DELETE: {
					long pos = SendMessage( hlb, LB_GETCURSEL, 0, 0 );
					long id = (DWORD) SendMessage( hlb, LB_GETITEMDATA, pos, 0 );
					if( id < pocet ) {
						SendMessage( hlb, LB_DELETESTRING, pos, 0 );
						if( pos != 0 ) pos--;
						SendMessage( hlb, LB_SETCURSEL, pos, 0 );

						wsprintf( tmp_id+1, "%ld", id );
						*tmp_id = INI_NAME; dsk->DeleteItem( tmp_id );
						*tmp_id = INI_PROG; dsk->DeleteItem( tmp_id );
						*tmp_id = INI_ARG; dsk->DeleteItem( tmp_id );
						*tmp_id = INI_DIR; dsk->DeleteItem( tmp_id );
						*tmp_id = INI_SHOWSTATE; dsk->DeleteItem( tmp_id );
					}
				} break;

				case IDCANCEL:
				case IDOK:
					dsk->WriteNumber( INI_POCET, pocet );
					Register();
					EndDialog( hDialog, 1 );
				break;
			}
	}


	return 0;
}






BOOL CALLBACK ExecuteDlgProc_Add( HWND hDialog, UINT msg, WPARAM wParam, LPARAM lParam )
{
	static HWND heName, heProg, heArg, heDir, hCombo;
	static long id;


	switch( msg ) {
		case WM_INITDIALOG: {
			hOkno2 = hDialog;
			heName = GetDlgItem( hDialog, IDCE_NAME ); heProg = GetDlgItem( hDialog, IDCE_PROG );
			heArg = GetDlgItem( hDialog, IDCE_ARG ); heDir = GetDlgItem( hDialog, IDCE_DIR );
			hCombo = GetDlgItem( hDialog, IDC_COMBO );

			for( int i=0; i<12; i++ )
				SendMessage( hCombo, CB_INSERTSTRING, i, (LPARAM) ShowState[i].str_ss );

			id = lParam;

			if( (unsigned long) id < (unsigned long) pocet ) {			// edit
				wsprintf( tmp_id+1, "%ld", id );
				*tmp = 0; *tmp_id = INI_NAME; dsk->ReadString( tmp_id, tmp, 64 );
				SendMessage( heName, WM_SETTEXT, 0, (LPARAM) tmp );

				*tmp = 0; *tmp_id = INI_PROG; dsk->ReadString( tmp_id, tmp, MAX_PATH );
				SendMessage( heProg, WM_SETTEXT, 0, (LPARAM) tmp );

				*tmp = 0; *tmp_id = INI_ARG; dsk->ReadString( tmp_id, tmp, MAX_PATH );
				SendMessage( heArg, WM_SETTEXT, 0, (LPARAM) tmp );

				*tmp = 0; *tmp_id = INI_DIR; dsk->ReadString( tmp_id, tmp, MAX_PATH );
				SendMessage( heDir, WM_SETTEXT, 0, (LPARAM) tmp );

				long show = SW_SHOWDEFAULT;
				*tmp_id = INI_SHOWSTATE; dsk->ReadNumber( tmp_id, &show );
				for( i=0; i<12; i++ )
					if( ShowState[i].ss == show ) break;
			}
			else id = -1;

			SendMessage( hCombo, CB_SETCURSEL, i<12 ? i : 0, 0 );
		} return true;


		case WM_COMMAND:
			switch( LOWORD(wParam) ) {
				case IDCB_BROWSE: OnBrowse( hDialog ); break;
				case IDCB_BROWSEFILE: OnBrowseFile( hDialog ); break;

				case IDCANCEL: EndDialog( hDialog, 0 ); break;
				case IDOK: {
					long new_id = id;
					if( new_id == -1 ) new_id = FindID();

					if( new_id != -1 ) {
						*tmp_id = INI_NAME; *tmp = 0;
						wsprintf( tmp_id+1, "%ld", new_id );
						SendMessage( heName, WM_GETTEXT, 64, (LPARAM) tmp );

						if( *tmp == 0 ) break;

						dsk->WriteString( tmp_id, tmp );

						if( id == -1 ) {										// Add
							id = SendMessage( hlb, LB_ADDSTRING, 0, (LPARAM) tmp );
							SendMessage( hlb, LB_SETITEMDATA, id, new_id );
						}
						else if( hOkno ) {													// Edit
							SendMessage( hlb, LB_DELETESTRING, index, 0 );
							id = SendMessage( hlb, LB_ADDSTRING, 0, (LPARAM) tmp );
							SendMessage( hlb, LB_SETITEMDATA, id, new_id );
							SendMessage( hlb, LB_SETCURSEL, id, 0 );
						}

						WriteEdit( heProg, INI_PROG ); WriteEdit( heArg, INI_ARG ); WriteEdit( heDir, INI_DIR );

						DWORD show = SendMessage( hCombo, CB_GETCURSEL, 0, 0 );
						if( show > 11 ) show = 0;
						show = ShowState[show].ss;
						*tmp_id = INI_SHOWSTATE; dsk->WriteNumber( tmp_id, (long) show );
					}

					EndDialog( hDialog, 1 ); break;
				} break;
			}
	}


	return 0;
}






void WriteEdit( HWND he, char c )
{
	*tmp_id = c; *tmp = 0;
	SendMessage( he, WM_GETTEXT, MAX_PATH, (LPARAM) tmp );
	dsk->WriteString( tmp_id, tmp );
}



void OnBrowseFile( HWND hOwner )
{
	*tmp = 0;

	OPENFILENAME ofn = {sizeof(OPENFILENAME), hOwner, NULL, STR_filter, NULL, 0, 1,
										tmp, MAX_PATH, NULL, 0, ".", NULL,
										OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST,
										0, 0, NULL, 0, NULL, NULL};

	BOOL ret = GetOpenFileName( &ofn );
	if( ret ) SendDlgItemMessage( hOwner, IDCE_PROG, WM_SETTEXT, 0, (LPARAM) tmp );
}



void OnBrowse( HWND hOwner )
{
	BROWSEINFO bi;
	bi.hwndOwner = hOwner; bi.pidlRoot = NULL;
	bi.pszDisplayName = NULL;
	bi.lpszTitle = NULL;
	bi.ulFlags = BIF_DONTGOBELOWDOMAIN; bi.lpfn = NULL;

	LPITEMIDLIST lpIIL = SHBrowseForFolder( &bi );

	if( lpIIL ) {
		*tmp = 0;
		SHGetPathFromIDList( lpIIL, tmp );
		LPMALLOC g_pMalloc;
		if( SHGetMalloc( &g_pMalloc ) == NOERROR ) {
			g_pMalloc->Free( lpIIL ); g_pMalloc->Release();
		}

		if( *tmp ) SendDlgItemMessage( hOwner, IDCE_DIR, WM_SETTEXT, 0, (LONG) tmp );
	}
}



void Register()
{
	WORD count = 0; *tmp_id = INI_NAME;
	for( long i=0; i<pocet; i++ ) {
		wsprintf( tmp_id+1, "%ld", i );
		if( dsk->ReadString(tmp_id, tmp, 64) ) count++;
	}

	PluginData * plgData = NULL;
	char (* names)[64];
	if( count ) {
		plgData = new PluginData[count];
		memset( plgData, 0, count*sizeof(PluginData) );
		names = new char[count][64];

		count = 0;
		PluginData * pd = plgData;
		for( i=0; i<pocet; i++ ) {
			wsprintf( tmp_id+1, "%ld", i );
			if( dsk->ReadString(tmp_id, names[count], 64) ) {
				pd->fncName = names[count]; pd->fncID = (WORD) i;
				pd++; count++;
			}
		}
	}
	dsk->RegisterFunctions( count, plgData );

	if( plgData ) {delete plgData; delete [] names;}
}









BOOL FillListbox()
{
	SendMessage( hlb, LB_RESETCONTENT, 0, 0 );
	*tmp_id = INI_NAME;

	for( long i=0; i<pocet; i++ ) {
		wsprintf( tmp_id+1, "%ld", i );
		*tmp = 0;
		if( dsk->ReadString(tmp_id, tmp, 64) ) {
			if( *tmp ) {
				long offset = SendMessage( hlb, LB_ADDSTRING, 0, (LONG) tmp );
				SendMessage( hlb, LB_SETITEMDATA, offset, i );
			}
		}
	}

	return true;
}







WORD FindID()
{
	*tmp_id = INI_NAME;
	for( WORD i=0; i<0xFFFF; i++ ) {
		wsprintf( tmp_id+1, "%ld", i );
		if( ! dsk->ReadString(tmp_id, tmp, 64) ) {
			if( i >= pocet ) pocet = i+1;
			return i;
		}
	}

	return i;
}










