#include "fpmathf.h"

#ifndef _Teleso
#define _Teleso

#define Dim3D 3

typedef unsigned long dword;
typedef unsigned int word;
typedef unsigned char byte;

typedef dword far* Pdword;
typedef word far* Pword;
typedef byte far* Pbyte;

typedef struct TVektor
 {
  FPNum V[Dim3D];
 };

typedef TVektor far* PVektor;

typedef struct Hrana
 {
  word Konce[2];
 };

typedef Hrana far* PHrana;

typedef struct TPlocha
 {
  word PocetBodov;   //0
  Pword Okraj;       //2
  FPNum Svetlost;    //6
  FPNum Uhol;        //10
 };

typedef TPlocha far* PPlocha;

typedef struct HranoveTeleso
 {
  int PocetBodov;
  int PocetHran;
  PVektor Body;
  Hrana far* Hrany;
 };

typedef HranoveTeleso far* PHranoveTeleso;

typedef struct TPlosneTeleso
 {
  int PocetBodov;  //0
  int PocetPloch;  //2
  int PocetHran;   //4
  PVektor Body;    //6
  PVektor Smery;   //10
  PVektor Normaly; //14
  PPlocha Plochy;  //18
  PFPNum Farby;    //22
 };

typedef TPlosneTeleso far* PPlosneTeleso;

#endif

HranoveTeleso far* VytvorHranoveTeleso (int pBodov, int pHran);
HranoveTeleso far* PrenesHranoveTeleso (HranoveTeleso far* T);
HranoveTeleso far* NacitajHranoveTeleso (char name[]);
void UlozHranoveTeleso (HranoveTeleso far* T, char name[]);
void ZrusHranoveTeleso (HranoveTeleso far* T);
PPlosneTeleso VytvorPlosneTeleso (int pBodov, int pPloch, int pHran);
PPlosneTeleso PretvorPlosneTeleso (PPlosneTeleso T);
PPlosneTeleso PrenesPlosneTeleso (PPlosneTeleso T);
PPlosneTeleso NacitajPlosneTeleso (char name[]);
void UlozPlosneTeleso (PPlosneTeleso T, char name[]);
void VyprazdniPlosneTeleso (PPlosneTeleso T);
void ZrusPlosneTeleso (PPlosneTeleso T);

