// Implementuje dva typy telies - hranove teleso - droteny model
//                              - plosne teleso - body + ich plochy

#include "teleso.h"
#include "alloc.h"
#include "stdio.h"
#include "fpmathf.h"
#include "3d.h"
#include "process.h"

#pragma option -rd

// Implementacia hranoveho typu telesa
// Zoznam bodov, zoznam hran - dva vrcholy hrany

HranoveTeleso far* VytvorHranoveTeleso (int pBodov, int pHran)
 {
  HranoveTeleso far* T;

  T=(HranoveTeleso far*) farmalloc (sizeof(HranoveTeleso));
  T->PocetBodov=pBodov;
  T->PocetHran=pHran;
  T->Body=(PVektor) farmalloc (sizeof(TVektor)*pBodov);
  T->Hrany=(Hrana far*) farmalloc (sizeof(Hrana)*pHran);
  return T;
 }

HranoveTeleso far* PrenesHranoveTeleso (HranoveTeleso far* T)
 {
  HranoveTeleso far* PT;
  int i,j;

  PT=VytvorHranoveTeleso (T->PocetBodov,T->PocetHran);
  for (i=j=0;i<T->PocetBodov;PT->Body[i].V[j]=T->Body[i].V[j],(j==Dim3D-1)?j=0,++i:j++);
  for (i=j=0;i<T->PocetHran;PT->Hrany[i].Konce[j]=T->Hrany[i].Konce[j],(j==1)?j=0,++i:j++);
  return PT;
 }

HranoveTeleso far* NacitajHranoveTeleso (char name[])
 {
  HranoveTeleso far* T;
  FILE *Subor;
  int B,H,i,j;
  float FP;

  Subor=fopen(name,"rt");
  fscanf (Subor,"%d",&B);
  fscanf (Subor,"%d",&H);
  T=VytvorHranoveTeleso (B,H);
  for (i=0,j=0;i<T->PocetBodov;(j==Dim3D-1)?++i,j=0:++j)
   {
    fscanf(Subor,"%f",&FP);
    T->Body[i].V[j]=ConvertRealL(FP);
   }
  for (i=0,j=0;i<T->PocetHran;(j==1)?++i,j=0:++j)
   {
    fscanf(Subor,"%d",&B);
    T->Hrany[i].Konce[j]=B;
   }
  fclose(Subor);
  return T;
 }

void UlozHranoveTeleso (HranoveTeleso far* T, char name[])
 {
  FILE *Subor;
  int B,H,i,j;
  float FP;

  Subor=fopen(name,"wt");
  fprintf (Subor,"%d\n",T->PocetBodov);
  fprintf (Subor,"%d\n",T->PocetHran);
  for (i=0,j=0;i<T->PocetBodov;(j==Dim3D-1)?++i,j=0:++j)
   {
    fprintf(Subor,"%4.2f ",(float)T->Body[i].V[j].L/65536);
    if (j==Dim3D-1) fprintf (Subor,"\n");
   }
  for (i=0,j=0;i<T->PocetHran;(j==1)?++i,j=0:++j)
   {
    fprintf(Subor,"%2d",T->Hrany[i].Konce[j]);
    if (j==1) fprintf (Subor,"\n");
   }
  fclose(Subor);
 }

void ZrusHranoveTeleso (HranoveTeleso far* T)
 {
  farfree (T->Body);
  farfree (T->Hrany);
  farfree (T);
 }

// Implementacia plosneho typu telesa
// Zoznam bodov, zoznam ploch - pocet bodov, poradie bodov

PPlosneTeleso VytvorPlosneTeleso (int pBodov, int pPloch, int pHran)
 {
  PPlosneTeleso T;
  unsigned long Mem;

  T=(PPlosneTeleso ) farmalloc (sizeof(TPlosneTeleso));
  if (T==NULL)
   {
    printf ("\nNemozno vytvorit teleso\n");
    exit(0);
   }
  T->PocetBodov=pBodov;
  T->PocetPloch=pPloch;
  T->PocetHran=pHran;
  T->Body=(PVektor ) farmalloc (dword(sizeof(TVektor))*pBodov);
  if (T->Body==NULL)
   {
    printf ("\nNemozno vytvorit zoznam bodov\n");
    exit(0);
   }
  T->Smery=(PVektor) farmalloc (dword(sizeof(TVektor))*pBodov);
  if (T->Smery==NULL)
   {
    printf ("\nNemozno vytvorit zoznam smerov bodov\n");
    exit(0);
   }
  if (pPloch!=0)
   {
    T->Normaly=(PVektor) farmalloc (dword(sizeof(TVektor))*pPloch);
    if (T->Normaly==NULL)
     {
      printf ("\nNemozno vytvorit zoznam normal ploch\n");
      exit(0);
     }
    T->Plochy=(PPlocha) farmalloc (dword(sizeof(TPlocha))*dword(pPloch));
    if (T->Plochy==NULL)
     {
      printf ("\nNemozno vytvorit zoznam ploch\n");
      exit(0);
     }
   }
  T->Farby=(PFPNum) farmalloc (dword(sizeof(FPNum))*dword(pBodov));
  if (T->Farby==NULL)
   {
    printf ("\nNemozno vytvorit zoznam farieb\n");
    exit(0);
   }
/*
  farheapinfo f;
  f.ptr=NULL;
  int a;

  while ((a=farheapwalk(&f))!=5)
   {
    printf ("%p %lu %d\n",f.ptr,f.size,f.in_use);
   }
  printf("%lu\n",farcoreleft());
*/
  return T;
 }

PPlosneTeleso PretvorPlosneTeleso (PPlosneTeleso T)
 {
  PPlosneTeleso PT;
  int i,j;

  PT=VytvorPlosneTeleso (T->PocetBodov,0,T->PocetHran);
  PT->PocetPloch=T->PocetPloch;
  PT->Plochy=T->Plochy;
  PT->Normaly=(PVektor) farmalloc (dword(T->PocetPloch)*sizeof(TVektor));
//  for (i=0;i<T->PocetBodov;*PT->Body[i]=*T->Body[i],*PT->Smery[i]=*T->Smery[i],++i);
/*
  for (i=0;i<T->PocetPloch;i++)
   {
    PT->Plochy[i].Okraj=(word far*)farmalloc (T->Plochy[i].PocetBodov*sizeof(word));
    PT->Plochy[i].PocetBodov=T->Plochy[i].PocetBodov;
    PT->Plochy[i].Normala=(Bod far*) farmalloc (sizeof(Bod));
    PT->Plochy[i].Svetlost=T->Plochy[i].Svetlost;
    for (j=0;j<Dim3D-1;++j) PT->Plochy[i].Normala[j]=T->Plochy[i].Normala[j];
    for (j=0;j<T->Plochy[i].PocetBodov;++j)
     {
      PT->Plochy[i].Okraj[j]=T->Plochy[i].Okraj[j];
     }
   }
*/
  return PT;
 }

PPlosneTeleso PrenesPlosneTeleso (PPlosneTeleso T)
 {
  PPlosneTeleso PT;
  int i,j;

  PT=VytvorPlosneTeleso (T->PocetBodov,T->PocetPloch,T->PocetHran);
  for (i=j=0;i<T->PocetBodov;PT->Body[i].V[j]=T->Body[i].V[j],(j==Dim3D-1)?j=0,++i:j++);
  for (i=0;i<T->PocetPloch;i++)
   {
    PT->Plochy[i].PocetBodov=T->Plochy[i].PocetBodov;
    PT->Plochy[i].Svetlost=T->Plochy[i].Svetlost;
//    for (j=0;j<Dim3D-1;++j) PT->Plochy[i].Normala[j]=T->Plochy[i].Normala[j];
    for (j=0;j<T->Plochy[i].PocetBodov;++j)
     {
      PT->Plochy[i].Okraj[j]=T->Plochy[i].Okraj[j];
     }
   }
  return PT;
 }

PPlosneTeleso NacitajPlosneTeleso (char name[])
 {
  PPlosneTeleso T;
  FILE *Subor;
  int B,P,i,j;
  float FP;
  PVektor B1,B2;

  B1=(PVektor) farmalloc (sizeof(TVektor));
  B2=(PVektor) farmalloc (sizeof(TVektor));
  Subor=fopen(name,"rt");
  fscanf (Subor,"%d",&B);
  fscanf (Subor,"%d",&P);
  fscanf (Subor,"%d",&i);
  printf ("\nVytvaram objekt %s\n",name);
  T=VytvorPlosneTeleso (B,P,i);
  printf (" - vytvoreny\n");
  B1->V[0]=FPLNula;
  B1->V[1]=FPLNula;
  B1->V[2]=FPLNula;
  for (i=0;i<T->PocetBodov;i++)
   {
    for (j=0;j<Dim3D;j++)
     {
      fscanf(Subor,"%f",&FP);
      T->Body[i].V[j]=ConvertRealL(FP);
     }
    T->Smery[i]=*B1;
    T->Farby[i]=FPLNula;
   }
  printf (" - body nacitane\n");

// Nacitanie ploch
  for (i=0;i<T->PocetPloch;++i)
   {
    fscanf (Subor,"%d",&P);
    T->Plochy[i].Okraj=(Pword)farmalloc (long(P)*sizeof(word));
    if (T->Plochy[i].Okraj==NULL)
     {
      printf ("NULL = Teleso->Plochy[%d].Okraj\n",i);
      exit(0);
     }
    T->Plochy[i].PocetBodov=P;
    T->Plochy[i].Svetlost=FPLJedna;
    for (j=0;j<P;j++)
     {
      fscanf(Subor,"%d",&B);
      T->Plochy[i].Okraj[j]=--B;
     }

// Normaly ploch
    *B1=T->Body[T->Plochy[i].Okraj[1]];
    SubstractVectors (B1,&T->Body[T->Plochy[i].Okraj[0]]);
    NormalizeVector (B1,B1);                                 // Nepreteka
    *B2=T->Body[T->Plochy[i].Okraj[2]];
    SubstractVectors (B2,&T->Body[T->Plochy[i].Okraj[1]]);
    NormalizeVector (B2,B2);                                 // Nepreteka
//    NormalVector (B1,B2,T->Plochy[i].Normala);       // Neide pre 1 a -1
    VectorProduct (B1,B2,&T->Normaly[i]);
    NormalizeVector (&T->Normaly[i],&T->Normaly[i]); // Nepreteka

// Normaly bodov
    for (j=0;j<P;j++)
     {
      AddVectors (&T->Smery[T->Plochy[i].Okraj[j]],&T->Normaly[i]);
      NormalizeVector (&T->Smery[T->Plochy[i].Okraj[j]],&T->Smery[T->Plochy[i].Okraj[j]]);
     }
   }
  printf (" - plochy nacitane\n - normaly ploch vypocitane\n - normaly bodov vypocitane\n");
  fclose(Subor);
  farfree (B2);
  farfree (B1);
  return(T);
 }

void UlozPlosneTeleso (PPlosneTeleso T, char name[])
 {
  FILE *Subor;
  int i,j;
  float FP;

  Subor=fopen(name,"wt");
  fprintf (Subor,"%d\n",T->PocetBodov);
  fprintf (Subor,"%d\n",T->PocetPloch);
  fprintf (Subor,"%d\n",T->PocetHran);
  for (i=0,j=0;i<T->PocetBodov;(j==Dim3D-1)?++i,j=0:++j)
   {
    fprintf(Subor,"%4.2f ",(float)T->Body[i].V[j].L/65536);
    if (j==Dim3D-1) fprintf (Subor,"\n");
   }
  for (i=0;i<T->PocetPloch;++i)
   {
    fprintf (Subor,"%d ",T->Plochy[i].PocetBodov);
    for (j=0;j<T->Plochy[i].PocetBodov;j++)
     {
      fprintf(Subor,"%2d ",T->Plochy[i].Okraj[j]);
     }
    fprintf (Subor,"\n");
   }
  fclose(Subor);
 }

void VyprazdniPlosneTeleso (PPlosneTeleso T)
 {
  farfree (T->Body);
  farfree (T->Smery);
  farfree (T->Normaly);
  farfree (T->Farby);
  farfree (T);
 }

void ZrusPlosneTeleso (PPlosneTeleso T)
 {
  farfree (T->Body);
  farfree (T->Smery);
  farfree (T->Normaly);
  farfree (T->Farby);
  for (int i=0; i<T->PocetPloch; i++)
   {
    farfree (T->Plochy[i].Okraj);
   }
  farfree (T->Plochy);
  farfree (T);
 }

