#include "polygon.h"
#include "gdriver.h"

const int mClipMinX = 0;
const int mClipMaxX = 319;
const int mClipMinY = 0;
const int mClipMaxY = 199;
const int Medza = 0x8000;

int zx[200];
int kx[200];
int zf[200];
int kf[200];

#pragma option -rd

void far pascal Polygon (TPolygon PolyGon, byte Color)
 {
  int xz,yz,xk,yk,miy,may;
  int dx,dy;
  char koniec;
  long ax,fx;

  miy=32767;
  may=-32768;
  for (int i=0;i<PolyGon.Pocet;i++)
   {
    if (miy>PolyGon.Vrcholy[i].Y) miy=PolyGon.Vrcholy[i].Y;
    if (may<PolyGon.Vrcholy[i].Y) may=PolyGon.Vrcholy[i].Y;
    if (PolyGon.Vrcholy[i].Y>=mClipMinX)
     {
      if (PolyGon.Vrcholy[i].Y<=mClipMaxX) kx[PolyGon.Vrcholy[i].Y]=Medza;
      else kx[mClipMaxX]=Medza;
     }
    else kx[mClipMinX]=Medza;
   }
  if (!((miy>mClipMaxY) || (may<mClipMinY)))
   {
    if (miy<mClipMinY) miy=mClipMinY;
    if (may>mClipMaxY) may=mClipMaxY;
    for (i=miy;i<=may;i++) zx[i]=Medza;
    for (int j=0; j<PolyGon.Pocet; j++)
     {
      xz=PolyGon.Vrcholy[j].X;
      yz=PolyGon.Vrcholy[j].Y;
      if (j<PolyGon.Pocet-1)
       {
	xk=PolyGon.Vrcholy[j+1].X;
	yk=PolyGon.Vrcholy[j+1].Y;
       }
      else
       {
	xk=PolyGon.Vrcholy[0].X;
	yk=PolyGon.Vrcholy[0].Y;
       }
      if (yz==yk)
       {
	if (zx[yz]==Medza)
	 {
	  zx[yz]=xz;
	  kx[yz]=xk;
	 }
       }
      else
       {
	if (yz>yk)
	 {
	  int tm=yz;
	  yz=yk;
	  yk=tm;
	  tm=xz;
	  xz=xk;
	  xk=tm;
	 }
	koniec=0;
	dx=xk-xz;
	dy=yk-yz;
	fx=(long(long(dx)<<16))/long(dy);
	if (yz<mClipMinY)
	 {
	  if (yk<mClipMinY) koniec=1;
	  else
	   {
	    ax=long(xz)<<16;
	    ax+=long(mClipMinY-yz)*fx;
	    xz=ax>>16;
	    yz=mClipMinY;
            if (yz==yk) koniec=1;
	   }
	 }
	else ax=long(xz)<<16;
	if (yk>mClipMaxY)
         {
          yk=mClipMaxY;
          if (yz==yk) koniec=1;
         }
	if (!koniec)
	 {
	  if (zx[yz]==Medza)
	   if (kx[yz]==Medza) kx[yz]=xz;
	   else zx[yz]=xz;
	  ax+=fx;
	  for (i=yz+1;i<=yk;i++)
	   {
	    if (zx[i]==Medza)
	     {
	      zx[i]=ax>>16;
	      if ((ax & 0xFFFF)>0x8000) zx[i]+=1;
	     }
	    else
	     {
	      kx[i]=ax>>16;
	      if ((ax & 0xFFFF)>0x8000) kx[i]+=1;
	     }
	    ax+=fx;
	   }
	 }
       }
     }
    for (i=miy;i<=may;i++)
     {
      xz=zx[i];
      xk=kx[i];
      if (xk<xz)
       {
	int tm=xk;
	xk=xz;
	xz=tm;
       }
      if (!((xk<mClipMinX)||(xz>mClipMaxX)))
       {
        if (xk<mClipMinX) xk=mClipMinX;
        if (xk>mClipMaxX) xk=mClipMaxX;
        if (xz<mClipMinX) xz=mClipMinX;
        if (xz>mClipMaxX) xz=mClipMaxX;
        HorizontalLine (xz,xk,i,Color);
       }
     }
   }
 }

void far pascal ShadedPolygon (TShadedPolygon PolyGon)
 {
  int xz,yz,xk,yk,miy,may;
  int dx,dy;
  char koniec;
  long ax,fx;
  int ac,fc,cz,ck;

  miy=32767;
  may=-32768;
  for (int i=0;i<PolyGon.Pocet;i++)
   {
    if (miy>PolyGon.Vrcholy[i].Y) miy=PolyGon.Vrcholy[i].Y;
    if (may<PolyGon.Vrcholy[i].Y) may=PolyGon.Vrcholy[i].Y;
    if (PolyGon.Vrcholy[i].Y>=mClipMinX)
     {
      if (PolyGon.Vrcholy[i].Y<=mClipMaxX) kx[PolyGon.Vrcholy[i].Y]=Medza;
      else kx[mClipMaxX]=Medza;
     }
    else kx[mClipMinX]=Medza;
   }
  if (!((miy>mClipMaxY) || (may<mClipMinY)))
   {
    if (miy<mClipMinY) miy=mClipMinY;
    if (may>mClipMaxY) may=mClipMaxY;
    for (i=miy;i<=may;i++) zx[i]=Medza;
    for (int j=0; j<PolyGon.Pocet; j++)
     {
      xz=PolyGon.Vrcholy[j].X;
      yz=PolyGon.Vrcholy[j].Y;
      cz=PolyGon.Vrcholy[j].Color<<8;
      if (j<PolyGon.Pocet-1)
       {
	xk=PolyGon.Vrcholy[j+1].X;
	yk=PolyGon.Vrcholy[j+1].Y;
	ck=PolyGon.Vrcholy[j+1].Color<<8;
       }
      else
       {
	xk=PolyGon.Vrcholy[0].X;
	yk=PolyGon.Vrcholy[0].Y;
	ck=PolyGon.Vrcholy[0].Color<<8;
       }
      if (yz==yk)
       {
	if ((xz!=xk) && (zx[yz]==Medza))
	 {
	  zx[yz]=xz;
	  kx[yz]=xk;
	  zf[yz]=cz;
	  kf[yz]=ck;
	 }
       }
      else
       {
	if (yz>yk)
	 {
	  long tm=yz;
	  yz=yk;
	  yk=tm;
	  tm=xz;
	  xz=xk;
	  xk=tm;
	  tm=cz;
	  cz=ck;
	  ck=tm;
	 }
	koniec=0;
	dx=xk-xz;
	dy=yk-yz;
	fx=(long(long(dx)<<16))/long(dy);
	if (unsigned(ck)>=unsigned(cz)) fc=unsigned(ck-cz)/dy;
	else fc=-int(unsigned(cz-ck)/dy);
//	fc=long(long(ck)-long(cz))/long(dy);
	ac=cz;
	if (yz<mClipMinY)
	 {
	  if (yk<mClipMinY) koniec=1;
	  else
	   {
	    ax=long(xz)<<16;
	    ax+=long(mClipMinY-yz)*fx;
	    xz=ax>>16;
            ac+=(mClipMinY-yz)*fc;
	    yz=mClipMinY;
            if (yz==yk) koniec=1;
	   }
	 }
	else ax=long(xz)<<16;
	if (yk>mClipMaxY)
         {
          yk=mClipMaxY;
          if (yz==yk) koniec=1;
         }
	if (!koniec)
	 {
	  if (zx[yz]==Medza)
	   if (kx[yz]==Medza)
	    {
	     kx[yz]=xz;
	     kf[yz]=ac;
	    }
	   else
	    {
	     zx[yz]=xz;
	     zf[yz]=ac;
	    }
	  ax+=fx;
	  ac+=fc;
	  for (i=yz+1;i<=yk;i++)
	   {
	    if (zx[i]==Medza)
	     {
	      zx[i]=ax>>16;
	      zf[i]=ac;
	      if ((ax & 0xFFFF)>0x8000) zx[i]+=1;
	     }
	    else
	     {
	      kx[i]=ax>>16;
	      kf[i]=ac;
	      if ((ax & 0xFFFF)>0x8000) kx[i]+=1;
	     }
	    ax+=fx;
	    ac+=fc;
	   }
	 }
       }
     }
    for (i=miy;i<=may;i++)
     {
      xz=zx[i];
      xk=kx[i];
      cz=zf[i];
      ck=kf[i];
      if (xk<xz)
       {
	int tm=xk;
	xk=xz;
	xz=tm;
	cz=kf[i];
	ck=zf[i];
       }
      if (!((xk<mClipMinX)||(xz>mClipMaxX)))
       {
        dx=xk-xz;
        if (dx!=0)
         {
          if (unsigned(ck)>unsigned(cz)) fc=unsigned(ck-cz)/dx;
          else fc=-int(unsigned(cz-ck)/dx);
          if (xk>mClipMaxX)
           {
            ck-=(mClipMaxX-xk)*fc;
            xk=mClipMaxX;
           }
          if (xz<mClipMinX)
           {
            cz+=(mClipMinX-xz)*fc;
            xz=mClipMinX;
           }
          dx=xk-xz;
         }
        ac=cz;
/*
        for (j=xz;j<=xk;j++)
         {
	  SetPixel (j,i,ac>>8);
	  ac+=fc;
         }
*/

        word vp=GetVideoPage();
        asm {
         MOV  AX,[vp]
         MOV  ES,AX
         MOV  DI,[i]
         MOV  AX,DI
         SHL  DI,8
         SHL  AX,6
         ADD  DI,AX
         ADD  DI,[xz]
         MOV  CX,[xk]
         SUB  CX,[xz]
         INC  CX
         MOV  BX,[ac]
         MOV  DX,[fc]
        }
  Tien:;
        asm {
         MOV  AL,BH
         STOSB
         ADD  BX,DX
         LOOP Tien
        }

       }
     }
   }
 }

