#include "stdio.h"
#include "alloc.h"
#include "operat3d.h"
#include "matica.h"
#include "gdriver.h"
#include "conio.h"
#include "teleso.h"
#include "3d.h"
#include "fpmathf.h"
#include "polygon.h"
#include "object.h"
#include "viditel.h"

#pragma option -rd

PMatica VytvorXR3DMaticu (void)
 {
  PMatica M;
  M=VytvorMaticu (3,3);
  M->M[0][0]=FPLJedna;
  M->M[0][1]=FPLNula;
  M->M[0][2]=FPLNula;
  M->M[1][0]=FPLNula;
  M->M[2][0]=FPLNula;
  return M;
 }

PMatica VytvorYR3DMaticu (void)
 {
  PMatica M;
  M=VytvorMaticu (3,3);
  M->M[1][1]=FPLJedna;
  M->M[0][1]=FPLNula;
  M->M[1][2]=FPLNula;
  M->M[1][0]=FPLNula;
  M->M[2][1]=FPLNula;
  return M;
 }

PMatica VytvorZR3DMaticu (void)
 {
  PMatica M;
  M=VytvorMaticu (3,3);
  M->M[2][2]=FPLJedna;
  M->M[0][2]=FPLNula;
  M->M[1][2]=FPLNula;
  M->M[2][1]=FPLNula;
  M->M[2][0]=FPLNula;
  return M;
 }

PMatica VytvorXYZR3DMaticu (void)
 {
  PMatica M;

  M=VytvorMaticu (3,3);
  return M;
 }

void PrepocetX3DMatice (PMatica M, FPNum Uhol)
 {
  FPNum cos=FPCos (Uhol);
  FPNum sin=FPSin (Uhol);
  M->M[1][1]=cos;
  M->M[1][2]=FPNeg(sin);
  M->M[2][1]=sin;
  M->M[2][2]=cos;
 }

void PrepocetY3DMatice (PMatica M, FPNum Uhol)
 {
  FPNum cos=FPCos (Uhol);
  FPNum sin=FPSin (Uhol);
  M->M[0][0]=cos;
  M->M[2][0]=FPNeg(sin);
  M->M[0][2]=sin;
  M->M[2][2]=cos;
 }

void PrepocetZ3DMatice (PMatica M, FPNum Uhol)
 {
  FPNum cos=FPCos (Uhol);
  FPNum sin=FPSin (Uhol);
  M->M[1][1]=cos;
  M->M[0][1]=FPNeg(sin);
  M->M[1][0]=sin;
  M->M[0][0]=cos;
 }

void PrepocetXYZ3DMatice (PMatica M, FPNum a,FPNum b,FPNum c)
 {
  FPNum cosa=FPCos (a);
  FPNum sina=FPSin (a);
  FPNum cosb=FPCos (b);
  FPNum sinb=FPSin (b);
  FPNum cosc=FPCos (c);
  FPNum sinc=FPSin (c);
  FPNum sab;
  FPNum cac;
  FPNum csac;
  FPNum tmp,tm2;
  sab=FPMul (sina,sinb);
  cac=FPMul (cosa,cosc);
  csac=FPMul (cosa,sinc);
  M->M[0][0]=FPMul (cosb,cosc);
  M->M[0][1]=FPMul(FPNeg(cosb),sinc);
  M->M[0][2]=sinb;
  M->M[1][0]=FPPlus(FPMul(sab,cosc),csac);
  M->M[1][1]=FPMinus(cac,FPMul (sab,sinc));
  M->M[1][2]=FPMul (FPNeg(sina),cosb);
  M->M[2][0]=FPMinus(FPMul(sina,sinc),FPMul(cac,sinb));
  M->M[2][1]=FPPlus(FPMul(sinb,csac),FPMul(sina,cosc));
  M->M[2][2]=FPMul (cosa,cosb);
 }

void RotujBod3D (PMatica M, PVektor B, PVektor V)
 {
  int i,j;

  for (i=0;i<3;V->V[i]=FPLNula,i++);
  for (i=0;i<3;++i)
   {
    for (j=0;j<3;++j)
     {
      if (M->M[i][j].L!=FPLNula.L)
       {
	if (M->M[i][j].L==FPLJedna.L)
	 V->V[i].L=V->V[i].L+B->V[j].L;        //FPPlus
//	 V->V[i]+=B->V[j];
	else
	 {
	  V->V[i].L+=FPMul (M->M[i][j],B->V[j]).L;
//	  FPMul (M->M[i][j],B->V[j],&Res);
//	  FPPlus (V->V[i],Res,&V->V[i]);
//	 V->V[i]+=M->M[i][j]*B->V[j];

	 }
       }
     }
   }
 }

#define StX -160
#define StY -100
#define StZ -100
#define LnX 80
#define LnY 80
#define LnZ 80

void Kresli (HranoveTeleso far *T)
 {
  int x1,y1,x2,y2;
  int v1,v2;

  for (int i=0; i<T->PocetHran; i++)
   {
    v1=T->Hrany[i].Konce[0];
    v2=T->Hrany[i].Konce[1];
    x1=FPTrunc(T->Body[v1-1].V[0])-StX;
    y1=FPTrunc(T->Body[v1-1].V[1])-StY;
    x2=FPTrunc(T->Body[v2-1].V[0])-StX;
    y2=FPTrunc(T->Body[v2-1].V[1])-StY;
    Line (x1,y1,x2,y2,15);
   }

/*
  for (int i=0; i<T->PocetBodov; i++)
   {
    x1=Trunc(T->Body[i].V[0])-StX;
    y1=Trunc(T->Body[i].V[1])-StY;
    SetPixel(x1,y1,15);
   }
*/
 }

void KresliPlochy (PPlosneTeleso T)
 {
  int x1,y1,x2,y2;
  int v1,v2,vt;
  byte c;
  FPNum U;
  TColorPoint p[30];
  TShadedPolygon P;

/*
  for (int i=0; i<T->PocetPloch; i++)
   {
    if (T->Plochy[i].Svetlost.L>=0)
     {
      c=(T->Plochy[i].Svetlost.L>>12) & 0x0F;
      for (int j=0; j<T->Plochy[i].PocetBodov; ++j)
       {
	v1=T->Plochy[i].Okraj[j];
	if (j<T->Plochy[i].PocetBodov-1) v2=T->Plochy[i].Okraj[j+1];
	else v2=T->Plochy[i].Okraj[0];
	if (v1>v2)
	 {
	  vt=v1;
	  v1=v2;
	  v2=vt;
	 }
	x1=FPTrunc(T->Body[v1].V[0])-StX;
	y1=FPTrunc(T->Body[v1].V[1])-StY;
	x2=FPTrunc(T->Body[v2].V[0])-StX;
	y2=FPTrunc(T->Body[v2].V[1])-StY;
	Line (x1,y1,x2,y2,c+16);
       }
     }
   }
*/

  for (int i=0; i<T->PocetPloch; i++)
   {
    if (T->Plochy[i].Svetlost.L>=0)
     {
      for (int j=0; j<T->Plochy[i].PocetBodov; ++j)
       {
	if (T->Farby[T->Plochy[i].Okraj[j]].L<=0) p[j].Color=0;
	else p[j].Color=((T->Farby[T->Plochy[i].Okraj[j]].L>>8) & 0xFF);
	p[j].X=FPTrunc(T->Body[T->Plochy[i].Okraj[j]].V[0])-StX;
	p[j].Y=FPTrunc(T->Body[T->Plochy[i].Okraj[j]].V[1])-StY;
       }
      P.Pocet=T->Plochy[i].PocetBodov;
      P.Vrcholy=(TColorPoint far*) &p;
      ShadedPolygon (P);
     }

// Viditelnost zadnej strany
/*
    else
     {
      for (int j=0; j<T->Plochy[i].PocetBodov; ++j)
       {
	if (T->Farby[T->Plochy[i].Okraj[j]].L>0) p[j].Color=0;
	else p[j].Color=((-T->Farby[T->Plochy[i].Okraj[j]].L>>8) & 0xFF);
	p[j].X=FPTrunc(T->Body[T->Plochy[i].Okraj[j]].V[0])-StX;
	p[j].Y=FPTrunc(T->Body[T->Plochy[i].Okraj[j]].V[1])-StY;
       }
      P.Pocet=T->Plochy[i].PocetBodov;
      P.Vrcholy=(TColorPoint far*) &p;
      ShadedPolygon (P);
     }
*/
   }
 }

void KresliUtriedenePlochy (PPlosneTeleso T, PTriediacaTabulka TT)
 {
  int x1,y1,x2,y2;
  int v1,v2,vt,k;
  byte c;
  FPNum U;
  TColorPoint p[30];
  TShadedPolygon P;

  for (int i=0; i<T->PocetPloch; i++)
   {
    k=TT->Poradie[i];
    if (T->Plochy[k].Svetlost.L>=0)
     {
      for (int j=0; j<T->Plochy[k].PocetBodov; ++j)
       {
	if (T->Farby[T->Plochy[k].Okraj[j]].L<=0) p[j].Color=0;
	else p[j].Color=((T->Farby[T->Plochy[k].Okraj[j]].L>>8) & 0xFF);
	p[j].X=FPTrunc(T->Body[T->Plochy[k].Okraj[j]].V[0])-StX;
	p[j].Y=FPTrunc(T->Body[T->Plochy[k].Okraj[j]].V[1])-StY;
       }
      P.Pocet=T->Plochy[k].PocetBodov;
      P.Vrcholy=(TColorPoint far*) &p;
      ShadedPolygon (P);
     }

// Viditelnost zadnej strany
/*
    else
     {
      for (int j=0; j<T->Plochy[k].PocetBodov; ++j)
       {
	if (T->Farby[T->Plochy[k].Okraj[j]].L>0) p[j].Color=0;
	else p[j].Color=(((-T->Farby[T->Plochy[k].Okraj[j]].L)>>8) & 0xFF);
	p[j].X=FPTrunc(T->Body[T->Plochy[k].Okraj[j]].V[0])-StX;
	p[j].Y=FPTrunc(T->Body[T->Plochy[k].Okraj[j]].V[1])-StY;
       }
      P.Pocet=T->Plochy[k].PocetBodov;
      P.Vrcholy=(TColorPoint far*) &p;
      ShadedPolygon (P);
     }
*/
   }
 }

// Rotacia cez 3 matice

void Rotuj3Mat (HranoveTeleso far* T)
 {
  PMatica M;
  PMatica N;
  PMatica O;
  FPNum Uhol,zUhol,Uhol2,zUhol2,Uhol3,zUhol3;
  HranoveTeleso far* V;
  HranoveTeleso far* W;
  HranoveTeleso far* U;
  int i;

  M=VytvorZR3DMaticu();
  N=VytvorXR3DMaticu();
  O=VytvorYR3DMaticu();
  Uhol=FPLNula;
  Uhol2=FPLNula;
  Uhol3=FPLNula;
  zUhol=ConvertRealL(0.025);
  zUhol2=ConvertRealL(0.05);
  zUhol3=ConvertRealL(0.001);
  V=PrenesHranoveTeleso (T);
  W=PrenesHranoveTeleso (T);
  U=PrenesHranoveTeleso (T);
  while (!kbhit())
   {
    PrepocetZ3DMatice (M,Uhol);
    PrepocetX3DMatice (N,Uhol2);
    PrepocetY3DMatice (O,Uhol3);
    for (i=0; i<V->PocetBodov; i++)
     {
      RotujBod3D (M,&T->Body[i],&V->Body[i]);
     }
    for (i=0; i<V->PocetBodov; i++)
     {
      RotujBod3D (N,&V->Body[i],&W->Body[i]);
     }
    for (i=0; i<V->PocetBodov; i++)
     {
      RotujBod3D (N,&W->Body[i],&U->Body[i]);
     }
    Kresli (U);
    WaitFrames(2);
    ClearScreen (0);
    Uhol.L+=zUhol.L;
    Uhol2.L+=zUhol2.L;
    Uhol3.L+=zUhol3.L;
   }
 }

// Rotacia cez jednu maticu

void Rotuj (HranoveTeleso far* T)
 {
  PMatica M;
  PMatica N;
  PMatica O;
  PMatica P;
  FPNum Uhol,zUhol,Uhol2,zUhol2,Uhol3,zUhol3;
  HranoveTeleso far* V;
  HranoveTeleso far* W;
  HranoveTeleso far* U;
  int i;

  P=VytvorXYZR3DMaticu();
  Uhol=FPLNula;
  Uhol2=FPLNula;
  Uhol3=FPLNula;
  zUhol=ConvertRealL(0.001);
  zUhol2=ConvertRealL(0.025);
  zUhol3=ConvertRealL(0.025);
  V=PrenesHranoveTeleso (T);
  while (!kbhit())
   {
    PrepocetXYZ3DMatice (P,Uhol,Uhol2,Uhol3);
    for (i=0; i<V->PocetBodov; i++)
     {
      RotujBod3D (P,&T->Body[i],&V->Body[i]);
     }
    Kresli (V);
    WaitFrames(2);
    ClearScreen (0);
    Uhol.L+=zUhol.L;
    Uhol2.L+=zUhol2.L;
    Uhol3.L+=zUhol3.L;
   }
 }

// Rotacia

void Rotuj3D (unsigned int Scr, HranoveTeleso far* T)
 {
  PGonio G;
  FPNum Uhol,zUhol,Uhol2,zUhol2,Uhol3,zUhol3;
  HranoveTeleso far* V;
  int i;

  G=CreateGonioTable();
  Uhol=FPLNula;
  Uhol2=FPLNula;
  Uhol3=FPLNula;
  zUhol=ConvertRealL(0.001);
  zUhol2=ConvertRealL(0.025);
  zUhol3=ConvertRealL(0.025);
  V=PrenesHranoveTeleso (T);
  while (!kbhit())
   {
    ComputeXYZRotation(G,Uhol,Uhol2,Uhol3);
    for (i=0; i<V->PocetBodov; i++)
     {
      XYZRotate3D (G,&T->Body[i],&V->Body[i]);
     }
    Kresli (V);
//    WaitFrames(2);
    UseVirtual(Scr);
    WaitRetrace();
    ClearScreen (0);
    Uhol.L+=zUhol.L;
    Uhol2.L+=zUhol2.L;
    Uhol3.L+=zUhol3.L;
   }
 }

void Rotuj3DPlochy (unsigned int Scr, PVektor S, PPlosneTeleso T)
 {
  PGonio G;
  FPNum Uhol,zUhol,Uhol2,zUhol2,Uhol3,zUhol3;
  PPlosneTeleso V;
  PTriediacaTabulka TT;
  PVektor B;
  TVektor P;
  int i;

  G=CreateGonioTable();
  TT=VytvorTriediacuTabulku (T->PocetPloch);
  Uhol=FPLNula;
  Uhol2=FPLNula;
  Uhol3=FPLNula;
  zUhol=ConvertRealL(0.001);
  zUhol2=ConvertRealL(0.025);
  zUhol3=ConvertRealL(0.025);
  P.V[0]=FPLNula;                  // Vektor pohladu
  P.V[1]=FPLNula;
  P.V[2]=FPLJedna;
  NormalizeVector (S,S);
  V=PretvorPlosneTeleso (T);
  while (!kbhit())
   {
    ComputeXYZRotation(G,Uhol,Uhol2,Uhol3);
    XYZObjectRotate3D (G,S,T,V);
    NastavParametreTriedenia (TT,V);
    UtriedTabulku (TT);
/*
    for (i=0; i<V->PocetBodov; i++)
     {
      XYZRotate3D (G,&T->Body[i],&V->Body[i]);
      XYZRotate3D (G,&T->Smery[i],&V->Smery[i]);
      V->Farby[i]=ScalarProduct (S,&V->Smery[i]);
     }
*/
/*
    for (i=0; i<V->PocetPloch; i++)
     {
      XYZRotate3D (G,&T->Normaly[i],&V->Normaly[i]);
//      V->Plochy[i].Svetlost=ScalarProduct (&P,&V->Normaly[i]);
      V->Plochy[i].Svetlost=V->Normaly[i].V[2];
     }
*/
    KresliUtriedenePlochy (V,TT);
//    WaitFrames(2);
    WaitRetrace();
    UseVirtual(Scr);
    ClearScreen (0);
    Uhol.L+=zUhol.L;
    Uhol2.L+=zUhol2.L;
    Uhol3.L+=zUhol3.L;
   }
  VyprazdniPlosneTeleso(V);
  farfree (G);
 }

