// Driver.Hpp
// Implementes use of *.DRV graphical drivers
// under Borland C++
// (c) 1993-1997 ALAC Software

#ifndef _Driver
#define _Driver

#define Font8x6         6
#define Font8x8         8
#define Font8x12        12
#define Font8x14        14
#define Font8x16        16
#define VRAM            0xA000

// Compatibility structures
typedef unsigned char TPalette [768];
typedef unsigned char TVESABuf [512];
typedef char **String;

#endif

// Driver procedures
extern "C" void far pascal SetBIOSMode (unsigned char Mode);
extern "C" void far pascal LoadDriver (void far *Name);
extern "C" void far pascal LocateDriver (void far *Name, void far *Where, unsigned int SizeAvailable);
extern "C" void far pascal DeAllocateDriver (void);
extern "C" void far pascal LinkDriver (void);
extern "C" void far pascal UnLinkDriver (void);
extern "C" void far pascal AllocateDriverMemory (unsigned int Size, void far* far* Memory);
extern "C" void far pascal DeAllocateDriverMemory (unsigned int Size, void far* far* Memory);

// Driver implemented procedures
extern "C" unsigned int far pascal DriverLink (void);
extern "C" void far pascal SetMode (unsigned char Mode);
extern "C" void far pascal SetUserMode (unsigned int VBEMode, unsigned int HorizRg, unsigned int VertRg, unsigned int Color, unsigned int HorizFreq, unsigned int VertFreq);
extern "C" void far* far pascal ModeInfo (unsigned int Num);
extern "C" void far pascal SetActualPage (unsigned int Page);
extern "C" void far pascal SetVisualPage (unsigned int Page);
extern "C" unsigned int far pascal GetActualPage (void);
extern "C" unsigned int far pascal GetVisualPage (void);
extern "C" void far pascal GetResolution (unsigned int ResX, unsigned int ResY);
extern "C" void far pascal GetFrequency (unsigned int Vert, unsigned int Horiz);
extern "C" unsigned long far pascal GetColors (void);

// Main functions
extern "C" void far pascal SetGraphicsMode (void);
extern "C" void far pascal SetTextMode (void);
extern "C" void far pascal UseVirtual (unsigned int SegVirtual);
extern "C" void far pascal CopyScreen (unsigned int SegSource, unsigned int SegDestinaton);
extern "C" void far pascal CopyRows (unsigned int SegSource, unsigned int SegDestinaton, unsigned int Y1, unsigned int Y2);
extern "C" void far pascal CopyRowsRel (unsigned int SegSource, unsigned int SegDestinaton, unsigned int Y, unsigned int Count);
extern "C" void far pascal ClearScreen (unsigned char Color);
extern "C" void far pascal ClearScreenVirtual (unsigned int SegVirtual, unsigned char Color);
extern "C" void far pascal InvertScreen (unsigned int SegScreen);
extern "C" void far pascal WaitRetrace (void);
extern "C" void far pascal WaitVRetrace (void);
extern "C" void far pascal WaitNotVRetrace (void);
extern "C" void far pascal WaitFrames (unsigned int Frames);
extern "C" void far pascal SetVideoPage (unsigned int VPage);
extern "C" unsigned int far pascal GetVideoPage (void);

// Palette
extern "C" void far pascal SetPalette (void far *PPal);
extern "C" void far pascal GetPalette (TPalette far *PPal);
extern "C" void far pascal IncPalette (void far *PPal, unsigned char Step);
extern "C" void far pascal DecPalette (void far *PPal, unsigned char Step);
extern "C" void far pascal ConvertRGBPalette (TPalette far *POldPal, TPalette far *Pal);
extern "C" void far pascal RotatePaletteLeft (void far *PPal);
extern "C" void far pascal RotatePaletteRight (void far *PPal);

// Pixel
extern "C" void far pascal SetPixel (unsigned int X, unsigned int Y, unsigned char Col);
extern "C" void far pascal SetPixelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned char Col);
extern "C" unsigned char far pascal GetPixel (unsigned int X, unsigned int Y);
extern "C" unsigned char far pascal GetPixelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y);

// Line
extern "C" void far pascal HorizontalLine (unsigned int X1, unsigned int X2, unsigned int Y, unsigned char Col);
extern "C" void far pascal HorizontalLineVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int X2, unsigned int Y, unsigned char Col);
extern "C" void far pascal HorizontalLineRel (unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern "C" void far pascal HorizontalLineRelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern "C" void far pascal VerticalLine (unsigned int X, unsigned int Y1, unsigned int Y2, unsigned char Col);
extern "C" void far pascal VerticalLineVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y1, unsigned int Y2, unsigned char Col);
extern "C" void far pascal VerticalLineRel (unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern "C" void far pascal VerticalLineRelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern "C" void far pascal Line (unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern "C" void far pascal LineVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);

// Boxes, filled rectangles
extern "C" void far pascal DrawBox (unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern "C" void far pascal DrawBoxRel (unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern "C" void far pascal DrawBoxVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern "C" void far pascal DrawBoxRelVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);

// Circle, filled circle
extern "C" void far pascal Circle (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal CircleVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal CircleClip (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal CircleClipVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal FilledCircle (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal FilledCircleVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal FilledCircleClip (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern "C" void far pascal FilledCircleClipVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);

// Ellipse, filled ellipse
extern "C" void far pascal Ellipse (unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal EllipseVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal EllipseClip (unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal EllipseClipVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal FilledEllipse (unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal FilledEllipseVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal FilledEllipseClip (unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);
extern "C" void far pascal FilledEllipseClipVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int A, unsigned int B, unsigned char Color);

// Sprites
extern "C" unsigned int far pascal Adress (unsigned int X, unsigned int Y);
extern "C" void far pascal Sprite (void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal SpriteOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal SpriteVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal SpriteOverVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal GetSprite (void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal GetSpriteVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal CopySprite (unsigned int SegSource, unsigned int SegDestinaton, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char SWidth, unsigned char SHeight);
extern "C" void far pascal SpriteScale (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern "C" void far pascal SpriteScaleOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern "C" void far pascal SpriteScaleVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern "C" void far pascal SpriteScaleOverVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern "C" void far pascal SpriteScaleRel (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);
extern "C" void far pascal SpriteScaleOverRel (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);
extern "C" void far pascal SpriteScaleRelVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);
extern "C" void far pascal SpriteScaleOverRelVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);

// Cells
extern "C" void far pascal Cell (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);
extern "C" void far pascal CellOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);
extern "C" void far pascal CellVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);
extern "C" void far pascal CellOverVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);

// Write, font functions
extern "C" void far pascal SetCharSpace (unsigned int Space);
extern "C" void far pascal SetCharHeight (unsigned char Height);
extern "C" void far pascal SetLineSpace (unsigned char Space);
extern "C" unsigned int far pascal GetCharSpace;
extern "C" unsigned char far pascal GetCharHeight;
extern "C" unsigned char far pascal GetLineSpace;
extern "C" void far pascal PrintText (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextHI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextHD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextVI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextVD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextOver (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextOverHI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextOverHD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextOverVI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern "C" void far pascal PrintTextOverVD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);

// Screens, compressed screens
// Fix-up overflow
extern "C" void far pascal ShowScreen (void far *PScreen);
extern "C" void far pascal SetScreen (void far *PScreen);
extern "C" void far pascal SetScreenVirtual (unsigned int SegVirtual, void far *PScreen);
extern "C" void far pascal ShowCompressedScreen (void far *PScreen);
extern "C" void far pascal DeCompressScreen (void far *PScreen);
extern "C" void far pascal DeCompressVirtual (unsigned int SegVirtual, void far *PScreen);
extern "C" void far pascal DeCompressOverVirtual (unsigned int SegVirtual, void far *PScreen);

// PCX screens & sprites
extern "C" void far pascal ShowPCX (void far *PPCX);
extern "C" void far pascal DeCompressPCX (void far *PPCX);
extern "C" void far pascal DeCompressPCXVirtual (unsigned int SegVirtual, void far *PPCX);
extern "C" void far pascal PCXSprite (void far *PPCX, unsigned int X, unsigned int Y);
extern "C" void far pascal PCXSpriteVirtual (unsigned int SegVirtual, void far *PPCX, unsigned int X, unsigned int Y);
extern "C" void far pascal PCXSpriteOver (void far *PPCX, unsigned int X, unsigned int Y);
extern "C" void far pascal PCXSpriteOverVirtual (unsigned int SegVirtual, void far *PPCX, unsigned int X, unsigned int Y);
