TITLE Driver

Model Medium

.286

INCLUDE DriveExt.Inc

.CODE

INCLUDE DrivePub.Inc
INCLUDE DriveDef.Inc
INCLUDE DriveInt.Inc

;Displays message if procedure not linked

LinkError:         MOV     BX,Offset mError
                   PUSH    BX
		   CALL    PrintMessage
                   MOV     AX,0FFFFH
                   RETF

;Prints message

PrintMessage PROC NEAR
 ARG MessageOffset: WORD
                   ENTER   0,0
                   MOV     BX,[MessageOffset]
                   MOV     AH,2
          PrintCh: MOV     DL,CS:[BX]
                   OR      DL,DL
                   JZ      PrintOv
                   INT     21H
		   INC     BX
                   JMP     PrintCh
          PrintOv: LEAVE
		   RET     2
PrintMessage ENDP

;Sets BIOS video mode

SetBIOSMode PROC FAR
 ARG Mode: Byte
                   ENTER   0,0
                   XOR     AX,AX
                   MOV     AL,[Mode]
                   INT     10H
                   LEAVE
                   RET     2
SetBIOSMode ENDP

;Opens file, input: ASCIIZ name, output: AX-handle/error(-1)

FileOpen PROC NEAR
 ARG FileName: DWORD
                   ENTER   0,0
                   PUSH    DS
                   LDS     DX,[FileName]
                   MOV     AX,3D00H
                   INT     21H
                   JNC     OpenOK
                   MOV     AX,0FFFFH
        OpenOk:    POP     DS
                   LEAVE
                   RET     4
FileOpen ENDP

;Seeks position in a file, input: Handle & position, ouput: DX:AX new position

FileSeek PROC NEAR
 ARG Position: DWORD, Handle: WORD
		  ENTER   0,0
                  MOV     CX,WORD PTR [Position+2]
                  MOV     DX,WORD PTR [Position]
                  MOV     BX,[Handle]
                  MOV     AX,4200H
                  INT     21H
                  JNC     SeekOk
                  MOV     AX,0FFFFH
                  MOV     DX,AX
       SeekOk:    LEAVE
                  RET     6
FileSeek ENDP

;Reads block from file, input: Handle, Buffer PTR, filesize, output: AX-Error

FileRead PROC NEAR
 ARG FSize: WORD, Buffer: DWORD, Handle: WORD
                  ENTER   0,0
                  PUSH    DS
                  LDS     DX,[Buffer]
                  MOV     BX,[Handle]
                  MOV     AH,3FH
                  MOV     CX,[FSize]
                  INT     21H
                  JNC     ReadOk
                  MOV     AX,0FFFFH
       ReadOk:    POP     DS
                  LEAVE
                  RET     8
FileRead ENDP

;Gets size of file, input: handle, output: DX:AX-size/error

FileSize PROC NEAR
 ARG Handle: WORD
		  ENTER   0,0
                  XOR     CX,CX
                  XOR     DX,DX
                  MOV     BX,[Handle]
                  MOV     AX,4202H
                  INT     21H
                  JNC     SizeOk
                  MOV     AX,0FFFFH
                  MOV     DX,AX
       SizeOk:    PUSH    DX
                  PUSH    AX
                  MOV     AX,[Handle]
                  PUSH    AX
                  PUSH    0
                  PUSH    0
                  CALL    FileSeek
                  POP     AX
                  POP     DX
                  LEAVE
                  RET     2
FileSize ENDP

;Closes file, input: handle, output: AX-error

FileClose PROC NEAR
 ARG Handle: WORD
                   ENTER   0,0
                   MOV     BX,[Handle]
                   MOV     AH,3EH
                   INT     21H
                   JNC     CloseOK
                   MOV     AX,0FFFFH
      CloseOk:     LEAVE
                   RET     2
FileClose ENDP

;Links driver, links references in main code segment with driver code segment

LinkDriver PROC NEAR
                   PUSH    DS
                   MOV     AX,[DriverSegment]
                   MOV     BX,AX
                   MOV     DS,AX
                   MOV     SI,80H
                   MOV     AX,CS
                   MOV     ES,AX
                   MOV     DI,Offset _DriverLink
                   MOV     CX,NumProc
       LinkTable:  LODSW
                   STOSW
;                   ADD     SI,2
                   MOV     AX,BX
                   STOSW
                   LOOP    LinkTable
                   POP     DS
                   RET
LinkDriver ENDP

; Unlinks driver, makes all the pointers as DRIVER_TEXT:LinkError

UnLinkDriver PROC NEAR
                   PUSH    DS
                   MOV     AX,[DriverSegment]
                   MOV     BX,AX
                   MOV     AX,CS
                   MOV     ES,AX
                   MOV     DI,Offset _DriverLink
		   MOV     CX,NumProc
                   MOV     DX,Offset LinkError
                   MOV     BX,CS
     UnLinkTable:  MOV     AX,DX
                   STOSW
                   MOV     AX,BX
                   STOSW
                   LOOP    UnLinkTable
                   POP     DS
                   RET
UnLinkDriver ENDP

;Loads and links driver into memory

LoadDriver PROC FAR
 ARG FileName: DWORD
		   ENTER   0,0
                   MOV     AX,WORD PTR [FileName+2]
                   PUSH    AX
                   MOV     AX,WORD PTR [FileName]
                   PUSH    AX
                   CALL    FileOpen
                   CMP     AX,0FFFFH
                   JE      FileErr
                   MOV     [mHandle],AX
                   PUSH    AX
                   CALL    FileSize
                   CMP     DX,0FFFFH
                   JE      FileErr
                   MOV     [mMemorySize],AX
                   MOV     AX,[mMemorySize]
                   PUSH    AX
                   PUSH    CS
                   MOV     AX,Offset mMemoryBlock
                   PUSH    AX
                   CALL    AllocateDriverMemory
                   MOV     AX,WORD PTR [mMemoryBlock]
                   MOV     CX,AX
		   MOV     BX,WORD PTR [mMemoryBlock+2]
                   OR      BX,BX
                   JNZ     MemAll
                   OR      AX,AX
                   JZ      MemoryErr
        MemAll:    OR      CX,CX
                   JZ      SegOk
                   INC     BX
         SegOk:    MOV     [DriverSegment],BX
                   MOV     AX,[mHandle]
                   PUSH    AX
                   MOV     AX,[DriverSegment]
                   PUSH    AX
		   PUSH    0
                   MOV     AX,[mMemorySize]
                   PUSH    AX
                   CALL    FileRead
                   CMP     AX,0FFFFH
                   JE      FileErr
                   MOV     AX,[mHandle]
                   PUSH    AX
                   CALL    FileClose
                   CMP     AX,0FFFFH
                   JE      FileErr
                   CALL    LinkDriver
                   XOR     AX,AX
         LoadEnd:  LEAVE
                   RET     4
         FileErr:  MOV     AX,Offset mIOError
                   PUSH    AX
                   CALL    PrintMessage
                   MOV     AX,0FFFFH
                   JMP     LoadEnd
       MemoryErr:  MOV     AX,Offset mMemError
                   PUSH    AX
                   CALL    PrintMessage
                   MOV     AX,0FFFFH
                   JMP     LoadEnd
LoadDriver ENDP

; Loads and links driver into preallocated memory with its size

LocateDriver PROC FAR
 ARG SizeAvail: WORD, Where: DWORD, FileName: DWORD
                   ENTER   0,0
                   MOV     AX,WORD PTR [FileName+2]
                   PUSH    AX
                   MOV     AX,WORD PTR [FileName]
		   PUSH    AX
                   CALL    FileOpen
                   CMP     AX,0FFFFH
                   JE      AFileErr
                   MOV     [mHandle],AX
                   PUSH    AX
                   CALL    FileSize
                   CMP     DX,0FFFFH
                   JE      AFileErr
                   MOV     [mMemorySize],AX
                   ADD     AX,16
                   OR      DX,DX
                   JNZ     AMemoryErr
                   CMP     AX,[SizeAvail]
                   JA      AMemoryErr
                   LES     DI,[Where]
                   MOV     BX,ES
                   MOV     AX,DI
                   MOV     WORD PTR [mMemoryBlock],AX
                   MOV     CX,AX
                   MOV     WORD PTR [mMemoryBlock+2],BX
                   OR      BX,BX
		   JNZ     AMemAll
                   OR      AX,AX
                   JZ      AMemoryErr
        AMemAll:   OR      CX,CX
                   JZ      ASegOk
                   INC     BX
        ASegOk:    MOV     [DriverSegment],BX
                   MOV     AX,[mHandle]
                   PUSH    AX
                   MOV     AX,[DriverSegment]
                   PUSH    AX
                   PUSH    0
                   MOV     AX,[mMemorySize]
		   PUSH    AX
                   CALL    FileRead
                   CMP     AX,0FFFFH
                   JE      AFileErr
                   MOV     AX,[mHandle]
                   PUSH    AX
                   CALL    FileClose
                   CMP     AX,0FFFFH
                   JE      AFileErr
                   CALL    LinkDriver
                   XOR     AX,AX
        AllocEnd:  LEAVE
                   RET     10
        AFileErr:  MOV     AX,Offset mIOError
                   PUSH    AX
                   CALL    PrintMessage
                   MOV     AX,0FFFFH
                   JMP     LoadEnd
      AMemoryErr:  MOV     AX,Offset mMemError
                   PUSH    AX
                   CALL    PrintMessage
                   MOV     AX,0FFFFH
		   JMP     LoadEnd
LocateDriver ENDP

; Deallocates memory, but first unlinks driver

DeAllocateDriver PROC FAR
		   ENTER   0,0
		   CALL    UnLinkDriver
		   MOV     AX,[mMemorySize]
		   PUSH    AX
		   PUSH    CS
		   MOV     AX,Offset mMemoryBlock
		   PUSH    AX
                   CALL    DeAllocateDriverMemory
                   LEAVE
                   RET
DeAllocateDriver ENDP

END
