TITLE Operations_in_3D_Space_32bit_Real_Mode

;*************************************************************************
;* Non-matrix basical set of 3D operations                               *
;* Higher Level Programming Language Interface                           *
;* 32-bit FixedPoint Math Usage, 386+ Required, Real Mode                *
;* 3D Vectors supported (FPNum V[3], Array [0..2] Of FPNum)              *
;*************************************************************************

.386

; Gonio - storage of single-step constants

Gonio STRUC
       CosA     DD    0
       SinA     DD    0
       CosB     DD    0
       SinB     DD    0
       CosC     DD    0
       SinC     DD    0
       SinAB    DD    0
       CosAC    DD    0
       CSAC     DD    0
Gonio ENDS

EXTRN FPSin : FAR              ; Linked from FixPMFnc.Asm
EXTRN FPCos : FAR              ; FixedPoint Math Function
EXTRN FPSqrt: FAR

Operat3D32 SEGMENT WORD PUBLIC USE16 'CODE'
ASSUME CS:Operat3D32

;*****************************************************************************
;*                            FPXXXX 3D Support                              *
;*****************************************************************************

; ComputeXRotation - computes constant values Sin(A), Cos(A)
;                    and stores them into ConstVal variable P

PUBLIC ComputeXRotation
ComputeXRotation PROC FAR
 ARG A: DWORD, P: DWORD
                  ENTER  0,0
                  MOV    EAX,[A]
                  PUSH   EAX
                  CALL   FPSin
                  LES    DI,[P]
                  MOV    ES:[DI+4],AX         ; SinA
                  MOV    ES:[DI+6],DX
                  MOV    EAX,[A]
                  PUSH   EAX
                  CALL   FPCos
                  LES    DI,[P]
                  MOV    ES:[DI],AX           ; CosA
                  MOV    ES:[DI+2],DX
                  LEAVE
                  RET    8
ComputeXRotation ENDP

; ComputeYRotation - computes constant values Sin(A), Cos(A)
;                    and stores them into ConstVal variable P

PUBLIC ComputeYRotation
ComputeYRotation PROC FAR
                  JMP    ComputeXRotation
ComputeYRotation ENDP

; ComputeZRotation - computes constant values Sin(A), Cos(A)
;                    and stores them into ConstVal variable P

PUBLIC ComputeZRotation
ComputeZRotation PROC FAR
                  JMP    ComputeZRotation
ComputeZRotation ENDP

; ComputeXRotation - computes constant values Sin(A), Cos(A), Sin(B), Cos(B),
;                    Sin(C), Cos(C), Sin(A)*Sin(B), Cos(A)*Cos(C),
;                    Cos(A)*Sin(C) and stores them into ConstVal variable P

PUBLIC ComputeXYZRotation
ComputeXYZRotation PROC FAR
 ARG C: DWORD, B: DWORD, A: DWORD, P: DWORD
                  ENTER  0,0
                  MOV    EAX,[A]
                  PUSH   EAX
                  CALL   FPSin
                  LES    DI,[P]
                  MOV    ES:[DI+4],AX         ; SinA
                  MOV    ES:[DI+6],DX
                  MOV    EAX,[A]
                  PUSH   EAX
                  CALL   FPCos
                  LES    DI,[P]
                  MOV    ES:[DI],AX           ; CosA
                  MOV    ES:[DI+2],DX
                  LES    DI,[P]
                  MOV    EAX,[B]
                  PUSH   EAX
                  CALL   FPSin
                  LES    DI,[P]
                  MOV    ES:[DI+12],AX        ; SinB
                  MOV    ES:[DI+14],DX
                  MOV    EAX,[B]
                  PUSH   EAX
                  CALL   FPCos
                  LES    DI,[P]
                  MOV    ES:[DI+8],AX         ; CosB
                  MOV    ES:[DI+10],DX
                  LES    DI,[P]
                  MOV    EAX,[C]
                  PUSH   EAX
                  CALL   FPSin
                  LES    DI,[P]
                  MOV    ES:[DI+20],AX        ; SinC
                  MOV    ES:[DI+22],DX
                  MOV    EAX,[C]
                  PUSH   EAX
                  CALL   FPCos
                  LES    DI,[P]
                  MOV    ES:[DI+16],AX        ; CosC
                  MOV    ES:[DI+18],DX
                  LES    DI,[P]
                  MOV    EAX,ES:[DI+4]
                  MOV    EBX,ES:[DI+12]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ES:[DI+24],EDX       ; SinAB = Sin(A)*Sin(B)
                  LES    DI,[P]
                  MOV    EAX,ES:[DI]
                  MOV    EBX,ES:[DI+16]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ES:[DI+28],EDX       ; CosAC = Cos(A)*Cos(C)
                  LES    DI,[P]
                  MOV    EAX,ES:[DI]
                  MOV    EBX,ES:[DI+20]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ES:[DI+32],EDX       ; CSAC = Cos(A)*Sin(C)
                  LEAVE
                  RET    16
ComputeXYZRotation ENDP

; XRotate3D - rotates vector about X-axis

PUBLIC XRotate3D
XRotate3D PROC FAR
 ARG VO: DWORD, VI: DWORD, M: DWORD
                  ENTER  0,0
                  PUSH   DS
                  LES    DI,[M]
                  MOV    ECX,ES:[DI]          ; ECX = CosA
                  MOV    EBX,ES:[DI+4]        ; EBX = SinA
                  LES    DI,[VO]              ; ES:[DI] = New vector
                  LDS    SI,[VI]              ; DS:[SI] = Source vector
                  MOV    EAX,DS:[SI]          ;           (model)
                  MOV    ES:[DI],EAX          ; X=X
                  MOV    EAX,DS:[SI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  PUSH   EDX
                  MOV    EAX,DS:[SI+4]
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  POP    EAX
                  SUB    EDX,EAX              ; Y=Y*Cos(A)-Z*Sin(A)
                  MOV    ES:[DI+4],EDX        ; Y=DS:[SI+4]*ECX-DS:[SI+8]*EBX
                  MOV    EAX,DS:[SI+4]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
		  PUSH   EDX
                  MOV    EAX,DS:[SI+8]
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  POP    EAX
                  ADD    EDX,EAX              ; Z=Y*Sin(A)+Z*Cos(A)
                  MOV    ES:[DI+8],EDX        ; Z=DS:[SI+4]*EBX+DS:[SI+8]*ECX
                  POP    DS
                  LEAVE
                  RET    12
XRotate3D ENDP

; YRotate3D - rotates vector about Y-axis

PUBLIC YRotate3D
YRotate3D PROC FAR
 ARG VO: DWORD, VI: DWORD, M: DWORD
                  ENTER  0,0
                  PUSH   DS
                  LES    DI,[M]
                  MOV    ECX,ES:[DI]          ; ECX = CosA
                  MOV    EBX,ES:[DI+4]        ; EBX = SinA
                  LES    DI,[VO]              ; ES:[DI] = New vector
                  LDS    SI,[VI]              ; DS:[SI] = Source vector
                  MOV    EAX,DS:[SI+4]        ;           (model)
                  MOV    ES:[DI+4],EAX        ; Y=Y
                  MOV    EAX,DS:[SI]
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  PUSH   EDX
		  MOV    EAX,DS:[SI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  POP    EAX
                  ADD    EDX,EAX              ; X=X*Cos(A)+Z*Sin(A)
                  MOV    ES:[DI],EDX          ; X=DS:[SI]*ECX+DS:[SI+8]*EBX
                  MOV    EAX,DS:[SI]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  PUSH   EDX
                  MOV    EAX,DS:[SI+8]
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  POP    EAX
                  SUB    EDX,EAX              ; Z=Z*Cos(A)-X*Sin(A)
                  MOV    ES:[DI+8],EDX        ; Z=DS:[SI+8]*ECX-DS:[SI]*EBX
                  POP    DS
                  LEAVE
                  RET    12
YRotate3D ENDP

; ZRotate3D - rotates vector about Z-axis

PUBLIC ZRotate3D
ZRotate3D PROC FAR
 ARG VO: DWORD, VI: DWORD, M: DWORD
                  ENTER  0,0
                  PUSH   DS
		  LES    DI,[M]
                  MOV    ECX,ES:[DI]          ; ECX = CosA
                  MOV    EBX,ES:[DI+4]        ; EBX = SinA
                  LES    DI,[VO]              ; ES:[DI] = New vector
                  LDS    SI,[VI]              ; DS:[SI] = Source vector
                  MOV    EAX,DS:[SI+8]        ;           (model)
                  MOV    ES:[DI+8],EAX        ; Z=Z
                  MOV    EAX,DS:[SI+4]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  PUSH   EDX
                  MOV    EAX,DS:[SI]
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  POP    EAX
                  SUB    EDX,EAX              ; X=X*Cos(A)-Y*Sin(A)
                  MOV    ES:[DI],EDX          ; X=DS:[SI]*ECX-DS:[SI+4]*EBX
                  MOV    EAX,DS:[SI]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  PUSH   EDX
                  MOV    EAX,DS:[SI+4]
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  POP    EAX
                  ADD    EDX,EAX              ; Y=X*Sin(A)+Y*Cos(A)
		  MOV    ES:[DI+8],EDX        ; Y=DS:[SI]*EBX+DS:[SI+4]*ECX
                  POP    DS
                  LEAVE
                  RET    12
ZRotate3D ENDP

; XYZRotate3D - rotates vector about X-axis by A radians
;                                    Y-axis by B radians
;                                    Z-axis by C radians

PUBLIC XYZRotate3D
XYZRotate3D PROC FAR
 ARG VO: DWORD, VI: DWORD, M: DWORD
                  ENTER  0,0
                  PUSH   DS
                  LDS    SI,[VI]              ; DS:[SI] = Source vector
                  LES    DI,[M]               ;           (model)
                  MOV    EAX,DS:[SI]          ; X*Cos(B)
                  MOV    EBX,ES:[DI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    EAX,EDX              ; Ans*Cos(C)
                  MOV    EBX,ES:[DI+16]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX = X*Cos(B)*Cos(C)
                  MOV    EAX,DS:[SI+4]        ; Y*Cos(B)
                  MOV    EBX,ES:[DI+8]
                  IMUL   EBX
                  SHL    EDX,16
		  SHR    EAX,16
                  MOV    DX,AX
                  MOV    EAX,EDX
                  MOV    EBX,ES:[DI+20]       ; Ans*Sin(C)
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  SUB    ECX,EDX              ; ECX=X*CosBC-Y*Cos(B)*Sin(C)
                  MOV    EAX,DS:[SI+8]        ; Z*Sin(B)
                  MOV    EBX,ES:[DI+12]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX                ; ECX=X*CosBC-Y*Cos(B)*Sin(C)+
                  ADD    ECX,EDX              ;     Z*Sin(B)
                  LES    DI,[VO]
                  MOV    ES:[DI],ECX          ; X=ECX **********************
                  LES    DI,[M]               ; ES:[DI] => Gonio
                  MOV    EAX,ES:[DI+24]       ; SinAB*Cos(C)
                  MOV    EBX,ES:[DI+16]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  ADD    EDX,ES:[DI+32]       ; Ans+CSAC
                  MOV    EBX,EDX              ; Ans*X
                  MOV    EAX,DS:[SI]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX=X*(SinAB*Cos(C)+CSAC)
                  MOV    EAX,ES:[DI+24]       ; SinAB*Sin(C)
		  MOV    EBX,ES:[DI+20]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    EAX,ES:[DI+28]       ; CosAC-Ans
                  SUB    EAX,EDX
                  MOV    EBX,DS:[SI+4]        ; Ans*Y
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX                ; ECX=X*(SinAB*Cos(C)+CSAC)+
                  ADD    ECX,EDX              ;     Y*(CosAC-SinAB*Sin(C))
                  MOV    EAX,ES:[DI+4]        ; Sin(A)*Cos(B)
                  MOV    EBX,ES:[DI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    EBX,EDX              ; Z*Ans
                  MOV    EAX,DS:[SI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX                ; ECX=X*(SinAB*Cos(C)+CSAC)+
                  SUB    ECX,EDX              ;     Y*(CosAC-SinAB*Sin(C))-
                  LES    DI,[VO]              ;     Z*Sin(A)*Cos(B)
                  MOV    ES:[DI+4],ECX        ; Y=ECX **********************
                  LES    DI,[M]               ; ES:[DI] => Gonio
                  MOV    EAX,ES:[DI+4]        ; Sin(A)*Sin(C)
                  MOV    EBX,ES:[DI+20]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
		  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX=Sin(A)*Sin(C)
                  MOV    EAX,ES:[DI+12]       ; Sin(B)*CosAC
                  MOV    EBX,ES:[DI+28]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  SUB    ECX,EDX              ; ECX=Sin(A)*Sin(C)-Sin(B)*CosAC
                  MOV    EAX,DS:[SI]          ; Ans*X
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX=X*(Sin(A)*Sin(C)-Sin(B)*
                  PUSH   ECX                  ;        *CosAC)
                  MOV    EAX,ES:[DI+32]       ; CSAC*Sin(B)
                  MOV    EBX,ES:[DI+12]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX
                  MOV    EAX,ES:[DI+4]        ; Sin(A)*Cos(C)
                  MOV    EBX,ES:[DI+16]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  ADD    ECX,EDX
                  MOV    EAX,DS:[SI+4]        ; Ans*Y
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16               ; ECX=X*(Sin(A)*Sin(C)-Sin(B)*
		  MOV    DX,AX                ;     *CosAC)+Y*(CSAC*Sin(B)+
                  POP    ECX                  ;     Sin(A)*Cos(C))
                  ADD    ECX,EDX
                  MOV    EAX,ES:[DI+0]        ; Cos(A)*Cos(B)
                  MOV    EBX,ES:[DI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    EBX,DS:[SI+8]
                  MOV    EAX,EDX
                  IMUL   EBX
                  SHL    EDX,16               ; ECX=X*(Sin(A)*Sin(C)-Sin(B)*
                  SHR    EAX,16               ;     *CosAC)+Y*(CSAC*Sin(B)+
                  MOV    DX,AX                ;     Sin(A)*Cos(C))+Z*Cos(A)*
                  ADD    ECX,EDX              ;     Cos(B)
                  LES    DI,[VO]
                  MOV    ES:[DI+8],ECX        ; Z=ECX **********************
                  POP    DS
                  LEAVE
                  RET    12
XYZRotate3D ENDP

; XYZRotateNormal - rotates vector about X-axis by A radians
;                                    Y-axis by B radians
;                                    Z-axis by C radians

PUBLIC XYZRotateNormal
XYZRotateNormal PROC FAR
 ARG VO: DWORD, VI: DWORD, M: DWORD
                  ENTER  0,0
                  PUSH   DS
                  LDS    SI,[VI]              ; DS:[SI] = Source vector
                  LES    DI,[M]               ; ES:[DI] => Gonio
                  MOV    EAX,ES:[DI+4]        ; Sin(A)*Sin(C)
                  MOV    EBX,ES:[DI+20]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
		  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX=Sin(A)*Sin(C)
                  MOV    EAX,ES:[DI+12]       ; Sin(B)*CosAC
                  MOV    EBX,ES:[DI+28]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  SUB    ECX,EDX              ; ECX=Sin(A)*Sin(C)-Sin(B)*CosAC
                  MOV    EAX,DS:[SI]          ; Ans*X
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX=X*(Sin(A)*Sin(C)-Sin(B)*
                  PUSH   ECX                  ;        *CosAC)
                  MOV    EAX,ES:[DI+32]       ; CSAC*Sin(B)
                  MOV    EBX,ES:[DI+12]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX
                  MOV    EAX,ES:[DI+4]        ; Sin(A)*Cos(C)
                  MOV    EBX,ES:[DI+16]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  ADD    ECX,EDX
                  MOV    EAX,DS:[SI+4]        ; Ans*Y
                  IMUL   ECX
                  SHL    EDX,16
                  SHR    EAX,16               ; ECX=X*(Sin(A)*Sin(C)-Sin(B)*
		  MOV    DX,AX                ;     *CosAC)+Y*(CSAC*Sin(B)+
                  POP    ECX                  ;     Sin(A)*Cos(C))
                  ADD    ECX,EDX
                  MOV    EAX,ES:[DI+0]        ; Cos(A)*Cos(B)
                  MOV    EBX,ES:[DI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    EBX,DS:[SI+8]
                  MOV    EAX,EDX
                  IMUL   EBX
                  SHL    EDX,16               ; ECX=X*(Sin(A)*Sin(C)-Sin(B)*
                  SHR    EAX,16               ;     *CosAC)+Y*(CSAC*Sin(B)+
                  MOV    DX,AX                ;     Sin(A)*Cos(C))+Z*Cos(A)*
                  ADD    ECX,EDX              ;     Cos(B)
                  LES    DI,[VO]
                  MOV    ES:[DI+8],ECX        ; Z=ECX **********************
                  POP    DS
                  LEAVE
                  RET    12
XYZRotateNormal ENDP

; Translate - translates vector A about vector B

PUBLIC Translate
Translate PROC FAR
 ARG B: DWORD, A: DWORD
                  ENTER  0,0
                  PUSH   DS
                  LES    DI,[A]
                  LDS    SI,[B]
                  MOV    EAX,ES:[DI]
                  ADD    EAX,DS:[SI]
		  MOV    ES:[DI],EAX
                  MOV    EAX,ES:[DI+2]
                  ADD    EAX,DS:[SI+2]
                  MOV    ES:[DI+2],EAX
                  MOV    EAX,ES:[DI+4]
                  ADD    EAX,DS:[SI+4]
                  MOV    ES:[DI+4],EAX
                  POP    DS
                  LEAVE
                  RET    8
Translate ENDP

; AddVectors - adds vectors A=A+B
; Result - A:

PUBLIC AddVectors
AddVectors PROC FAR
 ARG B: DWORD, A: DWORD
		  ENTER  0,0
		  PUSH   DS
		  LDS    SI,[B]               ; X1+X2
		  LES    DI,[A]
		  MOV    EAX,DS:[SI]
		  ADD    ES:[DI],EAX          ; X1=X1+X2
		  MOV    EAX,DS:[SI+4]        ; Y1+Y2
		  ADD    ES:[DI+4],EAX        ; Y1=Y1+Y2
		  MOV    EAX,DS:[SI+8]        ; Z1+Z2
		  ADD    ES:[DI+8],EAX        ; Z1=Z1+Z2
		  POP    DS
		  LEAVE
		  RET    8
AddVectors ENDP

; SubstractVectors - substracts vectors A=A-B
; Result - A:

PUBLIC SubstractVectors
SubstractVectors PROC FAR
 ARG B: DWORD, A: DWORD
		  ENTER  0,0
		  PUSH   DS
		  LDS    SI,[B]               ; X1-X2
		  LES    DI,[A]
		  MOV    EAX,DS:[SI]
		  SUB    ES:[DI],EAX          ; X1=X1-X2
		  MOV    EAX,DS:[SI+4]        ; Y1-Y2
		  SUB    ES:[DI+4],EAX        ; Y1=Y1-Y2
		  MOV    EAX,DS:[SI+8]        ; Z1-Z2
		  SUB    ES:[DI+8],EAX        ; Z1=Z1-Z2
                  POP    DS
                  LEAVE
                  RET    8
SubstractVectors ENDP

; VectorProduct - computes vector product of vector AxB ( = -BxA)
; Result - PN:

PUBLIC VectorProduct
VectorProduct PROC FAR
 ARG PN: DWORD, B: DWORD, A: DWORD
		  ENTER  0,0
                  PUSH   DS
                  LES    DI,[B]
                  LDS    SI,[A]
                  MOV    EAX,ES:[DI+8]        ; Y1*Z2
                  MOV    EBX,DS:[SI+4]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX
                  MOV    EAX,ES:[DI+4]        ; Y2*Z1
                  MOV    EBX,DS:[SI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  SUB    ECX,EDX              ; XN=Y1*Z2-Y2*Z1
                  LDS    SI,[PN]
                  MOV    DS:[SI],ECX
                  LDS    SI,[A]
                  MOV    EAX,ES:[DI]          ; X2*Z1
                  MOV    EBX,DS:[SI+8]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX
                  MOV    EAX,ES:[DI+8]        ; X1*Z2
                  MOV    EBX,DS:[SI]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
		  SUB    ECX,EDX              ; YN=X2*Z1-X1*Z2
                  LDS    SI,[PN]
                  MOV    DS:[SI+4],ECX
                  LDS    SI,[A]
                  MOV    EAX,ES:[DI+4]        ; X1*Y2
                  MOV    EBX,DS:[SI]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  MOV    ECX,EDX
                  MOV    EAX,ES:[DI]          ; X2*Y1
                  MOV    EBX,DS:[SI+4]
                  IMUL   EBX
                  SHL    EDX,16
                  SHR    EAX,16
                  MOV    DX,AX
                  SUB    ECX,EDX              ; ZN=X1*Y2-X2*Y1
                  LDS    SI,PN
                  MOV    DS:[SI+8],ECX
                  POP    DS
                  LEAVE
                  RET    12
VectorProduct ENDP

; ScalarProduct - computes normalized scalar product A.B
;                 A,B must be unit vectors: A=B=1, use NormalizeVector
;                 Returns cos(u)=A.B, where u is angle between A,B
; Result - DX:AX

PUBLIC ScalarProduct
ScalarProduct PROC FAR
 ARG B: DWORD, A: DWORD
                  ENTER  0,0
		  PUSH   DS
                  LES    DI,[B]
                  LDS    SI,[A]
                  MOV    EAX,DS:[SI]          ; X1*X2
                  MOV    EBX,ES:[DI]
		  IMUL   EBX
		  SHL    EDX,16
		  SHR    EAX,16
		  MOV    DX,AX
		  MOV    ECX,EDX
		  MOV    EAX,DS:[SI+4]        ; Y1*Y2
		  MOV    EBX,ES:[DI+4]
		  IMUL   EBX
		  SHL    EDX,16
		  SHR    EAX,16
		  MOV    DX,AX
		  ADD    ECX,EDX
		  MOV    EAX,DS:[SI+8]        ; Z1*Z2
		  MOV    EBX,ES:[DI+8]
		  IMUL   EBX
		  SHL    EDX,16
		  SHR    EAX,16
		  MOV    DX,AX
		  ADD    EDX,ECX              ; EDX=Cos(U)=X1*X2+Y1*Y2+Z1*Z2
		  MOV    EAX,EDX
		  SHR    EDX,16               ; DX:AX=Cos(U)
		  POP    DS
		  LEAVE
		  RET    8
ScalarProduct ENDP

; NormalizeVector - normalizes vector A into unit vector A/A
;                   A=(X^2+Y^2+Z^2)
; Result - PN:

PUBLIC NormalizeVector
NormalizeVector PROC FAR
 ARG PN: DWORD, A: DWORD
		  ENTER  0,0
		  LES    DI,[A]
		  MOV    EAX,ES:[DI]          ; X^2
		  MOV    EBX,EAX
		  IMUL   EBX
		  SHL    EDX,16
		  SHR    EAX,16
		  MOV    DX,AX
		  MOV    ECX,EDX
		  MOV    EAX,ES:[DI+4]        ; Y^2
		  MOV    EBX,EAX
		  IMUL   EBX
		  SHL    EDX,16
		  SHR    EAX,16
		  MOV    DX,AX
		  ADD    ECX,EDX
		  MOV    EAX,ES:[DI+8]        ; Z^2
		  MOV    EBX,EAX
		  IMUL   EBX
		  SHL    EDX,16
		  SHR    EAX,16
		  MOV    DX,AX
		  ADD    ECX,EDX              ; ECX=X^2+Y^2+Z^2
		  PUSH   ECX
                  CALL   FPSqrt
                  SHL    EDX,16
                  MOV    DX,AX
                  MOV    ECX,EDX              ; ECX=(X^2+Y^2+Z^2)
                  LES    DI,[A]
                  MOV    EAX,ES:[DI]          ; X/A
		  MOV    EDX,EAX
                  MOV    EBX,ECX
                  SAR    EDX,16
                  SHL    EAX,16
                  IDIV   EBX
                  LES    DI,[PN]
                  MOV    ES:[DI],EAX          ; X=X/A
                  LES    DI,[A]
                  MOV    EAX,ES:[DI+4]        ; Y/A
                  MOV    EDX,EAX
                  MOV    EBX,ECX
                  SAR    EDX,16
                  SHL    EAX,16
                  IDIV   EBX
                  LES    DI,[PN]
                  MOV    ES:[DI+4],EAX        ; Y=Y/A
                  LES    DI,[A]
                  MOV    EAX,ES:[DI+8]        ; Z/A
                  MOV    EDX,EAX
                  MOV    EBX,ECX
                  SAR    EDX,16
                  SHL    EAX,16
                  IDIV   EBX
                  LES    DI,[PN]
                  MOV    ES:[DI+8],EAX        ; Z=Z/A
                  LEAVE
                  RET    8
NormalizeVector ENDP

; NormalVector - computes normalized normal vector (AxB)/(AB)
; Result - PN:

PUBLIC NormalVector
NormalVector PROC FAR
 ARG PN: DWORD, B: DWORD, A: DWORD
                  ENTER  0,0
                  MOV    EAX,[A]
                  PUSH   EAX
                  MOV    EAX,[B]
                  PUSH   EAX
                  MOV    EAX,[PN]
                  PUSH   EAX
                  CALL   VectorProduct        ; Compute vector product AxB
                  MOV    EAX,[PN]
                  PUSH   EAX
                  PUSH   EAX
                  CALL   NormalizeVector      ; Normalize result
                  LEAVE
                  RET    12
NormalVector ENDP

Operat3D32 ENDS

END
