{
 MIT - 5th Information Window.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitWin5;

interface
uses Dialogs, Drivers, Objects, Strings, Views,
     Lib,
     MitInfo, MitShare;

type
{TInfoWindow5}
  PInfoWindow5 = ^TInfoWindow5;
  TInfoWindow5 = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

implementation

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TInfoWindow5.Init;
var
  S, T: String;
  I, J, K: Integer;
  P: TParams;
  Rect: TRect;
  AccProfileName: TAccProfileNameField;
begin
  inherited Init(Bounds, 'Profile infos');
  Options:= Options and not(ofSelectable + ofTopSelect);
  Flags:= 0;

  I:= 0;
                                         { acceleration profile data }
  S:= NotSuppString;
  if (Info.PMouse705 <> nil) and
     (Info.PMouse705^.PAccProfileData <> nil)
  then begin
    P.P0:= Info.PMouse705^.PAccProfileData^.Size;
    FormatStr(S, '%d byte(s)', P);
  end;

  S:= Concat('Profile data size: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { current active acceleration profile }
  S:= NotSuppString;
  if (Info.PMouse700 <> nil) and
     (Info.PMouse700^.PAccProfiles <> nil)
  then begin
    P.P0:= Info.PMouse700^.PAccProfiles^.CurrentActive;
    FormatStr(S, '%d', P);
  end;

  S:= Concat('Current active profile: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { acceleration profile names }
  Inc(I);
  for J:= 1 to 4 do begin
    T:= UnknownString;
    if (Info.PMouse700 <> nil) and
       (Info.PMouse700^.PAccProfiles <> nil) and
       (Info.PMouse700^.PAccProfiles^.PAccProfile <> nil)
    then begin
      AccProfileName:= Info.PMouse700^.PAccProfiles^.
                            PAccProfile^.AccProfileName[J];
      T[0]:= Chr(SizeOf(AccProfileName));
      for K:= 0 to Length(T) do
        T[K+1]:= AccProfileName[K];
      T:= StrCleanUp(T);
      if Length(T) < SizeOf(AccProfileName) then
        T:= UnknownString;
    end;
    P.P0:= J;
    P.P1:= LongInt(@T);
    FormatStr(S, 'Profile name %d: %s', P);
    Inc(I);
    Rect.Assign(1, I, Size.X-1, I+1);
    Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));
  end;

                                         { button }
  Rect.Assign(Size.X-22, Size.Y-3, Size.X-12, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Prev~',
    cmPrevWin, bfDefault)));

  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Next~',
    cmNextWin, bfDefault)));
end;

{Initialition unit}

end.