{
 MIT - 4th Information Window.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitWin4;

interface
uses Dialogs, Drivers, Objects, Strings, Views,
     MitInfo, MitShare;

type
{TInfoWindow4}
  PInfoWindow4 = ^TInfoWindow4;
  TInfoWindow4 = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

implementation

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TInfoWindow4.Init;
var
  S: String;
  I: Integer;
  P: TParams;
  Rect: TRect;
begin
  inherited Init(Bounds, 'Move infos');
  Options:= Options and not(ofSelectable + ofTopSelect);
  Flags:= 0;

  I:= 0;

                                         { double threshold speed }
  S:= NotSuppString;
  if (Info.PMouse600 <> nil) and
     (Info.PMouse600^.PSensitivity <> nil)
  then begin
    P.P0:= Info.PMouse600^.PSensitivity^.DoubleThresholdSpeed;
    FormatStr(S, '%d mickey(s)/second', P);
  end;

  S:= Concat('Double threshold speed: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { horizotal speed }
  S:= NotSuppString;
  if (Info.PMouse600 <> nil) and
     (Info.PMouse600^.PSensitivity <> nil)
  then begin
    P.P0:= Info.PMouse600^.PSensitivity^.HorizontalSpeed;
    FormatStr(S, '%d mickeys/pixel', P);
  end;

  S:= Concat('Horizontal speed: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { virtual horizontal coord }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PVirtCoor <> nil)
  then begin
    P.P0:= Info.PMouse626^.PVirtCoor^.CoorX;
    FormatStr(S, '%d pixel(s)', P);
  end;

  S:= Concat('Virtual horizontal coord: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { min. virtual horizontal coord }
  S:= NotSuppString;
  if (Info.PMouse705 <> nil) and
     (Info.PMouse705^.PMinMaxVirtCoor <> nil)
  then begin
    P.P0:= Info.PMouse705^.PMinMaxVirtCoor^.MinCoorX;
    FormatStr(S, '%d pixel(s)', P);
  end;

  S:= Concat('Min. virt. horizontal coord: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { max. virtual horizontal coord }
  S:= NotSuppString;
  if (Info.PMouse705 <> nil) and
     (Info.PMouse705^.PMinMaxVirtCoor <> nil)
  then begin
    P.P0:= Info.PMouse705^.PMinMaxVirtCoor^.MaxCoorX;
    FormatStr(S, '%d pixel(s)', P);
  end;

  S:= Concat('Max. virt. horizontal coord: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { vertical speed }
  S:= NotSuppString;
  if (Info.PMouse600 <> nil) and
     (Info.PMouse600^.PSensitivity <> nil)
  then begin
    P.P0:= Info.PMouse600^.PSensitivity^.VerticalSpeed;
    FormatStr(S, '%d mickeys/pixel', P);
  end;

  S:= Concat('Vertical speed: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { virtual vertical coord }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PVirtCoor <> nil)
  then begin
    P.P0:= Info.PMouse626^.PVirtCoor^.CoorY;
    FormatStr(S, '%d pixel(s)', P);
  end;

  S:= Concat('Virtual vertical coord: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { min. virtual vertical coord }
  S:= NotSuppString;
  if (Info.PMouse705 <> nil) and
     (Info.PMouse705^.PMinMaxVirtCoor <> nil)
  then begin
    P.P0:= Info.PMouse705^.PMinMaxVirtCoor^.MinCoorY;
    FormatStr(S, '%d pixel(s)', P);
  end;

  S:= Concat('Min. virt. vertical coord: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { max. virtual vertical coord }
  S:= NotSuppString;
  if (Info.PMouse705 <> nil) and
     (Info.PMouse705^.PMinMaxVirtCoor <> nil)
  then begin
    P.P0:= Info.PMouse705^.PMinMaxVirtCoor^.MaxCoorY;
    FormatStr(S, '%d pixel(s)', P);
  end;

  S:= Concat('Max. virt. vertical coord: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { hot spot }
  S:= NotSuppString;
  if (Info.PMouse702 <> nil) and
     (Info.PMouse702^.PHotSpot <> nil)
  then begin
    P.P0:= Info.PMouse702^.PHotSpot^.HotSpotCol;
    P.P1:= Info.PMouse702^.PHotSpot^.HotSpotRow;
    FormatStr(S, '%d/%d', P);
  end;

  S:= Concat('Hot spot column/row: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { button }
  Rect.Assign(Size.X-22, Size.Y-3, Size.X-12, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Prev~',
    cmPrevWin, bfDefault)));

  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Next~',
    cmNextWin, bfDefault)));
end;

{Initialition unit}

end.