{
 MIT - 3th Information Window.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitWin3;

interface
uses Dialogs, Drivers, Objects, Strings, Views,
     MitInfo, MitShare;

type
{TInfoWindow3}
  PInfoWindow3 = ^TInfoWindow3;
  TInfoWindow3 = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

implementation

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TInfoWindow3.Init;
var
  S: String;
  I: Integer;
  P: TParams;
  Rect: TRect;
begin
  inherited Init(Bounds, 'Mouse infos');
  Options:= Options and not(ofSelectable + ofTopSelect);
  Flags:= 0;

  I:= 0;

                                         { number of buttons }
  if ButtonCount <> 0 then begin
    P.P0:= ButtonCount;
    FormatStr(S, 'Number of buttons: %d', P);
    Inc(I);
    Rect.Assign(1, I, Size.X-1, I+1);
    Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));
  end;

                                         { mouse type }
  P.P0:= LongInt(@NotSuppString);
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PVersion <> nil)
  then
    if Info.PMouse626^.PVersion^.Typ in [1..5] then
      P.P0:= LongInt(@TypeString[Info.PMouse626^.PVersion^.Typ])
    else
      P.P0:= LongInt(@UnknownString);

  FormatStr(S, 'Mouse type: %s', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { mouse IRQ }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PVersion <> nil)
  then
    if Info.PMouse626^.PVersion^.Typ in [1..5] then begin
      P.P0:= Info.PMouse626^.PVersion^.Interupt;
      FormatStr(S, '%d', P);
    end;

  S:= Concat('Interrupt request: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { mouse IRQ rate }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then
    if Info.PMouse626^.PGenInfo^.IntRate in [0..4] then begin
      P.P0:= LongInt(@RateString[Info.PMouse626^.PGenInfo^.IntRate]);
      FormatStr(S, '%s/second', P);
    end else
      S:= UnknownString;

  S:= Concat('Interrupt rate: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { ball-point }
  S:= NotSuppString;
  if (Info.PMouse704 <> nil) and
     (info.PMouse704^.PBallPoint <> nil)
  then
    S:= 'yes';

  S:= Concat('BallPoint support: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, S)));

                                         { ball-point buttons }
  S:= NotSuppString;
  if (Info.PMouse704 <> nil) and
     (Info.PMouse704^.PBallPoint <> nil)
  then begin
    S:= '';
    if (Info.PMouse704^.PBallPoint^.Buttons and $20 <> 0) then S:= S + '1';
    if (Info.PMouse704^.PBallPoint^.Buttons and $10 <> 0) then S:= S + '2';
    if (Info.PMouse704^.PBallPoint^.Buttons and $08 <> 0) then S:= S + '3';
    if (Info.PMouse704^.PBallPoint^.Buttons and $04 <> 0) then S:= S + '4';
  end;

  S:= Concat('BallPoint button status: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, S)));

                                         { ball-point angle }
  S:= NotSuppString;
  if (Info.PMouse704 <> nil) and
     (Info.PMouse704^.PBallPoint <> nil)
  then begin
      P.P0:= Info.PMouse704^.PBallPoint^.Angle;
      FormatStr(S, '%d', P);
  end;

  S:= Concat('BallPoint rotation angle: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, S)));

                                         { ball-point primary }
  S:= NotSuppString;
  if (Info.PMouse704 <> nil) and
     (Info.PMouse704^.PBallPoint <> nil)
  then begin
      P.P0:= Info.PMouse704^.PBallPoint^.Primary;
      FormatStr(S, '%d', P);
  end;

  S:= Concat('BallPoint primary button mask: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, S)));

                                         { ball-point secondary }
  S:= NotSuppString;
  if (Info.PMouse704 <> nil) and
     (Info.PMouse704^.PBallPoint <> nil)
  then begin
      P.P0:= Info.PMouse704^.PBallPoint^.Primary;
      FormatStr(S, '%d', P);
  end;

  S:= Concat('BallPoint secondary button mask: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, S)));

                                         { cutemouse wheel api suuport }
  S:= NotSuppString;
  if (Info.PCuteMouse <> nil) and
     Info.PCutemouse^.WheelSupport
  then
      S:= SupportString;

  S:= Concat('Cutemouse Wheel API: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, S)));

                                         { buttons }
  Rect.Assign(Size.X-22, Size.Y-3, Size.X-12, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Prev~',
    cmPrevWin, bfDefault)));

  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Next~',
    cmNextWin, bfDefault)));
end;

{Initialition unit}

end.