{
 MIT - 2nd Information Window.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitWin2;

interface
uses Dialogs, Drivers, Objects, Strings, Views,
     MitInfo, MitShare;

type
{TInfoWindow2}
  PInfoWindow2 = ^TInfoWindow2;
  TInfoWindow2 = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

{TSuppFncsWindow}
  PSuppFncsWindow = ^TSuppFncsWindow;
  TSuppFncsWindow = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

{TAltIntrWindow}
  PAltIntrWindow = ^TAltIntrWindow;
  TAltIntrWindow = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

{TVideoModesWindow}
  PVideoModesWindow = ^TVideoModesWindow;
  TVideoModesWindow = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

implementation

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TInfoWindow2.Init;
var
  S, T: String;
  I, J: Integer;
  P: TParams;
  Rect: TRect;
begin
  inherited Init(Bounds, 'Driver infos');
  Options:= Options and not(ofSelectable + ofTopSelect);
  Flags:= 0;

  I:= 0;
                                         { screen mask }
  S:= NotSuppString;
  if (Info.PMouse701 <> nil) and
     (Info.PMouse701^.PMasks <> nil)
  then begin
    P.P0:= Info.PMouse701^.PMasks^.ScreenMask;
    FormatStr(S, '%4x', P);
  end;

  S:= Concat('Screen mask: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { cursor mask }
  S:= NotSuppString;
  if (Info.PMouse701 <> nil) and
     (Info.PMouse701^.PMasks <> nil)
  then begin
    P.P0:= Info.PMouse701^.PMasks^.CursorMask;
    FormatStr(S, '%4x', P);
  end;

  S:= Concat('Cursor mask: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { cursor lock flag }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then begin
    P.P0:= Info.PMouse626^.PGenInfo^.CursorLockFlag;
    FormatStr(S, '%2x', P);
  end;

  S:= Concat('Cursor lock flag: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { code active flag }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then begin
    P.P0:= Info.PMouse626^.PGenInfo^.CodeActiveFlag;
    FormatStr(S, '%2x', P);
  end;

  S:= Concat('Code active flag: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver busy flag }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then begin
    P.P0:= Info.PMouse626^.PGenInfo^.DriverBusyFlag;
    FormatStr(S, '%2x', P);
  end;

  S:= Concat('Driver busy flag: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { lcd pointer style }
  S:= NotSuppString;
  if (Info.PMouse810 <> nil) and
     (Info.PMouse810^.PLcdPointer <> nil)
  then begin
    if Info.PMouse810^.PLcdPointer^.Style in [0..2] then begin
      P.P0:= LongInt(@LcdPointerStyleString[Info.PMouse810^.PLcdPointer^.Style]);
      FormatStr(S, '%s', P);
    end else
      S:= UnknownString;
  end;

  S:= Concat('LCD pointer style: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { lcd pointer size }
  S:= NotSuppString;
  if (Info.PMouse810 <> nil) and
     (Info.PMouse810^.PLcdPointer <> nil)
  then begin
    if Info.PMouse810^.PLcdPointer^.Style in [0..2] then begin
      P.P0:= LongInt(@LcdPointerSizeString[Info.PMouse810^.PLcdPointer^.Size]);
      FormatStr(S, '%s', P);
    end else
      S:= UnknownString;
  end;

  S:= Concat('LCD pointer size: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { lcd pointer threshold }
  S:= NotSuppString;
  if (Info.PMouse810 <> nil) and
     (Info.PMouse810^.PLcdPointer <> nil)
  then begin
    P.P0:= Info.PMouse810^.PLcdPointer^.Threshold;
    FormatStr(S, '%d', P);
  end;

  S:= Concat('LCD pointer threshold: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { lcd pointer active flag }
  S:= NotSuppString;
  if (Info.PMouse810 <> nil) and
     (Info.PMouse810^.PLcdPointer <> nil)
  then begin
    if Info.PMouse810^.PLcdPointer^.Style in [0..1] then begin
      P.P0:= LongInt(@LcdPointerActiveString[Info.PMouse810^.PLcdPointer^.ActiveFlag]);
      FormatStr(S, '%s', P);
    end else
      S:= UnknownString;
  end;

  S:= Concat('LCD pointer active flag: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { lcd pointer delay }
  S:= NotSuppString;
  if (Info.PMouse810 <> nil) and
     (Info.PMouse810^.PLcdPointer <> nil)
  then begin
    P.P0:= Info.PMouse810^.PLcdPointer^.Delay;
    FormatStr(S, '%d', P);
  end;

  S:= Concat('LCD pointer delay: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { buttons }
  if (Info.PMouse600 = nil) or
     (Info.PMouse600^.PAltIntr = nil)
  then
    DisableCommands([cmAltIntr]);
  Rect.Assign(Size.X-23, 1, Size.X-2, 3);
  Insert(New(PButton, Init(Rect, '~Alt. interrupts~',
    cmAltIntr, bfNormal)));

  if (Info.PMouse705 = nil) or
     (Info.PMouse705^.PActiveAdvFncs = nil)
  then
    DisableCommands([cmSuppFncs]);
  Rect.Assign(Size.X-23, 3, Size.X-2, 5);
  Insert(New(PButton, Init(Rect, '~Supp. functions~',
    cmSuppFncs, bfNormal)));

  if (Info.PMouse700 = nil) or
     (Info.PMouse700^.PVideoModes = nil)
  then
    DisableCommands([cmVideoModes]);
  Rect.Assign(Size.X-23, 5, Size.X-2, 7);
  Insert(New(PButton, Init(Rect, '~Video modes~',
    cmVideoModes, bfNormal)));

  Rect.Assign(Size.X-22, Size.Y-3, Size.X-12, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Prev~',
    cmPrevWin, bfDefault)));

  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Next~',
    cmNextWin, bfDefault)));
end;

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TSuppFncsWindow.Init;
var
  S: String;
  I: Integer;
  P: TParams;
  Rect: TRect;
begin
  inherited Init(Bounds, 'Supported functions');
                                         { supported functions }
  for I:= 0 to 15 do begin
    P.P0:= I + $24;
    if (Info.PMouse705 <> nil) and
       (Info.PMouse705^.PActiveAdvFncs <> nil) and
       (Info.PMouse705^.PActiveAdvFncs^.SupportedFnc[I])
    then
      P.P1:= LongInt(@SupportString)
    else
      P.P1:= LongInt(@NotSuppString);
    FormatStr(S, 'Function %2x: %s', P);

    Rect.Assign(1, I+1, Size.X-1, I+2);
    Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));
  end;
                                         { button }
  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~O~k',
    cmOk, bfDefault)));
end;

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TAltIntrWindow.Init;
var
  S: String;
  I: Integer;
  P: TParams;
  Rect: TRect;
  Item: PAltIntr;
begin
  inherited Init(Bounds, 'Alternate interrupt vector');
                                         { alternate interrupt vector }
  Item:= nil;
  if Info.PMouse600 <> nil then
    Item:= Info.PMouse600^.PAltIntr;

  I:= 0;
  while ((Item <> nil) and (I < Size.Y-3)) do begin
    P.P0:= Item^.Mask;
    P.P1:= LongInt(Item^.Intr);
    FormatStr(S, 'Mask: %4x, Intr: %8x', P);

    Inc(I);
    Rect.Assign(1, I+1, Size.X-1, I+2);
    Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

    Item:= Item^.Next;
  end;
                                           { button }
  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~O~k',
    cmOk, bfDefault)));
end;

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TVideoModesWindow.Init;
var
  S, T: String;
  I: Integer;
  P: TParams;
  Rect: TRect;
  Item: PVideoModes;
begin
  inherited Init(Bounds, 'Video modes');
                                         { video modes }
  Item:= nil;
  if Info.PMouse700 <> nil then
    Item:= Info.PMouse700^.PVideoModes;

  I:= 0;
  while ((Item <> nil) and (I < Size.Y-3)) do begin
    P.P0:= Item^.VideoMode;
    if (Item^.Description <> nil) then
      T:= StrPas(Item^.Description)
    else
      T:= UnknownString;
    P.P1:= LongInt(@T);
    FormatStr(S, 'Mode: %4x, desc.: %s', P);

    Inc(I);
    Rect.Assign(1, I+1, Size.X-1, I+2);
    Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

    Item:= Item^.Next;
  end;
                                           { button }
  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~O~k',
    cmOk, bfDefault)));
end;

{Initialition unit}

end.