{
 MIT - 1st Information Window.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitWin1;

interface
uses Dialogs, Drivers, Objects, Strings, Views,
     Lib,
     MitInfo, MitShare;

type
{TInfoWindow1}
  PInfoWindow1 = ^TInfoWindow1;
  TInfoWindow1 = object(TDialog)
    constructor Init(Bounds: TRect; Info: TMouseInfo);
                                         { Initialize window }
  end;

implementation

{*
 * Initialize window.
 *
 * @param Bounds window size
 * @param Info mouse informations
 *}
constructor TInfoWindow1.Init;
var
  S: String;
  I: Integer;
  P: TParams;
  Rect: TRect;
begin
  inherited Init(Bounds, 'Driver infos');
  Options:= Options and not(ofSelectable + ofTopSelect);
  Flags:= 0;

  I:= 0;
                                         { driver version }
  P.P0:= Hi(Info.Version);
  P.P1:= Lo(Info.Version);
  FormatStr(S, 'Driver version: %x.%02x', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver status }
  P.P0:= LongInt(@NotSuppString);
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PVirtCoor <> nil)
  then
    P.P0:= LongInt(@DisableString[Info.PMouse626^.PVirtCoor^.Disabled = 0]);

  FormatStr(S, 'Driver %s', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver load type }
  P.P0:= LongInt(@NotSuppString);
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then
    P.P0:= LongInt(@LoadedString[Info.PMouse626^.PGenInfo^.LoadedAs <> 0]);

  FormatStr(S, 'Driver loaded as: %s', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver type }
  P.P0:= LongInt(@NotSuppString);
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then
    P.P0:= LongInt(@NewerString[Info.PMouse626^.PGenInfo^.Newer <> 0]);

  FormatStr(S, 'Driver integrated type: %s', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { newer driver type }
  S:= NotSuppString;
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then begin
    if Info.PMouse626^.PGenInfo^.Newer <> 0 then begin
      P.P0:= Info.PMouse626^.PGenInfo^.CountDrivers;
      FormatStr(S, '%d', P);
    end;
  end;

  S:= Concat('Currenty active newer drivers: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { current moouse display page }
  S:= NotSuppString;
  if Info.PMouse600 <> nil then begin
    P.P0:= Info.PMouse600^.DisplayPageNumber;
    FormatStr(S, '%d', P);
  end;

  S:= Concat('Driver active display page: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver language }
  P.P0:= LongInt(@NotSuppString);
  if Info.PMouse600 <> nil then begin
    if Info.PMouse600^.Language in [0..8] then begin
      P.P0:= LongInt(@LangString[Info.PMouse600^.Language]);
    end else begin
      P.P0:= LongInt(@UnknownString);
    end;
  end;

  FormatStr(S, 'Language for messages: %s', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { cursor type }
  P.P0:= LongInt(@NotSuppString);
  if (Info.PMouse626 <> nil) and
     (Info.PMouse626^.PGenInfo <> nil)
  then
    P.P0:= LongInt(@CursorTypeString[Info.PMouse626^.PGenInfo^.CursorType]);

  FormatStr(S, 'Mouse cursor: %s', P);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { buffer size }
  S:= NotSuppString;
  if Info.PMouse600 <> nil then begin
    P.P0:= Info.PMouse600^.StorageReq;
    FormatStr(S, '%d byte(s)', P);
  end;

  S:= Concat('Mouse status buffer size: ', S);
  Inc(I);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver initialization file }
  S:= NotSuppString;
  if Info.PMouse800 <> nil then begin
    S:= '(no initialization file)';
    if Info.PMouse800^.IniFile <> nil then
      if Length(StrPas(Info.PMouse800^.IniFile)) > 0 then
        S:= StrPas(Info.PMouse800^.IniFile);
  end;

  S:= Concat('Init file: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { driver copyright }
  S:= '(no copyright info)';
  if Info.Copyright <> nil then
    if StrLen(Info.Copyright) > 0 then begin
      S:= StrPas(Info.Copyright);
      S:= StrCleanUp(S);
    end;

  S:= Concat('Copyright: ', S);
  Inc(I, 2);
  Rect.Assign(1, I, Size.X-1, I+1);
  Insert(New(PStaticText, Init(Rect, Copy(S, 1, Size.X-2))));

                                         { buttons }
  Rect.Assign(Size.X-22, Size.Y-3, Size.X-12, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Prev~',
    cmPrevWin, bfDefault)));

  Rect.Assign(Size.X-12, Size.Y-3, Size.X-2, Size.Y-1);
  Insert(New(PButton, Init(Rect, '~Next~',
    cmNextWin, bfDefault)));
end;

{Initialition unit}

end.