{
 MIT - Mouse colored text.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitText;

interface
uses App, Dialogs, Drivers, Objects, Views;

type
{TColoredStaticTextText}
  PColoredStaticText = ^TColoredStaticText; { Colored text }
  TColoredStaticText = object(TStaticText)
    Attr: Byte;                          { color attribute }
    constructor Init(var Bounds: TRect; AText: String; Attribute: Byte);
                                         { Initialize text }
    function GetTheColor: Byte; virtual; { Get text color attribute }
    procedure Draw; virtual;             { Draw text }
  end;

{TColoredParamText}
  PColoredParamText = ^TColoredParamText;
  TColoredParamText = object(TColoredStaticText)
    ParamCount: Integer;                 { parameters count }
    ParamList: Pointer;                  { list of parameters }
    constructor Init(var Bounds: TRect; const AText: String;
      Attribute: Byte; AParamCount: Integer);
                                         { Initialize text }
    function DataSize: Word; virtual;    { Get size of data }
    procedure GetText(var S: String); virtual;
                                         { Get text }
    procedure SetData(var Rec); virtual; { Set data }
  end;

implementation

{*
 * Initialize text.
 *
 * @param Bounds view size
 * @param AText text
 * @param Attribute color attribute
 *}
constructor TColoredStaticText.Init;
begin
  inherited Init(Bounds, AText);         { call parrent }
  Attr:= Attribute;
end;

{*
 * Get text color attribute.
 *
 * @return color
 *}
function TColoredStaticText.GetTheColor;
begin
  if AppPalette = apColor then GetTheColor:= Attr
  else GetTheColor:= GetColor(1);
end;

{*
 * Draw view.
 *}
procedure TColoredStaticText.Draw;
var
  Color: Byte;                           { color }
  Center: Boolean;                       { center flag }
  B: TDrawBuffer;                        { draw buffer }
  S: String;                             { text buffer }
  I, J, L, P, Y: Integer;
begin
  Color:= GetTheColor;                   { get color }
  GetText(S);                            { get text }
  L:= Length(S);
  P:= 1;
  Y:= 0;
  Center:= False;
  while Y < Size.Y do begin
    MoveChar(B, ' ', Color, Size.X);     { prepare draw buffer }
    if P <= L then begin
      if S[P] = #3 then begin
        Center:= True;                   { center enabled }
        Inc(P);
      end;
      I:= P;                             { compute first draw index }
      repeat                             { compute second draw index }
        J:= P;
        while (P <= L) and (S[P] = ' ') do Inc(P);
        while (P <= L) and (S[P] <> ' ') and (S[P] <> #13) do Inc(P);
      until (P > L) or (P >= I+Size.X) or (S[P] = #13);
      if P > I+Size.X then
        if J > I then P:= J else P:= I + Size.X;
      if Center then J:= (Size.X - P + I) div 2 else J:= 0;
      MoveBuf(B[J], S[I], Color, P - I); { fill draw buffer }
      while (P <= L) and (S[P] = ' ') do Inc(P);
      if (P <= L) and (S[P] = #13) then begin
        Center:= False;                  { new line }
        Inc(P);                          { disable center }
        if (P <= L) and (S[P] = #10) then Inc(P);
      end;
    end;
    WriteLine(0, Y, Size.X, 1, B);       { write line }
    Inc(Y);                              { go to next line }
  end;
end;

{*
 * Initialize text.
 *
 * @param Bounds view size
 * @param AText text
 * @param Attribute color attribute
 * @param AParamCount count of parameters
 *}
constructor TColoredParamText.Init;
begin
  inherited Init(Bounds, AText, Attribute); { call parrent }
  ParamCount:= AParamCount;
end;

{*
 * Get size of data.
 *
 * @return data size
 *}
function TColoredParamText.DataSize: Word;
begin
  DataSize:= ParamCount * SizeOf(Longint); { compute size }
end;

{*
 * Get text.
 *
 * @param S formated text
 *}
procedure TColoredParamText.GetText;
begin
  if Text <> nil then FormatStr(S, Text^, ParamList^)
  else S:= '';
end;

{*
 * Set data.
 *
 * @param Rec data
 *}
procedure TColoredParamText.SetData;
begin
  ParamList:= @Rec;                      { set data }
  DrawView;                              { redraw text }
end;

{Initialition unit}

end.