{
 MIT - presentation shared objects.
 Copyright (C) 1994-2009  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit MitShare;

interface

type
  TParams = record                       { Parameters structure }
    P0,                                  { 1st parameter }
    P1: LongInt;                         { 2nd parameter }
  end;

const
  cmSuppFncs = 100;
  cmAltIntr = 101;
  cmVideoModes = 102;

  cmNextWin = 200;
  cmPrevWin = 201;

  NotSuppString: String[3] = 'n/a';      { not supported text }
  UnknownString: String[3] = '???';      { unknown text }
  SupportString: String[9] = 'supported';{ supported text }

  DisableString: array[False..True] of String[8] = (
    'disabled',
    'enabled'
  );                                     { driver status }

  LoadedString: array[False..True] of String[6] = (
    'TSR',
    'device'
  );                                     { driver load type }

  NewerString: array[False..True] of String[5] = (
    'older',
    'newer'
  );                                     { driver type }

  LangString: array[0..8] of String[10] = (
    'English',
    'French',
    'Dutch',
    'German',
    'Swedish',
    'Finnish',
    'Spanish',
    'Portuguese',
    'Italian'
  );                                     { language }

  CursorTypeString: array[0..3] of String[13] = (
    'software text',
    'hardware text',
    'graphics',
    'graphics'
  );                                     { cursor type }

  TypeString: array[1..5] of String[12] = (
    'BUS mouse',
    'Serial mouse',
    'Import mouse',
    'PS/2 mouse',
    'HP mouse'
  );                                     { mouse type }

  RateString: array[0..4] of String[3] = (
   '0',
   '30',
   '50',
   '100',
   '200'
  );                                     { mouse rate }

  LcdPointerStyleString: array[0..2] of String[11] = (
    'normal',
    'reverse',
    'transparent'
  );                                     { lcd screen pointer style }

  LcdPointerSizeString: array[0..2] of String[6] = (
    'small',
    'medium',
    'large'
  );                                     { lcd screen pointer size }

  LcdPointerActiveString: array[0..1] of String[8] = (
    'disabled',
    'enabled'
  );                                     { lcd screen pointer active flag }

implementation

{Initialition unit}

end.