{
 Com send monitor - The Com write char monitor.
 Copyright (C) 1997-2002  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
program ComSdMon;

{$M 3072, 0, 0}

uses Dos, Lib;

const
  Copyright: String = 'COM send monitor';{ identity string }
  Version = '3.1';                       { version string constant }
  ExeName = 'COMSDMON';                  { project name }
  DefFileName = 'COMSDMON.SAV';          { default file name }
  DefPortNumber = 1;                     { default port number }

  TimerCount = 100;                      { timer time-out ticks }
  BufferLength = 8192;                   { data buffer length }

var
  MySS, MySP, OldSS, OldSP: Word;        { stacks pointers }
  Switch: Integer;                       { stack switched flag }
  OldCom, OldTimer, OldDosSafe,          { old interrupt handlers }
  OldMultiplex, OldCriticalError: Pointer;
  Reg: Registers;                        { cpu registers structure }

  DosFlagPtr: ^Byte;                     { dos busy flag }
  MyTask: Byte;                          { resident task number }
  Active: Boolean;                       { activity flag }
  ActiveRqst: Boolean;                   { request activity flag }
  Timer: Byte;                           { timer ticks }

                                         { serial data buffer }
  Buffer: array[0..BufferLength-1] of Byte;
  BufferPosition: Integer;               { writen data position in buffer }
  FileName: PathStr;                     { data file name }
  Port: Word;                            { port number }

{$F+}

{********** common interrupt functions ***************************}

{*
 * Call the old interrupt handler.
 *
 * @param Address               pointer to old interrupt handler
 * @param Reg                   cpu registers structure
 * @return changed Reg cpu registers structure
 *}
procedure CallOldIntr(Address: Pointer; var Reg: Registers);
var
  _Flags, _AX, _BX, _CX, _DX, _SI, _DI, _DS, _ES, _BP: Word;
begin
  with Reg do begin                      { set registers }
    _Flags:= Flags;
    _AX:= Ax; _BX:= Bx; _CX:= Cx; _DX:= Dx;
    _SI:= Si; _DI:= Di;
    _DS:= Ds; _ES:= Es;
    _BP:= Bp;
  end;
  asm
    PUSH  DS
    PUSH  BP

    PUSH  _Flags
    PUSH  CS
{$IFOPT G+}
    PUSH  OFFSET @@1
{$ELSE}
    MOV   AX, OFFSET @@1
    PUSH  AX
{$ENDIF}
    PUSH  WORD (Address+2)
    PUSH  WORD (Address)

    MOV   AX, _AX
    MOV   BX, _BX
    MOV   CX, _CX
    MOV   DX, _DX
    MOV   SI, _SI
    MOV   DI, _DI
    MOV   DS, _DS
    MOV   ES, _ES
    MOV   BP, _BP

    RETF                                 { call :-) }
@@1:
    PUSH  BP

    MOV   BP, SP
    MOV   BP, SS:[BP + 2]

    MOV   _AX, AX
    MOV   _BX, BX
    MOV   _CX, CX
    MOV   _DX, DX
    MOV   _SI, SI
    MOV   _DI, DI
    MOV   _DS, DS
    MOV   _ES, ES
    POP   AX
    MOV   _BP, AX
    PUSHF
    POP   AX
    MOV   _FLAGS, AX

    POP   BP
    POP   DS
  end;
  with Reg do begin                      { set registers }
    Flags:= _Flags;
    Ax:= _AX; Bx:= _BX; Cx:= _CX; Dx:= _DX;
    Si:= _SI; Di:= _DI;
    Ds:= _DS; Es:= _ES;
    Bp:= _BP;
  end;
end;

procedure NewCriticalError(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
  _SI, _DI, _DS, _ES, _BP: Word); interrupt; forward;

{*
 * The resident part action.
 * Writen bytes to serial port save to file.
 *}
procedure Action;
var
  OldPSP: Word;
  N: Integer;                            { buffer counter }
  Data: Byte;                            { buffer data }
  F: File of Byte;                       { file }
  DirInfo: SearchRec;

begin
  ActiveRqst:= False;                    { request is now handled }
  Active:= True;                         { set active flag }

  Reg.Ah:= $62;                          { get interrupted pid }
  MsDos(Reg);                            { and save it }
  OldPSP:= Reg.Bx;

  Reg.Ah:= $50;                          { set resedent part pid }
  Reg.Bx:= PrefixSeg;
  MsDos(Reg);

  GetIntVec($24, OldCriticalError);      { temporary use self-error handler }
  SetIntVec($24, Addr(NewCriticalError));

  Assign(F, FileName);
  Data:= ReadOnly + Hidden + SysFile + Archive;
  FindFirst(FileName, Data, DirInfo);    { find the file }
  if DosError = 0 then begin             { found it }
    Data:= FileMode;
    FileMode:= 1;                        { set the write filemode }
    Reset(F);                            { open file }
    FileMode:= Data;
    Seek(F, FileSize(F));
  end else
    Rewrite(F);                          { not found - create file }

  asm CLI end;
  for N:= 0 to BufferPosition-1 do begin { for all datas do }
    Data:= Buffer[N];
    Write(F, Data);                      { write data }
  end;
  BufferPosition:= 0;
  asm STI end;
  Close(F);

  SetIntVec($24, OldCriticalError);      { restore error handler }

  Reg.Ah:= $50;                          { restore interrupted pid }
  Reg.Bx:= OldPSP;
  MsDos(Reg);

  Active:= False;                        { end of active }
end;

{********** interrupt handlers ***********************************}

{*
 * Critical error handler.
 * Handler is activated from Action routine.
 *
 * @param _Flags                cpu flags register
 * @param _CS                   cpu code segment register
 * @param _IP                   cpu instruction pointer register
 * @param _AX                   cpu accumulator register
 * @param _BX                   cpu base register
 * @param _CX                   cpu counter register
 * @param _DX                   cpu data register
 * @param _SI                   cpu source index register
 * @param _DI                   cpu destination index register
 * @param _DS                   cpu data segment register
 * @param _ES                   cpu extra segment register
 * @param _BP                   cpu base pointer register
 *}
procedure NewCriticalError(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
  _SI, _DI, _DS, _ES, _BP: Word);(* interrupt; *)
begin
  _AX:= (_AX and $FF00) or 3;
end;

{*
 * BIOS Serial handler.
 *
 * @param _Flags                cpu flags register
 * @param _CS                   cpu code segment register
 * @param _IP                   cpu instruction pointer register
 * @param _AX                   cpu accumulator register
 * @param _BX                   cpu base register
 * @param _CX                   cpu counter register
 * @param _DX                   cpu data register
 * @param _SI                   cpu source index register
 * @param _DI                   cpu destination index register
 * @param _DS                   cpu data segment register
 * @param _ES                   cpu extra segment register
 * @param _BP                   cpu base pointer register
 *}
procedure NewCom(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
  _SI, _DI, _DS, _ES, _BP: Word); interrupt;
begin
  asm CLI end;
  with Reg do begin                      { get registers }
    Flags:= _Flags;
    Ax:= _AX; Bx:= _BX; Cx:= _CX; Dx:= _DX;
    Si:= _SI; Di:= _DI;
    Ds:= _DS; Es:= _ES;
    Bp:= _BP;
  end;

  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;
  asm STI end;

  if Reg.Dx = Port then begin
    if Reg.Ah = $1 then begin
      while Active do ;
      ActiveRqst:= BufferPosition >= (BufferLength div 4);
      if BufferPosition < BufferLength then begin
        Buffer[BufferPosition]:= Reg.Al;
        Inc(BufferPosition);
      end;
    end;
  end;
  CallOldIntr(OldMultiplex, Reg);

  asm CLI end;
  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
  with Reg do begin                      { set registers }
    _Flags:= Flags;
    _AX:= Ax; _BX:= Bx; _CX:= Cx; _DX:= Dx;
    _SI:= Si; _DI:= Di;
    _DS:= Ds; _ES:= Es;
    _BP:= Bp;
  end;
  asm STI end;
end;

{*
 * BIOS Timer handler.
 *}
procedure NewTimer; interrupt;
begin
  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;

  asm
    PUSHF                                { call old handler }
    CALL  OldTimer
  end;

  Inc(Timer);                            { compute activity request }
  if Timer >= TimerCount then begin
    ActiveRqst:= BufferPosition > 0;
    Timer:= 0;
  end;

  if ActiveRqst and (DosFlagPtr^ = 0) and not(Active) then
  begin
    Action;                              { do it }
  end;

  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
end;

{*
 * DOS Safe (timeslice) handler.
 *}
procedure NewDosSafe; interrupt;
begin
  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;

  asm                                    { call old handler }
    PUSHF
    CALL  OldDosSafe
  end;

  if ActiveRqst and (DosFlagPtr^ <> 0) and not(Active) then
  begin
    Action;                              { do it }
  end;

  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
end;

function Terminate: Word; forward;

{*
 * DOS Multiplex handler.
 *
 * @param _Flags                cpu flags register
 * @param _CS                   cpu code segment register
 * @param _IP                   cpu instruction pointer register
 * @param _AX                   cpu accumulator register
 * @param _BX                   cpu base register
 * @param _CX                   cpu counter register
 * @param _DX                   cpu data register
 * @param _SI                   cpu source index register
 * @param _DI                   cpu destination index register
 * @param _DS                   cpu data segment register
 * @param _ES                   cpu extra segment register
 * @param _BP                   cpu base pointer register
 *}
procedure NewMultiplex(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
  _SI, _DI, _DS, _ES, _BP: Word); interrupt;
begin
  asm CLI end;
  with Reg do begin                      { get registers }
    Flags:= _Flags;
    Ax:= _AX; Bx:= _BX; Cx:= _CX; Dx:= _DX;
    Si:= _SI; Di:= _DI;
    Ds:= _DS; Es:= _ES;
    Bp:= _BP;
  end;

  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;
  asm STI end;

  if Reg.Ah = MyTask then begin
    case Reg.Al of
      $0:                                { get your presence and }
        begin                            { identity string }
          Reg.Al:= $FF;
          Reg.Es:= Seg(Copyright);
          Reg.Bx:= Ofs(Copyright);
        end;
      $C0:                               { unload itself }
        Reg.Ax:= Terminate;
    end;
  end else
    CallOldIntr(OldMultiplex, Reg);

  asm CLI end;
  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
  with Reg do begin                      { set registers }
    _Flags:= Flags;
    _AX:= Ax; _BX:= Bx; _CX:= Cx; _DX:= Dx;
    _SI:= Si; _DI:= Di;
    _DS:= Ds; _ES:= Es;
    _BP:= Bp;
  end;
  asm STI end;
end;

{*
 * Terminate the resident part
 *
 * @return terminate status; non zero if terminate, otherwise zero
 *}
function Terminate: Word;
var
  CanDo: Boolean;
  Com, Tmr, Dsf, Mlp: Pointer;
begin
                                         { get current interrupt handler }
  GetIntVec($14, Com);                   { addresses }
  GetIntVec($08, Tmr);
  GetIntVec($28, Dsf);
  GetIntVec($2F, Mlp);
                                         { check match for current handlers }
  CanDo:= (Com = Addr(NewCom)) and
          (Tmr = Addr(NewTimer)) and
          (Dsf = Addr(NewDosSafe)) and
          (Mlp = Addr(NewMultiplex));

  if CanDo then begin
                                         { safe-check if in buffer some data }
    Action;                              { do it }

    Active:= False;                      { remove activity }
    asm CLI end;
    SetIntVec($14, OldCom);              { set old interrupt handlers }
    SetIntVec($08, OldTimer);
    SetIntVec($28, OldDosSafe);
    SetIntVec($2F, OldMultiplex);
    asm STI end;

    Reg.Ah:= $49;                        { remove itself from memory }
    Reg.Es:= PrefixSeg;
    MsDos(Reg);
  end;
  Terminate:= Word(CanDo);
end;

{$F-}

{********** non resident part ************************************}

{*
 * Prints the syntax.
 *}
procedure Usage;
begin
  Writeln('Usage: ', ExeName, ' [-uqh?L pPORT fFILE]');
  Writeln;
  Writeln('Options:');
  Writeln('  u        remove program from memory');
  Writeln('  q        be quiet');
  Writeln('  h, ?     display this help screen');
  Writeln('  L        display software licence');
  Writeln;
  Writeln('  pPORT');
  Writeln('   PORT    COM port number');
  Writeln;
  Writeln('  fFILE');
  Writeln('   FILE    file name');
  Writeln;
  Writeln('Default: -p', DefPortNumber, ' -f', DefFileName);
  Halt(1);
end;

{*
 * Set port parameter from command line.
 *
 * @param Args                  arguments
 *}
procedure Paramp(Args: String);
const
 SEP = ' ';                             { arguments separator }
var
  S: String;
  V, Code: Integer;
begin
                                        { port }
  S:= GetParseString(0, Args, SEP);
  if Length(S) > 0 then begin
    Val(S, V, Code);
    if Code <> 0 then begin
      OptArgErrMsg(ExeName, True);
      Halt(2);
    end;
    if (V < 1) or (V > 4) then begin
      OptArgErrMsg(ExeName, True);
      Halt(2);
    end;
    Port:= V-1;
  end;
end;

{*
 * Set file name parameter from command line.
 *
 * @param Args                  arguments
 *}
procedure Paramf(Args: String);
const
 SEP = ' ';                             { arguments separator }
var
  S: String;
begin
                                        { data file name }
  S:= GetParseString(0, Args, SEP);
  if Length(S) > 0 then
    FileName:= S;
end;

{*
 * Initialize the resident part.
 *}
procedure Install;
begin
  Switch:= -1;                           { set default values }
  Active:= False;
  ActiveRqst:= False;
  Timer:= 0;
  BufferPosition:= 0;

  FileName:= FExpand(FileName);

  asm CLI end;
  MySS:= SSeg;                           { get stack pointers for handlers }
  MySP:= SPtr;
  GetIntVec($14, OldCom);                { get current interrupt handler }
  GetIntVec($08, OldTimer);              { addresses }
  GetIntVec($28, OldDosSafe);
  GetIntVec($2F, OldMultiplex);
  asm STI end;

  asm CLI end;
  SetIntVec($14, Addr(NewCom));          { set the new interrupt handlers }
  SetIntVec($08, Addr(NewTimer));
  SetIntVec($28, Addr(NewDosSafe));
  SetIntVec($2F, Addr(NewMultiplex));
  asm STI end;

  Reg.Ah:= $34;                          { get dos busy flag }
  MsDos(Reg);
  DosFlagPtr:= Ptr(Reg.Es, Reg.Bx);

  Reg.Ah:= $49;                          { free enviroments }
  Reg.Es:= MemW[PrefixSeg : $2C];
  MsDos(Reg);
end;

var
  I: Byte;
  UnInstall, Quiet: Boolean;
  Args: String;

begin
  Write(Copyright, ' ', Version, ', ');
  Writeln('Copyright (C) 1997-2002 Henrich Fukna');
  LicenceLine(Copyright, ExeName);
  Writeln;

  UnInstall:= False;
  Quiet:= False;
  FileName:= DefFileName;
  Port:= DefPortNumber-1;

  I:= 1;
  while I <= ParamCount do begin
    Args:= ParamStr(I);
    if (Args[1] = '-') then begin
      Delete(Args, 1, 1);
      while Length(Args) > 0 do begin
        case Args[1] of
          '?',
          'h': Usage;
          'L':
            begin
              Licence;
              Halt(1);
            end;
          'u': UnInstall:= True;
          'q': Quiet:= True;
          'p':
            begin
              Paramp(Copy(Args, 2, Length(Args)-1));
              Args:= '';
            end;
          'f':
            begin
              Paramf(Copy(Args, 2, Length(Args)-1));
              Args:= '';
            end;
          else begin
            OptArgErrMsg(ExeName, False);
            Halt(2);
          end;
        end;
        Delete(Args, 1, 1);
      end;
    end else begin
      OptArgErrMsg(ExeName, True);
      Halt(2);
    end;
    Inc(I);
  end;

  I:= $FF;                               { find first free multiplex service }
  MyTask:= 0;
  while (I > $7F) do begin
    Reg.Ah:= I;
    Reg.Al:= 0;
    Intr($2F, Reg);
    if Reg.Al = $FF then begin           { check presence }
      if StrComp(Addr(Copyright), Ptr(Reg.Es, Reg.Bx)) then
        if UnInstall then begin          { uninstall request }
          Reg.Ah:= I;
          Reg.Al:= $C0;
          Intr($2F, Reg);
          if (Reg.Ax) = 0 then begin
            if not(Quiet) then
              Writeln('Resident can not be unloaded.');
            Halt(3);
          end else begin
            if not(Quiet) then
              Writeln('Resident was unloaded.');
            Halt(0);
          end;
        end else begin
          if not(Quiet) then
            Writeln('Resident is already loaded.');
          Halt(4);
        end;
    end else
      if (MyTask = 0) and (Reg.Al = 0) then MyTask:= I;
    Dec(I);
  end;
  if UnInstall then begin                { resident part not present }
    if not(Quiet) then
      Writeln('Resident is not in memory.');
    Halt(4);
  end;
  if MyTask = 0 then begin               { no free multiplex service }
    if not(Quiet) then
      Writeln('Resident can not be loaded.');
    Halt(3);
  end;

  if not(Quiet) then begin               { print the values }
    Writeln('Resident was loaded.');
    Writeln('COM', Port+1, ' port monitored to ', FileName);
  end;

  Install;                               { initialize TSR }
  Keep(0);                               { keep resident }
end.