unit hwmonu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Registry, TrayIcon, Menus, LM78Ctrl, PortIO;

type
  TAlarmType=(Voltage,Temperature,Fan);
  TAlarmType2=(VCore_,V33_,V5P_,V12P_,V5N_,V12N_,Fan1_,Fan2_,Fan3_,Temp1_,Temp2_,Temp3_);
  THardwareMon = class(TForm)
    VCoreV: TLabel;
    V33V: TLabel;
    V5PV: TLabel;
    V12PV: TLabel;
    V5NV: TLabel;
    V12NV: TLabel;
    Fan1V: TLabel;
    Fan2V: TLabel;
    Fan3V: TLabel;
    Temp2V: TLabel;
    Temp1V: TLabel;
    RefreshB: TButton;
    VCoreL: TLabel;
    V33L: TLabel;
    V5PL: TLabel;
    V12PL: TLabel;
    V5NL: TLabel;
    V12NL: TLabel;
    Fan1L: TLabel;
    Fan2L: TLabel;
    Fan3L: TLabel;
    Temp2L: TLabel;
    Temp1L: TLabel;
    AboutB: TButton;
    OptionsB: TButton;
    Timer: TTimer;
    TrayIcon: TTrayIcon;
    HideB: TButton;
    PopupMenu: TPopupMenu;
    ShowM: TMenuItem;
    ExitM: TMenuItem;
    AboutM: TMenuItem;
    UpdEnabledM: TMenuItem;
    OptionsM: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    VoltageIcon: TImage;
    FanIcon: TImage;
    TempIcon: TImage;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Temp3L: TLabel;
    Temp3V: TLabel;
    DLPortIO: TDLPortIO;
    procedure ReadSettings;
    procedure SaveSettings;
    procedure RefreshBClick(Sender: TObject);
    procedure AboutBClick(Sender: TObject);
    procedure OptionsBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HideBClick(Sender: TObject);
    procedure TrayIconClick(Sender: TObject);
    procedure ShowMClick(Sender: TObject);
    procedure TrayIconRightClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ExitMClick(Sender: TObject);
    procedure UpdEnabledMClick(Sender: TObject);
    procedure OptionsMClick(Sender: TObject);
    procedure AboutMClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure WindowsShutDown(var Message:TMessage);message WM_QUERYENDSESSION;
  private
    procedure MonitorRefresh;
    procedure CheckAlarm;
    procedure LogEvent(What:String);
    procedure Alarm(AlarmType:TAlarmType; Type2:TAlarmType2; Value:Integer);
    { Private declarations }
  public
    { Public declarations }
    Reg:TRegistry;
  end;
var
  HardwareMon: THardwareMon;
  LM78:TLM78;
  UpdInterval, VTolerance: Byte;
  Address: Word;
  VCore,V33,V5P,V12P,V5N,V12N,Fan1,Fan2,Fan3,Temp1,Temp2,Temp3:Integer;
  NormVCore,MinFan1,MinFan2,MinFan3,MaxMB,MaxCPU,MaxPower:Integer;
  AlEnabled:Boolean;
  AlarmEnabled:record
    VCore,V33,V5,V12,Fan1,Fan2,Fan3,Temp1,Temp2,Temp3:Boolean;
               end;
  LogEnabled,ShutDown:Boolean;
  LogFile:String;

implementation

uses HwMonOpt, HwMonAbt;

{$R *.DFM}

procedure THardwareMon.ReadSettings;
begin
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_LOCAL_MACHINE;
  if Reg.OpenKey('Software\Rainbow Software\HwMon',FALSE) then
   begin
     try Fan1L.Caption:=Reg.ReadString('Fan1Name')+':' except Fan1L.Caption:='Chassis Fan:' end;
     if Fan1L.Caption=':' then Fan1L.Caption:='Chassis Fan:';
     try Fan2L.Caption:=Reg.ReadString('Fan2Name')+':' except Fan2L.Caption:='CPU Fan:' end;
     if Fan2L.Caption=':' then Fan2L.Caption:='CPU Fan:';
     try Fan3L.Caption:=Reg.ReadString('Fan3Name')+':' except Fan3L.Caption:='Power Fan:' end;
     if Fan3L.Caption=':' then Fan3L.Caption:='Power Fan:';
     try Reg.ReadBinaryData('Address',Address,SizeOf(Address)) except Address:=$290 end;
     try Temp1L.Caption:=Reg.ReadString('Temp1Name')+':' except Temp1L.Caption:='MB Temperature:' end;
     if Temp1L.Caption=':' then Temp1L.Caption:='MB Temperature:';
     try Temp2L.Caption:=Reg.ReadString('Temp2Name')+':' except Temp2L.Caption:='CPU Temperature:' end;
     if Temp2L.Caption=':' then Temp2L.Caption:='CPU Temperature:';
     try Temp3L.Caption:=Reg.ReadString('Temp3Name')+':' except Temp3L.Caption:='Power Temp.:' end;
     if Temp3L.Caption=':' then Temp3L.Caption:='Power Temp.:';
     if Address=0 then Address:=$290;
     try Reg.ReadBinaryData('Update Interval',UpdInterval,SizeOf(UpdInterval)) except UpdInterval:=10 end;
     if UpdInterval=0 then UpdInterval:=10;
     HardwareMon.Timer.Interval:=UpdInterval*1000;
     try UpdEnabledM.Checked:=Reg.ReadBool('Update') except UpdEnabledM.Checked:=True end;
     with AlarmEnabled do
      begin
        try VCore:=Reg.ReadBool('VCore') except VCore:=False end;
        try V33:=Reg.ReadBool('V33') except V33:=False end;
        try V5:=Reg.ReadBool('V5') except V5:=False end;
        try V12:=Reg.ReadBool('V12') except V12:=False end;
        try Fan1:=Reg.ReadBool('Fan1') except Fan1:=False end;
        try Fan2:=Reg.ReadBool('Fan2') except Fan2:=False end;
        try Fan3:=Reg.ReadBool('Fan3') except Fan3:=False end;
        try Temp1:=Reg.ReadBool('Temp1') except Temp1:=False end;
        try Temp2:=Reg.ReadBool('Temp2') except Temp2:=False end;
        try Temp3:=Reg.ReadBool('Temp3') except Temp3:=False end;        
      end;
     try Reg.ReadBinaryData('NormVCore',NormVCore,SizeOf(NormVCore)) except NormVCore:=200 end;
     if NormVCore=0 then NormVCore:=200;
     try Reg.ReadBinaryData('VTolerance',VTolerance,SizeOf(VTolerance)) except VTolerance:=10 end;
     if VTolerance=0 then VTolerance:=10;
     try Reg.ReadBinaryData('MinFan1',MinFan1,SizeOf(MinFan1)) except MinFan1:=3000 end;
     if MinFan1=0 then MinFan1:=3000;
     try Reg.ReadBinaryData('MinFan2',MinFan2,SizeOf(MinFan2)) except MinFan2:=3000 end;
     if MinFan2=0 then MinFan2:=3000;
     try Reg.ReadBinaryData('MinFan3',MinFan3,SizeOf(MinFan3)) except MinFan3:=3000 end;
     if MinFan3=0 then MinFan3:=3000;
     try Reg.ReadBinaryData('MaxMB',MaxMB,SizeOf(MaxMB)) except MaxMB:=45 end;
     if MaxMB=0 then MaxMB:=45;
     try Reg.ReadBinaryData('MaxCPU',MaxCPU,SizeOf(MaxCPU)) except MaxCPU:=50 end;
     if MaxCPU=0 then MaxCPU:=50;
     try Reg.ReadBinaryData('MaxPower',MaxPower,SizeOf(MaxPower)) except MaxPower:=45 end;
     if MaxPower=0 then MaxPower:=45;
     try LogEnabled:=Reg.ReadBool('LogEnabled') except LogEnabled:=False end;
     try LogFile:=Reg.ReadString('LogFile') except LogFile:='' end;
     if LogFile='' then LogEnabled:=False;
     Reg.CloseKey;
   end else
    begin
      Fan1L.Caption:='Chassis Fan:';
      Fan2L.Caption:='CPU Fan:';
      Fan3L.Caption:='Power Fan:';
      Temp1L.Caption:='MB Temperature:';
      Temp2L.Caption:='CPU Temperature:';
      Temp3L.Caption:='Power Temp.:';
      Address:=$290;
      UpdInterval:=10;
      HardwareMon.Timer.Interval:=10000;
      UpdEnabledM.Checked:=True;
      with AlarmEnabled do
       begin
         VCore:=False;
         V33:=False;
         V5:=False;
         V12:=False;
         Fan1:=False;
         Fan2:=False;
         Fan3:=False;
         Temp1:=False;
         Temp2:=False;
         Temp3:=False;
       end;
      NormVCore:=200;
      VTolerance:=10;
      MinFan1:=3000;
      MinFan2:=3000;
      MinFan3:=3000;
      MaxMB:=45;
      MaxCPU:=50;
      MaxPower:=45;
      LogEnabled:=False;
      LogFile:='';
    end;
   Reg.Free;
end;

procedure THardwareMon.SaveSettings;
begin
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_LOCAL_MACHINE;
  if Reg.OpenKey('Software\Rainbow Software\HwMon',TRUE) then
   begin
     try
       Reg.WriteString('Fan1Name',Copy(Fan1L.Caption,1,Length(Fan1L.Caption)-1));
       Reg.WriteString('Fan2Name',Copy(Fan2L.Caption,1,Length(Fan2L.Caption)-1));
       Reg.WriteString('Fan3Name',Copy(Fan3L.Caption,1,Length(Fan3L.Caption)-1));
       Reg.WriteString('Temp1Name',Copy(Temp1L.Caption,1,Length(Temp1L.Caption)-1));
       Reg.WriteString('Temp2Name',Copy(Temp2L.Caption,1,Length(Temp2L.Caption)-1));
       Reg.WriteString('Temp3Name',Copy(Temp3L.Caption,1,Length(Temp3L.Caption)-1));
       Reg.WriteBinaryData('Address',Address,SizeOf(Address));
       Reg.WriteBool('Update',UpdEnabledM.Checked);
       Reg.WriteBinaryData('Update Interval',UpdInterval,SizeOf(UpdInterval));
       Reg.WriteBool('VCore',AlarmEnabled.VCore);
       Reg.WriteBool('V33',AlarmEnabled.V33);
       Reg.WriteBool('V5',AlarmEnabled.V5);
       Reg.WriteBool('V12',AlarmEnabled.V12);
       Reg.WriteBool('Fan1',AlarmEnabled.Fan1);
       Reg.WriteBool('Fan2',AlarmEnabled.Fan2);
       Reg.WriteBool('Fan3',AlarmEnabled.Fan3);
       Reg.WriteBool('Temp1',AlarmEnabled.Temp1);
       Reg.WriteBool('Temp2',AlarmEnabled.Temp2);
       Reg.WriteBool('Temp3',AlarmEnabled.Temp3);
       Reg.WriteBinaryData('NormVCore',NormVCore,SizeOf(NormVCore));
       Reg.WriteBinaryData('VTolerance',VTolerance,SizeOf(VTolerance));
       Reg.WriteBinaryData('MinFan1',MinFan1,SizeOf(MinFan1));
       Reg.WriteBinaryData('MinFan2',MinFan2,SizeOf(MinFan2));
       Reg.WriteBinaryData('MinFan3',MinFan3,SizeOf(MinFan3));
       Reg.WriteBinaryData('MaxMB',MaxMB,SizeOf(MaxMB));
       Reg.WriteBinaryData('MaxCPU',MaxCPU,SizeOf(MaxCPU));
       Reg.WriteBinaryData('MaxPower',MaxPower,SizeOf(MaxPower));
       Reg.WriteBool('LogEnabled',LogEnabled);
       Reg.WriteString('LogFile',LogFile);
     finally
       Reg.CloseKey;
     end;  
   end;
  Reg.Free;
end;

procedure THardwareMon.RefreshBClick(Sender: TObject);
begin
  MonitorRefresh;
  CheckAlarm;
end;

procedure THardwareMon.MonitorRefresh;

  procedure HWMonitor(var VCore,V33,V5P,V12P,V5N,V12N,Fan1,Fan2,Fan3,Temp1,Temp2,Temp3:Integer);
  begin
    LM78.RefreshValues;
    // v1.6 - Accurate results
    // Max voltage is 4.096V and byte is max 256 (4096/256=16)
    VCore:=Round(LM78.ValueRAM.VCoreA*1.6);
    V33:=Round(LM78.ValueRAM.V33*1.6);
    V5P:=Round(LM78.ValueRAM.V5*1.68*1.6{8/3}); // (50+34)/50*x
    V12P:=Round(LM78.ValueRAM.V12*3.8*1.6{6.08}); // (28+10)/10*x
    if not LM78.W83782D_ then
     begin // -5V and -12V were swapped (!!!)
       V5N:=0-Round(LM78.ValueRAM._V5{12}*90.9/60.4*1.6{2.4}); // 90.9K and 60.4Kohm resistors
       V12N:=0-Round(LM78.ValueRAM._V12{5}*210/60.4*1.6{5.568}); // 210K and 60.4Kohm resistors
     end
    else
     begin // Is this OK?                        // Pit:54
       V5N:=Round((LM78.ValueRAM._V5*1.6-360*(15/22))/(1-15/22)); // 120K and 56Kohm resistors, 3.6V ref. voltage
       V12N:=Round((LM78.ValueRAM._V12*1.6-360*(29/36))/(1-29/36)); // 232K and 56Kohm resistors, 3.6V ref. voltage
     end;                                        // Pit:39

    if LM78.ValueRAM.Fan1<>255 then Fan1:=1350000 div LM78.ValueRAM.Fan1 div LM78.F1Div else Fan1:=0;
    if LM78.ValueRAM.Fan2<>255 then Fan2:=1350000 div LM78.ValueRAM.Fan2 div LM78.F2Div else Fan2:=0;
    if LM78.ValueRAM.Fan3<>255 then Fan3:=1350000 div LM78.ValueRAM.Fan3 div LM78.F3Div else Fan3:=0;
    Temp1:=LM78.ValueRAM.Temp;
    Temp2:=LM78.Temp2;
    Temp3:=LM78.Temp3;
  end;

begin
  HWMonitor(VCore,V33,V5P,V12P,V5N,V12N,Fan1,Fan2,Fan3,Temp1,Temp2,Temp3);
  VCoreV.Caption:=FloatToStrF(VCore/100,ffFixed,5,2)+' V';
  V33V.Caption:=FloatToStrF(V33/100,ffFixed,5,2)+' V';
  V5PV.Caption:=FloatToStrF(V5P/100,ffFixed,5,2)+' V';
  V12PV.Caption:=FloatToStrF(V12P/100,ffFixed,5,2)+' V';
  V5NV.Caption:=FloatToStrF(V5N/100,ffFixed,5,2)+' V';
  V12NV.Caption:=FloatToStrF(V12N/100,ffFixed,5,2)+' V';
  if Fan1<>2700000 then Fan1V.Caption:=IntToStr(Fan1)+' RPM' else Fan1V.Caption:='N/A';
  if Fan2<>2700000 then Fan2V.Caption:=IntToStr(Fan2)+' RPM' else Fan2V.Caption:='N/A';
  if Fan3<>2700000 then Fan3V.Caption:=IntToStr(Fan3)+' RPM' else Fan3V.Caption:='N/A';
  if (Temp1<127) and (Temp1>1) then Temp1V.Caption:=IntToStr(Temp1)+' C' else Temp1V.Caption:='N/A';
  if (Temp2<1275) and (Temp2>-400) then Temp2V.Caption:=FloatToStrF(Temp2/10,ffFixed,4,1)+' C' else Temp2V.Caption:='N/A';
  if (Temp3<1275) and (Temp3>-400) then Temp3V.Caption:=FloatToStrF(Temp3/10,ffFixed,4,1)+' C' else Temp3V.Caption:='N/A';
end;

procedure THardwareMon.Alarm(AlarmType:TAlarmType; Type2:TAlarmType2; Value:Integer);
var Msg,Title:String;
begin
  if not AlEnabled then Exit;
  AlEnabled:=False;
  Msg:='WARNING: ';
  case Type2 of
    VCore_: Title:='Core ';
    V33_: Title:='3.3V ';
    V5P_: Title:='+5V ';
    V12P_: Title:='+12V ';
    V5N_: Title:='-5V ';
    V12N_: Title:='-12V ';
    Fan1_: Title:=Copy(Fan1L.Caption,1,Length(Fan1L.Caption)-1)+' ';
    Fan2_: Title:=Copy(Fan2L.Caption,1,Length(Fan2L.Caption)-1)+' ';
    Fan3_: Title:=Copy(Fan3L.Caption,1,Length(Fan3L.Caption)-1)+' ';
    Temp1_: Title:=Copy(Temp1L.Caption,1,Length(Temp1L.Caption)-1)+' ';
    Temp2_: Title:=Copy(Temp2L.Caption,1,Length(Temp2L.Caption)-1)+' ';
    Temp3_: Title:=Copy(Temp3L.Caption,1,Length(Temp3L.Caption)-1)+' ';
  end;
  case AlarmType of
    Voltage: Title:=Title+'Voltage';
    Temperature: Title:=Title+'Temperature';
    Fan: Title:=Title+'Speed';
  end;
  Msg:=Msg+Title+' is out of range.'+#13+#10+#13+#10+'Normal value: ';
  case Type2 of
    VCore_: Msg:=Msg+FloatToStrF(NormVCore/100,ffFixed,5,2)+' V';
    V33_  : Msg:=Msg+FloatToStrF(3.3,ffFixed,5,2)+' V';
    V5P_  : Msg:=Msg+FloatToStrF(5,ffFixed,5,2)+' V';
    V12P_ : Msg:=Msg+FloatToStrF(12,ffFixed,5,2)+' V';
    V5N_  : Msg:=Msg+FloatToStrF(-5,ffFixed,5,2)+' V';
    V12N_ : Msg:=Msg+FloatToStrF(-12,ffFixed,5,2)+' V';
    Fan1_ : Msg:=Msg+IntToStr(MinFan1)+' RPM';
    Fan2_ : Msg:=Msg+IntToStr(MinFan2)+' RPM';
    Fan3_ : Msg:=Msg+IntToStr(MinFan3)+' RPM';
    Temp1_: Msg:=Msg+IntToStr(MaxMB)+' C';
    Temp2_: Msg:=Msg+IntToStr(MaxCPU)+' C';
    Temp3_: Msg:=Msg+IntToStr(MaxPower)+' C';
  end;
  Msg:=Msg+#13+#10+'Current value: ';
  case Type2 of
    VCore_,V33_,V5P_,V12P_,V5N_,V12N_: Msg:=Msg+FloatToStrF(Value/100,ffFixed,5,2)+' V';
    Fan1_,Fan2_,Fan3_: Msg:=Msg+IntToStr(Value)+' RPM';
    Temp1_,Temp2_,Temp3_: Msg:=Msg+IntToStr(Value)+' C';
  end;
  Title:=Title+' Alarm';
  LogEvent(Msg);
  MessageBox(0,PChar(Msg),PChar(Title),16);
  AlEnabled:=True;
end;

procedure THardwareMon.CheckAlarm;
begin
  if (AlarmEnabled.VCore) and (Abs(VCore/100-NormVCore/100)>(NormVCore/100*VTolerance/100)) then Alarm(Voltage,VCore_,VCore);
  if (AlarmEnabled.V33) and (Abs(V33/100-3.3)>(3.3*VTolerance/100)) then Alarm(Voltage,V33_,V33);
  if (AlarmEnabled.V5) and (Abs(V5P/100-5)>(5*VTolerance/100)) then Alarm(Voltage,V5P_,V5P);
  if (AlarmEnabled.V12) and (Abs(V12P/100-12)>(12*VTolerance/100)) then Alarm(Voltage,V12P_,V12P);
  if (AlarmEnabled.V5) and (Abs(V5N/100+5)>(5*VTolerance/100)) then Alarm(Voltage,V5N_,V5N);
  if (AlarmEnabled.V12) and (Abs(V12N/100+12)>(12*VTolerance/100)) then Alarm(Voltage,V12N_,V12N);
  if (AlarmEnabled.Fan1) and (Fan1<MinFan1) then Alarm(Fan,Fan1_,Fan1);
  if (AlarmEnabled.Fan2) and (Fan2<MinFan2) then Alarm(Fan,Fan2_,Fan2);
  if (AlarmEnabled.Fan3) and (Fan3<MinFan3) then Alarm(Fan,Fan3_,Fan3);
  if (AlarmEnabled.Temp1) and ((Temp1<200) and (Temp1>MaxMB)) then Alarm(Temperature,Temp1_,Temp1);
  if (AlarmEnabled.Temp2) and ((Temp2<200) and (Temp2>MaxCPU)) then Alarm(Temperature,Temp2_,Temp2);
  if (AlarmEnabled.Temp3) and ((Temp3<200) and (Temp3>MaxPower)) then Alarm(Temperature,Temp3_,Temp3);
end;

procedure THardwareMon.LogEvent(What:String);
var F:TextFile;
    S:String;
    A:Byte;
begin
  if not LogEnabled then Exit;
  S:='';
  for A:=1 to Length(What) do
   begin
     if (What[A]=#13) or (What[A]=#10) then S:=S+' ' else S:=S+What[A];
   end;
  AssignFile(F,LogFile);
  {$I-}
  Append(F);
  if IOResult<>0 then ReWrite(F);
  WriteLn(F,DateToStr(Date),' ',TimeToStr(Time),'  -  ',S);
  CloseFile(F);
  {$I+}
end;

procedure THardwareMon.AboutBClick(Sender: TObject);
begin
  if not AboutBox.Visible then AboutBox.ShowModal else AboutBox.BringToFront;
end;

procedure THardwareMon.OptionsBClick(Sender: TObject);
begin
  Options.ShowModal;
end;

procedure THardwareMon.FormCreate(Sender: TObject);
var OS: TOSVersionInfo;
begin
  AlEnabled:=True;
  ShutDown:=False;
  ReadSettings;
  LogEvent(Application.Title+' started.');
  DLPortIO.OpenDriver;
  if not DLPortIO.ActiveHW then
   begin
     OS.dwPlatformId:=0;
     OS.dwOSVersionInfoSize:=SizeOf(TOSVersionInfo);
     GetVersionEx(os);
     if OS.dwPlatformId=VER_PLATFORM_WIN32_NT then
      begin
        CopyFile('DLPORTIO.SYS',PChar(DLPortIO.DriverPath+'\DLPORTIO.SYS'),FALSE);
        DLPortIO.OpenDriver;
      end;
   end;
  if not DLPortIO.ActiveHW then
   begin
     Application.MessageBox('Could not open DriverLINX driver.','Error',0);
     LogEvent('Cannot open DriverLINX driver.');
     Application.Terminate;
     Exit;
   end;
  Timer.Enabled:=UpdEnabledM.Checked;
  LM78:=TLM78.Create(Address);
  if LM78.Error<>ER_NoError then
   begin
     Application.MessageBox('Hardware Monitoring chip not found at specified address.','Error accessing Hardware Monitoring chip',0); // NOT FOUND
     LogEvent('Cannot access Hardware Monitoring chip.');
   end;
  TrayIcon.Active:=True;
  MonitorRefresh;
end;

procedure THardwareMon.FormDestroy(Sender: TObject);
begin
  HardwareMon.SaveSettings;
  LM78.Free;
  LogEvent(Application.Title+' closed.');
end;

procedure THardwareMon.HideBClick(Sender: TObject);
begin
  HardwareMon.Hide;
end;

procedure THardwareMon.TrayIconClick(Sender: TObject);
begin
  if AboutBox.Visible then AboutBox.BringToFront else
   if Options.Visible then Options.BringToFront else
    if not HardwareMon.Visible then HardwareMon.Show;
  Application.BringToFront;
end;

procedure THardwareMon.ShowMClick(Sender: TObject);
begin
  if AboutBox.Visible then AboutBox.BringToFront else
   if Options.Visible then Options.BringToFront else
    if not HardwareMon.Visible then HardwareMon.Show;
  Application.BringToFront;
end;

procedure THardwareMon.TrayIconRightClick(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  PopupMenu.PopUp(X,Y);
end;

procedure THardwareMon.ExitMClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure THardwareMon.UpdEnabledMClick(Sender: TObject);
begin
  if HardwareMon.Timer.Enabled then
   begin
     UpdEnabledM.Checked:=False;
     HardwareMon.Timer.Enabled:=False;
   end
  else
   begin
     UpdEnabledM.Checked:=True;
     HardwareMon.Timer.Enabled:=True;
   end;
end;

procedure THardwareMon.OptionsMClick(Sender: TObject);
begin
  if AboutBox.Visible then AboutBox.BringToFront else
  if not Options.Visible then Options.ShowModal else Options.BringToFront;
  Application.BringToFront;
end;

procedure THardwareMon.AboutMClick(Sender: TObject);
begin
  if Options.Visible then Options.BringToFront else
  if not AboutBox.Visible then AboutBox.ShowModal else AboutBox.BringToFront;
  Application.BringToFront;
end;

procedure THardwareMon.FormShow(Sender: TObject);
begin
  RefreshB.SetFocus;
end;

procedure THardwareMon.FormCloseQuery(Sender: TObject; //v1.6
  var CanClose: Boolean);
begin
  if not ShutDown then
   begin
     CanClose:=False;
     Hide;
   end;
end;

procedure THardwareMon.WindowsShutDown(var Message:TMessage); //v1.6
begin
  ShutDown:=True;
  inherited
end;

end.
