unit hwmonopt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Spin, ShellAPI, LM78Ctrl;

type
  TOptions = class(TForm)
    PageControl: TPageControl;
    Configuration: TTabSheet;
    OK: TButton;
    Cancel: TButton;
    HwMonIcon: TImage;
    ConfigLabel2: TLabel;
    ConfigLabel1: TLabel;
    UpdateGroup: TGroupBox;
    Seconds: TLabel;
    Interval: TSpinEdit;
    Update: TCheckBox;
    Alarm: TTabSheet;
    AlarmIcon: TImage;
    AlarmLabel1: TLabel;
    AlarmLabel2: TLabel;
    VoltAlGroup: TGroupBox;
    FanAlGroup: TGroupBox;
    TempAlGroup: TGroupBox;
    Temp1C: TCheckBox;
    Temp2C: TCheckBox;
    Fan1C: TCheckBox;
    Fan2C: TCheckBox;
    Fan3C: TCheckBox;
    VCoreC: TCheckBox;
    V5C: TCheckBox;
    V12C: TCheckBox;
    V33C: TCheckBox;
    FansB: TButton;
    TemperaturesB: TButton;
    VoltagesB: TButton;
    ChipGroup: TGroupBox;
    Address: TEdit;
    LMAddress: TLabel;
    LMHex: TLabel;
    Apply: TButton;
    Logging: TTabSheet;
    LogIcon: TImage;
    LogLabel1: TLabel;
    LogLabel2: TLabel;
    LogGroup: TGroupBox;
    LogFile: TEdit;
    Browse: TButton;
    LogFileLabel: TLabel;
    BrowseDialog: TSaveDialog;
    ViewLog: TButton;
    ClearLog: TButton;
    LogEnabled: TCheckBox;
    HwMonChip: TLabel;
    ChipType: TLabel;
    AdrReset: TButton;
    Temp3C: TCheckBox;
    FanGroup: TGroupBox;
    Configure: TButton;
    procedure OKClick(Sender: TObject);
    procedure UpdateClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure VoltagesBClick(Sender: TObject);
    procedure FansBClick(Sender: TObject);
    procedure TemperaturesBClick(Sender: TObject);
    procedure ApplyOptions;
    procedure LogTabUpdate;
    function Hex2Dec(S:String):Word;
    function Word2Hex(I:Word):String;
    procedure ApplyClick(Sender: TObject);
    procedure ApplyEnable(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LogEnabledClick(Sender: TObject);
    procedure BrowseClick(Sender: TObject);
    procedure ClearLogClick(Sender: TObject);
    procedure ViewLogClick(Sender: TObject);
    procedure ReInitChip;
    procedure AdrResetClick(Sender: TObject);
    procedure ConfigureClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Options: TOptions;

implementation

uses hwmonu, hwmonvol, hwmonfan, hwmontmp, hwmonnam;

{$R *.DFM}

function TOptions.Hex2Dec(S:String):Word;
var A,I,Z:Word;
begin
  I:=0;
  Z:=1;
  for A:=Length(S) downto 1 do
   begin
     if (S[A]<':') and (S[A]>'/') then Inc(I,(Ord(S[A])-48)*Z);
     if (S[A]<'G') and (S[A]>'@') then Inc(I,(Ord(S[A])-55)*Z);
     if (S[A]<'g') and (S[A]>'`') then Inc(I,(Ord(S[A])-87)*Z);
     Z:=Z*16;
   end;
  Hex2Dec:=I;
end;

function TOptions.Word2Hex(I:Word):String;
const Values:Array[0..15] of Char='0123456789abcdef';
var S,S1:String;
    A:Byte;
begin
  S:='';
  S1:='';
  repeat
    S:=S+Values[I mod 16];
    I:=I div 16;
  until I=0;
  for A:=3 downto Length(S) do S1:=S1+'0';
  for A:=Length(S) downto 1 do S1:=S1+S[A];
  Word2Hex:=S1;
end;

procedure TOptions.ApplyOptions;
begin
  UpdInterval:=Interval.Value;
  HardwareMon.UpdEnabledM.Checked:=Update.Checked;
  if HWMonU.Address<>Hex2Dec(Address.Text) then ReInitChip;
  HWMonU.Address:=Hex2Dec(Address.Text);
  HardwareMon.Timer.Enabled:=Update.Checked;
  HardwareMon.Timer.Interval:=Interval.Value*1000;
  AlarmEnabled.VCore:=VCoreC.Checked;
  AlarmEnabled.V33:=V33C.Checked;
  AlarmEnabled.V5:=V5C.Checked;
  AlarmEnabled.V12:=V12C.Checked;
  AlarmEnabled.Fan1:=Fan1C.Checked;
  AlarmEnabled.Fan2:=Fan2C.Checked;
  AlarmEnabled.Fan3:=Fan3C.Checked;
  AlarmEnabled.Temp1:=Temp1C.Checked;
  AlarmEnabled.Temp2:=Temp2C.Checked;
  AlarmEnabled.Temp3:=Temp3C.Checked;
  HWMonU.LogEnabled:=LogEnabled.Checked;
  HWMonU.LogFile:=LogFile.Text;
  Apply.Enabled:=False;
end;

procedure TOptions.LogTabUpdate;
var F:TextFile;
begin
  if LogEnabled.Checked then
   begin
     LogFileLabel.Enabled:=True;
     LogFile.Enabled:=True;
     Browse.Enabled:=True;
   end
  else
   begin
     LogFileLabel.Enabled:=False;
     LogFile.Enabled:=False;
     Browse.Enabled:=False;
   end;
  if HWMonU.LogFile<>'' then
   begin
     AssignFile(F,HWMonU.LogFile);
     {$I-}
     Reset(F);
     {$I+}
     if IOResult=0 then
      begin
        CloseFile(F);
        ClearLog.Enabled:=True;
        ViewLog.Enabled:=True;
        Exit;
      end;
   end;
  ClearLog.Enabled:=False;
  ViewLog.Enabled:=False;
end;

function ExecuteFile(const FileName, Params, DefaultDir: string; ShowCmd: Integer): THandle;
begin
  Result:=ShellExecute(Application.MainForm.Handle,nil,
   PChar(FileName),PChar(Params),PChar(DefaultDir),ShowCmd);
end;

procedure TOptions.OKClick(Sender: TObject);
begin
  ApplyOptions;
end;

procedure TOptions.UpdateClick(Sender: TObject);
begin
  if Update.Checked then
   begin
     Interval.Enabled:=True;
     Seconds.Enabled:=True;
   end
  else
   begin
     Interval.Enabled:=False;
     Seconds.Enabled:=False;
   end;
  Apply.Enabled:=True;
end;

procedure TOptions.FormHide(Sender: TObject);
begin
  if Tag=1 then AlEnabled:=True; //v1.6
end;

procedure TOptions.VoltagesBClick(Sender: TObject);
var Z:Integer;
    R:Real;
begin
  if VoltagesConfig.ShowModal=mrOk then
   begin
     Val(VoltagesConfig.NormVCore.Text,R,Z);
     HwMonU.NormVCore:=Round(R*100);
     if HwMonU.NormVCore=0 then HwMonU.NormVCore:=200;
     HwMonU.VTolerance:=VoltagesConfig.VTolerance.Value;
   end;
end;

procedure TOptions.FansBClick(Sender: TObject);
begin
  if FansConfig.ShowModal=mrOK then
   begin
     HwMonU.MinFan1:=FansConfig.MinFan1.Value;
     HwMonU.MinFan2:=FansConfig.MinFan2.Value;
     HwMonU.MinFan3:=FansConfig.MinFan3.Value;
   end;
end;

procedure TOptions.TemperaturesBClick(Sender: TObject);
begin
  if TempsConfig.ShowModal=mrOK then
   begin
     HwMonU.MaxMB:=TempsConfig.MaxTemp1.Value;
     HwMonU.MaxCPU:=TempsConfig.MaxTemp2.Value;
     HwMonU.MaxPower:=TempsConfig.MaxTemp3.Value;     
   end;
end;

procedure TOptions.ApplyClick(Sender: TObject);
begin
  ApplyOptions;
end;

procedure TOptions.ApplyEnable(Sender: TObject);
begin
  Apply.Enabled:=True;
end;

procedure TOptions.FormShow(Sender: TObject);
begin
  Fan1C.Caption:=Copy(HardwareMon.Fan1L.Caption,1,Length(HardwareMon.Fan1L.Caption)-1);
  Fan2C.Caption:=Copy(HardwareMon.Fan2L.Caption,1,Length(HardwareMon.Fan2L.Caption)-1);
  Fan3C.Caption:=Copy(HardwareMon.Fan3L.Caption,1,Length(HardwareMon.Fan3L.Caption)-1);
  Temp1C.Caption:=Copy(HardwareMon.Temp1L.Caption,1,Length(HardwareMon.Temp1L.Caption)-1);
  Temp2C.Caption:=Copy(HardwareMon.Temp2L.Caption,1,Length(HardwareMon.Temp2L.Caption)-1);
  Temp3C.Caption:=Copy(HardwareMon.Temp3L.Caption,1,Length(HardwareMon.Temp3L.Caption)-1);
  PageControl.ActivePage:=Configuration;
  Interval.Value:=UpdInterval;
  Update.Checked:=HardwareMon.Timer.Enabled;
  Address.Text:=Word2Hex(HwMonU.Address);
  VCoreC.Checked:=AlarmEnabled.VCore;
  V33C.Checked:=AlarmEnabled.V33;
  V5C.Checked:=AlarmEnabled.V5;
  V12C.Checked:=AlarmEnabled.V12;
  Fan1C.Checked:=AlarmEnabled.Fan1;
  Fan2C.Checked:=AlarmEnabled.Fan2;
  Fan3C.Checked:=AlarmEnabled.Fan3;
  Temp1C.Checked:=AlarmEnabled.Temp1;
  Temp2C.Checked:=AlarmEnabled.Temp2;
  Temp3C.Checked:=AlarmEnabled.Temp3;
  LogEnabled.Checked:=HWMonU.LogEnabled;
  LogFile.Text:=HWMonU.LogFile;
  LogTabUpdate;
  if AlEnabled then Tag:=1 else Tag:=0; //v1.6
  AlEnabled:=False;
  Apply.Enabled:=False;
  OK.SetFocus;
  if LM78.ChipType='' then ChipType.Caption:='Not present'
   else ChipType.Caption:=LM78.ChipType;
end;

procedure TOptions.LogEnabledClick(Sender: TObject);
begin
  Apply.Enabled:=True;
  LogTabUpdate;
end;

procedure TOptions.BrowseClick(Sender: TObject);
begin
  if BrowseDialog.Execute then LogFile.Text:=BrowseDialog.FileName;
end;

procedure TOptions.ClearLogClick(Sender: TObject);
var F:TextFile;
begin
  AssignFile(F,HWMonU.LogFile);
  {$I-}
  Erase(F);
  {$I+}
  ClearLog.Enabled:=False;
  ViewLog.Enabled:=False;
end;

procedure TOptions.ViewLogClick(Sender: TObject);
begin
  ExecuteFile('notepad.exe',HWMonU.LogFile,'',1)
end;

procedure TOptions.ReInitChip;
begin
  LM78.Free;
  LM78:=TLM78.Create(Hex2Dec(Address.Text));
  if LM78.ChipType='' then ChipType.Caption:='Not present'
   else ChipType.Caption:=LM78.ChipType;
  if LM78.Error<>ER_NoError then
   Application.MessageBox('Hardware Monitoring chip not found at specified address.','Error accessing Hardware Monitoring chip',0); // NOT FOUND
end;

procedure TOptions.AdrResetClick(Sender: TObject);
begin
  HWMonU.Address:=$290;
  Address.Text:='0290';
  ReInitChip;
end;

procedure TOptions.ConfigureClick(Sender: TObject);
begin
  if Names.ShowModal=mrOk then
   begin
     HardwareMon.Fan1L.Caption:=Names.Fan1NameE.Text+':';
     HardwareMon.Fan2L.Caption:=Names.Fan2NameE.Text+':';
     HardwareMon.Fan3L.Caption:=Names.Fan3NameE.Text+':';
     Fan1C.Caption:=Names.Fan1NameE.Text;
     Fan2C.Caption:=Names.Fan2NameE.Text;
     Fan3C.Caption:=Names.Fan3NameE.Text;
     HardwareMon.Temp1L.Caption:=Names.Temp1NameE.Text+':';
     HardwareMon.Temp2L.Caption:=Names.Temp2NameE.Text+':';
     HardwareMon.Temp3L.Caption:=Names.Temp3NameE.Text+':';
     Temp1C.Caption:=Names.Temp1NameE.Text;
     Temp2C.Caption:=Names.Temp2NameE.Text;
     Temp3C.Caption:=Names.Temp3NameE.Text;
   end;
end;

end.
