unit hwmonabt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ShellAPI;

type
  TAboutBox = class(TForm)
    OK: TButton;
    AboutIcon: TImage;
    AboutMainLabel: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    HomePageLabel: TLabel;
    HomePage: TLabel;
    EmailLabel: TLabel;
    Email: TLabel;
    FreewareLabel: TLabel;
    UnmodifiedLabel: TLabel;
    BugLabel: TLabel;
    LatestLabel: TLabel;
    function ExecuteFile(const FileName, Params, DefaultDir: string;ShowCmd: Integer): THandle;
    procedure OKClick(Sender: TObject);
    procedure HomePageClick(Sender: TObject);
    procedure EmailClick(Sender: TObject);
    procedure HomePageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure EmailMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

uses hwmonu;
{$R *.DFM}

function TAboutBox.ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..79] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;

procedure TAboutBox.OKClick(Sender: TObject);
begin
  AboutBox.Hide;
  AboutBox.ModalResult:=1;
end;

procedure TAboutBox.HomePageClick(Sender: TObject);
begin
  ExecuteFile('http://rainbow.ht.st','','',1);
end;

procedure TAboutBox.EmailClick(Sender: TObject);
begin
  ExecuteFile('mailto:rnbw@geocities.com','','',1);
end;

procedure TAboutBox.HomePageMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if Email.Font.Color=clRed then Email.Font.Color:=clBlue;
  HomePage.Font.Color:=clRed;
end;

procedure TAboutBox.EmailMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if HomePage.Font.Color=clRed then HomePage.Font.Color:=clBlue;
  Email.Font.Color:=clRed;
end;

procedure TAboutBox.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if HomePage.Font.Color=clRed then HomePage.Font.Color:=clBlue;
  if Email.Font.Color=clRed then Email.Font.Color:=clBlue;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  AboutMainLabel.Caption:=Application.Title;
end;

procedure TAboutBox.FormShow(Sender: TObject); //v1.6
begin
  if AlEnabled then Tag:=1 else Tag:=0;
  AlEnabled:=False;
end;

procedure TAboutBox.FormHide(Sender: TObject); //v1.6
begin
  if Tag=1 then AlEnabled:=True;
end;

end.
