{
 Library - The library functions.
 Copyright (C) 1999-2002  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit Lib;

interface

type
  PString = ^String;

{*
 * Prints the licence.
 *}
procedure Licence;

{*
 * Prints the licence line notify.
 *
 * @param Name                  project name
 * @param ExeName               main module name
 *}
procedure LicenceLine(Name, ExeName: String);

{*
 * Option or argument error message.
 *
 * @param ExeName               main module name
 * @param OptArg                option/argument flag
 *}
procedure OptArgErrMsg(ExeName: String; OptArg: Boolean);

{*
 * Compare two pascal style strings.
 *
 * @param str1                  pointer to first string
 * @param str2                  pointer to second string
 * @return true if strings matches, otherwise false
 *}
function StrComp(Str1, Str2: PString): Boolean;

{*
 * Converts hexadecimal to integer.
 *
 * @param S                     hexadecimal string
 * @return long-integer, or -1 if error
 *}
function Hex2Int(S: String): LongInt;

{*
 * Converts integer to hexadecimal.
 *
 * @param V                     integer to convert
 * @return hexadecimal string, or empty string if error occured
 *}
function Int2Hex(V: LongInt): String;

{*
 * Get the parameters count.
 *
 * @param ArgS                  argument string
 * @param Separ                 separator char
 * @return number of parameters
 *}
function GetParseCount(ArgS: String; Separ: Char): Integer;

{*
 * Get the parameter.
 *
 * @param Index                 index of parameter
 * @param Args                  argument string
 * @param Separ                 separator char
 * @return parameter as pascal style string
 *}
function GetParseString(Index: Integer; ArgS: String; Separ: Char): String;

implementation

{*
 * Prints the licence.
 *}
procedure Licence;
begin
  Writeln('This program is free software; you can redistribute it and/or modify');
  Writeln('it under the terms of the GNU General Public License as published by');
  Writeln('the Free Software Foundation; either version 2 of the License, or');
  Writeln('(at your option) any later version.');
  Writeln;
  Writeln('This program is distributed in the hope that it will be useful,');
  Writeln('but WITHOUT ANY WARRANTY; without even the implied warranty of');
  Writeln('MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the');
  Writeln('GNU General Public License for more details.');
  Writeln;
  Writeln('You should have received a copy of the GNU General Public License');
  Writeln('along with this program; if not, write to the Free Software');
  Writeln('Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA');
end;

{*
 * Prints the licence line notify.
 *
 * @param Name                  project name
 * @param ExeName               main module name
 *}
procedure LicenceLine(Name, ExeName: String);
begin
  Writeln(Name, ' comes with ABSOLUTELY NO WARRANTY;');
  Writeln('for details type `', ExeName, ' -L''.');
end;

{*
 * Option or argument error message.
 *
 * @param ExeName               main module name
 * @param OptArg                option/argument flag
 *}
procedure OptArgErrMsg(ExeName: String; OptArg: Boolean);
begin
  Write('Invalid ');
  if OptArg then Write('option') else Write('argument');
  Writeln('.');
  Writeln('Type: `', ExeName, ' -h'' for help.');
end;

{*
 * Compare two pascal style strings.
 *
 * @param str1                  pointer to first string
 * @param str2                  pointer to second string
 * @return true if strings matches, otherwise false
 *}
function StrComp(Str1, Str2: PString): Boolean;
var
  Cnt: Byte;
  Cmp: Boolean;
begin
  Cnt:= Length(Str1^);
  Cmp:= (Cnt = Length(Str2^));
  while Cmp and (Cnt > 0) do begin
    Cmp:= (Str1^[Cnt] = Str2^[Cnt]);
    Dec(Cnt);
  end;
  StrComp:= Cmp;
end;

{*
 * Converts hexadecimal to integer.
 *
 * @param S                     hexadecimal string
 * @return long-integer, or -1 if error
 *}
function Hex2Int(S: String): LongInt;
var
  I, V: LongInt;
begin
  V:= 0;
  for I:= 1 to Length(S) do begin
    case S[I] of
      '0'..'9': V:= V*16 + (Ord(S[I])-Ord('0'));
      'a'..'f': V:= V*16 + (Ord(S[I])-Ord('a')+10);
      'A'..'F': V:= V*16 + (Ord(S[I])-Ord('A')+10);
      else begin
        Hex2Int:= -1;
        Exit;
      end;
    end;
  end;
  Hex2Int:= V;
end;

{*
 * Converts integer to hexadecimal.
 *
 * @param V                     integer to convert
 * @return hexadecimal string, or empty string if error occured
 *}
function Int2Hex(V: LongInt): String;
var
  M: LongInt;
  S: String;
begin
  S:= '';
  repeat
    M:= V mod 16;
    V:= V div 16;
    if M < 10 then
      S:= Concat(Chr(Ord('0')+M), S)
    else
      S:= Concat(Chr(Ord('A')+M-10), S);
  until V = 0;
  Int2Hex:= S;
end;

{*
 * Get the parameters count.
 *
 * @param ArgS                  argument string
 * @param Separ                 separator char
 * @return number of parameters
 *}
function GetParseCount(ArgS: String; Separ: Char): Integer;
var
  I, J: Integer;
begin
  J:= 0;
  I:= 1;
  while I <= Length(ArgS) do begin
    while I <= Length(ArgS) do begin
      if ArgS[I] <> Separ then Break;
      Inc(I);
    end;
    if I <= Length(ArgS) then begin
      Inc(J);
      while I <= Length(ArgS) do begin
        if ArgS[I] = Separ then Break;
        Inc(I);
      end;
    end;
  end;
  GetParseCount:= J;
end;

{*
 * Get the parameter.
 *
 * @param Index                 index of parameter
 * @param Args                  argument string
 * @param Separ                 separator char
 * @return parameter as pascal style string
 *}
function GetParseString(Index: Integer; ArgS: String; Separ: Char): String;
var
  I, J, K: Integer;
begin
  GetParseString:= '';
  if (Index < 0) or (Index > GetParseCount(ArgS, Separ)-1) then Exit;

  I:= 1;
  J:= -1;
  K:= I;
  while (I <= Length(ArgS)) and (J < Index) do begin
    while I <= Length(ArgS) do begin
      if ArgS[I] <> Separ then Break;
      Inc(I);
    end;
    if I <= Length(ArgS) then begin
      K:= I;
      Inc(J);
      while I <= Length(ArgS) do begin
        if ArgS[I] = Separ then Break;
        Inc(I);
      end;
    end;
  end;
  GetParseString:= Copy(ArgS, K, I-K);
end;

{Initialition unit}

end.