{
 Hard Drives Read Only - Write and format denied utility for DOS.
 Copyright (C) 1996-2002  Henrich Fukna <fuky@azet.sk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
program HdRdOnly;

{$M 3072, 0, 0}

uses Dos, Crt, Lib;

const
  Copyright: String = 'Hard Drives Read Only'; { identity string }
  Version = '2.1';                       { version string constant }
  ExeName = 'HDRDONLY';                  { project name }

  { Scan kody HotKey klaves }
  CtrlKey = $1D;                         { Ctrl scan code }
  ScrollLockKey = $46;                   { Scroll Lock scan code }

  DISK_A = 1;                            { fdd a }
  DISK_B = 2;                            { fdd b }
  DISK_FDD = 3;                          { all fdds }
  DISK_HDD = 4;                          { all hdds }
  DISK_ALL = 5;                          { all }

var
  MySS, MySP, OldSS, OldSP: Word;        { stacks pointers }
  Switch: Integer;                       { stack switched flag }
  OldKeyboard, OldBiosDisk,              { old interrupt handlers }
  OldMultiplex: Pointer;
  Reg: Registers;                        { cpu registers structure }

  MyTask: Byte;                          { resident task number }
  Active: Boolean;                       { activity flag }

  CtrlPress: Boolean;                    { ctrl key down, or not }
  Scan: Byte;                            { scan code for the key }
  Disk: Byte;                            { disk code for BIOS disk i/o }

{$F+}

{********** common interrupt functions ***************************}

{*
 * Call the old interrupt handler.
 *
 * @param Address               pointer to old interrupt handler
 * @param Reg                   cpu registers structure
 * @return changed Reg cpu registers structure
 *}
procedure CallOldIntr(Address: Pointer; var Reg: Registers);
var
  _Flags, _AX, _BX, _CX, _DX, _SI, _DI, _DS, _ES, _BP: Word;
begin
  with Reg do begin                      { set registers }
    _Flags:= Flags;
    _AX:= Ax; _BX:= Bx; _CX:= Cx; _DX:= Dx;
    _SI:= Si; _DI:= Di;
    _DS:= Ds; _ES:= Es;
    _BP:= Bp;
  end;
  asm
    PUSH  DS
    PUSH  BP

    PUSH  _Flags
    PUSH  CS
{$IFOPT G+}
    PUSH  OFFSET @@1
{$ELSE}
    MOV   AX, OFFSET @@1
    PUSH  AX
{$ENDIF}
    PUSH  WORD (Address+2)
    PUSH  WORD (Address)

    MOV   AX, _AX
    MOV   BX, _BX
    MOV   CX, _CX
    MOV   DX, _DX
    MOV   SI, _SI
    MOV   DI, _DI
    MOV   DS, _DS
    MOV   ES, _ES
    MOV   BP, _BP

    RETF                                 { call :-) }
@@1:
    PUSH  BP

    MOV   BP, SP
    MOV   BP, SS:[BP + 2]

    MOV   _AX, AX
    MOV   _BX, BX
    MOV   _CX, CX
    MOV   _DX, DX
    MOV   _SI, SI
    MOV   _DI, DI
    MOV   _DS, DS
    MOV   _ES, ES
    POP   AX
    MOV   _BP, AX
    PUSHF
    POP   AX
    MOV   _FLAGS, AX

    POP   BP
    POP   DS
  end;
  with Reg do begin                      { set registers }
    Flags:= _Flags;
    Ax:= _AX; Bx:= _BX; Cx:= _CX; Dx:= _DX;
    Si:= _SI; Di:= _DI;
    Ds:= _DS; Es:= _ES;
    Bp:= _BP;
  end;
end;

{*
 * Play the sound.
 *
 * @param High                  sound frequency
 * @param Len                   sound length
 *}
procedure Beep(High, Len: Word);
begin
  Sound(High);
  Delay(Len);
  NoSound;
end;

{********** interrupt handlers ***********************************}

{*
 * BIOS keyboard handler.
 *}
procedure NewKeyboard; interrupt;
begin
  asm CLI end;
  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;
  asm STI end;

  Scan:= Port[$60];                      { get scan code }

  if Scan = CtrlKey then CtrlPress:= True                 { ctrl down }
  else if Scan = (CtrlKey or $80) then CtrlPress:= False  { ctrl up }
  else if CtrlPress and (Scan = ScrollLockKey) then begin { is hot key }
    Active:= not Active;                 { change activity }
    if Active then Beep(1750, 125) else Beep(750, 125);
  end;

  asm
    PUSHF                                { call old handler }
    CALL  OldKeyboard
  end;

  asm CLI end;
  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
  asm STI end;
end;

{*
 * BIOS disk i/o handler.
 *
 * @param _Flags                cpu flags register
 * @param _CS                   cpu code segment register
 * @param _IP                   cpu instruction pointer register
 * @param _AX                   cpu accumulator register
 * @param _BX                   cpu base register
 * @param _CX                   cpu counter register
 * @param _DX                   cpu data register
 * @param _SI                   cpu source index register
 * @param _DI                   cpu destination index register
 * @param _DS                   cpu data segment register
 * @param _ES                   cpu extra segment register
 * @param _BP                   cpu base pointer register
 *}
procedure NewBiosDisk(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
  _SI, _DI, _DS, _ES, _BP: Word); interrupt;
begin
  asm CLI end;
  with Reg do begin                      { get registers }
    Flags:= _Flags;
    Ax:= _AX; Bx:= _BX; Cx:= _CX; Dx:= _DX;
    Si:= _SI; Di:= _DI;
    Ds:= _DS; Es:= _ES;
    Bp:= _BP;
  end;

  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;
  asm STI end;

  if Active and                          { if resident part active }
     ((Reg.Ah = 3) or                    { and write sectors }
      (Reg.Ah = 5) or                    { and format track }
      (Reg.Ah = 6) or                    { and format track & check }
      (Reg.Ah = 7) or                    { and format disk }
      (Reg.Ah = $B) or                   { and write long sectors }
      (Reg.Ah = $F)) and                 { and write buffer }
     (                                   { and disk accessing }
      ((Disk = DISK_A) and (Reg.Dl = 0)) or               { floppy a }
      ((Disk = DISK_B) and (Reg.Dl = 1)) or               { floppy b }
      ((Disk = DISK_FDD) and (Reg.Dl < $80)) or           { all fdds }
      ((Disk = DISK_HDD) and (Reg.Dl >= $80)) or          { all hdds }
      ((Disk = DISK_ALL))) then                           { all }
  begin                                  { protect it! }
    Reg.Flags:= Reg.Flags or fCarry;     { set error flag }
    Reg.Ah:= 3;                          { set error code: write protect }
    Mem[Seg0040: $74]:= Reg.Al;          { set last operation status }
  end else
    CallOldIntr(OldBiosDisk, Reg);

  asm CLI end;
  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
  with Reg do begin                      { set registers }
    _Flags:= Flags;
    _AX:= Ax; _BX:= Bx; _CX:= Cx; _DX:= Dx;
    _SI:= Si; _DI:= Di;
    _DS:= Ds; _ES:= Es;
    _BP:= Bp;
  end;
  asm STI end;
end;

function Terminate: Word; forward;

{*
 * DOS Multiplex handler.
 *
 * @param _Flags                cpu flags register
 * @param _CS                   cpu code segment register
 * @param _IP                   cpu instruction pointer register
 * @param _AX                   cpu accumulator register
 * @param _BX                   cpu base register
 * @param _CX                   cpu counter register
 * @param _DX                   cpu data register
 * @param _SI                   cpu source index register
 * @param _DI                   cpu destination index register
 * @param _DS                   cpu data segment register
 * @param _ES                   cpu extra segment register
 * @param _BP                   cpu base pointer register
 *}
procedure NewMultiplex(_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
  _SI, _DI, _DS, _ES, _BP: Word); interrupt;
begin
  asm CLI end;
  with Reg do begin                      { get registers }
    Flags:= _Flags;
    Ax:= _AX; Bx:= _BX; Cx:= _CX; Dx:= _DX;
    Si:= _SI; Di:= _DI;
    Ds:= _DS; Es:= _ES;
    Bp:= _BP;
  end;

  Inc(Switch);                           { switch the stack context }
  if Switch = 0 then begin
    OldSS:= SSeg;
    OldSP:= SPtr;
    asm
      MOV  SS,MySS
      MOV  SP,MySP
    end;
  end;
  asm STI end;

  if Reg.Ah = MyTask then begin
    case Reg.Al of
      $0:                                { get your presence and }
        begin                            { identity string }
          Reg.Al:= $FF;
          Reg.Es:= Seg(Copyright);
          Reg.Bx:= Ofs(Copyright);
        end;
      $C0:                               { unload itself }
        Reg.Ax:= Terminate;
    end;
  end else
    CallOldIntr(OldMultiplex, Reg);

  asm CLI end;
  Dec(Switch);                           { switch the stack context }
  if Switch < 0 then begin
    asm
      MOV  SS,OldSS
      MOV  SP,OldSP
    end;
  end;
  with Reg do begin                      { set registers }
    _Flags:= Flags;
    _AX:= Ax; _BX:= Bx; _CX:= Cx; _DX:= Dx;
    _SI:= Si; _DI:= Di;
    _DS:= Ds; _ES:= Es;
    _BP:= Bp;
  end;
  asm STI end;
end;

{*
 * Terminate the resident part
 *
 * @return terminate status; non zero if terminate, otherwise zero
 *}
function Terminate: Word;
var
  CanDo: Boolean;
  Kbd, Dsk, Mlp: Pointer;
begin
                                         { get current interrupt handler }
  GetIntVec($09, Kbd);                   { addresses }
  GetIntVec($13, Dsk);
  GetIntVec($2F, Mlp);
                                         { check match for current handlers }
  CanDo:= (Kbd = Addr(NewKeyboard)) and
          (Dsk = Addr(NewBiosDisk)) and
          (Mlp = Addr(NewMultiplex));

  if CanDo then begin
    Active:= False;                      { remove activity }
    Beep(750, 125);

    asm CLI end;
    SetIntVec($09, OldKeyboard);         { set old interrupt handlers }
    SetIntVec($13, OldBiosDisk);
    SetIntVec($2F, OldMultiplex);
    asm STI end;

    Reg.Ah:= $49;                        { remove itself from memory }
    Reg.Es:= PrefixSeg;
    MsDos(Reg);
  end;
  Terminate:= Word(CanDo);
end;

{$F-}

{********** non resident part ************************************}

{*
 * Prints the syntax.
 *}
procedure Usage;
begin
  Writeln('Usage: ', ExeName, ' [-uqh?L dDISK]');
  Writeln;
  Writeln('Options:');
  Writeln('  u        remove program from memory');
  Writeln('  q        be quiet');
  Writeln('  h, ?     display this help screen');
  Writeln('  L        display software licence');
  Writeln;
  Writeln('  dDISK    disk to protect');
  Writeln('   DISK    a   for floppy A:');
  Writeln('           b   for floppy B:');
  Writeln('           fdd for all floppy drives');
  Writeln('           hdd for all hard drives');
  Writeln('           all for all drives');
  Writeln;
  Writeln('Default: -dhdd');
  Halt(1);
end;

{*
 * Set disk parameter from command line.
 *
 * @param Args                  arguments
 *}
procedure Params(Args: String);
const
  SEP = ' ';                            { arguments separator }
var
  S: String;
begin
                                        { disk code }
  S:= GetParseString(0, Args, SEP);
  if Length(S) = 0 then begin
    OptArgErrMsg(ExeName, True);
    Halt(2);
  end;
  if S = 'a' then Disk:= DISK_A
  else if S = 'b' then Disk:= DISK_B
  else if S = 'fdd' then Disk:= DISK_FDD
  else if S = 'hdd' then Disk:= DISK_HDD
  else if S = 'all' then Disk:= DISK_ALL
  else begin
    OptArgErrMsg(ExeName, True);
    Halt(2);
  end;
end;

procedure Install;
begin
  Switch:= -1;                           { set default values }
  Active:= False;

  asm CLI end;
  MySS:= SSeg;                           { get stack pointers for handlers }
  MySP:= SPtr;
  GetIntVec($09, OldKeyboard);           { get current interrupt handler }
  GetIntVec($13, OldBiosDisk);           { addresses }
  GetIntVec($2F, OldMultiplex);
  asm STI end;

  asm CLI end;
  SetIntVec($09, Addr(NewKeyboard));     { set the new interrupt handlers }
  SetIntVec($13, Addr(NewBiosDisk));
  SetIntVec($2F, Addr(NewMultiplex));
  asm STI end;

  Beep(1750, 125);
  Active:= True;                         { set activity }

  Reg.Ah:= $49;                          { free enviroments }
  Reg.Es:= MemW[PrefixSeg : $2C];
  MsDos(Reg);
end;

var
  I: Byte;
  UnInstall, Quiet: Boolean;
  Args: String;

begin
  Write(Copyright, ' ', Version, ', ');
  Writeln('Copyright (C) 1996-2002 Henrich Fukna');
  LicenceLine(Copyright, ExeName);
  Writeln;

  UnInstall:= False;
  Quiet:= False;

  I:= 1;
  while I <= ParamCount do begin
    Args:= ParamStr(I);
    if (Args[1] = '-') then begin
      Delete(Args, 1, 1);
      while Length(Args) > 0 do begin
        case Args[1] of
          '?',
          'h': Usage;
          'L':
            begin
              Licence;
              Halt(1);
            end;
          'u': UnInstall:= True;
          'q': Quiet:= True;
          'd':
            begin
              Params(Copy(Args, 2, Length(Args)-1));
              Args:= '';
            end;
          else begin
            OptArgErrMsg(ExeName, False);
            Halt(2);
          end;
        end;
        Delete(Args, 1, 1);
      end;
    end else begin
      OptArgErrMsg(ExeName, True);
      Halt(2);
    end;
    Inc(I);
  end;

  I:= $FF;                               { find first free multiplex service }
  MyTask:= 0;
  while (I > $7F) do begin
    Reg.Ah:= I;
    Reg.Al:= 0;
    Intr($2F, Reg);
    if Reg.Al = $FF then begin           { check presence }
      if StrComp(Addr(Copyright), Ptr(Reg.Es, Reg.Bx)) then
        if UnInstall then begin          { uninstall request }
          Reg.Ah:= I;
          Reg.Al:= $C0;
          Intr($2F, Reg);
          if (Reg.Ax) = 0 then begin
            if not(Quiet) then
              Writeln('Resident can not be unloaded.');
            Halt(3);
          end else begin
            if not(Quiet) then
              Writeln('Resident was unloaded.');
            Halt(0);
          end;
        end else begin
          if not(Quiet) then
            Writeln('Resident is already loaded.');
          Halt(4);
        end;
    end else
      if (MyTask = 0) and (Reg.Al = 0) then MyTask:= I;
    Dec(I);
  end;
  if UnInstall then begin                { resident part not present }
    if not(Quiet) then
      Writeln('Resident is not in memory.');
    Halt(4);
  end;
  if MyTask = 0 then begin               { no free multiplex service }
    if not(Quiet) then
      Writeln('Resident can not be loaded.');
    Halt(3);
  end;

  if not(Quiet) then begin               { print the values }
    Writeln('Resident was loaded.');
    Writeln('Press <Ctrl+Scroll Lock> to ENABLE/DISABLE write-protected mode.');
  end;

  Install;                               { initialize TSR }
  Keep(0);                               { keep resident }
end.