;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

Title BitMap_Mul_&_Div_Scaling

Model Small

.286

LOCALS

.DATA

SpritePage    DW    0A000H

.CODE

;******************************************************************************
;* Procedra SpriteScale (PSprite: Pointer; ZX,ZY: Word; Wide, Height: Byte,  *
;*                        NewWide, NewHeight: Word);                          *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii ZX,ZY,  *
;*                priom jeho rozmery bud NewWide x NewHeight.               *
;******************************************************************************
;*               Pozor ! 0x0 vek sprite nevykresl (stvrdne) !              *
;******************************************************************************

PUBLIC SpriteScale
SpriteScale PROC FAR
 ARG NewHeight: Word, NewWide: Word, Height: Byte, Wide: Byte, ZY: Word, ZX: Word, PSprite: DWord
 LOCAL StepX: Word, StepY: Word, MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    MOV    AX,[NewWide]
                    MOV    [MaxX],AX
                    MOV    AX,[NewHeight]
                    MOV    [MaxY],AX
                    MOV    AX,100
                    MUL    [NewWide]
                    XOR    BH,BH
                    MOV    BL,[Wide]
                    DIV    BX
                    MOV    [StepX],AX
                    MOV    AX,100
                    MUL    [NewHeight]
                    MOV    BL,[Height]
                    DIV    BX
                    MOV    [StepY],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    BX,[PSprite]
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
           @SSL1:   MOV    AX,100
                    MUL    [Y]
                    DIV    [StepY]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [StepX]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    MOV    ES:[DI],AL
                    INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    16

SpriteScale ENDP

;******************************************************************************
;* Procedra SpriteScaleVirtual (SegVirtual: Word; PSprite: Pointer;          *
;*                               ZX,ZY: Word; Wide, Height: Byte, Step: Word);*
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*            ZX,ZY, priom jeho rozmery bud NewWide x NewHeight.            *
;******************************************************************************
;*              Pozor ! 0x0 vek sprite nevykresl (stvrdne) !               *
;******************************************************************************

PUBLIC SpriteScaleVirtual
SpriteScaleVirtual PROC FAR
 ARG NewHeight: Word, NewWide: Word, Height: Byte, Wide: Byte, ZY:Word, ZX:Word, PSprite: DWord, SegVirtual: Word
 LOCAL StepX: Word, StepY: Word, MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    MOV    AX,[NewWide]
                    MOV    [MaxX],AX
                    MOV    AX,[NewHeight]
                    MOV    [MaxY],AX
                    XOR    BX,BX
                    MOV    AX,100
                    MUL    [NewWide]
                    MOV    BL,[Wide]
                    DIV    BX
                    MOV    [StepX],AX
                    MOV    AX,100
                    MUL    [NewHeight]
                    MOV    BL,[Height]
                    DIV    BX
                    MOV    [StepY],AX
                    LDS    BX,[PSprite]
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
          @SSVL1:   MOV    AX,100
                    MUL    [Y]
                    DIV    [StepY]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [StepX]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    MOV    ES:[DI],AL
                    INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSVL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSVL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    18

SpriteScaleVirtual ENDP

;******************************************************************************
;*      Procedra SpriteScaleOver (PSprite: Pointer; ZX,ZY: Word; Wide,       *
;*                                 Height: Byte, Step: Word);                 *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii ZX,ZY,  *
;*       priom jeho rozmery bud NewWide x NewHeight a body s farbou 0       *
;*                              sa nevykresuj.                              *
;******************************************************************************
;*              Pozor ! 0x0 vek sprite nevykresl (stvrdne) !               *
;******************************************************************************

PUBLIC SpriteScaleOver
SpriteScaleOver PROC FAR
 ARG NewHeight: Word, NewWide: Word, Height: Byte, Wide: Byte, ZY: Word, ZX: Word, PSprite: DWord
 LOCAL StepX: Word, StepY: Word, MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    MOV    AX,[NewWide]
                    MOV    [MaxX],AX
                    MOV    AX,[NewHeight]
                    MOV    [MaxY],AX
                    XOR    BX,BX
                    MOV    AX,100
                    MUL    [NewWide]
                    MOV    BL,[Wide]
                    DIV    BX
                    MOV    [StepX],AX
                    MOV    AX,100
                    MUL    [NewHeight]
                    MOV    BL,[Height]
                    DIV    BX
                    MOV    [StepY],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    BX,[PSprite]
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
          @SSOL1:   MOV    AX,100
                    MUL    [Y]
                    DIV    [StepY]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [StepX]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    OR     AL,AL
                    JZ     @SSON
                    MOV    ES:[DI],AL
          @SSON:    INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSOL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSOL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    16

SpriteScaleOver ENDP

;******************************************************************************
;*   Procedra SpriteScaleOverVirtual (SegVirtual: Word; PSprite: Pointer;    *
;*                           ZX,ZY: Word; Wide, Height: Byte, Step: Word);    *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*   ZX,ZY, priom jeho rozmery bud NewWide x NewHeight a body s farbou 0    *
;*                               sa nevykresuj.                             *
;******************************************************************************
;*               Pozor ! 0x0 vek sprite nevykresl (stvrdne) !              *
;******************************************************************************

PUBLIC SpriteScaleOverVirtual
SpriteScaleOverVirtual PROC FAR
 ARG NewHeight: Word, NewWide: Word, Height: Byte, Wide: Byte, ZY:Word, ZX:Word, PSprite: DWord, SegVirtual: Word
 LOCAL StepX: Word, StepY: Word, MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    MOV    AX,[NewWide]
                    MOV    [MaxX],AX
                    MOV    AX,[NewHeight]
                    MOV    [MaxY],AX
                    XOR    BX,BX
                    MOV    AX,100
                    MUL    [NewWide]
                    MOV    BL,[Wide]
                    DIV    BX
                    MOV    [StepX],AX
                    MOV    AX,100
                    MUL    [NewHeight]
                    MOV    BL,[Height]
                    DIV    BX
                    MOV    [StepY],AX
                    LDS    BX,[PSprite]
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
         @SSOVL1:   MOV    AX,100
                    MUL    [Y]
                    DIV    [StepY]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [StepX]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    OR     AL,AL
                    JZ     @SSOVN
                    MOV    ES:[DI],AL
         @SSOVN:    INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSOVL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSOVL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    18

SpriteScaleOverVirtual ENDP

;******************************************************************************
;*Procedra SpriteScaleRel (PSprite: Pointer; ZX,ZY: Word; Wide, Height: Byte,*
;*                        Step: Word);                                        *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii ZX,ZY   *
;*    s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu.     *
;******************************************************************************
;*         Pozor ! 0% vek sprite nevykresl (stvrdne) ! Step > 0 !          *
;******************************************************************************

PUBLIC SpriteScaleRel
SpriteScaleRel PROC FAR
 ARG Step: Word, Height: Byte, Wide: Byte, ZY: Word, ZX: Word, PSprite: DWord
 LOCAL MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    XOR    DX,DX
                    XOR    CH,CH
                    MOV    AX,[Step]
                    MOV    CL,Wide
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxX],AX
                    MOV    AX,[Step]
                    MOV    CL,Height
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxY],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    BX,[PSprite]
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
           @SSRL1:  MOV    AX,100
                    MUL    [Y]
                    DIV    [Step]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [Step]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    MOV    ES:[DI],AL
                    INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSRL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSRL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14

SpriteScaleRel ENDP

;******************************************************************************
;* Procedra SpriteScaleRelVirtual (SegVirtual: Word; PSprite: Pointer;       *
;*                               ZX,ZY: Word; Wide, Height: Byte, Step: Word);*
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;* ZX,ZY s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu.  *
;******************************************************************************
;*         Pozor ! 0% vek sprite nevykresl (stvrdne) ! Step > 0 !          *
;******************************************************************************

PUBLIC SpriteScaleRelVirtual
SpriteScaleRelVirtual PROC FAR
 ARG Step: Word, Height: Byte, Wide: Byte, ZY:Word, ZX:Word, PSprite: DWord, SegVirtual: Word
 LOCAL MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    XOR    DX,DX
                    XOR    CH,CH
                    MOV    AX,[Step]
                    MOV    CL,Wide
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxX],AX
                    MOV    AX,[Step]
                    MOV    CL,Height
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxY],AX
                    LDS    BX,[PSprite]
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
         @SSRVL1:   MOV    AX,100
                    MUL    [Y]
                    DIV    [Step]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [Step]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    MOV    ES:[DI],AL
                    INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSRVL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSRVL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    16

SpriteScaleRelVirtual ENDP

;******************************************************************************
;*      Procedra SpriteScaleOverRel (PSprite: Pointer; ZX,ZY: Word; Wide,    *
;*                                 Height: Byte, Step: Word);                 *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii ZX,ZY   *
;*    s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu,     *
;*                   priom body s farbou 0 sa nevykresuj.                  *
;******************************************************************************
;*         Pozor ! 0% vek sprite nevykresl (stvrdne) ! Step > 0 !          *
;******************************************************************************

PUBLIC SpriteScaleOverRel
SpriteScaleOverRel PROC FAR
 ARG Step: Word, Height: Byte, Wide: Byte, ZY: Word, ZX: Word, PSprite: DWord
 LOCAL MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    XOR    DX,DX
                    XOR    CH,CH
                    MOV    AX,[Step]
                    MOV    CL,Wide
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxX],AX
                    MOV    AX,[Step]
                    MOV    CL,Height
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxY],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    BX,[PSprite]
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
          @SSORL1:   MOV    AX,100
                    MUL    [Y]
                    DIV    [Step]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [Step]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    OR     AL,AL
                    JZ     @SSORN
                    MOV    ES:[DI],AL
          @SSORN:   INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSORL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSORL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14

SpriteScaleOverRel ENDP

;******************************************************************************
;*  Procedra SpriteScaleOverVirtualRel (SegVirtual: Word; PSprite: Pointer;  *
;*                           ZX,ZY: Word; Wide, Height: Byte, Step: Word);    *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;* ZX,ZY s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu,  *
;*                  priom body s farbou 0 sa nevykresuj.                   *
;******************************************************************************
;*         Pozor ! 0% vek sprite nevykresl (stvrdne) ! Step > 0 !          *
;******************************************************************************

PUBLIC SpriteScaleOverRelVirtual
SpriteScaleOverRelVirtual PROC FAR
 ARG Step: Word, Height: Byte, Wide: Byte, ZY:Word, ZX:Word, PSprite: DWord, SegVirtual: Word
 LOCAL MaxX: Word, MaxY: Word, Difference: Word, X: Word, Y: Word = VLocal
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VLocal
                    PUSH   DS
                    XOR    DX,DX
                    XOR    CH,CH
                    MOV    AX,[Step]
                    MOV    CL,Wide
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxX],AX
                    MOV    AX,[Step]
                    MOV    CL,Height
                    MUL    CX
                    MOV    CL,100
                    DIV    CX
                    MOV    [MaxY],AX
                    LDS    BX,[PSprite]
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    AX,[ZY]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,[ZX]
                    MOV    DI,AX
                    MOV    AX,320
                    MOV    DX,[MaxX]
                    SUB    AX,DX
                    MOV    [Difference],AX
                    MOV    [X],0
                    MOV    [Y],0
         @SSORVL1:  MOV    AX,100
                    MUL    [Y]
                    DIV    [Step]
                    MUL    [Wide]
                    MOV    SI,AX
                    MOV    AX,100
                    MUL    [X]
                    DIV    [Step]
                    ADD    SI,AX
                    MOV    AL,DS:[BX+SI]
                    OR     AL,AL
                    JZ     @SSORVN
                    MOV    ES:[DI],AL
         @SSORVN:   INC    DI
                    INC    [X]
                    MOV    AX,[X]
                    MOV    DX,[MaxX]
                    CMP    AX,DX
                    JB     @SSORVL1
                    MOV    [X],0
                    ADD    DI,[Difference]
                    INC    [Y]
                    MOV    AX,[Y]
                    MOV    DX,[MaxY]
                    CMP    AX,DX
                    JB     @SSORVL1
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    16

SpriteScaleOverRelVirtual ENDP

END