{$F+,G+}                           (* -FAR- Model Compiled *)
Unit Graphics;                     (* 286+ instruction set *)

Interface

Const Font8x6  =  6;
      Font8x8  =  8;
      Font8x12 = 12;
      Font8x14 = 14;
      Font8x16 = 16;
      VRAM = $A000;

Type TPalette = Array [0..767] Of Byte;
     TVESABuf = Array [0..511] Of Byte;

Procedure SetMode (Mode: Byte);
Procedure SetVGAMode;
Procedure SetTextMode;
Procedure SetPalette (PPal: Pointer);
Procedure GetPalette (Var Pal: TPalette);
Procedure IncPalette (PPal: Pointer; Step: Byte);
Procedure DecPalette (PPal: Pointer; Step: Byte);
Procedure RotatePaletteLeft (PPal: Pointer);
Procedure RotatePaletteRight (PPal: Pointer);
Procedure SetPixel (X,Y: Word; Col: Byte);
Procedure SetPixelTab (X,Y: Word; Col: Byte);
Procedure SetPixelVirtual (SegVirtual,X,Y: Word; Col: Byte);
Procedure SetPixelTabVirtual (SegVirtual,X,Y: Word; Col: Byte);
Function GetPixel (X,Y: Word): Byte;
Function GetPixelVirtual (SegVirtual,X,Y: Word): Byte;
Procedure HorizontalLine (X1,X2,Y: Word; Col: Byte);
Procedure HorizontalLineVirtual (SegVirtual,X1,X2,Y: Word; Col: Byte);
Procedure HorizontalLineRel (X,Y,Length: Word; Col: Byte);
Procedure HorizontalLineRelVirtual (SegVirtual,X,Y,Length: Word; Col: Byte);
Procedure VerticalLine (X,Y1,Y2: Word; Col: Byte);
Procedure VerticalLineVirtual (SegVirtual,X,Y1,Y2: Word; Col: Byte);
Procedure VerticalLineRel (X,Y1,Y2: Word; Col: Byte);
Procedure VerticalLineRelVirtual (SegVirtual,X,Y1,Y2: Word; Col: Byte);
Procedure Line (X1,Y1,X2,Y2: Word; Color: Byte);
Procedure LineVirtual (SegVirtual,X1,Y1,X2,Y2: Word; Color: Byte);
Procedure Circle (X,Y,R: Word; Color: Byte);
Procedure CircleVirtual (SegVirtual,X,Y,R: Word; Color: Byte);
Procedure FilledCircle (X,Y,R: Word; Color: Byte);
Procedure FilledCircleVirtual (SegVirtual,X,Y,R: Word; Color: Byte);
Procedure WaitRetrace;
Procedure WaitVRetrace;
Procedure WaitNotVRetrace;
Function Adress (X,Y: Word): Word;
Procedure DrawSpriteXY (PSprite: Pointer; X,Y: Word; Count: Byte);
Procedure DrawSprite (PSprite: Pointer; X,Y: Word; Count: Byte);
Procedure DrawSpriteOver (PSprite: Pointer; X,Y: Word; Count: Byte);
Procedure Sprite (PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
Procedure SpriteOver (PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
Procedure SpriteVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
Procedure SpriteOverVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
Procedure GetSprite (PSprite: Pointer; X,Y: Word; Wide,Height: Byte);
Procedure GetSpriteVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; Wide,Height: Byte);
Procedure Cell (PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
Procedure CellOver (PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
Procedure CellVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
Procedure CellOverVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
Procedure WriteFont (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontOver (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontOverHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontOverHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontOverVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure WriteFontOverVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFont (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontOver (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontOverHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontOverHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontOverVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure PrintFontOverVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
Procedure SpriteScale (PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
Procedure SpriteScaleOver (PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
Procedure SpriteScaleVirtual (SegVirtual: Word; PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
Procedure SpriteScaleOverVirtual (SegVirtual: Word;PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
Procedure SpriteScaleRel (PSprite: Pointer; X,Y,Wide,Height,Step: Word);
Procedure SpriteScaleOverRel (PSprite: Pointer; X,Y,Wide,Height,Step: Word);
Procedure SpriteScaleRelVirtual (SegVirtual: Word;PSprite: Pointer; X,Y,Wide,Height,Step: Word);
Procedure SpriteScaleOverRelVirtual (SegVirtual: Word;PSprite: Pointer; X,Y,Wide,Height,Step: Word);
Procedure DrawBox (X1,Y1,X2,Y2: Word; Color: Byte);
Procedure DrawBoxRel (X1,Y1,Wide,Height: Word; Color: Byte);
Procedure DrawBoxVirtual (SegVirtual,X1,Y1,X2,Y2: Word; Color: Byte);
Procedure DrawBoxRelVirtual (SegVirtual,X1,Y1,Wide,Height: Word; Color: Byte);
Procedure ClearScreen (Color: Byte);
Procedure ClearScreenVirtual (SegVirtual: Word; Color: Byte);
Procedure UseVirtual (SegVirtual: Word);
Procedure ConvertRGBPalette (POldPal: Pointer; Var Pal: TPalette);
Procedure InvertScreen (SegScreen: Word);
Procedure ShowScreen (PScreen: Pointer);
Procedure SetScreen (PScreen: Pointer);
Procedure SetScreenVirtual (SegVirtual: Word; PScreen: Pointer);
Procedure ShowCompressedScreen (PScreen: Pointer);
Procedure DeCompressScreen (PScreen: Pointer);
Procedure DeCompressVirtual (SegVirtual: Word; PScreen: Pointer);
Procedure DeCompressOverVirtual (SegVirtual: Word; PScreen: Pointer);
Procedure CopySprite (SegSource, SegDestinaton, X1, Y1, X2, Y2: Word; SWidth, SHeight: Byte);
Procedure CopyScreen (SegSource, SegDestinaton: Word);
Procedure CopyRows (SegSource, SegDestinaton, Y1, Y2: Word);
Procedure CopyRowsRel (SegSource, SegDestinaton, Y, Count: Word);
Procedure WaitFrames (Frames: Word);
Procedure SetCharSpace (Space: Word);
Procedure SetCharHeight (Height: Byte);
Procedure SetLineSpace (Space: Byte);
Procedure SetVideoPage (VPage: Word);
Procedure SetWritePage (WPage: Word);
Procedure SetSpritePage (SPage: Word);
Procedure SetLinePage (LPage: Word);
Procedure SetPointPage (PPage: Word);
Procedure SetCirclePage (CPage: Word);
Procedure SetBoxPage (BPage: Word);
Procedure SetCellPage (CPage: Word);
Function GetCharSpace: Word;
Function GetCharHeight: Byte;
Function GetLineSpace: Byte;
Function GetWritePage: Word;
Function GetSpritePage: Word;
Function GetLinePage: Word;
Function GetPointPage: Word;
Function GetCirclePage: Word;
Function GetBoxPage: Word;
Function GetCellPage: Word;
Procedure ClearKeyBuffer;
Procedure WaitMSec (MSec: Word);
Procedure Time (Var Hour, Minute, Second, Hundreds: Byte);
Procedure WaitTime (Hundreds: Word);
Procedure ExtractPointer (PPointer: Pointer; Var PSegment,POffset: Word);
Function DetectVideo: Byte;
Function PresentCDROM: Boolean;
Function GetCDROMDrive: Char;
Function GetCDROMNumber: Byte;
Procedure GetMSCDExVersion (Var VerHi,VerLo: Byte);
Function ProcessorType: Byte;
Function PresentMathCoprocessor: Boolean;
Function GetFloppyDrive: Byte;
Procedure FloppyDriveType (Var Floppy1,Floppy2: Byte);
Function GetSerialPort: Byte;
Function GetParallelPort: Byte;
Function PresentGamePort: Boolean;
Function PresentMouse: Byte;
Function EnhancedKeyboard: Boolean;
Function PresentEMS: Boolean;
Function GetEMSVersion: Byte;
Procedure EMSMemory (Var MTotal,MFree: Word);
Function GetVCPIVersion: Word;
Function GetDPMIVersion: Word;
Function PresentXMS: Boolean;
Procedure GetXMSVersion (Var XMSVer,DriverRev: Word);
Procedure XMSMemory (Var XMSMem,XMSFree: Word);
Function PresentVESA: Boolean;
Procedure GetVESAInfo (Var VESABuffer: TVESABuf);
Function AllocateMemory (Var PMem: Pointer; MSize: Word): Word;
Function DeAllocate (Var PMem: Pointer): Word;
Function FreeDOSMemory: LongInt;

Implementation

{$L Main.Obj}
{$L Point.Obj}
{$L Line.Obj}
{$L Circle.Obj}
{$L Sprite.Obj}
{$L Cell.Obj}
{$L Font.Obj}
{$L Box.Obj}
{$L Palette.Obj}
{$L Screen.Obj}
{$L Misc.Obj}
{$L Hardware.Obj}
{$L MemAlloc.Obj}

Procedure SetMode (Mode: Byte);
 External;
Procedure SetVGAMode;
 External;
Procedure SetTextMode;
 External;
Procedure SetPalette (PPal: Pointer);
 External;
Procedure GetPalette (Var Pal: TPalette);
 External;
Procedure IncPalette (PPal: Pointer; Step: Byte);
 External;
Procedure DecPalette (PPal: Pointer; Step: Byte);
 External;
Procedure RotatePaletteLeft (PPal: Pointer);
 External;
Procedure RotatePaletteRight (PPal: Pointer);
 External;
Procedure SetPixel (X,Y: Word; Col: Byte);
 External;
Procedure SetPixelTab (X,Y: Word; Col: Byte);
 External;
Procedure SetPixelVirtual (SegVirtual,X,Y: Word; Col: Byte);
 External;
Procedure SetPixelTabVirtual (SegVirtual,X,Y: Word; Col: Byte);
 External;
Function GetPixel (X,Y: Word): Byte;
 External;
Function GetPixelVirtual (SegVirtual,X,Y: Word): Byte;
 External;
Procedure HorizontalLine (X1,X2,Y: Word; Col: Byte);
 External;
Procedure HorizontalLineVirtual (SegVirtual,X1,X2,Y: Word; Col: Byte);
 External;
Procedure HorizontalLineRel (X,Y,Length: Word; Col: Byte);
 External;
Procedure HorizontalLineRelVirtual (SegVirtual,X,Y,Length: Word; Col: Byte);
 External;
Procedure VerticalLine (X,Y1,Y2: Word; Col: Byte);
 External;
Procedure VerticalLineVirtual (SegVirtual,X,Y1,Y2: Word; Col: Byte);
 External;
Procedure VerticalLineRel (X,Y1,Y2: Word; Col: Byte);
 External;
Procedure VerticalLineRelVirtual (SegVirtual,X,Y1,Y2: Word; Col: Byte);
 External;
Procedure Line (X1,Y1,X2,Y2: Word; Color: Byte);
 External;
Procedure LineVirtual (SegVirtual,X1,Y1,X2,Y2: Word; Color: Byte);
 External;
Procedure Circle (X,Y,R: Word; Color: Byte);
 External;
Procedure CircleVirtual (SegVirtual,X,Y,R: Word; Color: Byte);
 External;
Procedure FilledCircle (X,Y,R: Word; Color: Byte);
 External;
Procedure FilledCircleVirtual (SegVirtual,X,Y,R: Word; Color: Byte);
 External;
Procedure WaitRetrace;
 External;
Procedure WaitVRetrace;
 External;
Procedure WaitNotVRetrace;
 External;
Function Adress (X,Y: Word): Word;
 External;
Procedure DrawSpriteXY (PSprite: Pointer; X,Y: Word; Count: Byte);
 External;
Procedure DrawSprite (PSprite: Pointer; X,Y: Word; Count: Byte);
 External;
Procedure DrawSpriteOver (PSprite: Pointer; X,Y: Word; Count: Byte);
 External;
Procedure Sprite (PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
 External;
Procedure SpriteOver (PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
 External;
Procedure SpriteVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
 External;
Procedure SpriteOverVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; SWidth,SHeight: Byte);
 External;
Procedure GetSprite (PSprite: Pointer; X,Y: Word; Wide,Height: Byte);
 External;
Procedure GetSpriteVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; Wide,Height: Byte);
 External;
Procedure Cell (PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
 External;
Procedure CellOver (PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
 External;
Procedure CellVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
 External;
Procedure CellOverVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);
 External;
Procedure WriteFont (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontOver (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontOverHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontOverHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontOverVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure WriteFontOverVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFont (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontOver (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontOverHI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontOverHD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontOverVI (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure PrintFontOverVD (PFont: Pointer; Txt: String; X,Y: Word; Color: Byte);
 External;
Procedure SpriteScale (PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
 External;
Procedure SpriteScaleOver (PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
 External;
Procedure SpriteScaleVirtual (SegVirtual: Word; PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
 External;
Procedure SpriteScaleOverVirtual (SegVirtual: Word; PSprite: Pointer; X,Y,Wide,Height,NewWide,NewHeight: Word);
 External;
Procedure SpriteScaleRel (PSprite: Pointer; X,Y,Wide,Height,Step: Word);
 External;
Procedure SpriteScaleOverRel (PSprite: Pointer; X,Y,Wide,Height,Step: Word);
 External;
Procedure SpriteScaleRelVirtual (SegVirtual: Word; PSprite: Pointer; X,Y,Wide,Height,Step: Word);
 External;
Procedure SpriteScaleOverRelVirtual (SegVirtual: Word; PSprite: Pointer; X,Y,Wide,Height,Step: Word);
 External;
Procedure DrawBox (X1,Y1,X2,Y2: Word; Color: Byte);
 External;
Procedure DrawBoxRel (X1,Y1,Wide,Height: Word; Color: Byte);
 External;
Procedure DrawBoxVirtual (SegVirtual,X1,Y1,X2,Y2: Word; Color: Byte);
 External;
Procedure DrawBoxRelVirtual (SegVirtual,X1,Y1,Wide,Height: Word; Color: Byte);
 External;
Procedure ClearScreen (Color: Byte);
 External;
Procedure ClearScreenVirtual (SegVirtual: Word; Color: Byte);
 External;
Procedure UseVirtual (SegVirtual: Word);
 External;
Procedure ConvertRGBPalette (POldPal: Pointer; Var Pal: TPalette);
 External;
Procedure InvertScreen (SegScreen: Word);
 External;
Procedure ShowScreen (PScreen: Pointer);
 External;
Procedure SetScreen (PScreen: Pointer);
 External;
Procedure SetScreenVirtual (SegVirtual: Word; PScreen: Pointer);
 External;
Procedure ShowCompressedScreen (PScreen: Pointer);
 External;
Procedure DeCompressScreen (PScreen: Pointer);
 External;
Procedure DeCompressVirtual (SegVirtual: Word; PScreen: Pointer);
 External;
Procedure DeCompressOverVirtual (SegVirtual: Word; PScreen: Pointer);
 External;
Procedure CopySprite (SegSource, SegDestinaton, X1, Y1, X2, Y2: Word; SWidth, SHeight: Byte);
 External;
Procedure CopyScreen (SegSource, SegDestinaton: Word);
 External;
Procedure CopyRows (SegSource, SegDestinaton, Y1, Y2: Word);
 External;
Procedure CopyRowsRel (SegSource, SegDestinaton, Y, Count: Word);
 External;
Procedure WaitFrames (Frames: Word);
 External;
Procedure SetCharSpace (Space: Word);
 External;
Procedure SetCharHeight (Height: Byte);
 External;
Procedure SetLineSpace (Space: Byte);
 External;
Procedure SetVideoPage (VPage: Word);
 Begin
  Asm
                      PUSH   [VPage]
                      CALL   SetWritePage
                      PUSH   [VPage]
                      CALL   SetSpritePage
                      PUSH   [VPage]
                      CALL   SetLinePage
                      PUSH   [VPage]
                      CALL   SetPointPage
                      PUSH   [VPage]
                      CALL   SetCirclePage
                      PUSH   [VPage]
                      CALL   SetBoxPage
                      PUSH   [VPage]
                      CALL   SetCellPage
  End;
 End;
Procedure SetWritePage (WPage: Word);
 External;
Procedure SetSpritePage (SPage: Word);
 External;
Procedure SetLinePage (LPage: Word);
 External;
Procedure SetPointPage (PPage: Word);
 External;
Procedure SetCirclePage (CPage: Word);
 External;
Procedure SetBoxPage (BPage: Word);
 External;
Procedure SetCellPage (CPage: Word);
 External;
Function GetCharSpace: Word;
 External;
Function GetCharHeight: Byte;
 External;
Function GetLineSpace: Byte;
 External;
Function GetWritePage: Word;
 External;
Function GetSpritePage: Word;
 External;
Function GetLinePage: Word;
 External;
Function GetPointPage: Word;
 External;
Function GetCirclePage: Word;
 External;
Function GetBoxPage: Word;
 External;
Function GetCellPage: Word;
 External;
Procedure ClearKeyBuffer;
 External;
Procedure WaitMSec (MSec: Word);
 External;
Procedure Time (Var Hour, Minute, Second, Hundreds: Byte);
 External;
Procedure WaitTime (Hundreds: Word);
 External;
Procedure ExtractPointer (PPointer: Pointer; Var PSegment,POffset: Word);
 External;
Function DetectVideo: Byte;
 External;
Function PresentCDROM: Boolean;
 External;
Function GetCDROMDrive: Char;
 External;
Function GetCDROMNumber: Byte;
 External;
Procedure GetMSCDExVersion (Var VerHi,VerLo: Byte);
 External;
Function ProcessorType: Byte;
 External;
Function PresentMathCoprocessor: Boolean;
 External;
Function GetFloppyDrive: Byte;
 External;
Procedure FloppyDriveType (Var Floppy1,Floppy2: Byte);
 External;
Function GetSerialPort: Byte;
 External;
Function GetParallelPort: Byte;
 External;
Function PresentGamePort: Boolean;
 External;
Function PresentMouse: Byte;
 External;
Function EnhancedKeyboard: Boolean;
 External;
Function PresentEMS: Boolean;
 External;
Function GetEMSVersion: Byte;
 External;
Procedure EMSMemory (Var MTotal,MFree: Word);
 External;
Function GetVCPIVersion: Word;
 External;
Function GetDPMIVersion: Word;
 External;
Function PresentXMS: Boolean;
 External;
Procedure GetXMSVersion (Var XMSVer,DriverRev: Word);
 External;
Procedure XMSMemory (Var XMSMem,XMSFree: Word);
 External;
Function PresentVESA: Boolean;
 External;
Procedure GetVESAInfo (Var VESABuffer: TVESABuf);
 External;
Function AllocateMemory (Var PMem: Pointer; MSize: Word): Word;
 External;
Function DeAllocate (Var PMem: Pointer): Word;
 External;
Function FreeDOSMemory: LongInt;
 External;

End.