{$G+,F+}
Program CircleDraw;

Uses Graphics,Crt;

Procedure CirclePas (XS,YS,R: Integer;C: Byte);
 Var P,DX,DY,X,Y: Integer;
  Begin
   X:=0;
   Y:=R;
   P:=1-R;
   DX:=3;
   DY:=2*R-2;
   Repeat
    SetPixel (XS+X,YS+Y,C);
    SetPixel (XS-X,YS+Y,C);
    SetPixel (XS+X,YS-Y,C);
    SetPixel (XS-X,YS-Y,C);
    SetPixel (XS+Y,YS+X,C);
    SetPixel (XS-Y,YS+X,C);
    SetPixel (XS+Y,YS-X,C);
    SetPixel (XS-Y,YS-X,C);
    If P>=0 Then
     Begin
      P:=P-DY;
      DY:=DY-2;
      Y:=Y-1;
     End;
    P:=P+DX;
    DX:=DX+2;
    X:=X+1;
   Until X>Y
  End;

Procedure Circle (XS,YS,R: Word;C: Byte);
 External;
  {$L Circle}

Procedure TetriPal;
 External; {$L TetriPal}

Procedure CircleAsm (XS,YS,R: Word;C: Byte);
 Var P,XD,YD,X,Y: Integer;
  Begin
   asm
                 MOV    [X],0
                 MOV    AX,[R]
                 MOV    [Y],AX
                 MOV    AX,1
                 SUB    AX,[R]
                 MOV    [P],AX
                 MOV    [XD],3
                 MOV    AX,[R]
                 SHL    AX,1
                 SUB    AX,2
                 MOV    [YD],AX
     @Repeat:    MOV    AX,[XS]
                 ADD    AX,[X]
                 PUSH   AX
                 MOV    AX,[YS]
                 ADD    AX,[Y]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 SUB    AX,[X]
                 PUSH   AX
                 MOV    AX,[YS]
                 ADD    AX,[Y]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 ADD    AX,[X]
                 PUSH   AX
                 MOV    AX,[YS]
                 SUB    AX,[Y]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 SUB    AX,[X]
                 PUSH   AX
                 MOV    AX,[YS]
                 SUB    AX,[Y]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 ADD    AX,[Y]
                 PUSH   AX
                 MOV    AX,[YS]
                 ADD    AX,[X]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 SUB    AX,[Y]
                 PUSH   AX
                 MOV    AX,[YS]
                 ADD    AX,[X]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 ADD    AX,[Y]
                 PUSH   AX
                 MOV    AX,[YS]
                 SUB    AX,[X]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[XS]
                 SUB    AX,[Y]
                 PUSH   AX
                 MOV    AX,[YS]
                 SUB    AX,[X]
                 PUSH   AX
                 MOV    AL,[C]
                 PUSH   AX
                 CALL   SetPixel
                 MOV    AX,[P]
                 AND    AX,8000H
                 JNZ    @CNext
                 MOV    AX,[P]
                 SUB    AX,[YD]
                 MOV    [P],AX
                 SUB    [YD],2
                 DEC    [Y]
       @CNext:   MOV    AX,[P]
                 ADD    AX,[XD]
                 MOV    [P],AX
                 ADD    [XD],2
                 INC    [X]
                 MOV    AX,[Y]
                 AND    AX,8000H
                 JNZ    @CEnd
                 MOV    AX,[Y]
       @CSign:   CMP    [X],AX
       @CEnd:    JNA    @Repeat
  end;
end;

Procedure FillCircle (XS,YS,R: Integer;C: Byte);
 External;

Procedure FillCirclePas (XS,YS,R: Integer;C: Byte);
 Var P,DX,DY,X,Y: Integer;
  Begin
   X:=0;
   Y:=R;
   P:=1-R;
   DX:=3;
   DY:=2*R-2;
   Repeat
{    VerticalLine (XS+X,YS-Y,YS+Y,C);
    VerticalLine (XS-X,YS-Y,YS+Y,C);
    VerticalLine (XS+Y,YS-X,YS+X,C);
    VerticalLine (XS-Y,YS-X,YS+X,C);}
    HorizontalLine (XS-X,XS+X,YS+Y,C);
    HorizontalLine (XS-X,XS+X,YS-Y,C);
    HorizontalLine (XS-Y,XS+Y,YS+X,C);
    HorizontalLine (XS-Y,XS+Y,YS-X,C);
    If P>=0 Then
     Begin
      P:=P-DY;
      DY:=DY-2;
      Y:=Y-1;
     End;
    P:=P+DX;
    DX:=DX+2;
    X:=X+1;
   Until X>Y
  End;

Begin
 SetVGAMode;
 SetPalette (@TetriPal);
{ FillCircle (159,99,30,15);
 Readln;
 Circle (159,99,200,5);
 Readln;
 FillCircle (159,99,30,15);}
 Repeat
  FillCircle (Random (250)+30,Random (120)+30,Random (30),Random (255));
{  CirclePas (Random (250)+30,Random (120)+30,Random (30),Random (255));}
{  FillCircle (Random (250)+30,Random (120)+30,Random (30),Random (255));}
{  CircleAsm (Random (250)+30,Random (120)+30,Random (30),Random (255));}
{  Circle (Random (250)+30,Random (120)+30,Random (30),Random (255));}
 WaitRetrace;
 Until KeyPressed;
 ReadLn;
 SetTextMode;
End.
