#ifndef _Graphics
#define _Graphics

#define Font8x6         6
#define Font8x8         8
#define Font8x12        12
#define Font8x14        14
#define Font8x16        16
#define VRAM            0xA000

typedef unsigned char TPalette [768];
typedef unsigned char TVESABuf [512];
typedef char** String;
unsigned int MainPage;

#endif

#ifndef __cplusplus
#define _CPP_
#else
#define _CPP_ "C"
#endif

// Main functions
extern _CPP_ void far pascal SetMode (unsigned char Mode);
extern _CPP_ void far pascal SetVGAMode (void);
extern _CPP_ void far pascal SetTextMode (void);
extern _CPP_ void far pascal WaitRetrace (void);
extern _CPP_ void far pascal WaitVRetrace (void);
extern _CPP_ void far pascal WaitNotVRetrace (void);
extern _CPP_ void far pascal WaitFrames (unsigned int Frames);
extern _CPP_ void far pascal UseVirtual (unsigned int SegVirtual);
extern _CPP_ void far pascal CopyScreen (unsigned int SegSource, unsigned int SegDestinaton);
extern _CPP_ void far pascal CopyRows (unsigned int SegSource, unsigned int SegDestinaton, unsigned int Y1, unsigned int Y2);
extern _CPP_ void far pascal CopyRowsRel (unsigned int SegSource, unsigned int SegDestinaton, unsigned int Y, unsigned int Count);
extern _CPP_ void far pascal ClearScreen (unsigned char Color);
extern _CPP_ void far pascal ClearScreenVirtual (unsigned int SegVirtual, unsigned char Color);
extern _CPP_ void far pascal InvertScreen (unsigned int SegScreen);

// Palette
extern _CPP_ void far pascal SetPalette (char far *PPal);
extern _CPP_ void far pascal GetPalette (TPalette far *PPal);
extern _CPP_ void far pascal IncPalette (char far *PPal, unsigned char Step);
extern _CPP_ void far pascal DecPalette (char far *PPal, unsigned char Step);
extern _CPP_ void far pascal ConvertRGBPalette (TPalette far *POldPal, TPalette far *Pal);
extern _CPP_ void far pascal RotatePaletteLeft (char far *PPal);
extern _CPP_ void far pascal RotatePaletteRight (char far *PPal);

// Pixel
extern _CPP_ void far pascal SetPixel (unsigned int X, unsigned int Y, unsigned char Col);
extern _CPP_ void far pascal SetPixelTab (unsigned int X, unsigned int Y, unsigned char Col);
extern _CPP_ void far pascal SetPixelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned char Col);
extern _CPP_ void far pascal SetPixelTabVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned char Col);
extern _CPP_ unsigned char far pascal GetPixel (unsigned int X, unsigned int Y);
extern _CPP_ unsigned char far pascal GetPixelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y);

// Line
extern _CPP_ void far pascal HorizontalLine (unsigned int X1, unsigned int X2, unsigned int Y, unsigned char Col);
extern _CPP_ void far pascal HorizontalLineVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int X2, unsigned int Y, unsigned char Col);
extern _CPP_ void far pascal HorizontalLineRel (unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern _CPP_ void far pascal HorizontalLineRelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern _CPP_ void far pascal VerticalLine (unsigned int X, unsigned int Y1, unsigned int Y2, unsigned char Col);
extern _CPP_ void far pascal VerticalLineVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y1, unsigned int Y2, unsigned char Col);
extern _CPP_ void far pascal VerticalLineRel (unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern _CPP_ void far pascal VerticalLineRelVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int Length, unsigned char Col);
extern _CPP_ void far pascal Line (unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern _CPP_ void far pascal LineVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);

// Boxes, filled rectangles
extern _CPP_ void far pascal DrawBox (unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern _CPP_ void far pascal DrawBoxRel (unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern _CPP_ void far pascal DrawBoxVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);
extern _CPP_ void far pascal DrawBoxRelVirtual (unsigned int SegVirtual, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char Color);

// Circle, filled circle
extern _CPP_ void far pascal Circle (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern _CPP_ void far pascal CircleVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern _CPP_ void far pascal FilledCircle (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern _CPP_ void far pascal FilledCircleVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern _CPP_ void far pascal FilledCircleClip (unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern _CPP_ void far pascal FilledCircleClipVirtual (unsigned int SegVirtual, unsigned int X, unsigned int Y, unsigned int R, unsigned char Color);
extern _CPP_ void far pascal SetCircleClipPage (unsigned int MinX, unsigned int MaxX, unsigned int MinY, unsigned int MaxY);

// Sprites
extern _CPP_ unsigned int far pascal Adress (unsigned int X, unsigned int Y);
extern _CPP_ void far pascal DrawSpriteXY (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Count);
extern _CPP_ void far pascal DrawSprite (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Count);
extern _CPP_ void far pascal DrawSpriteOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Count);
extern _CPP_ void far pascal Sprite (void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal SpriteOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal SpriteVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal SpriteOverVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal GetSprite (void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal GetSpriteVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal CopySprite (unsigned int SegSource, unsigned int SegDestinaton, unsigned int X1, unsigned int Y1, unsigned int X2, unsigned int Y2, unsigned char SWidth, unsigned char SHeight);
extern _CPP_ void far pascal SpriteScale (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern _CPP_ void far pascal SpriteScaleOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern _CPP_ void far pascal SpriteScaleVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern _CPP_ void far pascal SpriteScaleOverVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int NewWidth, unsigned int NewHeight);
extern _CPP_ void far pascal SpriteScaleRel (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);
extern _CPP_ void far pascal SpriteScaleOverRel (void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);
extern _CPP_ void far pascal SpriteScaleRelVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);
extern _CPP_ void far pascal SpriteScaleOverRelVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned int Width, unsigned int Height, unsigned int Ratio);

// Cells
extern _CPP_ void far pascal Cell (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);
extern _CPP_ void far pascal CellOver (void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);
extern _CPP_ void far pascal CellVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);
extern _CPP_ void far pascal CellOverVirtual (unsigned int SegVirtual, void far *PSprite, unsigned int X, unsigned int Y, unsigned char Wdt, unsigned char Hgt, unsigned char X2, unsigned char Y2, unsigned char NWdt, unsigned char NHgt);

// Write, font functions
extern _CPP_ void far pascal SetCharSpace (unsigned int Space);
extern _CPP_ void far pascal SetCharHeight (unsigned char Height);
extern _CPP_ void far pascal SetLineSpace (unsigned char Space);
extern _CPP_ unsigned int far pascal GetCharSpace;
extern _CPP_ unsigned char far pascal GetCharHeight;
extern _CPP_ unsigned char far pascal GetLineSpace;
extern _CPP_ void far pascal WriteFont (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontHI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontHD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontVI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontVD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontOver (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontOverHI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontOverHD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontOverVI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal WriteFontOverVD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFont (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontHI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontHD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontVI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontVD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontOver (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontOverHI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontOverHD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontOverVI (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);
extern _CPP_ void far pascal PrintFontOverVD (void far *PFont, String Txt, unsigned int X, unsigned int Y, unsigned char Color);

// Screens, compressed screens
// Fix-up overflow
extern _CPP_ void far pascal ShowScreen (void far *PScreen);
extern _CPP_ void far pascal SetScreen (void far *PScreen);
extern _CPP_ void far pascal SetScreenVirtual (unsigned int SegVirtual, void far *PScreen);
extern _CPP_ void far pascal ShowCompressedScreen (void far *PScreen);
extern _CPP_ void far pascal DeCompressScreen (void far *PScreen);
extern _CPP_ void far pascal DeCompressVirtual (unsigned int SegVirtual, void far *PScreen);
extern _CPP_ void far pascal DeCompressOverVirtual (unsigned int SegVirtual, void far *PScreen);

// PCX screens & sprites
extern _CPP_ void far pascal ShowPCX (void far *PPCX);
extern _CPP_ void far pascal DeCompressPCX (void far *PPCX);
extern _CPP_ void far pascal DeCompressPCXVirtual (unsigned int SegVirtual, void far *PPCX);
extern _CPP_ void far pascal PCXSprite (void far *PPCX, unsigned int X, unsigned int Y);
extern _CPP_ void far pascal PCXSpriteVirtual (unsigned int SegVirtual, void far *PPCX, unsigned int X, unsigned int Y);
extern _CPP_ void far pascal PCXSpriteOver (void far *PPCX, unsigned int X, unsigned int Y);
extern _CPP_ void far pascal PCXSpriteOverVirtual (unsigned int SegVirtual, void far *PPCX, unsigned int X, unsigned int Y);

// Page functions
extern _CPP_ void far pascal SetVideoPage (unsigned int VPage);
extern _CPP_ void far pascal SetMainPage (unsigned int MPage);
extern _CPP_ void far pascal SetWritePage (unsigned int WPage);
extern _CPP_ void far pascal SetSpritePage (unsigned int SPage);
extern _CPP_ void far pascal SetLinePage (unsigned int LPage);
extern _CPP_ void far pascal SetPointPage (unsigned int PPage);
extern _CPP_ void far pascal SetCirclePage (unsigned int CPage);
extern _CPP_ void far pascal SetBoxPage (unsigned int BPage);
extern _CPP_ void far pascal SetCellPage (unsigned int CPage);
extern _CPP_ unsigned int far pascal GetMainPage (void);
extern _CPP_ unsigned int far pascal GetWritePage (void);
extern _CPP_ unsigned int far pascal GetSpritePage (void);
extern _CPP_ unsigned int far pascal GetLinePage (void);
extern _CPP_ unsigned int far pascal GetPointPage (void);
extern _CPP_ unsigned int far pascal GetCirclePage (void);
extern _CPP_ unsigned int far pascal GetBoxPage (void);
extern _CPP_ unsigned int far pascal GetCellPage (void);

// Keyboard interrupt handler
extern _CPP_ void far pascal Keyboard (void);
extern _CPP_ void far pascal KeyBufferAddr (void far *PPBuf);
extern _CPP_ char far pascal Key (void);

// Hardware/Software detection
extern _CPP_ unsigned char far pascal DetectVideo (void);
extern _CPP_ unsigned char far pascal ProcessorType (void);
extern _CPP_ unsigned char far pascal PresentMathCoprocessor (void);
extern _CPP_ unsigned char far pascal PresentCDROM (void);
extern _CPP_ char far pascal GetCDROMDrive (void);
extern _CPP_ unsigned char far pascal GetCDROMNumber (void);
extern _CPP_ void far pascal GetMSCDExVersion (unsigned void far *VerHi, unsigned void far *VerLo);
extern _CPP_ unsigned char far pascal GetFloppyDrive (void);
extern _CPP_ void far pascal FloppyDriveType (unsigned void far *Floppy1, unsigned void far *Floppy2);
extern _CPP_ unsigned char far pascal GetSerialPort (void);
extern _CPP_ unsigned char far pascal GetParallelPort (void);
extern _CPP_ unsigned char far pascal PresentGamePort (void);
extern _CPP_ unsigned char far pascal PresentMouse (void);
extern _CPP_ unsigned char far pascal EnhancedKeyboard (void);
extern _CPP_ unsigned char far pascal PresentEMS (void);
extern _CPP_ unsigned char far pascal GetEMSVersion (void);
extern _CPP_ void far pascal EMSMemory (unsigned int far *MTotal, unsigned int far *MFree);
extern _CPP_ unsigned int far pascal GetVCPIVersion (void);
extern _CPP_ unsigned int far pascal GetDPMIVersion (void);
extern _CPP_ unsigned char far pascal PresentXMS (void);
extern _CPP_ void far pascal GetXMSVersion (unsigned int far *XMSVer, unsigned int far *DriverRev);
extern _CPP_ void far pascal XMSMemory (unsigned int far *XMSMem, unsigned int far *XMSFree);
extern _CPP_ unsigned char far pascal PresentVESA (void);
extern _CPP_ void far pascal GetVESAInfo (TVESABuf far *VESABuffer);

// Memory
extern _CPP_ unsigned int far pascal AllocateMemory (void far *PMem, unsigned int MSize);
extern _CPP_ unsigned int far pascal DeAllocate (void far *PMem);
extern _CPP_ long far pascal FreeDOSMemory (void);

// Miscelaneous
extern _CPP_ void far pascal ClearKeyBuffer (void);
extern _CPP_ void far pascal WaitMSec (unsigned int MSec);
extern _CPP_ void far pascal Time (unsigned void far *Hour, unsigned void far *Minute, unsigned void far *Second, unsigned void far *Hundreds);
extern _CPP_ void far pascal WaitTime (unsigned int Hundreds);
extern _CPP_ void far pascal ExtractPointer (void far *PPointer, unsigned int far *PSegment, unsigned int far *POffset);
