;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*                                  386+                                      *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Sprite

Model Medium

LOCALS

.386

.DATA

SpritePage   DW    0A000H          ;Segment obrazovky

.CODE

;******************************************************************************
;*                     Funkcia Adress (X,Y: Word): Word;                      *
;*          Vracia adresu (X-1)*8+(Y-1)*8*320, pouva ju DrawSprite          *
;*                    Obrazovka je ako pole [1..40,1..25]                     *
;******************************************************************************

PUBLIC Adress
Adress PROC FAR
 ARG Y: Word, X: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    DEC     AX
                    SHL     AX,3
                    MOV     DX,AX
                    SHL     AX,8
                    SHL     DX,6
                    ADD     AX,DX
                    MOV     DX,[X]
                    DEC     DX
                    SHL     DX,3
                    ADD     AX,DX
                    POP     BP
                    RET     4
Adress ENDP

;******************************************************************************
;*     Procedra DrawSpriteXY (PSprite: Pointer; X,Y: Word; Count: Byte);     *
;*     Vykresl (Count+1).sprite s rozmermi 8x8, na ktor ukazuje PSprite,    *
;*                        na pozcu X,Y na obrazovke                          *
;*   X je kad 8.stpec, Y je kad 8.riadok (obrazovka m rozmer 40 x 25)   *
;******************************************************************************

PUBLIC DrawSpriteXY
DrawSpriteXY PROC FAR
 ARG Count: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   [X]
                    PUSH   [Y]
                    CALL   Adress
                    PUSH   SI
                    XCHG   AX,SI
                    LES    BX,[PSprite]
                    MOV    AL,[Count]
                    XOR    AH,AH
                    SHL    AX,6
                    ADD    BX,AX
                    MOV    AX,0808H
                    PUSH   DS
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
         @BeginXY:  MOV    CL,ES:[BX]
                    INC    BX
                    MOV    DS:[SI],CL
                    INC    SI
                    DEC    AL
                    JNZ    @BeginXY
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @BeginXY
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    10
DrawSpriteXY ENDP

;******************************************************************************
;*      Procedra DrawSprite (PSprite: Pointer; X,Y: Word; Count: Byte);      *
;*     Vykresl (Count+1).sprite s rozmermi 8x8, na ktor ukazuje PSprite,    *
;*                        na pozcu X,Y na obrazovke                          *
;******************************************************************************

PUBLIC DrawSprite
DrawSprite PROC FAR
 ARG Count: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   SI
                    LES    BX,[PSprite]
                    MOV    AL,[Count]
                    XOR    AH,AH
                    SHL    AX,6
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    CX,[X]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,CX
                    MOV    SI,AX
                    MOV    AX,0808H
                    PUSH   DS
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
         @DSBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    MOV    DS:[SI],CL
                    INC    SI
                    DEC    AL
                    JNZ    @DSBegin
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @DSBegin
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    10
DrawSprite ENDP

;******************************************************************************
;*    Procedra DrawSpriteOver (PSprite: Pointer; X,Y: Word; Count: Byte);    *
;*     Vykresl (Count+1).sprite s rozmermi 8x8, na ktor ukazuje PSprite,    *
;*  na pozcu X,Y na obrazovke, priom 0 je transparentn farba (ak sa zist  *
;*                0 v sprite, ni sa na obrazovku nekresl)                   *
;******************************************************************************

PUBLIC DrawSpriteOver
DrawSpriteOver PROC FAR
 ARG Count: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   SI
                    LES    BX,[PSprite]
                    MOV    AL,Count
                    XOR    AH,AH
                    SHL    AX,6
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    CX,[X]
                    MOV    SI,320
                    MUL    SI
                    ADD    AX,CX
                    XCHG   SI,AX
                    MOV    AX,0808H
                    PUSH   DS
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
          @OBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @OCont
                    MOV    DS:[SI],CL
           @OCont:  INC    SI
                    DEC    AL
                    JNZ    @OBegin
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @OBegin
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    10
DrawSpriteOver ENDP

;******************************************************************************
;*   Procedra Sprite (PSprite: Pointer, X,Y: Word; SWidth, SHeight: Byte);   *
;*  Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y, priom SWidth  *
;*                   je rka a SHeight je vka spritu                       *
;******************************************************************************

PUBLIC Sprite
Sprite PROC FAR
 ARG SHeight: Byte, SWidth: Byte, Y: Word, X: Word, PSprite: DWord
                    ENTER  0,0
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,2
                    AND    BL,3
                    MOV    CX,[SpritePage]
                    MOV    ES,CX
                    LDS    SI,[PSprite]
                    XOR    CX,CX
                    CLD
           @SBegin: MOV    CL,AL
                    REP    MOVSD
                    MOV    CL,BL
                    REP    MOVSB
           @SAdd:   ADD    DI,DX
                    DEC    AH
                    JNZ    @SBegin
                    POP    DS
                    LEAVE
                    RET    12
Sprite ENDP

;******************************************************************************
;* Procedra SpriteOver (PSprite: Pointer, X,Y: Word; SWidth, SHeight: Byte); *
;*  Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y, priom SWidth  *
;*         je rka, SHeight je vka spritu a 0 je transparetn farba        *
;******************************************************************************

PUBLIC SpriteOver
SpriteOver PROC FAR
 ARG SHeight: Byte, SWidth: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    BH,[SHeight]
                    MOV    BL,[SWidth]
                    MOV    DX,320
                    MOV    AX,BX
                    AND    AX,0FFH
                    SUB    DX,AX
                    MOV    CX,[SpritePage]
                    MOV    ES,CX
                    LDS    SI,[PSprite]
                    XOR    CX,CX
                    CLD
          @SOBegin: MOV    CL,BL
          @SOBegan: LODSB
                    OR     AL,AL
                    JZ     @SOStay
                    STOSB
                    JMP    @SOCont
          @SOStay:  INC    DI
          @SOCont:  LOOP   @SOBegan
                    ADD    DI,DX
                    DEC    BH
                    JNZ    @SOBegin
                    POP    DS
                    POP    BP
                    RET    12
SpriteOver ENDP

;******************************************************************************
;*Procedra SpriteVirtual (SegVirtual: Word, PSprite:Pointer, X,Y:Word;       *
;*                         SWidth, SHeight:Byte);                             *
;*   Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y vo virtulnej  *
;*        obrazovke, priom SWidth je rka a SHeight je vka spritu.        *
;******************************************************************************

PUBLIC SpriteVirtual
SpriteVirtual PROC FAR
 ARG SHeight: Byte,SWidth: Byte,Y: Word,X: Word,PSprite: DWord,SegVirtual: Word
                    ENTER  0,0
                    PUSH   DS
                    LDS    SI,[PSprite]
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    CX,[SegVirtual]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,2
                    AND    BL,3
                    MOV    ES,CX
                    XOR    CX,CX
                    CLD
          @SVBegin: MOV    CL,AL
                    REP    MOVSD
                    MOV    CL,BL
                    REP    MOVSB
                    ADD    DI,DX
                    DEC    AH
                    JNZ    @SVBegin
                    POP    DS
                    LEAVE
                    RET    14
SpriteVirtual ENDP

;******************************************************************************
;* Procedra SpriteOverVirtual (SegVirtual: Word, PSprite:Pointer, X,Y:Word;  *
;*                              SWidth, SHeight:Byte);                        *
;*   Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y vo virtulnej  *
;*      obrazovke, priom SWidth je rka, SHeight je vka spritu a 0 je     *
;*                            transparentnou farbou.                          *
;******************************************************************************

PUBLIC SpriteOverVirtual
SpriteOverVirtual PROC FAR
 ARG SHeight: Byte,SWidth: Byte,Y: Word,X: Word,PSprite: DWord,SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PSprite]
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    BH,[SHeight]
                    MOV    BL,[SWidth]
                    MOV    CX,[SegVirtual]
                    PUSH   CX
                    MOV    DX,320
                    MOV    AX,BX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    CX
                    MOV    ES,CX
                    XOR    CX,CX
                    CLD
         @SOVBegin: MOV    CL,BL
         @SOVBegan: LODSB
                    OR     AL,AL
                    JZ     @SOVStay
                    STOSB
                    JMP    @SOVCont
         @SOVStay:  INC    DI
         @SOVCont:  LOOP   @SOVBegan
                    ADD    DI,DX
                    DEC    BH
                    JNZ    @SOVBegin
                    POP    DS
                    POP    BP
                    RET    14
SpriteOverVirtual ENDP

;******************************************************************************
;* Procedra GetSprite (PSprite: Pointer, X,Y: Word; SWidth, SHeight: Byte);  *
;*    Ulo sprite z pozcie X,Y obrazovky do pamte na miesto, kde ukazuje   *
;*         PSprite, priom SWidth je rka a SHeight je vka spritu.         *
;******************************************************************************

PUBLIC GetSprite
GetSprite PROC FAR
 ARG SHeight: Byte, SWidth:Byte, Y:Word, X:Word, PSprite: DWord
                    ENTER  0,0
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    CX,[X]
                    ADD    SI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,2
                    AND    BL,3
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
                    LES    DI,[PSprite]
                    XOR    CX,CX
                    CLD
          @GSBegin: MOV    CL,AL
                    REP    MOVSD
                    MOV    CL,BL
                    REP    MOVSB
                    ADD    SI,DX
                    DEC    AH
                    JNZ    @GSBegin
                    POP    DS
                    LEAVE
                    RET    12
GetSprite ENDP

;******************************************************************************
;*      Procedra GetSpriteVirtual (SegVirtual: Word; PSprite: Pointer, X,Y:  *
;*                                  Word; SWidth,SHeight: Byte);              *
;*  Ulo sprite z pozcie X,Y virtulnej obrazovky do pamte na miesto, kde  *
;*     ukazuje PSprite, priom SWidth je rka a SHeight je vka spritu.     *
;******************************************************************************

PUBLIC GetSpriteVirtual
GetSpriteVirtual PROC FAR
 ARG SHeight: Byte,SWidth: Byte,Y: Word,X: Word,PSprite: DWord,SegVirtual: Word
                    ENTER  0,0
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    CX,[X]
                    ADD    SI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,2
                    AND    BL,3
                    MOV    CX,[SegVirtual]
                    MOV    DS,CX
                    LES    DI,[PSprite]
                    XOR    CX,CX
                    CLD
         @GSVBegin: MOV    CL,AL
                    REP    MOVSD
                    MOV    CL,BL
                    REP    MOVSB
                    ADD    SI,DX
                    DEC    AH
                    JNZ    @GSVBegin
                    POP    DS
                    LEAVE
                    RET    14
GetSpriteVirtual ENDP

;******************************************************************************
;* Procedra SpriteScale (PSprite: Pointer; X, Y, Wide, Height: Word;         *
;*                        NewWide, NewHeight: Word);                          *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii X,Y,    *
;*                priom jeho rozmery bud NewWide x NewHeight.               *
;******************************************************************************

PUBLIC SpriteScale
SpriteScale PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL SHX: Word, SLX: Word, SHY: Word, SLY: Word, OSI: Word, YSt: Word, SIAd: Word, NHe: Word
                     ENTER  16,0
                     PUSH   DS
                     MOV    DX,[W]
                     XOR    AX,AX
                     MOV    [NHe],AX
                     MOV    BX,[NW]
                     CMP    DX,BX
                     JAE    @TwoPassX
                     MOV    BX,[NW]
                     DIV    BX
                     MOV    [SHX],0
                     MOV    [SLX],AX
                     JMP    @YAdd
        @TwoPassX:   XCHG   DX,AX
                     DIV    BX
                     MOV    [SHX],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLX],AX
        @YAdd:       MOV    DX,[H]
                     XOR    AX,AX
                     MOV    BX,[NH]
                     CMP    DX,BX
                     JAE    @TwoPassY
                     DIV    BX
                     MOV    [SHY],0
                     MOV    [SLY],AX
                     JMP    @InitScale
        @TwoPassY:   XCHG   DX,AX
                     DIV    BX
                     MOV    [SHY],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLY],AX
        @InitScale:  MOV    AX,[SpritePage]
                     MOV    ES,AX
                     MOV    DI,[Y]
                     MOV    AX,DI
                     SHL    DI,8
                     SHL    AX,6
                     ADD    DI,AX
                     ADD    DI,[X]
                     MOV    [YSt],0
                     MOV    AX,[SHY]
                     MUL    [W]
                     MOV    [SIAd],AX
                     LDS    SI,[PSprite]
                     MOV    CX,[SLX]
                     MOV    AX,[SHX]               ; Self-modify constant
                     MOV    WORD PTR CS:[OFFSET @RepADC+2],AX
                     MOV    AX,[NW]                ; Self-modify constant
                     MOV    WORD PTR CS:[OFFSET @RepCMP+2],AX
                     JMP    @VertLoop              ; Flush instruction cache
        @VertLoop:   XOR    AX,AX
                     XOR    BX,BX
                     MOV    [OSI],SI
        @HorizLoop:  MOV    DL,DS:[SI]
                     MOV    ES:[DI+BX],DL
                     ADD    AX,CX
        @RepADC:     ADC    SI,100H       ; Self-modify > SHX
                     INC    BX
        @RepCMP:     CMP    BX,100H       ; Self-modify > NW
                     JB     @HorizLoop
                     MOV    SI,[OSI]
                     MOV    BX,[SLY]
                     ADD    [YSt],BX
                     JNC    @NoModulo
                     ADD    SI,[W]
        @NoModulo:   ADD    SI,[SIAd]
                     ADD    DI,320
                     INC    [NHe]
                     MOV    AX,[NHe]
                     CMP    AX,[NH]
                     JB     @VertLoop
                     POP    DS
                     LEAVE
                     RET    16
SpriteScale ENDP

;******************************************************************************
;* Procedra SpriteScaleVirtual (SegVirtual: Word; PSprite: Pointer;          *
;*                               X,Y,Wide,Height,NewWide,NewHeight: Word);    *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*             X,Y, priom jeho rozmery bud NewWide x NewHeight.             *
;******************************************************************************

PUBLIC SpriteScaleVirtual
SpriteScaleVirtual PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL SHX: Word, SLX: Word, SHY: Word, SLY: Word, OSI: Word, YSt: Word, SIAd: Word, NHe: Word
                     ENTER  16,0
                     PUSH   DS
                     MOV    DX,[W]
                     XOR    AX,AX
                     MOV    [NHe],AX
                     MOV    BX,[NW]
                     CMP    DX,BX
                     JAE    @SVTwoPassX
                     MOV    BX,[NW]
                     DIV    BX
                     MOV    [SHX],0
                     MOV    [SLX],AX
                     JMP    @SVYAdd
        @SVTwoPassX: XCHG   DX,AX
                     DIV    BX
                     MOV    [SHX],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLX],AX
        @SVYAdd:     MOV    DX,[H]
                     XOR    AX,AX
                     MOV    BX,[NH]
                     CMP    DX,BX
                     JAE    @SVTwoPassY
                     DIV    BX
                     MOV    [SHY],0
                     MOV    [SLY],AX
                     JMP    @SVInitScale
        @SVTwoPassY: XCHG   DX,AX
                     DIV    BX
                     MOV    [SHY],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLY],AX
       @SVInitScale: MOV    AX,[SegVirtual]
                     MOV    ES,AX
                     MOV    DI,[Y]
                     MOV    AX,DI
                     SHL    DI,8
                     SHL    AX,6
                     ADD    DI,AX
                     ADD    DI,[X]
                     MOV    [YSt],0
                     MOV    AX,[SHY]
                     MUL    [W]
                     MOV    [SIAd],AX
                     LDS    SI,[PSprite]
                     MOV    CX,[SLX]
                     MOV    AX,[SHX]
                     MOV    WORD PTR CS:[OFFSET @SVRepADC+2],AX
                     MOV    AX,[NW]
                     MOV    WORD PTR CS:[OFFSET @SVRepCMP+2],AX
                     JMP    @SVVertLoop
        @SVVertLoop: XOR    AX,AX
                     XOR    BX,BX
                     MOV    [OSI],SI
       @SVHorizLoop: MOV    DL,DS:[SI]
                     MOV    ES:[DI+BX],DL
                     ADD    AX,CX
        @SVRepADC:   ADC    SI,100H       ; Self-modify > SHX
                     INC    BX
        @SVRepCMP:   CMP    BX,100H       ; Self-modify > NW
                     JB     @SVHorizLoop
                     MOV    SI,[OSI]
                     MOV    BX,[SLY]
                     ADD    [YSt],BX
                     JNC    @SVNoModulo
                     ADD    SI,[W]
        @SVNoModulo: ADD    SI,[SIAd]
                     ADD    DI,320
                     INC    [NHe]
                     MOV    AX,[NHe]
                     CMP    AX,[NH]
                     JB     @SVVertLoop
                     POP    DS
                     LEAVE
                     RET    18
SpriteScaleVirtual ENDP

;******************************************************************************
;*      Procedra SpriteScaleOver (PSprite: Pointer; X, Y, Wide, Height,      *
;*                                 NewWide, NewHeight: Word);                 *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii ZX,ZY,  *
;*       priom jeho rozmery bud NewWide x NewHeight a body s farbou 0       *
;*                              sa nevykresuj.                              *
;******************************************************************************

PUBLIC SpriteScaleOver
SpriteScaleOver PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL SHX: Word, SLX: Word, SHY: Word, SLY: Word, OSI: Word, YSt: Word, SIAd: Word, NHe: Word
                     ENTER  16,0
                     PUSH   DS
                     MOV    DX,[W]
                     XOR    AX,AX
                     MOV    [NHe],AX
                     MOV    BX,[NW]
                     CMP    DX,BX
                     JAE    @SRTwoPassX
                     MOV    BX,[NW]
                     DIV    BX
                     MOV    [SHX],0
                     MOV    [SLX],AX
                     JMP    @SRYAdd
        @SRTwoPassX: XCHG   DX,AX
                     DIV    BX
                     MOV    [SHX],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLX],AX
        @SRYAdd:     MOV    DX,[H]
                     XOR    AX,AX
                     MOV    BX,[NH]
                     CMP    DX,BX
                     JAE    @SRTwoPassY
                     DIV    BX
                     MOV    [SHY],0
                     MOV    [SLY],AX
                     JMP    @SRInitScale
        @SRTwoPassY: XCHG   DX,AX
                     DIV    BX
                     MOV    [SHY],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLY],AX
       @SRInitScale: MOV    AX,[SpritePage]
                     MOV    ES,AX
                     MOV    DI,[Y]
                     MOV    AX,DI
                     SHL    DI,8
                     SHL    AX,6
                     ADD    DI,AX
                     ADD    DI,[X]
                     MOV    [YSt],0
                     MOV    AX,[SHY]
                     MUL    [W]
                     MOV    [SIAd],AX
                     LDS    SI,[PSprite]
                     MOV    CX,[SLX]
                     MOV    AX,[SHX]
                     MOV    WORD PTR CS:[OFFSET @SRRepADC+2],AX
                     MOV    AX,[NW]
                     MOV    WORD PTR CS:[OFFSET @SRRepCMP+2],AX
                     JMP    @SRVertLoop
        @SRVertLoop: XOR    AX,AX
                     XOR    BX,BX
                     MOV    [OSI],SI
       @SRHorizLoop: MOV    DL,DS:[SI]
                     OR     DL,DL
                     JZ     @SROff
                     MOV    ES:[DI+BX],DL
        @SROff:      ADD    AX,CX
        @SRRepADC:   ADC    SI,100H       ; Self-modify > SHX
                     INC    BX
        @SRRepCMP:   CMP    BX,100H       ; Self-modify > NW
                     JB     @SRHorizLoop
                     MOV    SI,[OSI]
                     MOV    BX,[SLY]
                     ADD    [YSt],BX
                     JNC    @SRNoModulo
                     ADD    SI,[W]
        @SRNoModulo: ADD    SI,[SIAd]
                     ADD    DI,320
                     INC    [NHe]
                     MOV    AX,[NHe]
                     CMP    AX,[NH]
                     JB     @SRVertLoop
                     POP    DS
                     LEAVE
                     RET    16
SpriteScaleOver ENDP

;******************************************************************************
;*   Procedra SpriteScaleOverVirtual (SegVirtual: Word; PSprite: Pointer;    *
;*                            X, Y, Wide, Height, NewWide, NewHeight: Word);  *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*    X,Y, priom jeho rozmery bud NewWide x NewHeight a body s farbou 0     *
;*                               sa nevykresuj.                             *
;******************************************************************************

PUBLIC SpriteScaleOverVirtual
SpriteScaleOverVirtual PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL SHX: Word, SLX: Word, SHY: Word, SLY: Word, OSI: Word, YSt: Word, SIAd: Word, NHe: Word
                     ENTER  16,0
                     PUSH   DS
                     MOV    DX,[W]
                     XOR    AX,AX
                     MOV    [NHe],AX
                     MOV    BX,[NW]
                     CMP    DX,BX
                     JAE    @SOTwoPassX
                     MOV    BX,[NW]
                     DIV    BX
                     MOV    [SHX],0
                     MOV    [SLX],AX
                     JMP    @SOYAdd
        @SOTwoPassX: XCHG   DX,AX
                     DIV    BX
                     MOV    [SHX],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLX],AX
        @SOYAdd:     MOV    DX,[H]
                     XOR    AX,AX
                     MOV    BX,[NH]
                     CMP    DX,BX
                     JAE    @SOTwoPassY
                     DIV    BX
                     MOV    [SHY],0
                     MOV    [SLY],AX
                     JMP    @SOInitScale
        @SOTwoPassY: XCHG   DX,AX
                     DIV    BX
                     MOV    [SHY],AX
                     XOR    AX,AX
                     DIV    BX
                     MOV    [SLY],AX
       @SOInitScale: MOV    AX,[SegVirtual]
                     MOV    ES,AX
                     MOV    DI,[Y]
                     MOV    AX,DI
                     SHL    DI,8
                     SHL    AX,6
                     ADD    DI,AX
                     ADD    DI,[X]
                     MOV    [YSt],0
                     MOV    AX,[SHY]
                     MUL    [W]
                     MOV    [SIAd],AX
                     LDS    SI,[PSprite]
                     MOV    CX,[SLX]
                     MOV    AX,[SHX]
                     MOV    WORD PTR CS:[OFFSET @SORepADC+2],AX
                     MOV    AX,[NW]
                     MOV    WORD PTR CS:[OFFSET @SORepCMP+2],AX
                     JMP    @SOVertLoop
        @SOVertLoop: XOR    AX,AX
                     XOR    BX,BX
                     MOV    [OSI],SI
       @SOHorizLoop: MOV    DL,DS:[SI]
                     OR     DL,DL
                     JZ     @SOOff
                     MOV    ES:[DI+BX],DL
        @SOOff:      ADD    AX,CX
        @SORepADC:   ADC    SI,100H       ; Self-modify > SHX
                     INC    BX
        @SORepCMP:   CMP    BX,100H       ; Self-modify > NW
                     JB     @SOHorizLoop
                     MOV    SI,[OSI]
                     MOV    BX,[SLY]
                     ADD    [YSt],BX
                     JNC    @SONoModulo
                     ADD    SI,[W]
        @SONoModulo: ADD    SI,[SIAd]
                     ADD    DI,320
                     INC    [NHe]
                     MOV    AX,[NHe]
                     CMP    AX,[NH]
                     JB     @SOVertLoop
                     POP    DS
                     LEAVE
                     RET    18
SpriteScaleOverVirtual ENDP

;******************************************************************************
;*      Procedra SpriteScaleRel (PSprite: Pointer;  X, Y, Wide, Height,      *
;*                                Step: Word);                                *
;*   Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii X,Y    *
;*    s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu.     *
;******************************************************************************

PUBLIC SpriteScaleRel
SpriteScaleRel PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SRCont
                    JMP    @SREnd
        @SRCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SRXStr
                    JMP    @SRXShr
        @SRXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SR1LoopY:  CMP    CX,[NY]
                    JNA    @SR1Cont
                    JMP    @SREnd
        @SR1Cont:   MOV    DX,[W]
        @SR1LoopX:  CMP    BX,[NX]
                    JA     @SR1SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SR1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SR1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SR1LoopX
        @SR1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SR1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SR1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SR1LoopY
        @SRXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SR2LoopY:  CMP    CX,[NY]
                    JA     @SREnd
                    MOV    DX,[NW]
        @SR2LoopX:  CMP    BX,[NX]
                    JA     @SR2SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SR2ChecX:  CMP    DX,[W]
                    JAE    @SR2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SR2ChecX
        @SR2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SR2LoopX
        @SR2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SR2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SR2SkipX
        @SR2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SR2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SR2LoopY
        @SREnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleRel ENDP

;******************************************************************************
;*         Procedra SpriteScaleOverRel (PSprite: Pointer; X, Y, Wide,        *
;*                                       Height: Byte, Step: Word);           *
;*   Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii X,Y    *
;*    s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu,     *
;*                   priom body s farbou 0 sa nevykresuj.                  *
;******************************************************************************

PUBLIC SpriteScaleOverRel
SpriteScaleOverRel PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SBCont
                    JMP    @SBEnd
        @SBCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SBXStr
                    JMP    @SBXShr
        @SBXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SB1LoopY:  CMP    CX,[NY]
                    JNA    @SB1Cont
                    JMP    @SBEnd
        @SB1Cont:   MOV    DX,[W]
        @SB1LoopX:  CMP    BX,[NX]
                    JA     @SB1SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SB1NoP
                    MOV    ES:[DI],AL
        @SB1NoP:    CMP    DX,[NW]
                    JB     @SB1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SB1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SB1LoopX
        @SB1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SB1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SB1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SB1LoopY
        @SBXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SB2LoopY:  CMP    CX,[NY]
                    JA     @SBEnd
                    MOV    DX,[NW]
        @SB2LoopX:  CMP    BX,[NX]
                    JA     @SB2SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SB2ChecX
                    MOV    ES:[DI],AL
        @SB2ChecX:  CMP    DX,[W]
                    JAE    @SB2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SB2ChecX
        @SB2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SB2LoopX
        @SB2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SB2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SB2SkipX
        @SB2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SB2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SB2LoopY
        @SBEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleOverRel ENDP

;******************************************************************************
;*    Procedra SpriteScaleRelVirtual (SegVirtual: Word; PSprite: Pointer;    *
;*                                     X, Y, Wide, Height, Step: Word);       *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*  X,Y s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu.   *
;******************************************************************************

PUBLIC SpriteScaleRelVirtual
SpriteScaleRelVirtual PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SKCont
                    JMP    @SKEnd
        @SKCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SKXStr
                    JMP    @SKXShr
        @SKXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SK1LoopY:  CMP    CX,[NY]
                    JNA    @SK1Cont
                    JMP    @SKEnd
        @SK1Cont:   MOV    DX,[W]
        @SK1LoopX:  CMP    BX,[NX]
                    JA     @SK1SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SK1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SK1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SK1LoopX
        @SK1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SK1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SK1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SK1LoopY
        @SKXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SK2LoopY:  CMP    CX,[NY]
                    JA     @SKEnd
                    MOV    DX,[NW]
        @SK2LoopX:  CMP    BX,[NX]
                    JA     @SK2SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SK2ChecX:  CMP    DX,[W]
                    JAE    @SK2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SK2ChecX
        @SK2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SK2LoopX
        @SK2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SK2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SK2SkipX
        @SK2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SK2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SK2LoopY
        @SKEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleRelVirtual ENDP

;******************************************************************************
;*  Procedra SpriteScaleOverRelVirtual (SegVirtual: Word; PSprite: Pointer;  *
;*                                       X, Y, Wide, Height, Step: Word);     *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*  X,Y s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu,   *
;*                  priom body s farbou 0 sa nevykresuj.                   *
;******************************************************************************

PUBLIC SpriteScaleOverRelVirtual
SpriteScaleOverRelVirtual PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SZCont
                    JMP    @SZEnd
        @SZCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SZXStr
                    JMP    @SZXShr
        @SZXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SZ1LoopY:  CMP    CX,[NY]
                    JNA    @SZ1Cont
                    JMP    @SZEnd
        @SZ1Cont:   MOV    DX,[W]
        @SZ1LoopX:  CMP    BX,[NX]
                    JA     @SZ1SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SZ1NoP
                    MOV    ES:[DI],AL
        @SZ1NoP:    CMP    DX,[NW]
                    JB     @SZ1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SZ1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SZ1LoopX
        @SZ1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SZ1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SZ1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SZ1LoopY
        @SZXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SZ2LoopY:  CMP    CX,[NY]
                    JA     @SZEnd
                    MOV    DX,[NW]
        @SZ2LoopX:  CMP    BX,[NX]
                    JA     @SZ2SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SZ2ChecX
                    MOV    ES:[DI],AL
        @SZ2ChecX:  CMP    DX,[W]
                    JAE    @SZ2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SZ2ChecX
        @SZ2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SZ2LoopX
        @SZ2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SZ2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SZ2SkipX
        @SZ2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SZ2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SZ2LoopY
        @SZEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleOverRelVirtual ENDP

;******************************************************************************
;*    Procedra CopySprite (SegSource, SegDestinaton, X1, Y1, X2, Y2: Word;   *
;*                          SWidth, SHeight: Byte);                           *
;*     Skopruje sprite z obrazovky na segmente SegSource z pozcie X1,Y1     *
;*  na obrazovku na segmente SegDestination na pozciu X2,Y2, priom sprite   *
;*                         m rozmer SWidth x SHeight                         *
;******************************************************************************

PUBLIC CopySprite
CopySprite PROC FAR
 ARG SHeight: Byte, SWidth: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word, SegDestination: Word, SegSource: Word
                    ENTER  0,0
                    PUSH   DS
                    MOV    AX,SegSource
                    MOV    DS,AX
                    MOV    AX,[Y2]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X2]
                    ADD    DI,CX
                    MOV    AX,[Y1]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    CX,[X1]
                    ADD    SI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    AND    BL,3
                    SHR    AL,2
                    MOV    CX,SegDestination
                    MOV    ES,CX
                    XOR    CX,CX
                    CLD
          @CSBegin: MOV    CL,AL
                    REP    MOVSD
                    MOV    CL,BL
                    REP    MOVSB
                    ADD    DI,DX
                    ADD    SI,DX
                    DEC    AH
                    JNZ    @CSBegin
                    POP    DS
                    LEAVE
                    RET    12
CopySprite ENDP

;******************************************************************************
;*                   Procedra SetSpritePage (SPage: Word);                   *
;*      Nastav premenn SpritePage tak, aby urovala segment obrazovky,      *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetSpritePage
SetSpritePage PROC FAR
 ARG SPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[SPage]
                    MOV    [SpritePage],AX
                    POP    BP
                    RET    2
SetSpritePage ENDP

;******************************************************************************
;*                        Funkcia GetSpritePage : Word;                       *
;*     Vrti hodnotu premennej SpritePage, obrazovky, do ktorej kreslme      *
;******************************************************************************

PUBLIC GetSpritePage
GetSpritePage PROC FAR
                    MOV    AX,[SpritePage]
                    RET
GetSpritePage ENDP

END