;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Screen

Model Medium

LOCALS

.286

.DATA

.CODE

EXTRN SetPalette : FAR            ; P O Z O R ! Do programu musia by
EXTRN ConvertRGBPalette : FAR     ; nalinkovan extern procedry (Palette.Asm)

;******************************************************************************
;*     truktra TPalBuf - dka 768 bytov, je to vlastne pomocn paleta      *
;******************************************************************************

TPalBuf STRUC
 DB 768 DUP (?)
ENDS

;******************************************************************************
;*                  Procedra ShowScreen (PScreen: Pointer);                  *
;*         Zobraz ALAC .OBR obrzok na obrazovku, nastav aj paletu          *
;******************************************************************************

PUBLIC ShowScreen
ShowScreen PROC FAR 
 ARG PScreen: DWord
 LOCAL Palette: TPalBuf = LocalVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,LocalVar
                    PUSH   DS
                    LDS    SI,[PScreen]
                    LEA    DX,Palette
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    MOV    BX,SI
                    ADD    BX,6
                    PUSHA
                    PUSH   DS
                    PUSH   BX
                    PUSH   SS
                    PUSH   DX
                    CALL   ConvertRGBPalette
                    POPA
                    PUSHA
                    PUSH   SS
                    PUSH   DX
                    CALL   SetPalette
                    POPA
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AX,0A000H
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    CX,7D00H
                    REP    MOVSW
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
ShowScreen ENDP

;******************************************************************************
;*            Procedra ShowCompressedScreen (PScreen: Pointer);              *
;*   Zobraz ALAC .POB komprimovan obrzok na obrazovku, nastav aj paletu   *
;******************************************************************************

PUBLIC ShowCompressedScreen
ShowCompressedScreen PROC FAR 
 ARG PScreen: DWord
 LOCAL Palette: TPalBuf
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,LocalVar
                    PUSH   DS
                    LDS    SI,[PScreen]
                    LEA    DX,Palette
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    MOV    BX,SI
                    ADD    BX,6
                    PUSHA
                    PUSH   DS
                    PUSH   BX
                    PUSH   SS
                    PUSH   DX
                    CALL   ConvertRGBPalette
                    POPA
                    PUSHA
                    PUSH   SS
                    PUSH   DX
                    CALL   SetPalette
                    POPA
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AL,DS:[SI]
                    INC    SI
                    MOV    BX,0A000H
                    MOV    ES,BX
                    XOR    BX,BX
                    XOR    CH,CH
         @SCSBegin: MOV    AH,DS:[SI]
                    CMP    AH,AL
                    JNZ    @SCSCont2
                    MOV    CL,DS:[SI+2]
                    MOV    AH,DS:[SI+1]
         @SCSLoop1: MOV    ES:[BX],AH
                    INC    BX
                    DEC    CL
                    JNZ    @SCSLoop1
                    ADD    SI,3
                    JMP    @SCSTest
         @SCSCont2: MOV    AH,DS:[SI]
                    MOV    ES:[BX],AH
                    INC    BX
                    INC    SI
         @SCSTest:  CMP    BX,0FA00H
                    JC     @SCSBegin
         @SCSEnd:   POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
ShowCompressedScreen ENDP

;******************************************************************************
;*                  Procedra SetScreen (PScreen: Pointer);                   *
;*          Zobraz ALAC .OBR obrzok na obrazovku, nenastav paletu          *
;******************************************************************************

PUBLIC SetScreen
SetScreen PROC FAR 
 ARG PScreen: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PScreen]
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AX,0A000H
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    CX,7D00H
                    REP    MOVSW
                    POP    DS
                    POP    BP
                    RET    4
SetScreen ENDP

;******************************************************************************
;*      Procedra SetScreenVirtual (SegVirtual: Word; PScreen: Pointer);      *
;*     Zobraz ALAC .OBR obrzok na virtulnu obrazovku, nenastav paletu     *
;******************************************************************************

PUBLIC SetScreenVirtual
SetScreenVirtual PROC FAR 
 ARG PScreen: DWord, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PScreen]
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    CX,7D00H
                    REP    MOVSW
                    POP    DS
                    POP    BP
                    RET    6
SetScreenVirtual ENDP

;******************************************************************************
;*               Procedra DeCompressScreen (PScreen: Pointer);               *
;*   Zobraz ALAC .POB komprimovan obrzok na obrazovku, nenastav paletu    *
;******************************************************************************

PUBLIC DeCompressScreen
DeCompressScreen PROC FAR 
 ARG PScreen: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PScreen]
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AL,DS:[SI]
                    INC    SI
                    MOV    BX,0A000H
                    MOV    ES,BX
                    XOR    BX,BX
                    XOR    CH,CH
         @DCSBegin: MOV    AH,DS:[SI]
                    CMP    AH,AL
                    JNZ    @DCSCont2
                    MOV    CL,DS:[SI+2]
                    MOV    AH,DS:[SI+1]
         @DCSLoop1: MOV    ES:[BX],AH
                    INC    BX
                    DEC    CL
                    JNZ    @DCSLoop1
                    ADD    SI,3
                    JMP    @DCSTest
         @DCSCont2: MOV    AH,DS:[SI]
                    MOV    ES:[BX],AH
                    INC    BX
                    INC    SI
         @DCSTest:  CMP    BX,0FA00H
                    JC     @DCSBegin
         @DCSEnd:   POP    DS
                    POP    BP
                    RET    4
DeCompressScreen ENDP

;******************************************************************************
;*     Procedra DeCompressVirtual (SegVirtual: Word; PScreen: Pointer);      *
;*       Zobraz ALAC .POB komprimovan obrzok na virtulnu obrazovku,       *
;*                              nenastav paletu                              *
;******************************************************************************

PUBLIC DeCompressVirtual
DeCompressVirtual PROC FAR 
 ARG PScreen: DWord, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PScreen]
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AL,DS:[SI]
                    INC    SI
                    MOV    BX,[SegVirtual]
                    MOV    ES,BX
                    XOR    BX,BX
                    XOR    CH,CH
        @DCSVBegin: MOV    AH,DS:[SI]
                    CMP    AH,AL
                    JNZ    @DCSVCont2
                    MOV    CL,DS:[SI+2]
                    MOV    AH,DS:[SI+1]
        @DCSVLoop1: MOV    ES:[BX],AH
                    INC    BX
                    DEC    CL
                    JNZ    @DCSVLoop1
                    ADD    SI,3
                    JMP    @DCSVTest
        @DCSVCont2: MOV    AH,DS:[SI]
                    MOV    ES:[BX],AH
                    INC    BX
                    INC    SI
        @DCSVTest:  CMP    BX,0FA00H
                    JC     @DCSVBegin
        @DCSVEnd:   POP    DS
                    POP    BP
                    RET    6
DeCompressVirtual ENDP

;******************************************************************************
;*   Procedra DeCompressOverVirtual (SegVirtual: Word; PScreen: Pointer);    *
;*       Zobraz ALAC .POB komprimovan obrzok na virtulnu obrazovku,       *
;*    body s farbou 0 sa nevykresuj, s transparentn, nenastav paletu     *
;******************************************************************************

PUBLIC DeCompressOverVirtual
DeCompressOverVirtual PROC FAR 
 ARG PScreen: DWord, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PScreen]
                    MOV    BX,SI
                    ADD    BX,4
                    MOV    AX,DS:[BX]
                    MOV    BX,AX
                    SHL    AX,1
                    ADD    AX,BX
                    ADD    SI,AX
                    ADD    SI,6
                    MOV    AL,DS:[SI]
                    INC    SI
                    MOV    BX,[SegVirtual]
                    MOV    ES,BX
                    XOR    BX,BX
                    XOR    CH,CH
        @DCOVBegin: MOV    AH,DS:[SI]
                    CMP    AH,AL
                    JNZ    @DCOVCont2
                    MOV    CL,DS:[SI+2]
                    MOV    AH,DS:[SI+1]
                    OR     AH,AH
                    JZ     @DCOVAddIt
        @DCOVLoop1: MOV    ES:[BX],AH
        @DCOVCont:  INC    BX
                    DEC    CL
                    JNZ    @DCOVLoop1
                    JMP    @DCOVNext
        @DCOVAddIt: ADD    BX,CX
        @DCOVNext:  ADD    SI,3
                    JMP    @DCOVTest
        @DCOVCont2: MOV    AH,DS:[SI]
                    OR     AH,AH
                    JZ     @DCOVCont3
                    MOV    ES:[BX],AH
        @DCOVCont3: INC    BX
                    INC    SI
        @DCOVTest:  CMP    BX,0FA00H
                    JC     @DCOVBegin
        @DCOVEnd:   POP    DS
                    POP    BP
                    RET    6
DeCompressOverVirtual ENDP

END