;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Cell

MODEL Small

LOCALS

.286

.DATA

CellPage   DW    0A000H

.CODE

;******************************************************************************
;*         Procedra Cell (PSprite: Pointer; X,Y: Word; Wdt,Hgt,X2,Y2,        *
;*                         NWdt,NHgt: Byte);                                  *
;*   Zo spritu, ktor m vekos Wdt x Hgt vykresl jeho as, ktor zana   *
;*    na sradniciach X2,Y2 v sprite a m rozmery NWdt x NHgt na sradnice    *
;*                             X,Y na obrazovke                               *
;******************************************************************************

PUBLIC Cell
Cell PROC FAR
 ARG NHgt: Byte, NWdt: Byte, Y2: Byte, X2: Byte, Hgt: Byte, Wdt: Byte, Y: Word, X: Word, PCell: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,[NHgt]
                    OR     AL,AL
                    JNZ    @CChk1
                    JMP    @COver
        @CChk1:     MOV    AL,[NWdt]
                    OR     AL,AL
                    JNZ    @CChk2
                    JMP    @COver
        @CChk2:     PUSH   DS
                    MOV    AX,[CellPage]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,AX
                    LDS    SI,[PCell]
                    XOR    AX,AX
                    MOV    AL,[Y2]
                    MOV    BL,[Wdt]
                    MUL    BL
                    ADD    SI,AX
                    XOR    AH,AH
                    MOV    AL,[X2]
                    ADD    SI,AX
                    MOV    DX,320
                    MOV    AL,[NWdt]
                    SUB    DX,AX
                    XOR    BH,BH
                    MOV    BL,[Wdt]
                    MOV    AL,[NWdt]
                    SUB    BX,AX
                    AND    AL,1
                    MOV    AH,[NHgt]
                    XOR    CH,CH
        @CLoop:     MOV    CL,[NWdt]
                    SHR    CL,1
                    REP    MOVSW
                    OR     AL,AL
                    JZ     @CLCont
                    MOVSB
        @CLCont:    ADD    DI,DX
                    ADD    SI,BX
                    DEC    AH
                    JNZ    @CLoop
                    POP    DS
        @COver:     POP    BP
                    RET    20
Cell ENDP

;******************************************************************************
;*       Procedra CellOver (PSprite: Pointer;X,Y: Word; Wdt,Hgt,X2,Y2,       *
;*                           NWdt,NHgt: Byte);                                *
;*   Zo spritu, ktor m vekos Wdt x Hgt vykresl jeho as, ktor zana   *
;*    na sradniciach X2,Y2 v sprite a m rozmery NWdt x NHgt na sradnice    *
;*            X,Y na obrazovke, priom nevykresuje body s farbou 0           *
;******************************************************************************

PUBLIC CellOver
CellOver PROC FAR
 ARG NHgt: Byte, NWdt: Byte, Y2: Byte, X2: Byte, Hgt: Byte, Wdt: Byte, Y: Word, X: Word, PCell: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,[NHgt]
                    OR     AL,AL
                    JNZ    @COChk1
                    JMP    @COOver
        @COChk1:    MOV    AL,[NWdt]
                    OR     AL,AL
                    JNZ    @COChk2
                    JMP    @COOver
        @COChk2:    PUSH   DS
                    MOV    AX,[CellPage]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,AX
                    LDS    SI,[PCell]
                    XOR    AX,AX
                    MOV    AL,[Y2]
                    MOV    BL,[Wdt]
                    MUL    BL
                    ADD    SI,AX
                    XOR    AH,AH
                    MOV    AL,[X2]
                    ADD    SI,AX
                    MOV    DX,320
                    MOV    AL,[NWdt]
                    SUB    DX,AX
                    XOR    BH,BH
                    MOV    BL,[Wdt]
                    MOV    AL,[NWdt]
                    SUB    BX,AX
                    MOV    CH,[NHgt]
        @COLoop:    MOV    CL,[NWdt]
        @COILoop:   LODSB
                    OR     AL,AL
                    JZ     @COLC
                    STOSB
                    JMP    @COLCont
        @COLC:      INC    DI
        @COLCont:   DEC    CL
                    JNZ    @COILoop
                    ADD    DI,DX
                    ADD    SI,BX
                    DEC    CH
                    JNZ    @COLoop
                    POP    DS
        @COOver:    POP    BP
                    RET    20
CellOver ENDP

;******************************************************************************
;*     Procedra CellVirtual (SegVirtual: Word; PSprite: Pointer; X,Y: Word;  *
;*                            Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);                 *
;*   Zo spritu, ktor m vekos Wdt x Hgt vykresl jeho as, ktor zana   *
;*    na sradniciach X2,Y2 v sprite a m rozmery NWdt x NHgt na sradnice    *
;*                 X,Y na obrazovke na segmente SegVirtual                    *
;******************************************************************************

PUBLIC CellVirtual
CellVirtual PROC FAR
 ARG NHgt: Byte, NWdt: Byte, Y2: Byte, X2: Byte, Hgt: Byte, Wdt: Byte, Y: Word, X: Word, PCell: DWord, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,[NHgt]
                    OR     AL,AL
                    JNZ    @CVChk1
                    JMP    @CVOver
        @CVChk1:    MOV    AL,[NWdt]
                    OR     AL,AL
                    JNZ    @CVChk2
                    JMP    @CVOver
        @CVChk2:    PUSH   DS
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,AX
                    LDS    SI,[PCell]
                    XOR    AX,AX
                    MOV    AL,[Y2]
                    MOV    BL,[Wdt]
                    MUL    BL
                    ADD    SI,AX
                    XOR    AH,AH
                    MOV    AL,[X2]
                    ADD    SI,AX
                    MOV    DX,320
                    MOV    AL,[NWdt]
                    SUB    DX,AX
                    XOR    BH,BH
                    MOV    BL,[Wdt]
                    MOV    AL,[NWdt]
                    SUB    BX,AX
                    AND    AL,1
                    MOV    AH,[NHgt]
                    XOR    CH,CH
        @CVLoop:    MOV    CL,[NWdt]
                    SHR    CL,1
                    REP    MOVSW
                    OR     AL,AL
                    JZ     @CVLCont
                    MOVSB
        @CVLCont:   ADD    DI,DX
                    ADD    SI,BX
                    DEC    AH
                    JNZ    @CVLoop
                    POP    DS
        @CVOver:    POP    BP
                    RET    20
CellVirtual ENDP

;******************************************************************************
;*  Procedra CellOverVirtual (SegVirtual: Word; PSprite: Pointer;X,Y: Word;  *
;*                             Wdt,Hgt,X2,Y2,NWdt,NHgt: Byte);                *
;*   Zo spritu, ktor m vekos Wdt x Hgt vykresl jeho as, ktor zana   *
;*  na sradniciach X2,Y2 v sprite a m rozmery NWdt x NHgt na sradnice X,Y  *
;*  na obrazovke na segmente SegVirtual, priom nevykresuje body s farbou 0  *
;******************************************************************************

PUBLIC CellOverVirtual
CellOverVirtual PROC FAR
 ARG NHgt: Byte, NWdt: Byte, Y2: Byte, X2: Byte, Hgt: Byte, Wdt: Byte, Y: Word, X: Word, PCell: DWord, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,[NHgt]
                    OR     AL,AL
                    JNZ    @COVChk1
                    JMP    @COVOver
        @COVChk1:   MOV    AL,[NWdt]
                    OR     AL,AL
                    JNZ    @COVChk2
                    JMP    @COVOver
        @COVChk2:   PUSH   DS
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,AX
                    LDS    SI,[PCell]
                    XOR    AX,AX
                    MOV    AL,[Y2]
                    MOV    BL,[Wdt]
                    MUL    BL
                    ADD    SI,AX
                    XOR    AH,AH
                    MOV    AL,[X2]
                    ADD    SI,AX
                    MOV    DX,320
                    MOV    AL,[NWdt]
                    SUB    DX,AX
                    XOR    BH,BH
                    MOV    BL,[Wdt]
                    MOV    AL,[NWdt]
                    SUB    BX,AX
                    MOV    CH,[NHgt]
        @COVLoop:   MOV    CL,[NWdt]
        @COVILoop:  LODSB
                    OR     AL,AL
                    JZ     @COVLC
                    STOSB
                    JMP    @COVLCont
        @COVLC:     INC    DI
        @COVLCont:  DEC    CL
                    JNZ    @COVILoop
                    ADD    DI,DX
                    ADD    SI,BX
                    DEC    CH
                    JNZ    @COVLoop
                    POP    DS
        @COVOver:   POP    BP
                    RET    20
CellOverVirtual ENDP

;******************************************************************************
;*                    Procedra SetCellPage (CPage: Word);                    *
;*       Nastav premenn CellPage tak, aby urovala segment obrazovky,       *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetCellPage
SetCellPage PROC FAR
 ARG CPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[CPage]
                    MOV    [CellPage],AX
                    POP    BP
                    RET    2
SetCellPage ENDP

;******************************************************************************
;*                         Funkcia GetCellPage : Word;                        *
;*      Vrti hodnotu premennej CellPage, obrazovky, do ktorej kreslme       *
;******************************************************************************

PUBLIC GetCellPage
GetCellPage PROC FAR
                    MOV    AX,[CellPage]
                    RET
GetCellPage ENDP

END