;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Box

MODEL Small

.386

.DATA

BoxPage   DW    0A000H

.CODE

;******************************************************************************
;*           Procedra DrawBox (X1, Y1, X2, Y2: Word; Color: Byte);           *
;*       Vykresl vntro obdnika s farbou Color, ktorho jeden roh m       *
;*                sradnice X1, Y1 a druh roh sradnice X2, Y2.              *
;******************************************************************************

PUBLIC DrawBox
DrawBox PROC FAR
 ARG Color: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word
 LOCAL Count: Word
                    ENTER  2,0
                    MOV    AX,[Y1]                  ;Porovnanie Y1 a Y2
                    MOV    BX,[Y2]
                    CMP    AX,BX
                    JNA    @DBPX                    ;Ak Y1<=Y2, cho alej
                    MOV    [Y1],BX                  ;Inak vyme Y1 s Y2
                    MOV    [Y2],AX
         @DBPX:     MOV    AX,[X1]                  ;Porovnanie X1 a X2
                    MOV    BX,[X2]
                    CMP    AX,BX
                    JNA    @DBDo                    ;Ak X1<=X2, cho alej
                    MOV    [X1],BX                  ;Inak vyme X1 s X2
                    MOV    [X2],AX
         @DBDo:     MOV    AX,[Y1]                  ;Adresa = X+Y*320
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    BX,[Y2]                  ;Vka obdnika
                    SUB    BX,[Y1]
                    INC    BX
                    ADD    DI,[X1]                  ;Dka obdnika
                    XOR    ECX,ECX
                    MOV    CX,[X2]
                    SUB    CX,[X1]
                    INC    CX
                    MOV    AX,[BoxPage]
                    MOV    ES,AX
                    MOV    DX,320                   ;Rozdiel medzi riadkami
                    SUB    DX,CX
                    MOV    SI,CX
                    XCHG   AH,AL
                    SHR    CX,2
                    MOV    [Count],CX
                    AND    SI,3
                    MOV    AL,[Color]
                    MOV    AH,AL
                    PUSH   AX
                    SHL    EAX,16
                    POP    AX
         @DBBegin:  REP    STOSD
                    MOV    CX,SI
                    REP    STOSB
                    MOV    CX,[Count]
                    ADD    DI,DX
                    DEC    BX
                    JNZ    @DBBegin
                    LEAVE
                    RET    10
DrawBox ENDP

;******************************************************************************
;*     Procedra DrawBoxRel (X1, Y1, BWidth, BHeight: Word; Color: Byte);     *
;*     Vykresl vntro obdnika s farbou Color, ktorho av horn roh m    *
;*            sradnice X1, Y1, so rkou BWidth a vkou BHeight             *
;******************************************************************************

PUBLIC DrawBoxRel
DrawBoxRel PROC FAR
 ARG Color: Byte, BHeight: Word, BWidth: Word, Y: Word, X: Word
 LOCAL Count: Word
                    ENTER  2,0
                    CMP    [BHeight],0
                    JZ     @DREnd
                    CMP    [BWidth],0
                    JZ     @DREnd
                    MOV    AX,[Y1]                  ;Adresa = X+Y*320
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    BX,[BHeight]             ;Vka obdnika
                    ADD    DI,[X]                   ;Dka obdnika
                    XOR    ECX,ECX
                    MOV    CX,[BWidth]
                    MOV    AX,[BoxPage]
                    MOV    ES,AX
                    MOV    DX,320                   ;Rozdiel medzi riadkami
                    SUB    DX,CX
                    MOV    SI,CX
                    XCHG   AH,AL
                    SHR    CX,2
                    MOV    [Count],CX
                    AND    SI,3
                    MOV    AL,[Color]
                    MOV    AH,AL
                    PUSH   AX
                    SHL    EAX,16
                    POP    AX
         @DRBegin:  REP    STOSD
                    MOV    CX,SI
                    REP    STOSB
                    MOV    CX,[Count]
                    ADD    DI,DX
                    DEC    BX
                    JNZ    @DRBegin
         @DREnd:    LEAVE
                    RET    10
DrawBoxRel ENDP

;******************************************************************************
;*       Procedra DrawBoxVirtual (X1, Y1, X2, Y2: Word; Color: Byte);        *
;*       Vykresl vntro obdnika s farbou Color, ktorho jeden roh m       *
;*    sradnice X1, Y1 a druh roh sradnice X2, Y2 na virtulnu obrazovku    *
;******************************************************************************

PUBLIC DrawBoxVirtual
DrawBoxVirtual PROC FAR
 ARG Color: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word, SegVirtual: Word
 LOCAL Count: Word
                    ENTER  2,0
                    MOV    AX,[Y1]                  ;Porovnanie Y1 a Y2
                    MOV    BX,[Y2]
                    CMP    AX,BX
                    JNA    @DVPX                    ;Ak Y1<=Y2, cho alej
                    MOV    [Y1],BX                  ;Inak vyme Y1 s Y2
                    MOV    [Y2],AX
         @DVPX:     MOV    AX,[X1]                  ;Porovnanie X1 a X2
                    MOV    BX,[X2]
                    CMP    AX,BX
                    JNA    @DVDo                    ;Ak X1<=X2, cho alej
                    MOV    [X1],BX                  ;Inak vyme X1 s X2
                    MOV    [X2],AX
         @DVDo:     MOV    AX,[Y1]                  ;Adresa = X+Y*320
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    BX,[Y2]                  ;Vka obdnika
                    SUB    BX,[Y1]
                    INC    BX
                    ADD    DI,[X1]                  ;Dka obdnika
                    XOR    ECX,ECX
                    MOV    CX,[X2]
                    SUB    CX,[X1]
                    INC    CX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    DX,320                   ;Rozdiel medzi riadkami
                    SUB    DX,CX
                    MOV    SI,CX
                    XCHG   AH,AL
                    SHR    CX,2
                    MOV    [Count],CX
                    AND    SI,3
                    MOV    AL,[Color]
                    MOV    AH,AL
                    PUSH   AX
                    SHL    EAX,16
                    POP    AX
         @DVBegin:  REP    STOSD
                    MOV    CX,SI
                    REP    STOSB
                    MOV    CX,[Count]
                    ADD    DI,DX
                    DEC    BX
                    JNZ    @DVBegin
                    LEAVE
                    RET    12
DrawBoxVirtual ENDP

;******************************************************************************
;* Procedra DrawBoxRelVirtual (X1, Y1, BWidth, BHeight: Word; Color: Byte);  *
;*     Vykresl vntro obdnika s farbou Color, ktorho av horn roh m    *
;* sradnice X1, Y1 so rkou BWidth a vkou BHeight na virtulnu obrazovku  *
;******************************************************************************

PUBLIC DrawBoxRelVirtual
DrawBoxRelVirtual PROC FAR
 ARG Color: Byte,BHeight: Word,BWidth: Word,Y: Word,X: Word,SegVirtual: Word
 LOCAL Count: Word
                    ENTER  2,0
                    CMP    [BHeight],0
                    JZ     @DIEnd
                    CMP    [BWidth],0
                    JZ     @DIEnd
                    MOV    AX,[Y1]                  ;Adresa = X+Y*320
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    BX,[BHeight]             ;Vka obdnika
                    ADD    DI,[X]                   ;Dka obdnika
                    XOR    ECX,ECX
                    MOV    CX,[BWidth]
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    DX,320                   ;Rozdiel medzi riadkami
                    SUB    DX,CX
                    MOV    SI,CX
                    XCHG   AH,AL
                    SHR    CX,2
                    MOV    [Count],CX
                    AND    SI,3
                    MOV    AL,[Color]
                    MOV    AH,AL
                    PUSH   AX
                    SHL    EAX,16
                    POP    AX
         @DIBegin:  REP    STOSD
                    MOV    CX,SI
                    REP    STOSB
                    MOV    CX,[Count]
                    ADD    DI,DX
                    DEC    BX
                    JNZ    @DIBegin
         @DIEnd:    LEAVE
                    RET    12
DrawBoxRelVirtual ENDP

;******************************************************************************
;*                    Procedra SetBoxPage (BPage: Word);                     *
;*       Nastav premenn BoxPage tak, aby urovala segment obrazovky,        *
;*                          do ktorej chceme psa                            *
;******************************************************************************

PUBLIC SetBoxPage
SetBoxPage PROC FAR
 ARG BPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[BPage]
                    MOV    [BoxPage],AX
                    POP    BP
                    RET    2
SetBoxPage ENDP

;******************************************************************************
;*                         Funkcia GetBoxPage : Word;                         *
;*       Vrti hodnotu premennej BoxPage, obrazovky, do ktorej kreslme       *
;******************************************************************************

PUBLIC GetBoxPage
GetBoxPage PROC FAR
                    MOV    AX,[BoxPage]
                    RET
GetBoxPage ENDP

END