;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Sprite

Model Medium

LOCALS

.286

.DATA

SpritePage   DW    0A000H          ;Segment obrazovky

.CODE

;******************************************************************************
;*                     Funkcia Adress (X,Y: Word): Word;                      *
;*          Vracia adresu (X-1)*8+(Y-1)*8*320, pouva ju DrawSprite          *
;*                    Obrazovka je ako pole [1..40,1..25]                     *
;******************************************************************************

PUBLIC Adress
Adress PROC FAR
 ARG Y: Word, X: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    DEC     AX
                    SHL     AX,3
                    MOV     DX,AX
                    SHL     AX,8
                    SHL     DX,6
                    ADD     AX,DX
                    MOV     DX,[X]
                    DEC     DX
                    SHL     DX,3
                    ADD     AX,DX
                    POP     BP
                    RET     4
Adress ENDP

;******************************************************************************
;*     Procedra DrawSpriteXY (PSprite: Pointer; X,Y: Word; Count: Byte);     *
;*     Vykresl (Count+1).sprite s rozmermi 8x8, na ktor ukazuje PSprite,    *
;*                        na pozcu X,Y na obrazovke                          *
;*   X je kad 8.stpec, Y je kad 8.riadok (obrazovka m rozmer 40 x 25)   *
;******************************************************************************

PUBLIC DrawSpriteXY
DrawSpriteXY PROC FAR 
 ARG Count: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   [X]
                    PUSH   [Y]
                    CALL   Adress
                    PUSH   SI
                    XCHG   AX,SI
                    LES    BX,[PSprite]
                    MOV    AL,[Count]
                    XOR    AH,AH
                    SHL    AX,6
                    ADD    BX,AX
                    MOV    AX,0808H
                    PUSH   DS
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
         @BeginXY:  MOV    CL,ES:[BX]
                    INC    BX
                    MOV    DS:[SI],CL
                    INC    SI
                    DEC    AL
                    JNZ    @BeginXY
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @BeginXY
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    10
DrawSpriteXY ENDP

;******************************************************************************
;*      Procedra DrawSprite (PSprite: Pointer; X,Y: Word; Count: Byte);      *
;*     Vykresl (Count+1).sprite s rozmermi 8x8, na ktor ukazuje PSprite,    *
;*                        na pozcu X,Y na obrazovke                          *
;******************************************************************************

PUBLIC DrawSprite
DrawSprite PROC FAR
 ARG Count: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   SI
                    LES    BX,[PSprite]
                    MOV    AL,[Count]
                    XOR    AH,AH
                    SHL    AX,6
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    CX,[X]
                    MOV    DX,320
                    MUL    DX
                    ADD    AX,CX
                    MOV    SI,AX
                    MOV    AX,0808H
                    PUSH   DS
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
         @DSBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    MOV    DS:[SI],CL
                    INC    SI
                    DEC    AL
                    JNZ    @DSBegin
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @DSBegin
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    10
DrawSprite ENDP

;******************************************************************************
;*    Procedra DrawSpriteOver (PSprite: Pointer; X,Y: Word; Count: Byte);    *
;*     Vykresl (Count+1).sprite s rozmermi 8x8, na ktor ukazuje PSprite,    *
;*  na pozcu X,Y na obrazovke, priom 0 je transparentn farba (ak sa zist  *
;*                0 v sprite, ni sa na obrazovku nekresl)                   *
;******************************************************************************

PUBLIC DrawSpriteOver
DrawSpriteOver PROC FAR
 ARG Count: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   SI
                    LES    BX,[PSprite]
                    MOV    AL,Count
                    XOR    AH,AH
                    SHL    AX,6
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    CX,[X]
                    MOV    SI,320
                    MUL    SI
                    ADD    AX,CX
                    XCHG   SI,AX
                    MOV    AX,0808H
                    PUSH   DS
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
          @OBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @OCont
                    MOV    DS:[SI],CL
           @OCont:  INC    SI
                    DEC    AL
                    JNZ    @OBegin
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @OBegin
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    10
DrawSpriteOver ENDP

;******************************************************************************
;*   Procedra Sprite (PSprite: Pointer, X,Y: Word; SWidth, SHeight: Byte);   *
;*  Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y, priom SWidth  *
;*                   je rka a SHeight je vka spritu                       *
;******************************************************************************

PUBLIC Sprite
Sprite PROC FAR
 ARG SHeight: Byte, SWidth: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,1
                    AND    BL,1
                    MOV    CX,[SpritePage]
                    MOV    ES,CX
                    LDS    SI,[PSprite]
                    XOR    CX,CX
                    CLD
           @SBegin: MOV    CL,AL
                    REP    MOVSW
                    OR     BL,BL
                    JZ     @SAdd
                    MOVSB
           @SAdd:   ADD    DI,DX
                    DEC    AH
                    JNZ    @SBegin
                    POP    DS
                    POP    BP
                    RET    12
Sprite ENDP

;******************************************************************************
;* Procedra SpriteOver (PSprite: Pointer, X,Y: Word; SWidth, SHeight: Byte); *
;*  Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y, priom SWidth  *
;*         je rka, SHeight je vka spritu a 0 je transparetn farba        *
;******************************************************************************

PUBLIC SpriteOver
SpriteOver PROC FAR
 ARG SHeight: Byte, SWidth: Byte, Y: Word, X: Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    BH,[SHeight]
                    MOV    BL,[SWidth]
                    MOV    DX,320
                    MOV    AX,BX
                    AND    AX,0FFH
                    SUB    DX,AX
                    MOV    CX,[SpritePage]
                    MOV    ES,CX
                    LDS    SI,[PSprite]
                    XOR    CX,CX
                    CLD
          @SOBegin: MOV    CL,BL
          @SOBegan: LODSB
                    OR     AL,AL
                    JZ     @SOStay
                    STOSB
                    JMP    @SOCont
          @SOStay:  INC    DI
          @SOCont:  LOOP   @SOBegan
                    ADD    DI,DX
                    DEC    BH
                    JNZ    @SOBegin
                    POP    DS
                    POP    BP
                    RET    12
SpriteOver ENDP

;******************************************************************************
;*Procedra SpriteVirtual (SegVirtual: Word, PSprite:Pointer, X,Y:Word;       *
;*                         SWidth, SHeight:Byte);                             *
;*   Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y vo virtulnej  *
;*        obrazovke, priom SWidth je rka a SHeight je vka spritu.        *
;******************************************************************************

PUBLIC SpriteVirtual
SpriteVirtual PROC FAR
 ARG SHeight: Byte,SWidth: Byte,Y: Word,X: Word,PSprite: DWord,SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PSprite]
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    CX,[SegVirtual]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,1
                    AND    BL,1
                    MOV    ES,CX
                    XOR    CX,CX
                    CLD
          @SVBegin: MOV    CL,AL
                    REP    MOVSW
                    OR     BL,BL
                    JZ     @SVAdd
                    MOVSB
          @SVAdd:   ADD    DI,DX
                    DEC    AH
                    JNZ    @SVBegin
                    POP    DS
                    POP    BP
                    RET    14
SpriteVirtual ENDP

;******************************************************************************
;* Procedra SpriteOverVirtual (SegVirtual: Word, PSprite:Pointer, X,Y:Word;  *
;*                              SWidth, SHeight:Byte);                        *
;*   Vykresl sprite, na ktor ukazuje PSprite, na pozciu X,Y vo virtulnej  *
;*      obrazovke, priom SWidth je rka, SHeight je vka spritu a 0 je     *
;*                            transparentnou farbou.                          *
;******************************************************************************

PUBLIC SpriteOverVirtual
SpriteOverVirtual PROC FAR
 ARG SHeight: Byte,SWidth: Byte,Y: Word,X: Word,PSprite: DWord,SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    LDS    SI,[PSprite]
                    MOV    AX,[Y]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X]
                    ADD    DI,CX
                    MOV    BH,[SHeight]
                    MOV    BL,[SWidth]
                    MOV    CX,[SegVirtual]
                    PUSH   CX
                    MOV    DX,320
                    MOV    AX,BX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    CX
                    MOV    ES,CX
                    XOR    CX,CX
                    CLD
         @SOVBegin: MOV    CL,BL
         @SOVBegan: LODSB
                    OR     AL,AL
                    JZ     @SOVStay
                    STOSB
                    JMP    @SOVCont
         @SOVStay:  INC    DI
         @SOVCont:  LOOP   @SOVBegan
                    ADD    DI,DX
                    DEC    BH
                    JNZ    @SOVBegin
                    POP    DS
                    POP    BP
                    RET    14
SpriteOverVirtual ENDP

;******************************************************************************
;* Procedra GetSprite (PSprite: Pointer, X,Y: Word; SWidth, SHeight: Byte);  *
;*    Ulo sprite z pozcie X,Y obrazovky do pamte na miesto, kde ukazuje   *
;*         PSprite, priom SWidth je rka a SHeight je vka spritu.         *
;******************************************************************************

PUBLIC GetSprite
GetSprite PROC FAR
 ARG SHeight: Byte, SWidth:Byte, Y:Word, X:Word, PSprite: DWord
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    CX,[X]
                    ADD    SI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    SHR    AL,1
                    AND    BL,1
                    MOV    CX,[SpritePage]
                    MOV    DS,CX
                    LES    DI,[PSprite]
                    XOR    CX,CX
                    CLD
          @GSBegin: MOV    CL,AL
                    REP    MOVSW
                    OR     BL,BL
                    JZ     @GSAdd
                    MOVSB
          @GSAdd:   ADD    SI,DX
                    DEC    AH
                    JNZ    @GSBegin
                    POP    DS
                    POP    BP
                    RET    12
GetSprite ENDP

;******************************************************************************
;*      Procedra GetSpriteVirtual (SegVirtual: Word; PSprite: Pointer, X,Y:  *
;*                                  Word; SWidth,SHeight: Byte);              *
;*  Ulo sprite z pozcie X,Y virtulnej obrazovky do pamte na miesto, kde  *
;*     ukazuje PSprite, priom SWidth je rka a SHeight je vka spritu.     *
;******************************************************************************

PUBLIC GetSpriteVirtual
GetSpriteVirtual PROC FAR
 ARG SHeight: Byte,SWidth: Byte,Y: Word,X: Word,PSprite: DWord,SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   SI
                    LES    BX,[PSprite]
                    MOV    AX,[Y]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    CX,[X]
                    ADD    SI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    CX,[SegVirtual]
                    PUSH   DS
                    MOV    DS,CX
                    MOV    CH,AL
        @GSVBegin:  MOV    CL,DS:[SI]
                    MOV    ES:[BX],CL
                    INC    BX
                    INC    SI
                    DEC    AL
                    JNZ    @GSVBegin
                    ADD    SI,DX
                    MOV    AL,CH
                    DEC    AH
                    JNZ    @GSVBegin
                    POP    DS
                    POP    SI
                    POP    BP
                    RET    14
GetSpriteVirtual ENDP

;******************************************************************************
;* Procedra SpriteScale (PSprite: Pointer; X, Y, Wide, Height: Word;         *
;*                        NewWide, NewHeight: Word);                          *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii X,Y,    *
;*                priom jeho rozmery bud NewWide x NewHeight.               *
;******************************************************************************

PUBLIC SpriteScale
SpriteScale PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SSXStr
                    JMP    @SSXShr
        @SSXStr:    MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SSY1Str
                    JMP    @SSY1Shr
        @SSY1Str:   MOV    AX,[H]
                    MOV    [PY],AX
        @SS1LoopY:  CMP    CX,[NY]
                    JNA    @SS1Cont
                    JMP    @SSEnd
        @SS1Cont:   MOV    DX,[W]
        @SS1LoopX:  CMP    BX,[NX]
                    JA     @SS1SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SS1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SS1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SS1LoopX
        @SS1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SS1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SS1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SS1LoopY
        @SSY1Shr:   MOV    AX,[NH]
                    MOV    [PY],AX
        @SS2LoopY:  CMP    CX,[NY]
                    JNA    @SS2Cont
                    JMP    @SSEnd
        @SS2Cont:   MOV    DX,[W]
        @SS2LoopX:  CMP    BX,[NX]
                    JA     @SS2SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SS2NextX
                    INC    SI
                    SUB    DX,[NW]
        @SS2NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SS2LoopX
        @SS2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SS2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SS2SkipX
        @SS2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SS2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SS2LoopY
        @SSXShr:    MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SSY2Str
                    JMP    @SSY2Shr
        @SSY2Str:   MOV    AX,[H]
                    MOV    [PY],AX
        @SS3LoopY:  CMP    CX,[NY]
                    JNA    @SS3Cont
                    JMP    @SSEnd
        @SS3Cont:   MOV    DX,[NW]
        @SS3LoopX:  CMP    BX,[NX]
                    JA     @SS3SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SS3ChecX:  CMP    DX,[W]
                    JAE    @SS3NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SS3ChecX
        @SS3NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SS3LoopX
        @SS3SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SS3NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SS3NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SS3LoopY
        @SSY2Shr:   MOV    AX,[NH]
                    MOV    [PY],AX
        @SS4LoopY:  CMP    CX,[NY]
                    JA     @SSEnd
                    MOV    DX,[NW]
        @SS4LoopX:  CMP    BX,[NX]
                    JA     @SS4SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SS4ChecX:  CMP    DX,[W]
                    JAE    @SS4NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SS4ChecX
        @SS4NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SS4LoopX
        @SS4SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SS4YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SS4SkipX
        @SS4YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SS4NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SS4LoopY
        @SSEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    16
SpriteScale ENDP

;******************************************************************************
;* Procedra SpriteScaleVirtual (SegVirtual: Word; PSprite: Pointer;          *
;*                               X,Y,Wide,Height,NewWide,NewHeight: Word);    *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*             X,Y, priom jeho rozmery bud NewWide x NewHeight.             *
;******************************************************************************

PUBLIC SpriteScaleVirtual
SpriteScaleVirtual PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SSVXStr
                    JMP    @SSVXShr
        @SSVXStr:   MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SSVY1Str
                    JMP    @SSVY1Shr
        @SSVY1Str:  MOV    AX,[H]
                    MOV    [PY],AX
        @SSV1LoopY: CMP    CX,[NY]
                    JNA    @SSV1Cont
                    JMP    @SSVEnd
        @SSV1Cont:  MOV    DX,[W]
        @SSV1LoopX: CMP    BX,[NX]
                    JA     @SSV1SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SSV1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SSV1NextX: ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SSV1LoopX
        @SSV1SkipX: MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SSV1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SSV1NextY: ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SSV1LoopY
        @SSVY1Shr:  MOV    AX,[NH]
                    MOV    [PY],AX
        @SSV2LoopY: CMP    CX,[NY]
                    JNA    @SSV2Cont
                    JMP    @SSVEnd
        @SSV2Cont:  MOV    DX,[W]
        @SSV2LoopX: CMP    BX,[NX]
                    JA     @SSV2SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SSV2NextX
                    INC    SI
                    SUB    DX,[NW]
        @SSV2NextX: ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SSV2LoopX
        @SSV2SkipX: MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SSV2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SSV2SkipX
        @SSV2YFill: SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SSV2NextY: ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SSV2LoopY
        @SSVXShr:   MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SSVY2Str
                    JMP    @SSVY2Shr
        @SSVY2Str:  MOV    AX,[H]
                    MOV    [PY],AX
        @SSV3LoopY: CMP    CX,[NY]
                    JNA    @SSV3Cont
                    JMP    @SSVEnd
        @SSV3Cont:  MOV    DX,[NW]
        @SSV3LoopX: CMP    BX,[NX]
                    JA     @SSV3SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SSV3ChecX: CMP    DX,[W]
                    JAE    @SSV3NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SSV3ChecX
        @SSV3NextX: SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SSV3LoopX
        @SSV3SkipX: MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SSV3NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SSV3NextY: ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SSV3LoopY
        @SSVY2Shr:  MOV    AX,[NH]
                    MOV    [PY],AX
        @SSV4LoopY: CMP    CX,[NY]
                    JA     @SSVEnd
                    MOV    DX,[NW]
        @SSV4LoopX: CMP    BX,[NX]
                    JA     @SSV4SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SSV4ChecX: CMP    DX,[W]
                    JAE    @SSV4NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SSV4ChecX
        @SSV4NextX: SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SSV4LoopX
        @SSV4SkipX: MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SSV4YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SSV4SkipX
        @SSV4YFill: SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SSV4NextY: ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SSV4LoopY
        @SSVEnd:    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    18
SpriteScaleVirtual ENDP

;******************************************************************************
;*      Procedra SpriteScaleOver (PSprite: Pointer; X, Y, Wide, Height,      *
;*                                 NewWide, NewHeight: Word);                 *
;*  Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii ZX,ZY,  *
;*       priom jeho rozmery bud NewWide x NewHeight a body s farbou 0       *
;*                              sa nevykresuj.                              *
;******************************************************************************

PUBLIC SpriteScaleOver
SpriteScaleOver PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SOXStr
                    JMP    @SOXShr
        @SOXStr:    MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SOY1Str
                    JMP    @SOY1Shr
        @SOY1Str:   MOV    AX,[H]
                    MOV    [PY],AX
        @SO1LoopY:  CMP    CX,[NY]
                    JNA    @SO1Cont
                    JMP    @SOEnd
        @SO1Cont:   MOV    DX,[W]
        @SO1LoopX:  CMP    BX,[NX]
                    JA     @SO1SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SO1NoP
                    MOV    ES:[DI],AL
        @SO1NoP:    CMP    DX,[NW]
                    JB     @SO1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SO1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SO1LoopX
        @SO1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SO1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SO1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SO1LoopY
        @SOY1Shr:   MOV    AX,[NH]
                    MOV    [PY],AX
        @SO2LoopY:  CMP    CX,[NY]
                    JNA    @SO2Cont
                    JMP    @SOEnd
        @SO2Cont:   MOV    DX,[W]
        @SO2LoopX:  CMP    BX,[NX]
                    JA     @SO2SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SO2NoP
                    MOV    ES:[DI],AL
        @SO2NoP:    CMP    DX,[NW]
                    JB     @SO2NextX
                    INC    SI
                    SUB    DX,[NW]
        @SO2NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SO2LoopX
        @SO2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SO2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SO2SkipX
        @SO2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SO2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SO2LoopY
        @SOXShr:    MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SOY2Str
                    JMP    @SOY2Shr
        @SOY2Str:   MOV    AX,[H]
                    MOV    [PY],AX
        @SO3LoopY:  CMP    CX,[NY]
                    JNA    @SO3Cont
                    JMP    @SOEnd
        @SO3Cont:   MOV    DX,[NW]
        @SO3LoopX:  CMP    BX,[NX]
                    JA     @SO3SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SO3ChecX
                    MOV    ES:[DI],AL
        @SO3ChecX:  CMP    DX,[W]
                    JAE    @SO3NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SO3ChecX
        @SO3NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SO3LoopX
        @SO3SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SO3NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SO3NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SO3LoopY
        @SOY2Shr:   MOV    AX,[NH]
                    MOV    [PY],AX
        @SO4LoopY:  CMP    CX,[NY]
                    JA     @SOEnd
                    MOV    DX,[NW]
        @SO4LoopX:  CMP    BX,[NX]
                    JA     @SO4SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SO4ChecX
                    MOV    ES:[DI],AL
        @SO4ChecX:  CMP    DX,[W]
                    JAE    @SO4NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SO4ChecX
        @SO4NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SO4LoopX
        @SO4SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SO4YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SO4SkipX
        @SO4YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SO4NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SO4LoopY
        @SOEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    16
SpriteScaleOver ENDP

;******************************************************************************
;*   Procedra SpriteScaleOverVirtual (SegVirtual: Word; PSprite: Pointer;    *
;*                            X, Y, Wide, Height, NewWide, NewHeight: Word);  *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*    X,Y, priom jeho rozmery bud NewWide x NewHeight a body s farbou 0     *
;*                               sa nevykresuj.                             *
;******************************************************************************

PUBLIC SpriteScaleOverVirtual
SpriteScaleOverVirtual PROC FAR
 ARG NH: Word, NW: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SLXStr
                    JMP    @SLXShr
        @SLXStr:    MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SLY1Str
                    JMP    @SLY1Shr
        @SLY1Str:   MOV    AX,[H]
                    MOV    [PY],AX
        @SL1LoopY:  CMP    CX,[NY]
                    JNA    @SL1Cont
                    JMP    @SLEnd
        @SL1Cont:   MOV    DX,[W]
        @SL1LoopX:  CMP    BX,[NX]
                    JA     @SL1SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SL1NoP
                    MOV    ES:[DI],AL
        @SL1NoP:    CMP    DX,[NW]
                    JB     @SL1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SL1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SL1LoopX
        @SL1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SL1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SL1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SL1LoopY
        @SLY1Shr:   MOV    AX,[NH]
                    MOV    [PY],AX
        @SL2LoopY:  CMP    CX,[NY]
                    JNA    @SL2Cont
                    JMP    @SLEnd
        @SL2Cont:   MOV    DX,[W]
        @SL2LoopX:  CMP    BX,[NX]
                    JA     @SL2SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SL2NoP
                    MOV    ES:[DI],AL
        @SL2NoP:    CMP    DX,[NW]
                    JB     @SL2NextX
                    INC    SI
                    SUB    DX,[NW]
        @SL2NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SL2LoopX
        @SL2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SL2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SL2SkipX
        @SL2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SL2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SL2LoopY
        @SLXShr:    MOV    AX,[H]
                    CMP    AX,[NH]
                    JBE    @SLY2Str
                    JMP    @SLY2Shr
        @SLY2Str:   MOV    AX,[H]
                    MOV    [PY],AX
        @SL3LoopY:  CMP    CX,[NY]
                    JNA    @SL3Cont
                    JMP    @SLEnd
        @SL3Cont:   MOV    DX,[NW]
        @SL3LoopX:  CMP    BX,[NX]
                    JA     @SL3SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SL3ChecX
                    MOV    ES:[DI],AL
        @SL3ChecX:  CMP    DX,[W]
                    JAE    @SL3NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SL3ChecX
        @SL3NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SL3LoopX
        @SL3SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SL3NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SL3NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SL3LoopY
        @SLY2Shr:   MOV    AX,[NH]
                    MOV    [PY],AX
        @SL4LoopY:  CMP    CX,[NY]
                    JA     @SLEnd
                    MOV    DX,[NW]
        @SL4LoopX:  CMP    BX,[NX]
                    JA     @SL4SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SL4ChecX
                    MOV    ES:[DI],AL
        @SL4ChecX:  CMP    DX,[W]
                    JAE    @SL4NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SL4ChecX
        @SL4NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SL4LoopX
        @SL4SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SL4YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SL4SkipX
        @SL4YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SL4NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SL4LoopY
        @SLEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    18
SpriteScaleOverVirtual ENDP

;******************************************************************************
;*      Procedra SpriteScaleRel (PSprite: Pointer;  X, Y, Wide, Height,      *
;*                                Step: Word);                                *
;*   Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii X,Y    *
;*    s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu.     *
;******************************************************************************

PUBLIC SpriteScaleRel
SpriteScaleRel PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SRCont
                    JMP    @SREnd
        @SRCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SRXStr
                    JMP    @SRXShr
        @SRXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SR1LoopY:  CMP    CX,[NY]
                    JNA    @SR1Cont
                    JMP    @SREnd
        @SR1Cont:   MOV    DX,[W]
        @SR1LoopX:  CMP    BX,[NX]
                    JA     @SR1SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SR1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SR1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SR1LoopX
        @SR1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SR1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SR1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SR1LoopY
        @SRXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SR2LoopY:  CMP    CX,[NY]
                    JA     @SREnd
                    MOV    DX,[NW]
        @SR2LoopX:  CMP    BX,[NX]
                    JA     @SR2SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SR2ChecX:  CMP    DX,[W]
                    JAE    @SR2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SR2ChecX
        @SR2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SR2LoopX
        @SR2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SR2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SR2SkipX
        @SR2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SR2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SR2LoopY
        @SREnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleRel ENDP

;******************************************************************************
;*         Procedra SpriteScaleOverRel (PSprite: Pointer; X, Y, Wide,        *
;*                                       Height: Byte, Step: Word);           *
;*   Sprite, na ktor ukazuje PSprite, zobraz na obrazovku na pozcii X,Y    *
;*    s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu,     *
;*                   priom body s farbou 0 sa nevykresuj.                  *
;******************************************************************************

PUBLIC SpriteScaleOverRel
SpriteScaleOverRel PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SBCont
                    JMP    @SBEnd
        @SBCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SpritePage]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SBXStr
                    JMP    @SBXShr
        @SBXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SB1LoopY:  CMP    CX,[NY]
                    JNA    @SB1Cont
                    JMP    @SBEnd
        @SB1Cont:   MOV    DX,[W]
        @SB1LoopX:  CMP    BX,[NX]
                    JA     @SB1SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SB1NoP
                    MOV    ES:[DI],AL
        @SB1NoP:    CMP    DX,[NW]
                    JB     @SB1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SB1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SB1LoopX
        @SB1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SB1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SB1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SB1LoopY
        @SBXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SB2LoopY:  CMP    CX,[NY]
                    JA     @SBEnd
                    MOV    DX,[NW]
        @SB2LoopX:  CMP    BX,[NX]
                    JA     @SB2SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SB2ChecX
                    MOV    ES:[DI],AL
        @SB2ChecX:  CMP    DX,[W]
                    JAE    @SB2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SB2ChecX
        @SB2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SB2LoopX
        @SB2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SB2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SB2SkipX
        @SB2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SB2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SB2LoopY
        @SBEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleOverRel ENDP

;******************************************************************************
;*    Procedra SpriteScaleRelVirtual (SegVirtual: Word; PSprite: Pointer;    *
;*                                     X, Y, Wide, Height, Step: Word);       *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*  X,Y s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu.   *
;******************************************************************************

PUBLIC SpriteScaleRelVirtual
SpriteScaleRelVirtual PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SKCont
                    JMP    @SKEnd
        @SKCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SKXStr
                    JMP    @SKXShr
        @SKXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SK1LoopY:  CMP    CX,[NY]
                    JNA    @SK1Cont
                    JMP    @SKEnd
        @SK1Cont:   MOV    DX,[W]
        @SK1LoopX:  CMP    BX,[NX]
                    JA     @SK1SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
                    CMP    DX,[NW]
                    JB     @SK1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SK1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SK1LoopX
        @SK1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SK1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SK1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SK1LoopY
        @SKXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SK2LoopY:  CMP    CX,[NY]
                    JA     @SKEnd
                    MOV    DX,[NW]
        @SK2LoopX:  CMP    BX,[NX]
                    JA     @SK2SkipX
                    MOV    AL,DS:[SI]
                    MOV    ES:[DI],AL
        @SK2ChecX:  CMP    DX,[W]
                    JAE    @SK2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SK2ChecX
        @SK2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SK2LoopX
        @SK2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SK2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SK2SkipX
        @SK2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SK2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SK2LoopY
        @SKEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleRelVirtual ENDP

;******************************************************************************
;*  Procedra SpriteScaleOverRelVirtual (SegVirtual: Word; PSprite: Pointer;  *
;*                                       X, Y, Wide, Height, Step: Word);     *
;* Sprite, na ktor ukazuje PSprite,zobraz na virtulnu obrazovku na pozcii *
;*  X,Y s pomerom vekosti Step/100 = vo vekosti Step% z pvodnho spritu,   *
;*                  priom body s farbou 0 sa nevykresuj.                   *
;******************************************************************************

PUBLIC SpriteScaleOverRelVirtual
SpriteScaleOverRelVirtual PROC FAR
 ARG Step: Word, H: Word, W: Word, Y: Word, X: Word, PSprite: DWord, SegVirtual: Word
 LOCAL TX: Word, NX: Word, NY: Word, PY: Word, LDif: Word, NW: Word, NH: Word = SCVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,SCVar
                    PUSH   DS
                    MOV    AX,[Step]
                    OR     AX,AX
                    JNZ    @SZCont
                    JMP    @SZEnd
        @SZCont:    MOV    AX,[Step]
                    MOV    BX,[W]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NW],AX
                    MOV    AX,[Step]
                    MOV    BX,[H]
                    MUL    BX
                    MOV    BX,100
                    DIV    BX
                    MOV    [NH],AX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    LDS    SI,[PSprite]
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    DI,8
                    SHL    AX,6
                    ADD    DI,AX
                    MOV    AX,[X]
                    ADD    DI,[X]
                    MOV    [TX],AX
                    ADD    AX,[NW]
                    DEC    AX
                    MOV    [NX],AX
                    MOV    AX,[Y]
                    ADD    AX,[NH]
                    DEC    AX
                    MOV    [NY],AX
                    MOV    BX,[X]
                    MOV    CX,[Y]
                    MOV    AX,320
                    SUB    AX,[NW]
                    MOV    [LDif],AX
                    MOV    AX,[W]
                    CMP    AX,[NW]
                    JBE    @SZXStr
                    JMP    @SZXShr
        @SZXStr:    MOV    AX,[H]
                    MOV    [PY],AX
        @SZ1LoopY:  CMP    CX,[NY]
                    JNA    @SZ1Cont
                    JMP    @SZEnd
        @SZ1Cont:   MOV    DX,[W]
        @SZ1LoopX:  CMP    BX,[NX]
                    JA     @SZ1SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SZ1NoP
                    MOV    ES:[DI],AL
        @SZ1NoP:    CMP    DX,[NW]
                    JB     @SZ1NextX
                    INC    SI
                    SUB    DX,[NW]
        @SZ1NextX:  ADD    DX,[W]
                    INC    BX
                    INC    DI
                    JMP    @SZ1LoopX
        @SZ1SkipX:  MOV    AX,[PY]
                    CMP    AX,[NH]
                    JB     @SZ1NextY
                    SUB    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
        @SZ1NextY:  ADD    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    MOV    BX,[TX]
                    SUB    SI,[W]
                    ADD    DI,[LDif]
                    JMP    @SZ1LoopY
        @SZXShr:    MOV    AX,[NH]
                    MOV    [PY],AX
        @SZ2LoopY:  CMP    CX,[NY]
                    JA     @SZEnd
                    MOV    DX,[NW]
        @SZ2LoopX:  CMP    BX,[NX]
                    JA     @SZ2SkipX
                    MOV    AL,DS:[SI]
                    OR     AL,AL
                    JZ     @SZ2ChecX
                    MOV    ES:[DI],AL
        @SZ2ChecX:  CMP    DX,[W]
                    JAE    @SZ2NextX
                    ADD    DX,[NW]
                    INC    SI
                    JMP    @SZ2ChecX
        @SZ2NextX:  SUB    DX,[W]
                    ADD    DX,[NW]
                    INC    BX
                    INC    DI
                    INC    SI
                    JMP    @SZ2LoopX
        @SZ2SkipX:  MOV    AX,[PY]
                    CMP    AX,[H]
                    JAE    @SZ2YFill
                    ADD    AX,[NH]
                    MOV    [PY],AX
                    ADD    SI,[W]
                    JMP    @SZ2SkipX
        @SZ2YFill:  SUB    AX,[H]
                    MOV    [PY],AX
                    INC    CX
                    ADD    DI,[LDif]
        @SZ2NextY:  ADD    AX,[NH]
                    MOV    [PY],AX
                    MOV    BX,[TX]
                    JMP    @SZ2LoopY
        @SZEnd:     POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    14
SpriteScaleOverRelVirtual ENDP

;******************************************************************************
;*    Procedra CopySprite (SegSource, SegDestinaton, X1, Y1, X2, Y2: Word;   *
;*                          SWidth, SHeight: Byte);                           *
;*     Skopruje sprite z obrazovky na segmente SegSource z pozcie X1,Y1     *
;*  na obrazovku na segmente SegDestination na pozciu X2,Y2, priom sprite   *
;*                         m rozmer SWidth x SHeight                         *
;******************************************************************************

PUBLIC CopySprite
CopySprite PROC FAR
 ARG SHeight: Byte, SWidth: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word, SegDestination: Word, SegSource: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,SegSource
                    MOV    DS,AX
                    MOV    AX,[Y2]
                    MOV    DI,AX
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    MOV    CX,[X2]
                    ADD    DI,CX
                    MOV    AX,[Y1]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    CX,[X1]
                    ADD    SI,CX
                    MOV    AH,[SHeight]
                    MOV    AL,[SWidth]
                    MOV    DX,320
                    PUSH   AX
                    AND    AX,0FFH
                    SUB    DX,AX
                    POP    AX
                    MOV    BL,AL
                    AND    BL,1
                    SHR    AL,1
                    MOV    CX,SegDestination
                    MOV    ES,CX
                    XOR    CX,CX
                    CLD
          @CSBegin: MOV    CL,AL
                    REP    MOVSW
                    OR     BL,BL
                    JZ     @CSAdd
                    MOVSB
          @CSAdd:   ADD    DI,DX
                    ADD    SI,DX
                    DEC    AH
                    JNZ    @CSBegin
                    POP    DS
                    POP    BP
                    RET    12
CopySprite ENDP

;******************************************************************************
;*                   Procedra SetSpritePage (SPage: Word);                   *
;*      Nastav premenn SpritePage tak, aby urovala segment obrazovky,      *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetSpritePage
SetSpritePage PROC FAR
 ARG SPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[SPage]
                    MOV    [SpritePage],AX
                    POP    BP
                    RET    2
SetSpritePage ENDP

;******************************************************************************
;*                        Funkcia GetSpritePage : Word;                       *
;*     Vrti hodnotu premennej SpritePage, obrazovky, do ktorej kreslme      *
;******************************************************************************

PUBLIC GetSpritePage
GetSpritePage PROC FAR
                    MOV    AX,[SpritePage]
                    RET
GetSpritePage ENDP

END