;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Point

Model Medium

LOCALS

.286

.DATA

PointPage   DW    0A000H
Include Table13H.Inc

.CODE

;******************************************************************************
;*                 Procedra SetPixel (X,Y: Word; Col: Byte);                 *
;*                  Nakresl bod s farbou Col na pozciu X,Y                  *
;******************************************************************************

PUBLIC SetPixel
SetPixel PROC FAR
 ARG Col: Byte, Y: Word, X: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     BX,AX
                    MOV     AX,[X]
                    ADD     BX,AX
                    MOV     AX,[PointPage]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    MOV     ES:[BX],AL
		    POP     BP
                    RET     6
SetPixel ENDP

;******************************************************************************
;*               Procedra SetPixelTab (X,Y: Word; Col: Byte);                *
;*                 Nakresl bod s farbou Col na pozciu X,Y.                  *
;*     Adresa riadku je dopredu vypotan (LineTable), rchlejie na 286     *
;******************************************************************************

PUBLIC SetPixelTab
SetPixelTab PROC FAR
 ARG Col: Byte, Y: Word, X: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     BX,Seg LineTable
                    MOV     ES,BX
                    MOV     BX,Offset LineTable
                    MOV     AX,[Y]
                    SHL     AX,1
                    ADD     BX,AX
                    MOV     BX,ES:[BX]
                    ADD     BX,[X]
                    MOV     AX,[PointPage]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    MOV     ES:[BX],AL
                    POP     BP
                    RET     6
SetPixelTab ENDP

;******************************************************************************
;*        Procedra SetPixelVirtual (SegVirtual,X,Y: Word; Col: Byte);        *
;*      Nakresl bod s farbou Col na pozciu X,Y vo virtulnej obrazovke      *
;*        SegVirtual je segment virtulnej obrazovky (alokovan pam)        *
;******************************************************************************

PUBLIC SetPixelVirtual
SetPixelVirtual PROC FAR
 ARG Col: Byte, Y: Word, X: Word, SegVirtual: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     BX,AX
                    MOV     AX,[X]
                    ADD     BX,AX
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    MOV     ES:[BX],AL
                    POP     BP
                    RET     8
SetPixelVirtual ENDP

;******************************************************************************
;*       Procedra SetPixelTabVirtual (SegVirtual,X,Y: Word; Col: Byte);      *
;*      Nakresl bod s farbou Col na pozciu X,Y vo virtulnej obrazovke      *
;*        SegVirtual je segment virtulnej obrazovky (alokovan pam)        *
;*     Adresa riadku je dopredu vypotan (LineTable), rchlejie na 286     *
;******************************************************************************

PUBLIC SetPixelTabVirtual
SetPixelTabVirtual PROC FAR
 ARG Col: Byte, Y: Word, X: Word, SegVirtual: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     BX,Seg LineTable
                    MOV     ES,BX
                    MOV     BX,Offset LineTable
                    MOV     AX,[Y]
                    SHL     AX,1
                    ADD     BX,AX
                    MOV     BX,ES:[BX]
                    ADD     BX,[X]
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    MOV     ES:[BX],AL
                    POP     BP
                    RET     8
SetPixelTabVirtual ENDP

;******************************************************************************
;*                     Funkcia GetPixel (X,Y: Word): Byte;                    *
;*                      Zist farbu bodu na pozciu X,Y                       *
;******************************************************************************

PUBLIC GetPixel
GetPixel PROC FAR ;
 ARG Y: Word, X: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     BX,AX
                    MOV     AX,[X]
                    ADD     BX,AX
                    MOV     AX,[PointPage]
                    MOV     ES,AX
                    MOV     AL,ES:[BX]
                    XOR     AH,AH
                    POP     BP
                    RET     4
GetPixel ENDP

;******************************************************************************
;*                 Funkcia GetPixelVirtual (X,Y: Word): Byte;                 *
;*          Zist farbu bodu na pozciu X,Y vo virtulnej obrazovke           *
;*        SegVirtual je segment virtulnej obrazovky (alokovan pam)        *
;******************************************************************************

PUBLIC GetPixelVirtual
GetPixelVirtual PROC FAR
 ARG Y: Word, X: Word, SegVirtual: Word
                    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     BX,AX
                    MOV     AX,[X]
                    ADD     BX,AX
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,ES:[BX]
                    XOR     AH,AH
                    POP     BP
                    RET     6
GetPixelVirtual ENDP

;******************************************************************************
;*                   Procedra SetPointPage (PPage: Word);                    *
;*      Nastav premenn PointPage tak, aby urovala segment obrazovky,       *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetPointPage
SetPointPage PROC FAR
 ARG PPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[PPage]
                    MOV    [PointPage],AX
                    POP    BP
                    RET    2
SetPointPage ENDP

;******************************************************************************
;*                        Funkcia GetPointPage : Word;                        *
;*      Vrti hodnotu premennej PointPage, obrazovky, do ktorej kreslme      *
;******************************************************************************

PUBLIC GetPointPage
GetPointPage PROC FAR
                    MOV    AX,[PointPage]
                    RET
GetPointPage ENDP

END