;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

Title PCX

Model Medium

LOCALS

.286

.DATA

PCXPage    DW   0A000H

.CODE

;******************************************************************************
;*                      Procedra ShowPCX (PPCX: Pointer)                     *
;*  Zobraz obrzok vo formte PCX na zaiatok obrazovky (me ma najvie  *
;*   rozmery 320 x 200 v 256 farbch), priom po vykreslen nastav paletu.   *
;******************************************************************************

PUBLIC ShowPCX
ShowPCX PROC FAR
 ARG PPCX: DWord
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[PCXPage]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @PCXB:    OR     DX,DX
                    JZ     @PCXE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @PCXS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @PCXL:    STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXB1:   LOOP   @PCXL
                    JMP    @PCXB
          @PCXS:    XCHG   AL,AH
                    STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXB2:   JMP    @PCXB
          @PCXE:    INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @PCXP:    MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @PCXP
                    MOV    SI,BX
                    MOV    CX,100H
                    XOR    BX,BX
    @WritePalEntry: OR     CX,CX
                    JZ     @Done
                    CLD
                    MOV    DX,3DAH
    @WaitNotVSync:  IN     AL,DX
                    TEST   AL,8
                    JNZ    @WaitNotVSync
    @WaitVSync:     IN     AL,DX
                    TEST   AL,8
                    JZ     @WaitVSync
                    MOV    AX,BX
                    MOV    BX,60
    @SetLoop:       MOV    DX,3C8H
                    OUT    DX,AL
                    MOV    DX,3C9H
                    OUTSB
                    OUTSB
                    OUTSB
                    INC    AL
                    DEC    BX
                    JS     @TestVSync
                    LOOP   @SetLoop
                    JMP    @Done
    @TestVSync:     MOV    DX,3DAH
                    PUSH   AX
    @Wait:          IN     AL,DX
                    TEST   AL,8
                    JNZ    @Wait
                    POP    AX
                    MOV    BX,60
                    LOOP   @SetLoop
    @Done:          POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
ShowPCX ENDP

;******************************************************************************
;*                  Procedra DeCompressPCX (PPCX: Pointer)                   *
;*  Zobraz obrzok vo formte PCX na zaiatok obrazovky (me ma najvie  *
;*                     rozmery 320 x 200 v 256 farbch)                       *
;******************************************************************************

PUBLIC DeCompressPCX
DeCompressPCX PROC FAR
 ARG PPCX: DWord
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[PCXPage]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @DPCXB:   OR     DX,DX
                    JZ     @DPCXE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @DPCXS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @DPCXL:   STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @DPCXB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @DPCXB1:  LOOP   @DPCXL
                    JMP    @DPCXB
          @DPCXS:   XCHG   AL,AH
                    STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @DPCXB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @DPCXB2:  JMP    @DPCXB
          @DPCXE:   INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @DPCXP:   MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @DPCXP
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
DeCompressPCX ENDP

;******************************************************************************
;*      Procedra DeCompressPCXVirtual (SegVirtual: Word, PPCX: Pointer)      *
;*  Zobraz obrzok vo formte PCX na zaiatok obrazovky (me ma najvie  *
;*  rozmery 320 x 200 v 256 farbch), priom SegVirtual je segment obrazovky  *
;******************************************************************************

PUBLIC DeCompressPCXVirtual
DeCompressPCXVirtual PROC FAR
 ARG PPCX: DWord, SegVirtual: Word
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[SegVirtual]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @DPCXVB:  OR     DX,DX
                    JZ     @DPCXVE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @DPCXVS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @DPCXVL:  STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @DPCXVB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @DPCXVB1: LOOP   @DPCXVL
                    JMP    @DPCXVB
          @DPCXVS:  XCHG   AL,AH
                    STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @DPCXVB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @DPCXVB2: JMP    @DPCXVB
          @DPCXVE:  INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @DPCXVP:  MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @DPCXVP
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
DeCompressPCXVirtual ENDP

;******************************************************************************
;*               Procedra PCXSprite (PPCX: Pointer; X,Y: Word)               *
;*    Zobraz sprite vo formte PCX na pozciu X,Y obrazovky (PCX me ma    *
;*                 najvie rozmery 320 x 200 v 256 farbch)                 *
;******************************************************************************

PUBLIC PCXSprite
PCXSprite PROC FAR
 ARG Y: Word, X: Word, PPCX: DWord
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[PCXPage]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    ADD    DI,[X]
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @PCXSB:   OR     DX,DX
                    JZ     @PCXSE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @PCXSS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @PCXSL:   STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXSB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXSB1:  LOOP   @PCXSL
                    JMP    @PCXSB
          @PCXSS:   XCHG   AL,AH
                    STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXSB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXSB2:  JMP    @PCXSB
          @PCXSE:   INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @PCXSP:   MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @PCXSP
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    8
PCXSprite ENDP

;******************************************************************************
;*   Procedra PCXSpriteVirtual (SegVirtual: Word;PPCX: Pointer; X,Y: Word)   *
;*    Zobraz sprite vo formte PCX na pozciu X,Y obrazovky (PCX me ma    *
;*      najvie rozmery 320 x 200 v 256 farbch), priom SegVirtual je      *
;*                              segment obrazovky                             *
;******************************************************************************

PUBLIC PCXSpriteVirtual
PCXSpriteVirtual PROC FAR
 ARG Y: Word, X: Word, PPCX: DWord, SegVirtual: Word
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[SegVirtual]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    ADD    DI,[X]
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @PCXSVB:  OR     DX,DX
                    JZ     @PCXSVE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @PCXSVS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @PCXSVL:  STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXSVB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXSVB1: LOOP   @PCXSVL
                    JMP    @PCXSVB
          @PCXSVS:  XCHG   AL,AH
                    STOSB
                    DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXSVB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXSVB2: JMP    @PCXSVB
          @PCXSVE:  INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @PCXSVP:  MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @PCXSVP
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    10
PCXSpriteVirtual ENDP

;******************************************************************************
;*             Procedra PCXSpriteOver (PPCX: Pointer; X,Y: Word)             *
;*    Zobraz sprite vo formte PCX na pozciu X,Y obrazovky (PCX me ma    *
;*                 najvie rozmery 320 x 200 v 256 farbch),                *
;*                        nevykresuje body s farbou 0.                       *
;******************************************************************************

PUBLIC PCXSpriteOver
PCXSpriteOver PROC FAR
 ARG Y: Word, X: Word, PPCX: DWord
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[PCXPage]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    ADD    DI,[X]
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @PCXOB:   OR     DX,DX
                    JZ     @PCXOE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @PCXOS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @PCXOL:   OR     AL,AL
                    JZ     @PCXOR
                    STOSB
                    JMP    @PCXON
          @PCXOR:   INC    DI
          @PCXON:   DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXOB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXOB1:  LOOP   @PCXOL
                    JMP    @PCXOB
          @PCXOS:   XCHG   AL,AH
                    OR     AL,AL
                    JZ     @PCXOO
                    STOSB
                    JMP    @PCXOM
          @PCXOO:   INC    DI
          @PCXOM:   DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXOB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXOB2:  JMP    @PCXOB
          @PCXOE:   INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @PCXOP:   MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @PCXOP
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    8
PCXSpriteOver ENDP

;******************************************************************************
;* Procedra PCXSpriteOverVirtual (SegVirtual: Word;PPCX: Pointer; X,Y: Word) *
;*    Zobraz sprite vo formte PCX na pozciu X,Y obrazovky (PCX me ma    *
;*      najvie rozmery 320 x 200 v 256 farbch), priom SegVirtual je      *
;*                              segment obrazovky,                            *
;*                        nevykresuje body s farbou 0.                       *
;******************************************************************************

PUBLIC PCXSpriteOverVirtual
PCXSpriteOverVirtual PROC FAR
 ARG Y: Word, X: Word, PPCX: DWord, SegVirtual: Word
 LOCAL W: Word, LDif: Word = PCXVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PCXVar
                    PUSH   DS
                    MOV    AX,[SegVirtual]
                    LDS    SI,[PPCX]
                    MOV    ES,AX
                    MOV    DI,[Y]
                    MOV    AX,DI
                    SHL    AX,8
                    SHL    DI,6
                    ADD    DI,AX
                    ADD    DI,[X]
                    MOV    BX,SI
                    MOV    AX,DS:[BX+8]
                    MOV    DX,DS:[BX+4]
                    SUB    AX,DX
                    INC    AX
                    MOV    [W],AX
                    MOV    DX,320
                    SUB    DX,AX
                    MOV    [LDif],DX
                    MOV    AX,DS:[BX+10]
                    MOV    DX,DS:[BX+6]
                    SUB    AX,DX
                    INC    AX
                    MOV    BX,[W]
                    MUL    BX
                    XCHG   AX,DX
                    ADD    SI,128
          @PCXPB:   OR     DX,DX
                    JZ     @PCXPE
                    LODSB
                    MOV    AH,AL
                    AND    AL,0C0H
                    CMP    AL,0C0H
                    JNE    @PCXPS
                    XOR    AL,AL
                    XCHG   AL,AH
                    MOV    CX,AX
                    AND    CX,3FH
                    LODSB
          @PCXPL:   OR     AL,AL
                    JZ     @PCXPR
                    STOSB
                    JMP    @PCXPN
          @PCXPR:   INC    DI
          @PCXPN:   DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXPB1
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXPB1:  LOOP   @PCXPL
                    JMP    @PCXPB
          @PCXPS:   XCHG   AL,AH
                    OR     AL,AL
                    JZ     @PCXPO
                    STOSB
                    JMP    @PCXPM
          @PCXPO:   INC    DI
          @PCXPM:   DEC    DX
                    DEC    BX
                    OR     BX,BX
                    JNZ    @PCXPB2
                    ADD    DI,[LDif]
                    MOV    BX,[W]
          @PCXPB2:  JMP    @PCXPB
          @PCXPE:   INC    SI
                    MOV    BX,SI
                    MOV    CX,768
          @PCXPP:   MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    DS:[SI],AL
                    INC    SI
                    LOOP   @PCXPP
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    10
PCXSpriteOverVirtual ENDP

END