;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Palette

MODEL Medium

LOCALS

.286

.DATA

.CODE

;******************************************************************************
;*     truktra TPalBuf - dka 768 bytov, je to vlastne pomocn paleta      *
;******************************************************************************

TPalBuf STRUC
 DB 768 DUP (?)
ENDS

;******************************************************************************
;*                   Procedra SetPalette (PPal: Pointer);                    *
;*               Nastav paletu, na ktor ukazuje pointer PPal                *
;******************************************************************************

PUBLIC SetPalette                      ;Upraven z XMode Lib 4.0
SetPalette PROC FAR
 ARG Pal: DWord
       	            PUSH    BP
                    MOV     BP,SP
                    PUSH    DS
                    PUSH    SI
                    LDS     SI,[Pal]
                    MOV     CX,100H
                    XOR     BX,BX
    @WritePalEntry: OR      CX,CX
                    JZ      @Done
                    CLD
                    MOV     DX,3DAH
    @WaitNotVSync:  IN      AL,DX
                    TEST    AL,8
                    JNZ     @WaitNotVSync
    @WaitVSync:     IN      AL,DX
                    TEST    AL,8
                    JZ      @WaitVSync
                    MOV     AX,BX
                    MOV     BX,60
    @SetLoop:       MOV     DX,3C8H
                    OUT     DX,AL
                    MOV     DX,3C9H
                    OUTSB
                    OUTSB
                    OUTSB
                    INC     AL
                    DEC     BX
                    JS      @TestVSync
                    LOOP    @SetLoop
                    JMP     @Done
    @TestVSync:     MOV     DX,3DAH
                    PUSH    AX
    @Wait:          IN      AL,DX
                    TEST    AL,8
                    JNZ     @Wait
                    POP     AX
                    MOV     BX,60
                    LOOP    @SetLoop
    @Done:          POP     SI
                    POP     DS
                    POP     BP
                    RET     4
SetPalette ENDP

;******************************************************************************
;*                 Procedra GetPalette (Var Pal: TPalette);                  *
;*             Aktulnu paletu vlo na miesto, kde ukazuje PPal              *
;******************************************************************************

PUBLIC GetPalette
GetPalette PROC FAR
 ARG Pal: DWord
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AH,10H
                    MOV     AL,17H
                    XOR     BX,BX
                    MOV     CX,100H
                    LES     DX,[Pal]
                    INT     10H
		    POP     BP
                    RET     4
GetPalette ENDP

;******************************************************************************
;*              Procedra IncPalette (PPal: Pointer; Step: Byte);             *
;*           Rozsvieuje paletu, na ktor ukazuje PPal s krokom Step          *
;******************************************************************************
;*                Pozor ! Step me by iba slo od 1 po 32 !                *
;******************************************************************************

PUBLIC IncPalette
IncPalette PROC FAR
 ARG Step: Byte, PPal: DWord
 LOCAL Number: Byte, Cycle: Byte, PalBuf: TPalBuf = IPLocalVariables
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,IPLocalVariables
                    PUSH   DS
                    LDS    SI,[PPal]          ;DS:SI - pvodna paleta
                    MOV    AX,SS
                    MOV    ES,AX              ;ES:DX (SS:DX) - pracovn paleta
                    LEA    DX,PalBuf
                    MOV    CX,384             ;Vynulovanie pracovnej palety
                    XOR    AX,AX
                    MOV    BX,DX
      @IPClearBuf:  MOV    ES:[BX],AX
                    ADD    BX,2
                    LOOP   @IPClearBuf
                    MOV    AX,40H             ;Vpoet potu zmien palety
                    DIV    [Step]
                    MOV    [Number],AL        ;Cyklus od 0..Number
                    DEC    AL
                    MOV    CL,AL              ;CL - potadlo zmien
                    XOR    CH,CH
                    MOV    [Cycle],0          ;Sme v 0.cykle
           @IPC1:   XOR    DI,DI              ;0.farba palety
           @IPC2:   MOV    BX,DX
                    MOV    AH,ES:[BX+DI]      ;AL - aktulna farba
                    MOV    BX,SI
                    MOV    AL,DS:[BX+DI]      ;AH - pvodn farba
                    PUSH   BX
                    MOV    BX,AX              ;Je AH - AH Div Cyklus > AL ?
                    MOV    BL,AL
                    XOR    AH,AH
                    DIV    [Number]
                    SUB    BL,AL
                    XCHG   AL,BL
                    MOV    AH,BH
                    POP    BX
                    CMP    AH,AL
                    JNC    @IPMaxCol
                    PUSH   CX                 ;Ak treba zvi farbu
                    PUSH   BX
                    MOV    AL,DS:[BX+DI]      ;Farba = Krok*Cyklus*Farba/64
                    MOV    CL,[Cycle]
                    INC    CL
                    XOR    AX,AX
                    MOV    AL,[Step]
                    MOV    CH,DS:[BX+DI]
                    MUL    CL
                    MUL    CH
                    SHR    AX,6
                    MOV    BX,DX
                    MOV    ES:[BX+DI],AL
                    POP    BX
                    POP    CX
                    JMP    @IPNextCol         ;Daia farba
         @IPMaxCol: MOV    AL,DS:[BX+DI]      ;Ak m farba maximum
                    MOV    BX,DX
                    MOV    ES:[BX+DI],AL
      @IPNextCol:   INC    DI
                    CMP    DI,768             ;Vetky farby ?
                    JNZ    @IPC2
                    PUSHA
                    PUSH   ES
                    PUSH   DX
                    CALL   SetPalette         ;Nastav nov paletu
                    POPA
                    INC    [Cycle]
                    DEC    CL                 ;Kompletn zosvetlenie ?
                    JNZ    @IPC1
                    PUSH   DS
                    PUSH   SI
                    CALL   SetPalette         ;Nastavenie pvodnej palety
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    6
IncPalette ENDP

;******************************************************************************
;*              Procedra DecPalette (PPal: Pointer; Step: Byte);             *
;*             Zhasna paletu, na ktor ukazuje PPal s krokom Step            *
;******************************************************************************
;*                Pozor ! Step me by iba slo od 1 po 32 !                *
;******************************************************************************

PUBLIC DecPalette
DecPalette PROC FAR
 ARG Step: Byte, PPal: DWord
 LOCAL Number: Byte, Cycle: Byte, PalBuf: TPalBuf = DPLocalVariables
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,DPLocalVariables
                    PUSH   DS
                    MOV    CX,384
                    MOV    AX,SS
                    MOV    ES,AX
                    LEA    DI,PalBuf
                    LDS    SI,[PPal]
                    REP    MOVSW
                    SUB    SI,768
                    SUB    DI,768
                    XCHG   DX,DI
                    MOV    AX,40H
                    DIV    [Step]
                    MOV    [Number],AL
                    DEC    AX
                    MOV    CL,AL
                    XOR    CH,CH
                    MOV    [Cycle],0
        @DPC1:      XOR    DI,DI
        @DPC2:      MOV    BX,SI
                    MOV    AL,DS:[BX+DI]
                    MOV    BX,DX
                    MOV    AH,ES:[BX+DI]
                    PUSH   BX
                    MOV    BX,AX
                    XOR    AH,AH
                    DIV    [Number]
                    MOV    AH,BH
                    POP    BX
                    CMP    AH,AL
                    JNA    @DPNulCol
                    PUSH   CX
                    MOV    CL,[Cycle]
                    INC    CL
                    XOR    AX,AX
                    MOV    AL,[Step]
                    MOV    BX,SI
                    MOV    CH,DS:[BX+DI]
                    MUL    CL
                    MUL    CH
                    SHR    AX,6
                    SUB    CH,AL
                    MOV    BX,DX
                    MOV    ES:[BX+DI],CH
                    POP    CX
                    JMP    @DPNextCol
      @DPNulCol:    XOR    AL,AL
                    MOV    ES:[BX+DI],AL
      @DPNextCol:   INC    DI
                    CMP    DI,768
                    JNZ    @DPC2
                    PUSHA
                    PUSH   ES
                    PUSH   BX
                    CALL   SetPalette
                    POPA
                    INC    [Cycle]
                    DEC    CL
                    JNZ    @DPC1
                    XOR    AL,AL
                    MOV    CX,768
      @DPClearBuf:  MOV    ES:[BX],AL
                    INC    BX
                    LOOP   @DPClearBuf
                    PUSH   ES
                    PUSH   DX
                    CALL   SetPalette
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    6
DecPalette ENDP

;******************************************************************************
;*   Procedra ConvertRGBPalette (POldPal: Pointer; Var PNewPal: Pointer);    *
;*     Skonvertuje 8-bitov paletu (GIF, Image Alchemy RAW) na 6-bitov,      *
;*                     pouiten paletu (666 RGB shit)                       *
;******************************************************************************

PUBLIC ConvertRGBPalette
ConvertRGBPalette PROC FAR
 ARG PNewPal: DWord, POldPal: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    CX,768
                    LDS    SI,[POldPal]
                    LES    DI,[PNewPal]
          @CRGBPL:  MOV    AL,DS:[SI]
                    SHR    AL,2
                    MOV    ES:[DI],AL
                    INC    SI
                    INC    DI
                    LOOP   @CRGBPL
                    POP    BP
                    RET    8
ConvertRGBPalette ENDP

;******************************************************************************
;*                Procedra RotatePaletteLeft (PPal: Pointer);                *
;*      Zrotuje paletu smerom doava - 2.farba sa zmen na 1.farbu at.       *
;*     Zrotuje, ie zmen vstupn paletu, no nenastav ju na obrazovke       *
;*         Na nastavenie palety na obrazovku poui SetPalette (PPal)          *
;******************************************************************************

PUBLIC RotatePaletteLeft
RotatePaletteLeft PROC FAR
 ARG PPal: DWord
 LOCAL PalBuf: TPalBuf = LocalVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,LocalVar
                    PUSH   DS
                    LES    DI,[PPal]
                    LDS    SI,[PPal]
                    MOV    AX,DS:[SI]
                    ADD    SI,2
                    MOV    BL,DS:[SI]
                    INC    SI
                    MOV    CX,02FDH
                    CLD
                    REP    MOVSB
                    MOV    ES:[DI],AX
                    ADD    DI,2
                    MOV    ES:[DI],BL
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
RotatePaletteLeft ENDP

;******************************************************************************
;*               Procedra RotatePaletteRight (PPal: Pointer);                *
;*      Zrotuje paletu smerom doprava - 1.farba sa zmen na 2.farbu at.      *
;*      Zrotuje, ie zmen vstupn paletu, no nenastav ju na obrazovke      *
;*         Na nastavenie palety na obrazovku poui SetPalette (PPal)          *
;******************************************************************************

PUBLIC RotatePaletteRight
RotatePaletteRight PROC FAR
 ARG PPal: DWord
 LOCAL PalBuf: TPalBuf = LocalVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,LocalVar
                    PUSH   DS
                    STD
                    LES    DI,[PPal]
                    LDS    SI,[PPal]
                    ADD    DI,2FFH
                    ADD    SI,2FEH
                    MOV    AX,DS:[SI]
                    DEC    SI
                    MOV    BL,DS:[SI]
                    DEC    SI
                    MOV    CX,02FDH
                    REP    MOVSB
                    DEC    DI
                    MOV    ES:[DI],AX
                    DEC    DI
                    MOV    ES:[DI],BL
                    CLD
                    POP    DS
                    MOV    SP,BP
                    POP    BP
                    RET    4
RotatePaletteRight ENDP

END