;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Miscellaneous

MODEL Medium

LOCALS

.286

.DATA

.CODE

;******************************************************************************
;*                         Procedra ClearKeyBuffer;                          *
;*                         Vyist buffer klvesnice                          *
;******************************************************************************

PUBLIC ClearKeyBuffer
ClearKeyBuffer PROC FAR
           @Start:  MOV    AH,1                      ;Je buffer przdny ?
                    INT    16H
                    JZ     @Return                   ;Ak je, skoni
                    XOR    AH,AH                     ;Inak vyber klvesu
                    INT    16H                       ;z buffera
                    JMP    @Start                    ;Znovu opakuj
           @Return: RET
ClearKeyBuffer ENDP

;******************************************************************************
;*                     Procedra WaitMSec (MSec: Word);                       *
;*                          ak MSec mikroseknd                             *
;******************************************************************************

PUBLIC WaitMSec
WaitMSec PROC FAR
 ARG MSec: Word;
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AH,86H                    ;Funkcia 86H
                    MOV    DX,[MSec]                 ;DX = poet sec
                    XOR    CX,CX
            @Begin: INT    15H                       ;akanie
                    JC     @Begin                    ;Ak chyba, znovu
                    POP    BP                        ;Ak stle chyby - stuhne
                    RET    2
WaitMSec ENDP

;******************************************************************************
;*         Procedra Time (Var Hour, Minute, Second, Hundreds: Byte)          *
;*                            Zist systmov as                             *
;******************************************************************************

PUBLIC Time
Time PROC FAR
 ARG PHundreds: DWord, PSecond: DWord, PMinute: DWord, PHour: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,2C00H                  ;Zisti as
                    INT    21H                       ;cez DOS INT 21H
                    LES    DI,PHour                  ;Hodina = CH
                    MOV    ES:[DI],CH
                    LES    DI,PMinute                ;Minta = CL
                    MOV    ES:[DI],CL
                    LES    DI,PSecond                ;Sekunda = DH
                    MOV    ES:[DI],DH
                    LES    DI,PHundreds              ;Stotina = DL
                    MOV    ES:[DI],DL
                    POP    BP
                    RET    16
Time ENDP

;******************************************************************************
;*                    Procedra WaitTime (Hundreds: Word)                     *
;*                       ak Hundreds stotn sekundy                         *
;*                      Presnos 4 stotiny +/- autobus                        *
;******************************************************************************

PUBLIC WaitTime
WaitTime PROC FAR
 ARG Hundreds: Word;
 LOCAL NHour: Byte, NMinute: Byte, NSecond: Byte, NHundred: Byte, Carry: Word = TimeVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,TimeVar
                    MOV    AX,2C00H                  ;Zisti zaiaton as
                    INT    21H                       ;cez DOS INT 21H
                    XOR    AH,AH                     ;AH = 0 bude potrebn
                    MOV    AL,DL
                    ADD    AX,[Hundreds]
                    MOV    [Carry],0
         @WTL1:     CMP    AX,99                     ;viac ako 99 stotn ?
                    JNA    @WTN1                     ;ak nie, ide sa alej
                    SUB    AX,100                    ;inak sto = sto - 100
                    INC    [Carry]                   ;o sekundu viac
                    JMP    @WTL1
         @WTN1:     MOV    [NHundred],AL
                    MOV    AL,DH
                    ADD    AX,[Carry]
                    MOV    [Carry],0
         @WTL2:     CMP    AX,59                     ;viac ako 59 seknd ?
                    JNA    @WTN2                     ;ak nie, ide sa alej
                    SUB    AX,60                     ;inak sek = sek - 60
                    INC    [Carry]                   ;o mintu viac
                    JMP    @WTL2
         @WTN2:     MOV    [NSecond],AL
                    MOV    AL,CL
                    ADD    AX,[Carry]
                    MOV    [Carry],0
         @WTL3:     CMP    AX,59                     ;viac ako 59 mint ?
                    JNA    @WTN3                     ;ak nie, ide sa alej
                    SUB    AX,60                     ;inak min = min - 60
                    INC    [Carry]                   ;zvi hodinu
                    JMP    @WTL3
         @WTN3:     MOV    [NMinute],AL
                    MOV    AX,[Carry]
                    ADD    CH,AL
                    CMP    CH,23                     ;viac ako 23 hodn ?
                    JNA    @WTN4                     ;ak nie, ide sa alej
                    XOR    CH,CH
         @WTN4:     MOV    [NHour],CH                ;inak hod = 0
         @WTLoop:   MOV    AX,2C00H                  ;DOSovsk hodiny
                    INT    21H
                    XOR    AL,AL                     ;Porovnania, i u je as
                    CMP    DL,[NHundred]
                    JAE    @WTCmp1                   ;ASto > Sto
                    JMP    @WTNxt1                   ;     &
         @WTCmp1:   CMP    DH,[NSecond]              ;ASek = Sek ?
                    JE     @End                      ;Ak no, skoni
         @WTNxt1:   CMP    DH,[NSecond]
                    JA     @WTCmp2                   ;ASek > Sek
                    JMP    @WTNxt2                   ;     &
         @WTCmp2:   CMP    CL,[NMinute]              ;AMin = Min ?
                    JE     @End                      ;Ak no, skoni
         @WTNxt2:   CMP    CL,[NMinute]
                    JA     @WTCmp3                   ;AMin > Min
                    JMP    @WTNxt3                   ;     &
         @WTCmp3:   CMP    CH,[NHour]                ;AHod = Hod ?
                    JE     @End                      ;Ak no, skoni
         @WTNxt3:   CMP    CH,[NHour]
                    JA     @WTCmp3                   ;AHod > Hod
                    JMP    @WTNxt4                   ;     &
         @WTCmp4:   CMP    [NHour],AL                ; Hod > 0 ?
                    JA     @End                      ;Ak no, skoni
         @WTNxt4:   CMP    CH,0
                    JE     @WTCmp5                   ;AHod = 0
                    JMP    @WTLoop                   ;     &
         @WTCmp5:   MOV    AL,23                     ; Hod = 23 ?
                    CMP    [NHour],AL
                    JA     @End                      ;Ak no, skoni
                    JMP    @WTLoop                   ;Sks znovu
         @End:      MOV    SP,BP
                    POP    BP
                    RET    2
WaitTime ENDP

;******************************************************************************
;* Procedra ExtractPointer (PPointer: Pointer; Var PSegment,POffset: Word);  *
;*              Vrti hodnotu segmentu a offsetu v ukazovateli                *
;******************************************************************************

PUBLIC ExtractPointer
ExtractPointer PROC FAR
 ARG POffset: DWord, PSegment: DWord, PPointer: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PPointer]
                    MOV    AX,ES
                    LES    DI,[PSegment]
                    MOV    ES:[DI],AX
                    LES    DI,[POffset]
                    MOV    ES:[DI],BX
                    POP    BP
                    RET    12
ExtractPointer ENDP

END