;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Memory

Model Medium

LOCALS

.286

.DATA

.CODE

;******************************************************************************
;*       Funkcia AllocateMemory (Var PMem: Pointer; MSize: Word): Word;       *
;*      Funkcia vrti 0, ak prebehla spene alokcia pamte, inak vrti      *
;*                              chybov kd DOSu                              *
;******************************************************************************

PUBLIC AllocateMemory
AllocateMemory PROC FAR
 ARG MSize: Word, PMem: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    BX,[MSize]
                    SHR    BX,4
                    INC    BX
                    MOV    AH,48H
                    INT    21H
                    JC     @AMErr
                    XOR    CX,CX
                    JMP    @AMExit
           @AMErr:  MOV    CX,AX
                    LES    DI,[PMem]
                    XOR    AX,AX
           @AMExit: LES    DI,[PMem]
                    XOR    DX,DX
                    MOV    ES:[DI],DX
                    ADD    DI,2
                    MOV    ES:[DI],AX
                    MOV    AX,CX
                    POP    BP
                    RET    6
AllocateMemory ENDP

;******************************************************************************
;*                  Funkcia DeAllocate (Var PMem: Pointer);                   *
;*      Funkcia dealokuje pam, vrti 0 ak je dealokcia spen, inak       *
;*  vrti chybov kd DOSu, ukazovateu PMem prirad hodnotu NIL (0000:0000)  *
;******************************************************************************

PUBLIC DeAllocate
DeAllocate PROC FAR
 ARG PMem: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    DI,[PMem]
                    MOV    AX,ES:[DI]
                    OR     AX,AX
                    JNZ    @DACont
                    ADD    DI,2
                    MOV    AX,ES:[DI]
                    OR     AX,AX
                    JNZ    @DACont
                    XOR    AX,AX
                    POP    BP
                    RET
         @DACont:   MOV    AH,49H
                    LES    DI,[PMem]
                    LES    DI,ES:[DI]
                    INT    21H
                    JC     @DAExit
                    XOR    AX,AX
                    LES    DI,[PMem]
                    MOV    ES:[DI],AX
                    ADD    DI,2
                    MOV    ES:[DI],AX
         @DAExit:   POP    BP
                    RET    4
DeAllocate ENDP

;******************************************************************************
;*                      Funkcia FreeDOSMemory: LongInt;                       *
;*               Funkcia vrti vekos vonej DOSovskej pamte                *
;******************************************************************************

PUBLIC FreeDOSMemory
FreeDOSMemory PROC FAR
                    MOV    BX,0FFFFH
                    MOV    AH,48H
                    INT    21H
                    MOV    AX,BX
                    MOV    BX,16
                    MUL    BX
                    RET
FreeDOSMemory ENDP

END