;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Main

Model Medium

LOCALS

.286

.DATA

MainPage   DW    0A000H

.CODE

;******************************************************************************
;*                      Procedra SetMode (Mode: Byte);                       *
;*     Nastav poadovan grafick md cez preruenia Video BIOSu INT 10H     *
;******************************************************************************

PUBLIC SetMode
SetMode PROC FAR
 ARG Mode: Byte
                    PUSH  BP
                    MOV   BP,SP
                    PUSH  DS
                    XOR   AH,AH
                    MOV   AL,[Mode]
                    INT   10H
                    POP   DS
                    MOV   SP,BP
                    POP   BP
                    RET   2
SetMode ENDP

;******************************************************************************
;*                            Procedra SetVGAMode                            *
;*          Nastav grafick md 13H cez preruenia VGA BIOSu INT 10H         *
;******************************************************************************

PUBLIC SetVGAMode
SetVGAMode PROC FAR
                    MOV  AX,13H
                    INT  10H
                    RET
SetVGAMode ENDP

;******************************************************************************
;*                           Procedra SetTextMode                            *
;*       Nastav textov md 3H (CO80) cez preruenia VGA BIOSu INT 10H       *
;******************************************************************************

PUBLIC SetTextMode
SetTextMode PROC FAR
                    MOV  AX,3H
                    INT  10H
                    RET
SetTextMode ENDP

;******************************************************************************
;*                 Procedra UseVirtual (SegVirtual: Word);                   *
;*           Prekopruje obsah virtulnej obrazovky na obrazovku              *
;******************************************************************************

PUBLIC UseVirtual
UseVirtual PROC FAR
 ARG SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,0A000H
                    MOV    ES,AX
                    MOV    AX,[SegVirtual]
                    MOV    DS,AX
                    XOR    SI,SI
                    XOR    DI,DI
                    MOV    CX,7D00H
                    REP    MOVSW
                    POP    DS
                    POP    BP
                    RET    2
UseVirtual ENDP

;******************************************************************************
;*          Procedra CopyScreen (SegSource, SegDestination: Word);           *
;*     Skopruje obrazovku na segmente SegSource do obrazovky na segmente     *
;*                              SegDestination                                *
;******************************************************************************

PUBLIC CopyScreen
CopyScreen PROC FAR
 ARG SegDestination: Word, SegSource: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,SegSource
                    MOV    DS,AX
                    XOR    SI,SI
                    MOV    AX,SegDestination
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    CX,7D00H
                    REP    MOVSW
                    POP    DS
                    POP    BP
                    RET    4
CopyScreen ENDP

;******************************************************************************
;*         Procedra CopyRows (SegSource,SegDestination,Y1,Y2: Word);         *
;*    Skopruje stpce Y1-Y2 obrazovky na segmente SegSource do obrazovky     *
;*                        na segmente SegDestination                          *
;******************************************************************************

PUBLIC CopyRows
CopyRows PROC FAR
 ARG Y2: Word, Y1: Word, SegDestination: Word, SegSource: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,[Y1]
                    MOV    BX,AX
                    SHL    AX,8
                    SHL    BX,6
                    ADD    AX,BX
                    MOV    SI,AX
                    XCHG   DI,AX
                    MOV    AX,[Y1]
                    MOV    CX,[Y2]
                    SUB    CX,AX
                    INC    CX
                    MOV    AX,CX
                    SHL    AX,7
                    SHL    CX,5
                    ADD    CX,AX
                    MOV    AX,SegSource
                    MOV    DS,AX
                    MOV    AX,SegDestination
                    MOV    ES,AX
                    REP    MOVSW
                    POP    DS
                    POP    BP
                    RET    8
CopyRows ENDP

;******************************************************************************
;*      Procedra CopyRowsRel (SegSource,SegDestination,Y,Count: Word);       *
;*    Skopruje Count stpcov od Y.stpca obrazovky na segmente SegSource     *
;*                  do obrazovky na segmente SegDestination                   *
;******************************************************************************

PUBLIC CopyRowsRel
CopyRowsRel PROC FAR
 ARG Count: Word, Y: Word, SegDestination: Word, SegSource: Word
                    PUSH   BP
                    MOV    BP,SP
                    PUSH   DS
                    MOV    AX,[Y]
                    MOV    BX,[Y]
                    SHL    AX,8
                    SHL    BX,6
                    ADD    AX,BX
                    MOV    SI,AX
                    XCHG   DI,AX
                    MOV    AX,SegSource
                    MOV    DS,AX
                    MOV    AX,SegDestination
                    MOV    ES,AX
                    MOV    CX,[Count]
                    MOV    AX,CX
                    SHL    AX,7
                    SHL    CX,5
                    ADD    CX,AX
                    REP    MOVSW
                    POP    DS
                    POP    BP
                    RET    8
CopyRowsRel ENDP

;******************************************************************************
;*                    Procedra ClearScreen (Color: Byte);                    *
;*                  Vymae obrazovku zvolenou farbou Color                    *
;******************************************************************************

PUBLIC ClearScreen
ClearScreen PROC FAR
 ARG Color: Byte
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[MainPage]
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    CX,07D00H
                    MOV    AL,[Color]
                    MOV    AH,AL
                    REP    STOSW
                    POP    BP
                    RET    2
ClearScreen ENDP

;******************************************************************************
;*       Procedra ClearScreenVirtual (SegVirtual: Word; Color: Byte);        *
;*             Vymae virtulnu obrazovku zvolenou farbou Color               *
;******************************************************************************

PUBLIC ClearScreenVirtual
ClearScreenVirtual PROC FAR
 ARG Color: Byte, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    XOR    DI,DI
                    MOV    CX,07D00H
                    MOV    AL,[Color]
                    MOV    AH,AL
                    REP    STOSW
                    POP    BP
                    RET    4
ClearScreenVirtual ENDP

;******************************************************************************
;*                 Procedra InvertScreen (SegScreen: Word);                  *
;*           Obrti obrazovku na segmente SegScreen "hore nohami"             *
;******************************************************************************

PUBLIC InvertScreen
InvertScreen PROC FAR
 ARG SegScreen: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[SegScreen]
                    MOV    ES,AX
                    MOV    SI,0
                    MOV    DI,0F9FEH
                    MOV    CX,3E80H
          @ISLoop:  MOV    AX,ES:[SI]
                    MOV    DX,ES:[DI]
                    XCHG   AH,AL
                    XCHG   DH,DL
                    MOV    ES:[SI],DX
                    MOV    ES:[DI],AX
                    ADD    SI,2
                    SUB    DI,2
                    LOOP   @ISLoop
                    POP    BP
                    RET    2
InvertScreen ENDP

;******************************************************************************
;*                           Procedra WaitRetrace;                           *
;*                    ak na cel nvrat svetelnho la                     *
;******************************************************************************

PUBLIC WaitRetrace                     ;Prebrat z XMode Lib 4.0
WaitRetrace PROC FAR
                    MOV     DX,3DAH
     @WaitNotVSync: IN      AL,DX
                    TEST    AL,8
                    JNZ     @WaitNotVSync
     @WaitVSync:    IN      AL,DX
                    TEST    AL,8
                    JZ      @WaitVSync
                    RET
WaitRetrace ENDP

;******************************************************************************
;*                          Procedra WaitVRetrace;                           *
;*                       ak na nvrat svetelnho la                       *
;******************************************************************************

PUBLIC WaitVRetrace
WaitVRetrace PROC FAR
                    MOV     DX,3DAH
     @@WaitVSync:   IN      AL,DX
                    TEST    AL,8
                    JZ      @@WaitVSync
                    RET
WaitVRetrace ENDP

;******************************************************************************
;*                         Procedra WaitNotVRetrace;                         *
;*                   ak na koniec nvratu svetelnho la                   *
;******************************************************************************

PUBLIC WaitNotVRetrace
WaitNotVRetrace PROC FAR
                    MOV     DX,3DAH
    @@WaitNotVSync: IN      AL,DX
                    TEST    AL,8
                    JNZ     @@WaitNotVSync
                    RET
WaitNotVRetrace ENDP

;******************************************************************************
;*                    Procedra WaitFrames (Frames: Word);                    *
;*                    ak Frames-krt na Vertical Retrace                    *
;******************************************************************************

PUBLIC WaitFrames
WaitFrames PROC FAR
 ARG Frames: Word
                    PUSH   BP
                    MOV    SP,BP
                    MOV    CX,[Frames]
          @WFLoop:  CALL   WaitRetrace
                    LOOP   @WFLoop
                    POP    BP
                    RET    2
WaitFrames ENDP

;******************************************************************************
;*                    Procedra SetMainPage (CPage: Word);                    *
;*       Nastav premenn MainPage tak, aby urovala segment obrazovky,       *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetMainPage
SetMainPage PROC FAR
 ARG MPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[MPage]
                    MOV    [MainPage],AX
                    POP    BP
                    RET    2
SetMainPage ENDP

;******************************************************************************
;*                         Funkcia GetMainPage : Word;                        *
;*      Vrti hodnotu premennej MainPage, obrazovky, do ktorej kreslme       *
;******************************************************************************

PUBLIC GetMainPage
GetMainPage PROC FAR
                    MOV    AX,[MainPage]
                    RET
GetMainPage ENDP

END