;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Lines

Model Medium

LOCALS

.286

.DATA

LinePage   DW    0A000H                  ;Segment obrazovky

.CODE

;******************************************************************************
;*            Procedra HorizontalLine (X1,X2,Y: Word; Col: Byte);            *
;*        Nakresl vodorovn iaru od X1 po X2 v riadku Y s farbou Col        *
;******************************************************************************

PUBLIC HorizontalLine
HorizontalLine PROC FAR
 ARG Col: Byte, Y: Word, X2: Word, X1: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     CX,[X2]
                    MOV     AX,[X1]
                    SUB     CX,AX
                    INC     CX
                    MOV     BX,CX
                    AND     BX,1
                    SHR     CX,1
                    MOV     AX,[LinePage]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    MOV     AH,AL
                    CLD
                    REP     STOSW
                    OR      BL,BL
                    JZ      @HLEnd
                    STOSB
         @HLEnd:    POP     BP
                    RET     8
HorizontalLine ENDP

;******************************************************************************
;*   Procedra HorizontalLineVirtual (SegVirtual,X1,X2,Y: Word; Col: Byte);   *
;* Nakresl vodorovn iaru na obrazovke so segmentom SegVirtual, od X1 po X2 *
;*                       v riadku Y s farbou Col                              *
;******************************************************************************

PUBLIC HorizontalLineVirtual
HorizontalLineVirtual PROC FAR
 ARG Col: Byte, Y: Word, X2: Word, X1: Word, SegVirtual: Word;
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     CX,[X2]
                    MOV     AX,[X1]
                    SUB     CX,AX
                    INC     CX
                    MOV     BX,CX
                    AND     BX,1
                    SHR     CX,1
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    MOV     AH,AL
                    CLD
                    REP     STOSW
                    OR      BL,BL
                    JZ      @HLVEnd
                    STOSB
         @HLVEnd:   POP     BP
                    RET     10
HorizontalLineVirtual ENDP

;******************************************************************************
;*         Procedra HorizontalLineRel (X,Y,Length: Word; Col: Byte);         *
;*           Nakresl vodorovn iaru od X1 s dkou Len v riadku Y           *
;*                                 s farbou Col                               *
;******************************************************************************

PUBLIC HorizontalLineRel
HorizontalLineRel PROC FAR
 ARG Col: Byte, Len: Word, Y: Word, X: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     CX,[Len]
                    MOV     AX,[LinePage]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    CLD
                    REP     STOSB
		    POP     BP
                    RET     8
HorizontalLineRel ENDP

;******************************************************************************
;*      Procedra HorizontalLineRelVirtual (SegVirtual,X,Y,Length: Word;      *
;*                                          Col: Byte);                       *
;*        Nakresl rovn vodorovn iaru od X1 s dkou Len v riadku Y        *
;*              s farbou Col na obrazovku na segmente SegVirtual              *
;******************************************************************************

PUBLIC HorizontalLineRelVirtual
HorizontalLineRelVirtual PROC FAR
 ARG Col: Byte, Len: Word, Y: Word, X: Word, SegVirtual: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     CX,[Len]
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,[Col]
                    CLD
                    REP     STOSB
		    POP     BP
                    RET     10
HorizontalLineRelVirtual ENDP

;******************************************************************************
;*             Procedra VerticalLine (X,Y1,Y2: Word; Col: Byte);             *
;*          Nakresl zvisl iaru od Y1 po Y2 v stpci X s farbou Col         *
;******************************************************************************

PUBLIC VerticalLine
VerticalLine PROC FAR
 ARG Col: Byte, Y2: Word, Y1: Word, X: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y1]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     DX,320
                    MOV     CX,[Y2]
                    MOV     AX,[Y1]
                    SUB     CX,AX
                    INC     CX
                    MOV     AX,[LinePage]
                    MOV     ES,AX
                    MOV     AL,[Col]
        @VLLoop:    MOV     ES:[DI],AL
                    ADD     DI,DX
                    LOOP    @VLLoop
		    POP     BP
                    RET     8
VerticalLine ENDP

;******************************************************************************
;*           Procedra VerticalLineRel (X,Y1,Y2: Word; Col: Byte);            *
;*       Nakresl zvisl iaru od Y s dkou Len v stpci X s farbou Col      *
;******************************************************************************

PUBLIC VerticalLineRel
VerticalLineRel PROC FAR
 ARG Col: Byte, Len: Word, Y: Word, X: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y1]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     DX,320
                    MOV     CX,[Len]
                    MOV     AX,[LinePage]
                    MOV     ES,AX
                    MOV     AL,[Col]
        @VLRLoop:   MOV     ES:[DI],AL
                    ADD     DI,DX
                    LOOP    @VLRLoop
		    POP     BP
                    RET     8
VerticalLineRel ENDP

;******************************************************************************
;*    Procedra VerticalLineVirtual (SegVirtual,X,Y1,Y2: Word; Col: Byte);    *
;*          Nakresl zvisl iaru od Y1 po Y2 v stpci X s farbou Col         *
;*                     na obrazovku na segmente SegVirtual                    *
;******************************************************************************

PUBLIC VerticalLineVirtual
VerticalLineVirtual PROC FAR
 ARG Col: Byte, Y2: Word, Y1: Word, X: Word, SegVirtual: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y1]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     DX,320
                    MOV     CX,[Y2]
                    MOV     AX,[Y1]
                    SUB     CX,AX
                    INC     CX
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,[Col]
        @VLVLoop:   MOV     ES:[DI],AL
                    ADD     DI,DX
                    LOOP    @VLVLoop
		    POP     BP
                    RET     10
VerticalLineVirtual ENDP

;******************************************************************************
;*  Procedra VerticalLineRelVirtual (SegVirtual,X,Y1,Y2: Word; Col: Byte);   *
;*       Nakresl zvisl iaru od Y s dkou Len v stpci X s farbou Col      *
;*                     na obrazovku na segmente SegVirtual                    *
;******************************************************************************

PUBLIC VerticalLineRelVirtual
VerticalLineRelVirtual PROC FAR
 ARG Col: Byte, Len: Word, Y: Word, X: Word, SegVirtual: Word
       		    PUSH    BP
                    MOV     BP,SP
                    MOV     AX,[Y1]
                    MOV     BX,AX
                    SHL     AX,8
                    SHL     BX,6
                    ADD     AX,BX
                    MOV     BX,[X1]
                    ADD     AX,BX
                    XCHG    DI,AX
                    MOV     DX,320
                    MOV     CX,[Len]
                    MOV     AX,[SegVirtual]
                    MOV     ES,AX
                    MOV     AL,[Col]
        @VLRVLoop:  MOV     ES:[DI],AL
                    ADD     DI,DX
                    LOOP    @VLRVLoop
		    POP     BP
                    RET     10
VerticalLineRelVirtual ENDP

;******************************************************************************
;*              Procedra Line (X1,Y1,X2,Y2: Word; Color: Byte);              *
;*                    Vykresl iaru z X1,Y1 do X2,Y2.                        *
;*  Pouva modifikciu Bresenhama, je to vlastne upraven prepis rutiny z C  *
;*   do ASM, C rutina sa nachdza vo VGL 2.0 od Marka Morleyho (VGLLine.C)    *
;* znane urchlen vykresovanie bodu, asi 4x rchlejie ako pvodn rutina  *
;******************************************************************************

PUBLIC Line
Line PROC FAR
 ARG Color: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word
 LOCAL D: Word, XD: Word, YD: Word, XA: Word, XS: Word, YD: Word, YA: Word, YS: Word, X: Word, Y: Word = LineVar
                       PUSH   BP
                       MOV    BP,SP
                       SUB    SP,LineVar
                       MOV    AX,[LinePage]
                       MOV    ES,AX
                       MOV    AX,[X2]
                       SUB    AX,[X1]
                       MOV    [XD],AX
                       MOV    BX,AX
                       AND    BX,8000H
                       JZ     @LSign1
                       NEG    AX
           @LSign1:    SHL    AX,1
                       MOV    [XA],AX
                       MOV    AX,[XD]
                       AND    AX,8000H
                       JNZ    @LAbs1
                       MOV    [XS],1
                       JMP    @LNext1
           @LAbs1:     MOV    [XS],-1
           @LNext1:    MOV    AX,[Y2]
                       SUB    AX,[Y1]
                       MOV    [YD],AX
                       MOV    BX,AX
                       AND    BX,8000H
                       JZ     @LSign2
                       NEG    AX
           @LSign2:    SHL    AX,1
                       MOV    [YA],AX
                       MOV    AX,[YD]
                       AND    AX,8000H
                       JNZ    @LAbs2
                       MOV    [YS],320
                       JMP    @LNext2
           @LAbs2:     MOV    [YS],-320
           @LNext2:    MOV    AX,[Y1]
                       MOV    BX,AX
                       SHL    AX,8
                       SHL    BX,6
                       ADD    AX,BX
                       MOV    BX,[X1]
                       ADD    BX,AX
                       MOV    AX,[Y2]
                       MOV    DX,AX
                       SHL    AX,8
                       SHL    DX,6
                       ADD    AX,DX
                       MOV    DX,[X2]
                       ADD    DX,AX
                       MOV    CL,[Color]
                       MOV    ES:[BX],CL
                       MOV    AX,[XA]
                       CMP    AX,[YA]
                       JBE    @LPart2
                       MOV    AX,[XA]
                       SHR    AX,1
                       MOV    CX,[YA]
                       SUB    CX,AX
                       MOV    [D],CX
           @LCycle1:   CMP    BX,DX
                       JE     @LEnd
                       MOV    CL,[Color]
                       MOV    ES:[BX],CL
                       MOV    CX,[D]
                       AND    CX,8000H
                       MOV    CX,[D]
                       JNZ    @LNoth1
                       ADD    BX,[YS]
                       SUB    CX,[XA]
                       MOV    [D],CX
           @LNoth1:    ADD    BX,[XS]
                       ADD    CX,[YA]
                       MOV    [D],CX
                       JMP    @LCycle1
           @LPart2:    MOV    AX,[YA]
                       SHR    AX,1
                       MOV    CX,[XA]
                       SUB    CX,AX
                       MOV    [D],CX
           @LCycle2:   CMP    BX,DX
                       JE     @LEnd
                       MOV    CL,[Color]
                       MOV    ES:[BX],CL
                       MOV    CX,[D]
                       AND    CX,8000H
                       MOV    CX,[D]
                       JNZ    @LNoth2
                       ADD    BX,[XS]
                       SUB    CX,[YA]
                       MOV    [D],CX
           @LNoth2:    ADD    BX,[YS]
                       ADD    CX,[XA]
                       MOV    [D],CX
                       JMP    @LCycle2
           @LEnd:      MOV    SP,BP
                       POP    BP
                       RET    10
Line ENDP

;******************************************************************************
;*     Procedra LineVirtual (SegVirtual,X1,Y1,X2,Y2: Word; Color: Byte);     *
;*    Vykresl iaru z X1,Y1 do X2,Y2 na obrazovku na segmente SegVirtual.    *
;*  Pouva modifikciu Bresenhama, je to vlastne upraven prepis rutiny z C  *
;*   do ASM, C rutina sa nachdza vo VGL 2.0 od Marka Morleyho (VGLLine.C)    *
;* znane urchlen vykresovanie bodu, asi 4x rchlejie ako pvodn rutina  *
;******************************************************************************

PUBLIC LineVirtual
LineVirtual PROC FAR
 ARG Color: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word, SegVirtual: Word
 LOCAL D: Word, XD: Word, YD: Word, XA: Word, XS: Word, YD: Word, YA: Word, YS: Word, X: Word, Y: Word = LineVar
                       PUSH   BP
                       MOV    BP,SP
                       SUB    SP,LineVar
                       MOV    AX,[SegVirtual]
                       MOV    ES,AX
                       MOV    AX,[X2]
                       SUB    AX,[X1]
                       MOV    [XD],AX
                       MOV    BX,AX
                       AND    BX,8000H
                       JZ     @LVSign1
                       NEG    AX
           @LVSign1:   SHL    AX,1
                       MOV    [XA],AX
                       MOV    AX,[XD]
                       AND    AX,8000H
                       JNZ    @LVAbs1
                       MOV    [XS],1
                       JMP    @LVNext1
           @LVAbs1:    MOV    [XS],-1
           @LVNext1:   MOV    AX,[Y2]
                       SUB    AX,[Y1]
                       MOV    [YD],AX
                       MOV    BX,AX
                       AND    BX,8000H
                       JZ     @LVSign2
                       NEG    AX
           @LVSign2:   SHL    AX,1
                       MOV    [YA],AX
                       MOV    AX,[YD]
                       AND    AX,8000H
                       JNZ    @LVAbs2
                       MOV    [YS],320
                       JMP    @LVNext2
           @LVAbs2:    MOV    [YS],-320
           @LVNext2:   MOV    AX,[Y1]
                       MOV    BX,AX
                       SHL    AX,8
                       SHL    BX,6
                       ADD    AX,BX
                       MOV    BX,[X1]
                       ADD    BX,AX
                       MOV    AX,[Y2]
                       MOV    DX,AX
                       SHL    AX,8
                       SHL    DX,6
                       ADD    AX,DX
                       MOV    DX,[X2]
                       ADD    DX,AX
                       MOV    CL,[Color]
                       MOV    ES:[BX],CL
                       MOV    AX,[XA]
                       CMP    AX,[YA]
                       JBE    @LVPart2
                       MOV    AX,[XA]
                       SHR    AX,1
                       MOV    CX,[YA]
                       SUB    CX,AX
                       MOV    [D],CX
           @LVCycle1:  CMP    BX,DX
                       JE     @LVEnd
                       MOV    CL,[Color]
                       MOV    ES:[BX],CL
                       MOV    CX,[D]
                       AND    CX,8000H
                       MOV    CX,[D]
                       JNZ    @LVNoth1
                       ADD    BX,[YS]
                       SUB    CX,[XA]
                       MOV    [D],CX
           @LVNoth1:   ADD    BX,[XS]
                       ADD    CX,[YA]
                       MOV    [D],CX
                       JMP    @LVCycle1
           @LVPart2:   MOV    AX,[YA]
                       SHR    AX,1
                       MOV    CX,[XA]
                       SUB    CX,AX
                       MOV    [D],CX
           @LVCycle2:  CMP    BX,DX
                       JE     @LVEnd
                       MOV    CL,[Color]
                       MOV    ES:[BX],CL
                       MOV    CX,[D]
                       AND    CX,8000H
                       MOV    CX,[D]
                       JNZ    @LVNoth2
                       ADD    BX,[XS]
                       SUB    CX,[YA]
                       MOV    [D],CX
           @LVNoth2:   ADD    BX,[YS]
                       ADD    CX,[XA]
                       MOV    [D],CX
                       JMP    @LVCycle2
           @LVEnd:     MOV    SP,BP
                       POP    BP
                       RET    12
LineVirtual ENDP

;******************************************************************************
;*                    Procedra SetLinePage (LPage: Word);                    *
;*       Nastav premenn LinePage tak, aby urovala segment obrazovky,       *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetLinePage
SetLinePage PROC FAR
 ARG LPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[LPage]
                    MOV    [LinePage],AX
                    POP    BP
                    RET    2
SetLinePage ENDP

;******************************************************************************
;*                         Funkcia GetLinePage : Word;                        *
;*      Vrti hodnotu premennej LinePage, obrazovky, do ktorej kreslme       *
;******************************************************************************

PUBLIC GetLinePage
GetLinePage PROC FAR
                    MOV    AX,[LinePage]
                    RET
GetLinePage ENDP

END