Title Keyboard

Model Medium

LOCALS

.DATA

Pressed     DB   0
ActKey      DB   0
KeyBuffer   DB   128  DUP  (?)

.CODE

PUBLIC Keyboard
Keyboard PROC FAR
                    PUSH   AX
                    PUSH   BX
                    PUSH   CX
                    PUSH   DI
                    PUSH   DS
                    CLI
                    XOR    CX,CX
          @KGetS:   IN     AL,64H
                    TEST   AL,2
                    LOOPNZ @KGetS
                    IN     AL,60H
                    STI
                    MOV    CH,[Pressed]
                    OR     AL,AL
                    JS     @KReleas
                    MOV    CL,1
                    MOV    CH,BL
                    MOV    AH,AL
                    JMP    @KBuffer
          @KReleas: XOR    CL,CL
                    XOR    AH,AH
                    AND    AL,7FH
          @KBuffer: XOR    BH,BH
                    MOV    BL,AL
                    DEC    BL
                    PUSH   AX
                    MOV    AX,DGROUP
                    MOV    DS,AX
                    POP    AX
                    MOV    DS:[KeyBuffer+BX],CL
                    MOV    [ActKey],AH
                    MOV    [Pressed],CH
          @KSkip:   MOV    AL,20H
                    OUT    20H,AL
                    POP    DS
                    POP    DI
                    POP    CX
                    POP    BX
                    POP    AX
                    IRET
Keyboard ENDP

PUBLIC KeyBufferAddr
KeyBufferAddr PROC FAR
 ARG PPBuf: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    DI,[PPBuf]
                    LEA    BX,[KeyBuffer]
                    MOV    ES:[DI],BX
                    ADD    DI,2
                    MOV    ES:[DI],DS
                    POP    BP
                    RET    4
KeyBufferAddr ENDP

PUBLIC Key
Key PROC FAR
                    MOV    AL,[ActKey]
                    RET
Key ENDP

END