;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Hardware

MODEL Medium

LOCALS

.486                                     ;Pre testovanie CPU ID a 386/486

.DATA

ProcTest    DB     0
Floating    DW     0
EMMHandler  DB     'EMMXXXX0'
XMSHandler  DB     'XMSXXXX0'
CPUIDOut    DB     '                        '
CardTable   DB     0,2,5,6,7,8,10,9,9,11,13,12
Mono        DB     0
AdlibPort   DW     388H,388H,388H,388H

.CODE

;******************************************************************************
;*                         Funkcia DetectVideo: Byte;                         *
;*                        Vrti slo grafickej karty                         *
;*                                                                            *
;*      Hodnota funkcie (registra AL) :  0.bez grafickej karty (?)            *
;*                                       1.MDA                                *
;*                                       2.Hercules Graphics Card             *
;*                                       3.Hercules InColor                   *
;*                                       4.Hercules Graphics Card +           *
;*                                       5.CGA                                *
;*                                       6.EGA                                *
;*                                       7.EGA Mono                           *
;*                                       8.PGA Color                          *
;*                                       9.VGA                                *
;*                                      10.VGA Mono                           *
;*                                      11.MCGA Digital                       *
;*                                      12.MCGA                               *
;*                                      13.MCGA Mono                          *
;*                                      14.XGA                                *
;*                                      15.XGA NI                             *
;*                                     255. ?                                 *
;******************************************************************************

PUBLIC DetectVideo
DetectVideo PROC FAR
                    INT    11H                    ;Chceme informacie o systeme
                    AND    AX,30H
                    SHR    AX,4
                    OR     AL,AL                  ;Ma system videokartu ?
                    JNZ    @CheckMono
                    XOR	   AL,AL                  ;Ak nema :-(
                    JMP    @VTEnd
        @CheckMono: MOV    DI,Seg Mono            ;Nastavenie premennej, ktora
                    MOV    ES,DI                  ;ukazuje, ci mame monochromaticku
                    MOV    DI,Offset Mono         ;kartu, na 0
                    XOR    BL,BL                  ;(= segment nie je na B800H ale na B000H)
                    MOV    ES:[DI],BL
                    XOR    AL,3                   ;Mame monochrom ?
                    JNZ    @TestBIOS              ;Ak nemame
                    INC    BL                     ;Ak mame, nastavi Mono na 1
                    MOV    ES:[DI],BL             
        @TestBIOS:  MOV    AX,1A00H
                    INT    10H
                    CMP    AL,1AH                 ;Je to VGA BIOS ?
                    JNE    @TestEGA               ;Ak nie, testuje sa EGA
                    CMP    BL,0CH                 ;Karta hlasi, ze sa "nepozna" ?
                    JNA    @TestVGA               ;Ak sa pozna ;-)
                    MOV    AL,5
                    JMP    @DVEnd                 ;Zrejme mame CGA
        @TestVGA:   MOV    AX,Seg CardTable
                    MOV    ES,AX
                    MOV    DI,Offset CardTable
                    XOR    BH,BH                  ;Je to VGA/MCGA/PGA ?
                    ADD    DI,BX                  ;Alebo VGA emuluje inu kartu ?
                    MOV    AL,ES:[DI]
                    JMP    @VTEnd
        @TestEGA:   MOV    AH,12H                 ;Daj informacie o EGA
                    MOV    BX,10H
                    INT    10H
                    CMP    BL,3
                    JA     @TestCGA               ;Ak EGA nie je podporovana Video BIOSom
                    MOV    AL,6                   ;Ak je, tak mame EGA kartu
                    OR     BH,BH
                    JE     @VTEnd                 ;Je monochrom ?
                    INC    AL                     ;Ak je, mame EGA Mono
                    JMP    @VTEnd
        @TestCGA:   MOV    DX,3D4H
                    MOV    AL,0FH
                    OUT    DX,AL                  ;6845 Reg 0FH (Cursor Location Low)
                    INC    DX
                    IN     AL,DX                  ;Vyberieme hodnotu registra Cursor Location Low
                    MOV    AH,AL                  ;Ulozime si ho aj do AH
                    MOV    AL,23H                 ;Chceme vyslat hodnotu na Cursor Location Low
                    OUT    DX,AL                  ;Skusime zapisat do 6845
                    MOV    CX,0FFFFH
        @Wait6845:  LOOP   @Wait6845              ;Pockame, kym sa 6845 ozve
                    IN     AL,DX
                    XCHG   AH,AL                  ;Nieco nam prislo
                    OUT    DX,AL                  ;Vysleme originalnu hodnotu
                    CMP    AH,23H                 ;Vratilo nam 6845 to co sme don davali ?
                    JNE    @MDAHerc               ;Ak nie, testuje MDA/HGC
                    MOV    AL,5
                    JMP    @DVEnd
        @MDAHerc:   MOV    DX,3B4H
                    MOV    AL,0AH
                    OUT    DX,AL
                    INC    DX
                    IN     AL,DX
                    MOV    AH,AL
                    MOV    AL,6
                    OUT    DX,AL                  ;Zmena velkosti kurzora
                    MOV    CX,10000
        @HR1:       LOOP   @HR1
                    IN     AL,DX
                    XCHG   AH,AL
                    OUT    DX,AL
                    CMP    AH,6
                    JNE    @TestXGA
                    MOV    CX,50000
                    MOV    DX,3BAH
                    IN     AL,DX
                    XCHG   AH,AL
        @HR2:       IN     AL,DX
                    CMP    AH,AL
                    JNE    @MDATest
                    LOOP   @HR2
        @MDATest:   OR     CX,CX
                    JNZ    @HercID
                    MOV    AL,1
                    JMP    @VTEnd
        @HercID:    AND    AL,70H
                    CMP    AL,50H
                    JNE    @HercPlus
                    MOV    AL,3
                    JMP    @VTEnd
        @HercPlus:  CMP    AL,10H
                    JNE    @Hercules
                    MOV    AL,4
                    JMP    @VTEnd
        @Hercules:  MOV    AL,2
                    JMP    @VTEnd
        @TestXGA:   MOV    DX,100H                ;Mame XGA ?
                    IN     AX,DX                  ;Port 100H
                    CMP    AX,8FDBH               ;Je standartna XGA ?
                    JNE    @TestXGANI
                    MOV    AL,14                  ;Je to standartna XGA
                    JMP    @DVEnd
        @TestXGANI: CMP    AX,8FDAH               ;Je to XGA NI ?
                    JNE    @CardNotID
                    MOV    AL,15                  ;Je to XGA NI
                    JMP    @DVEnd
        @CardNotID: MOV    AL,0FFH                ;Neznama videokarta
                    JMP    @DVEnd
        @VTEnd:     MOV    DI,Seg Mono            ;Sme v monochrome ?
                    MOV    ES,DI                  ;Nasledujuce testy su kvoli nie-prilisnej
                    MOV    DI,Offset Mono         ;kompatibilite vacsiny kariet s originalnym
                    MOV    AH,ES:[DI]             ;VGA BIOS-om (napr. Tseng, Paradise...)
                    OR     AH,AH
                    JZ     @NoMono                ;Ak nie sme
                    CMP    AL,6
                    JNE    @Mon1                  ;Ak sme mono a BIOS hlasi, ze sme EGA Color,
                    INC    AL                     ;vratime EGA Mono
        @Mon1:      CMP    AL,9
                    JNE    @Mon2                  ;Ak sme mono a BIOS hlasi, ze sme VGA Color,
                    INC    AL                     ;vratime VGA Mono
        @Mon2:      CMP    AL,12
                    JNE    @DVEnd                 ;Ak sme mono a BIOS hlasi, ze sme MCGA Color,
                    INC    AL                     ;vratime MCGA Mono
                    JMP    @DVEnd
        @NoMono:    CMP    AL,7                   ;Ak sa hlasi ako color
                    JNE    @NoMon1                ;Ak sme color a BIOS hlasi, ze sme EGA Mono,
                    DEC    AL                     ;vratime EGA Color
        @NoMon1:    CMP    AL,10
                    JNE    @NoMon2                ;Ak sme color a BIOS hlasi, ze sme VGA Mono,
                    DEC    AL                     ;vratime VGA Color
        @NoMon2:    CMP    AL,13
                    JNE    @DVEnd                 ;Ak sme color a BIOS hlasi, ze sme MCGA Mono,
                    DEC    AL                     ;vratime MCGA Color
        @DVEnd:     RET
DetectVideo ENDP

;******************************************************************************
;*                      Funkcia PresentCDROM: Boolean                         *
;*         Zist, i je v potai naintalovan CD-ROM, cez MSCDEx           *
;******************************************************************************

PUBLIC PresentCDROM
PresentCDROM PROC FAR
                    MOV    AX,1500H                  ;Sluba 0 na INT 2FH
                    XOR    BX,BX
                    INT    2FH
                    XCHG   AL,BL                     ;Vstup do AL
                    RET
PresentCDROM ENDP

;******************************************************************************
;*                       Funkcia GetCDROMDrive: Char                          *
;*            Vrti psmeno logickho disku DOSu pre 1.CD-ROM                 *
;******************************************************************************

PUBLIC GetCDROMDrive
GetCDROMDrive PROC FAR
                    MOV    AX,1500H
                    INT    2FH
                    MOV    AL,CL
                    ADD    AL,65                     ;ASCII znak
                    RET
GetCDROMDrive ENDP

;******************************************************************************
;*                       Funkcia GetCDROMNumber: Byte                         *
;*                     Vrti poet CD-ROMiek v potai                       *
;******************************************************************************

PUBLIC GetCDROMNumber
GetCDROMNumber PROC FAR
                    MOV    AX,1500H
                    INT    2FH
                    MOV    AL,BL                     ;Vstup do AL
                    RET
GetCDROMNumber ENDP

;******************************************************************************
;*             Procedra GetMSCDExVersion (Var VerHi,VerLo: Byte)             *
;* Vrti slo verzie MSCDEx, VerHi - 1.slo, VerLo - 2.slo (VerHi.VerLo)  *
;******************************************************************************

PUBLIC GetMSCDExVersion
GetMSCDExVersion PROC FAR
 ARG VerLo: DWord, VerHi: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,150CH
                    XOR    BX,BX
                    INT    2FH
                    OR     BX,BX                     ;Je tam MSCDEx 2.0+ ?
                    JNZ    @MSCDEx2                  ;Ak je
                    MOV    BH,1                      ;Ak nie je
        @MSCDEx2:   LES    DI,[VerHi]                ;VerHi = BH
                    MOV    ES:[DI],BH
                    LES    DI,[VerLo]                ;VerLo = BL
                    MOV    ES:[DI],BL
                    POP    BP
                    RET    8
GetMSCDExVersion ENDP

;******************************************************************************
;*                            Preruenie Invalid                              *
;*     Tto rutina je na preruen INT 6H, vyvol sa pri vskyte neznmej     *
;*             intrukcie. Vyuiten pri detekcii typu procesora             *
;******************************************************************************

PUBLIC Invalid
Invalid PROC FAR
                    PUSH   BP
                    MOV    BP,SP
                    MOV    [ProcTest],1              ;no, procesor ju nepodporuje
                    ADD    WORD PTR SS:[BP+2],3      ;Preskoenie neposlunej intrukcie
                    POP    BP
                    IRET
Invalid ENDP

;******************************************************************************
;*                               Makro CPUID                                  *
;*  Intrukcia CPUID, vyskytuje sa na Pentiu, neskr sa zaviedla aj do i486,  *
;*        tieto 486-ky maj oznaenie 486-S (486DX2-S/486DX4/486SX2)          *
;*            Je predpoklad, e sa bude vyskytova aj v P6/P7...              *
;*                                                                            *
;*          Je zaujimave, ze AMD 5x86/133 sa predstavuje ako 486.             *
;*                          Asi na tom nieco bude...                          *
;*                                                                            *
;*              Cyrix 5x86 & 6x86 NEOBSAHUJU instrukciu CPUID !               *
;*                                                                            *
;*              Pri EAX = 0 vrati meno vyrobcu do EBX+EDX+ECX                 *
;*            Pri EAX = 1 vrati do EAX family, stepping a model               *
;*    Niektore zname nazvy vyrobcov: Intel - GenuineIntel                     *
;*                                     AMD - AuthenticAMD                     *
;*                                     UMC - UMC UMC UMC                      *
;*                                   Cyrix - CyrixInstead                     *
;******************************************************************************

CPUID MACRO
                    DB     0FH                       ;Intrukcia CPUID
                    DB     0A2H
      ENDM

;******************************************************************************
;*                       Funkcia ProcessorType: Byte                          *
;*                           Zist typ procesoru                              *
;*           slo v AL udva typ procesoru:   0 - neznmy procesor           *
;*                                             1 - 8088                       *
;*                                             2 - 8086                       *
;*                                             3 - NEC V20                    *
;*                                             4 - NEC V30                    *
;*                                             5 - 80188                      *
;*                                             6 - 80186                      *
;*                                             7 - 80286                      *
;*                                             8 - 80386SX                    *
;*                                             9 - 80386DX                    *
;*                                            10 - Cx486SLC                   *
;*                                            11 - Cyrix x86                  *
;*                                            12 - 80486SX                    *
;*                                            13 - 80486DX                    *
;*                                            14 - 80486SX-S                  *
;*                                            15 - 80486DX-S                  *
;*                                            16 - Pentium/K5                 *
;*                                            17 - Pentium Pro                *
;*                                            18 - P7+  (minimlne 786)       *
;******************************************************************************

PUBLIC ProcessorType
ProcessorType PROC FAR
 LOCAL PType: Byte, OldVecSeg,OldVecOfs: Word = PTVar
                    PUSH   BP
                    MOV    BP,SP                          ;Netestuje Intel RapidCAD
                    SUB    SP,PTVar
                    XOR    AX,AX
                    PUSHF
                    PUSH   AX                             ;Test CPU < 286
                    POPF                                  ;Bity 15-12 sa na <286 nedaju nastavit
                    PUSHF
                    POP    AX
                    POPF
                    AND    AX,0F000H
                    CMP    AX,0F000H
                    JNE    @Test486                       ;Test 486
                    XOR    AX,AX
                    DEC    AX
                    MOV    CL,21H
                    SHL    AX,CL                          ;Posun AL o 33 dolava
                    JZ     @Test86                        ;Ak nie je vystup rovnaky ako vstup, mame 186/188, ak je, je to 86/88 alebo NEC V20/V30
                    MOV    [PType],5                      ;Mame 186/188
                    JMP    @PTFront                       ;Rozlisenie 186/188
       @Test86:     PUSH   SP                             ;Ulo SP
                    POP    AX                             ;Vyber SP do AX
                    CMP    SP,AX                          ;Je to 8086/88/V20/V30 ?
                    JNZ    @8688V                         ;Ak AX=SP, nie je to 8086/88/V20/V30
                    JMP    @Unknown
       @8688V:      MOV    [PType],1
                    MOV    CX,0FFFFH
                    STI
                    PUSH   AX
                    PUSH   SI
                    DB     0F3H,026H,0ACH                 ;REP    SEG ES LODSB
                    POP    SI
                    POP    AX
                    JCXZ   @CPUNEC                        ;Je to V20/V30 ?
                    JMP    @Test486                       ;Ak to nie je 86/88/V20/V30
       @CPUNEC:     MOV    [PType],3                      ;Je to V20/V30
       @SkipNEC:    JMP    @PTFront                       ;Sko na zistenie 88/86/V20/V30
       @Test486:    MOV    [ProcTest],0
                    MOV    [PType],12
                    MOV    AX,3506H
                    INT    21H
                    MOV    [OldVecSeg],ES
                    MOV    [OldVecOfs],BX                 ;Zistenie starej rutiny na INT 6H
                    PUSH   DS
                    MOV    DX,Offset Invalid
                    MOV    AX,Seg Invalid
                    MOV    DS,AX
                    MOV    AX,2506H
                    INT    21H                            ;Nastavenie kontrolnej rutiny na INT 6H
                    POP    DS                             ;INT 6H je vyvolan, ke procesor nepozn intrukciu
                    P486
                    XADD   DX,DX                          ;DB 0FH,0C1H,0D2H - 486+
                    PUSH   DS
                    MOV    DX,[OldVecOfs]
                    MOV    AX,[OldVecSeg]
                    MOV    DS,AX
                    MOV    AX,2506H
                    INT    21H                            ;Nastavenie pvodnej rutiny na INT 6H
                    POP    DS
                    MOV    AL,[ProcTest]
                    OR     AL,AL                          ;Je to 486 ?
                    JNZ    @Test386                       ;Bolo vyvolan preruenie ? Ak no, sko na 386
        @Cx486DLC:  XOR    EAX,EAX                        ;Test na i486 vs Cyrix x86
                    CMP    EAX,EAX
                    PUSHFD                                ;Priznaky pred delenim do ECX
                    POP    ECX
                    MOV    EAX,0FFFFH                     ;Delenec do EAX
                    XOR    EDX,EDX                        ;Zvysok vyprazdnime
                    MOV    EBX,4                          ;Delitel do EBX
                    DIV    EBX                            ;Delime
                    PUSHFD
                    POP    EDX                            ;Priznaky po deleni do EDX
                    MOV    EAX,8D5H                       ;Chceme len niektore priznaky
                    AND    EAX,ECX
                    MOV    EBX,8D5H
                    AND    EBX,EDX
                    CMP    EAX,EBX                        ;Su rovnake ?
                    JNZ    @MathCopro                     ;Ak nie su, mame Intel/AMD/...
                    MOV    [PType],10                     ;Inak mame Cyrix/UMC
                    JMP    @PTFront                       ;Test na Cx486SLC/DLC/DX/UMC
        @MathCopro: FNINIT
                    MOV    [Floating],333H
                    FNSTSW [Floating]
                    MOV    AX,[Floating]
                    OR     AL,AL
	            JNZ    @ID486
                    FNSTCW [Floating]
                    MOV    AX,[Floating]
                    AND    AX,103FH
                    CMP    AX,3FH
                    JNZ    @ID486
                    INC    [PType]
       @ID486:      JMP    @CPUIDSup                      ;Ak to je 486, sko na test podpory CPUID
       @Test386:    MOV    [PType],8
                    MOV    [ProcTest],0
                    PUSH   DS
                    MOV    DX,Offset Invalid
                    MOV    AX,Seg Invalid
                    MOV    DS,AX
                    MOV    AX,2506H
                    INT    21H
                    POP    DS
                    MOV    EDX,CR0                        ;DB 0FH,20H,0C2H - len 386+
                    PUSH   DS
                    MOV    DX,[OldVecOfs]
                    MOV    AX,[OldVecSeg]
                    MOV    DS,AX
                    MOV    AX,2506H
                    INT    21H
                    POP    DS
                    MOV    AL,[ProcTest]
                    OR     AL,AL                          ;Je to 386 ?
                    JNZ    @Test286                       ;Bolo vyvolan preruenie ? Ak no, sko na 286
                    MOV    EAX,CR0                        ;Do EAX ulome Control Register 0
                    MOV    EBX,EAX                        ;Uschovanie EAX
                    XOR    AL,10H                         ;Prepnutie 4.bitu v EAX (ET bit)
                    MOV    CR0,EAX                        ;Uloenie EAX do CR0
                    MOV    EAX,CR0                        ;Vyberieme CR0 do EAX
                    MOV    CR0,EBX                        ;Do CR0 vlome pvodn hodnotu = EBX
                    XOR    EBX,EAX                        ;Zistme, i sme prepli 4.bit
                    JZ     @ID386                         ;Ak sme neprepli, 386SX (chyba SX)
                    INC    [PType]                        ;Inak 386DX
       @ID386:      JMP    @PTEnd                         ;Skoni
       @Test286:    MOV    [ProcTest],0
                    MOV    [PType],7
                    PUSH   DS
                    MOV    DX,Offset Invalid
                    MOV    AX,Seg Invalid
                    MOV    DS,AX
                    MOV    AX,2506H
                    INT    21H
                    POP    DS
                    SMSW   DX                             ;DB 0FH,01H,0E2H - len 286+
                    PUSH   DS
                    MOV    DX,[OldVecOfs]
                    MOV    AX,[OldVecSeg]
                    MOV    DS,AX
                    MOV    AX,2506H
                    INT    21H
                    POP    DS
                    MOV    AL,[ProcTest]
                    OR     AL,AL                          ;Je to 286 ?
                    JNZ    @Unknown                       ;Bolo vyvolan preruenie ? Ak no, sko na "unknown"
                    JMP    @PTEnd                         ;Ak to je 286, skoni
       @Unknown:    MOV    [PType],0                      ;Neznamy procesor
                    JMP    @PTEnd
       @CPUIDSup:   PUSHFD                                ;Prevzat z Intel recommended method
                    POP    EAX                            ;of determining processor type
                    MOV    ECX,EAX
                    XOR    EAX,200000H
                    PUSH   EAX
                    POPFD
                    PUSHFD
                    POP    EAX
                    XOR    EAX,ECX
                    JNE    @TestCPUID                     ;Je to 486-S ?
                    JMP    @PTEnd                         ;Ak nie, skoni
       @TestCPUID:  XOR    EAX,EAX
                    CPUID
                    MOV    DI,Seg CPUIDOut
                    MOV    ES,DI
                    MOV    DI,Offset CPUIDOut
                    MOV    ES:[DI],EBX
                    ADD    DI,4
                    MOV    ES:[DI],EDX
                    ADD    DI,4
                    MOV    ES:[DI],ECX
                    ADD    DI,4
                    MOV    EAX,1
                    CPUID
                    PUSH   EAX
                    AND    EAX,0F00H
                    SHR    AX,8
                    MOV    ES:[DI],AL
                    INC    DI
                    POP    EAX
                    PUSH   EAX
                    AND    AL,0FH
                    MOV    ES:[DI],AL
                    INC    DI
                    POP    EAX
                    PUSH   EAX
                    AND    EAX,0F0H
                    SHR    AX,4
                    MOV    ES:[DI],AL
                    POP    EAX
                    AND    EAX,0F00H
                    SHR    AX,8
                    CMP    AL,4                           ;Je to 486 ?
                    JNE    @Pentium                       ;Alebo 586 ?
                    ADD    [PType],2
                    JMP    @PTEnd
       @Pentium:    CMP    AL,5                          ;Je to 586 ?
                    JNE    @Sixtium
                    MOV    [PType],16
                    JMP    @PTEnd
       @Sixtium:    CMP    AL,6                          ;Je to 686 ?
                    JNE    @Heptium
                    MOV    [PType],17
                    JMP    @PTEnd
       @Heptium:    ADD    AL,0BH
                    MOV    [PType],AL                     ;786+ |-) '95
                    JMP    @PTEnd
       @PTFront:    MOV    AX,CS                          ;CS:Offset IFSelf
                    MOV    ES,AX
                    STD                                   ;Ideme dozadu
                    MOV    DI,Offset @IFSelf
                    MOV    AL,0FBH                        ;STI
                    MOV    CX,3                           ;3-krt
                    CLI                                   ;Zkaz preruenia
                    REP    STOSB                          ;A prepisujeme intrukcie
                    NOP                                   ;Zistenie dky frontu intrukci
                    NOP
                    NOP
                    NOP
                    INC    CX                             ;Ak je to 88/V20/188/SLC bude tu STI
                    NOP                                   ;Lebo INC CX nie je vo fronte
        @IFSelf:    STI                                   ;3<=>1.STI
                    CLD
                    JCXZ   @PTEnd
                    INC    [PType]
                    CMP    [PType],11
                    JNE    @PTEnd
                    JMP    @CPUIDSup
        @PTEnd:     MOV    AL,[PType]                     ;AL = Typ procesora
                    MOV    SP,BP
                    POP    BP
                    RET
ProcessorType ENDP

;******************************************************************************
;*                       Funkcia GetCPUIDInfo: Pointer;                       *
;*           Vrti adresu informci zskanch z intrukcie CPUID             *
;******************************************************************************

PUBLIC GetCPUIDInfo
GetCPUIDInfo PROC FAR
                    MOV    AX,Offset CPUIDOut
                    MOV    DX,Seg CPUIDOut
                    RET
GetCPUIDInfo ENDP

;******************************************************************************
;*                 Funkcia PresentMathCoprocessor: Boolean;                   *
;*          Vrti True, ak je matematick koprocesor naintalovan            *
;******************************************************************************

PUBLIC PresentMathCoprocessor
PresentMathCoprocessor PROC FAR
;                    PUSH   0                     ;Kontrola cez BIOS
;                    POP    ES                    ;Nata system info word BIOSu
;                    MOV    DI,410H               ;Nefunguje sprvne, ak m pota
;                    MOV    AX,ES:[DI]            ;s koprocesorom v BIOSe nastaven
;                    AND    AX,2                  ;Numeric procesor test DISABLED (AMI BIOS)
;                    SHR    AX,1
;                    RET
                    FNINIT                        ;Priama kontrola
                    MOV    [Floating],333H
                    FNSTSW [Floating]             ;Vybratie kontrolho slova z koprocesora
                    MOV    AX,[Floating]
                    OR     AL,AL
	            JNZ    @NoMCP
                    FNSTCW [Floating]
                    MOV    AX,[Floating]
                    AND    AX,103FH
                    CMP    AX,3FH
                    JNZ    @NoMCP
                    MOV    AL,1
                    RET
          @NoMCP:   XOR    AX,AX
                    RET
PresentMathCoprocessor ENDP

;******************************************************************************
;*                      Funkcia GetFloppyDrive: Byte;                         *
;*                     Vrti poet disketovch mechank                       *
;******************************************************************************

PUBLIC GetFloppyDrive
GetFloppyDrive PROC FAR
                    PUSH   0
                    POP    ES
                    MOV    DI,410H                ;Pretame konfiguran slovo BIOSu
                    XOR    AX,AX                  ;na 0000:0410H
                    MOV    BX,ES:[DI]
                    MOV    CX,BX
                    AND    BX,1                   ;Intalovan FDD ?
                    JZ     @GFDEnd                ;Ak nie, skoni
                    AND    CX,0C0H                ;Inak je poet-1 ulo4en na 6. a 7.bite
                    SHR    CX,6                   ;Posunieme doprava o 6 bitov
                    INC    CX                     ;Zvime poet
                    MOV    AX,CX
         @GFDEnd:   RET
GetFloppyDrive ENDP

;******************************************************************************
;*           Procedra FloppyDriveType (Var Floppy1,Floppy2: Byte)            *
;*     Vrti typ mechank do Floppy1/2, typy : 0 - nenaintalovan            *
;*                                             1 - 5.25" 360kB                *
;*                                             2 - 5.25" 1.2MB                *
;*                                             3 - 3.5"  720kB                *
;*                                             4 - 3.5" 1.44MB                *
;*                                             5 - 3.5" 2.88MB                *
;******************************************************************************

PUBLIC FloppyDriveType
FloppyDriveType PROC FAR
 ARG Floppy1: DWord, Floppy2: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,10H
                    OUT    70H,AL
                    JMP    $+2                    ;Zdranie pre CMOS
                    IN     AL,71H                 ;Typ mechaniky z portu 71H
                    MOV    AH,AL
                    AND    AL,0FH                 ;Zisjeme typ 1.FDD
                    LES    DI,[Floppy1]
                    MOV    ES:[DI],AL
                    AND    AH,0F0H                ;Zisujeme typ 2.FDD
                    SHR    AH,4
                    LES    DI,[Floppy2]
                    MOV    ES:[DI],AH
                    POP    BP
                    RET
FloppyDriveType ENDP

;******************************************************************************
;*                      Funkcia GetSerialPort: Byte;                          *
;*                      Vrti poet sriovch portov                          *
;******************************************************************************

PUBLIC GetSerialPort
GetSerialPort PROC FAR
                    PUSH   0
                    POP    ES
                    MOV    DI,410H                ;Z konfiguranho slova BIOSu
                    MOV    AX,ES:[DI]             ;zistme poet sriovch portov
                    AND    AX,0E00H
                    SHR    AX,9
                    RET
GetSerialPort ENDP

;******************************************************************************
;*                      Funkcia GetParallelPort: Byte;                        *
;*                      Vrti poet paralelnch portov                        *
;******************************************************************************

PUBLIC GetParallelPort
GetParallelPort PROC FAR
                    PUSH   0
                    POP    ES
                    MOV    DI,410H                ;Z konfiguranho sboru BIOSu
                    MOV    AX,ES:[DI]             ;zistme poet paralelnch portov
                    AND    AX,0C000H
                    SHR    AX,14
                    RET
GetParallelPort ENDP

;******************************************************************************
;*                     Funkcia PresentGamePort: Boolean;                      *
;*       Vrti True, ak zist podporu BIOSu pre joystick (nie joyport)        *
;******************************************************************************

PUBLIC PresentGamePort
PresentGamePort PROC FAR
                    PUSH   0
                    POP    ES
                    MOV    DI,410H                ;Z konfiguranho sboru BIOSu
                    MOV    AX,ES:[DI]             ;zistme, i BIOS podporuje
                    AND    AX,2000H               ;tanie z Game Portu
                    SHR    AX,12
                    RET
PresentGamePort ENDP

;******************************************************************************
;*                       Funkcia PresentMouse: Byte;                          *
;*    Vrti typ myi:                    0 - nenaintalovan                  *
;*                                       2 - MicroSoft, 2 tlatka            *
;*                                       3 - Mouse System, 3 tlatka         *
;*                                     255 - Neznmy typ                      *
;******************************************************************************

PUBLIC PresentMouse
PresentMouse PROC FAR
                    XOR    AX,AX
                    INT    33H
                    OR     AX,AX
                    JZ     @PMEnd
                    MOV    AX,BX
                    OR     AX,AX
                    JNZ    @PM1
                    MOV    AL,-1
                    JMP    @PMEnd
         @PM1:      AND    BX,8000H
                    JZ     @PMNext
                    NEG    AX
         @PMNext:   CMP    AX,1
                    JNE    @PMEnd
                    INC    AX
         @PMEnd:    RET
PresentMouse ENDP

;******************************************************************************
;*                     Funkcia EnhancedKeyboard: Boolean;                     *
;*    Vrti True, ak zist napojen rozren klvesnicu (101-102 klves)     *
;******************************************************************************

PUBLIC EnhancedKeyboard
EnhancedKeyboard PROC FAR
                    MOV    AH,02
                    INT    16H
                    XCHG   BL,AL
                    MOV    AH,12H
                    INT    16H
                    XCHG   AL,BH
                    XOR    AL,AL
                    CMP    BH,BL
                    JNE    @EKEnd
                    INC    AL
         @EKEnd:    RET
EnhancedKeyboard ENDP

;******************************************************************************
;*                       Funkcia PresentEMS: Boolean;                         *
;*             Zist, i je naintalovan EMM (Expanded memory)               *
;******************************************************************************

PUBLIC PresentEMS
PresentEMS PROC FAR
                    PUSH   DS
                    CLD
                    MOV    CX,8
                    MOV    AX,3567H
                    INT    21H
                    XOR    AL,AL
                    MOV    DI,0AH
                    MOV    SI,Offset EMMHandler
         @PELoop:   MOV    AH,ES:[DI]
                    MOV    BH,DS:[SI]
                    INC    SI
                    INC    DI
                    CMP    AH,BH
                    JNZ    @PEEnd
                    LOOP   @PELoop
                    MOV    AL,1
          @PEEnd:   POP    DS
                    RET
PresentEMS ENDP

;******************************************************************************
;*                       Funkcia GetEMSVersion: Byte;                         *
;*           Vrti verziu LIM EMS (3.2 alebo 4.0) v BCD formte               *
;******************************************************************************

PUBLIC GetEMSVersion
GetEMSVersion PROC FAR
                    MOV    AX,4600H
                    INT    67H
                    RET
GetEMSVersion ENDP

;******************************************************************************
;*                Procedra EMSMemory (Var MTotal,MFree: Word);               *
;*       Do premennej MTotal vlo celkov vekos EMS a do MFree von       *
;*                  vekos EMS, vlo tam poet 16kB strnok                 *
;******************************************************************************

PUBLIC EMSMemory
EMSMemory PROC FAR
 ARG MFree: DWord, MTotal: DWord
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,4200H
                    INT    67H
                    LES    DI,[MTotal]
                    MOV    ES:[DI],DX
                    LES    DI,[MFree]
                    MOV    ES:[DI],BX
                    POP    BP
                    RET
EMSMemory ENDP

;******************************************************************************
;*                      Funkcia GetVCPIVersion: Word;                         *
;*     Vrti verziu VCPI v BCD formte, ak nie je prtomn VCPI, vrti 0      *
;******************************************************************************

PUBLIC GetVCPIVersion
GetVCPIVersion PROC FAR
                    MOV    AX,0DE00H
                    INT    67H
                    OR     AH,AH
                    JNZ    @NoVCPI
                    MOV    AX,BX
                    JMP    @GVVEnd
         @NoVCPI:   XOR    AX,AX
         @GVVEnd:   RET
GetVCPIVersion ENDP

;******************************************************************************
;*                      Funkcia GetDPMIVersion: Word;                         *
;*     Vrti verziu DPMI v BCD formte, ak nie je prtomn DPMI, vrti 0      *
;******************************************************************************

PUBLIC GetDPMIVersion
GetDPMIVersion PROC FAR
                    MOV    AX,1687H
                    INT    2FH
                    OR     AX,AX
                    JZ     @DPMIPres
                    XOR    AX,AX
                    RET
        @DPMIPres:  MOV    AH,DH
                    MOV    AL,DL
                    RET
GetDPMIVersion ENDP

;******************************************************************************
;*                       Funkcia PresentXMS: Boolean;                         *
;*             Zist, i je naintalovan XMM (Extended memory)               *
;******************************************************************************

PUBLIC PresentXMS
PresentXMS PROC FAR
                    MOV    AX,4300H
                    INT    2FH
                    CMP    AL,80H
                    JE     @PXEnd
                    XOR    AL,AL
         @PXEnd:    RET
PresentXMS ENDP

;******************************************************************************
;*           Procedra GetXMSVersion (Var XMSVer,DriverRev: Word);            *
;*    Vrti verziu XMS v BCD formte (XMSVer) a verziu driveru (DriverRev)    *
;******************************************************************************

PUBLIC GetXMSVersion
GetXMSVersion PROC FAR
 ARG DriverRev: DWord, XMSVer: DWord
 LOCAL XMSOrg: DWord
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,4
                    MOV    AX,4310h
                    INT    2FH
                    MOV    WORD PTR [XMSOrg],BX
                    MOV    WORD PTR [XMSOrg+2],ES
                    XOR    AH,AH
                    CALL   [XMSOrg]
                    LES    DI,[XMSVer]
                    MOV    ES:[DI],AX
                    LES    DI,[DriverRev]
                    MOV    ES:[DI],BX
                    MOV    SP,BP
                    POP    BP
                    RET
GetXMSVersion ENDP

;******************************************************************************
;*               Procedra XMSMemory (Var XMSMem,XMSFree: Word);              *
;*      Do premennej XMSMem vlo celkov vekos XMS a do XMSFree von      *
;*                       vekos XMS, vlo vekos v kB                      *
;******************************************************************************

PUBLIC XMSMemory
XMSMemory PROC FAR
 ARG XMSFree: DWord, XMSMem: DWord
 LOCAL XMSOrg: DWord
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,4
                    MOV    AX,4310h
                    INT    2FH
                    MOV    WORD PTR [XMSOrg],BX
                    MOV    WORD PTR [XMSOrg+2],ES
                    MOV    AH,8
                    CALL   [XMSOrg]
                    LES    DI,[XMSMem]
                    MOV    ES:[DI],AX
                    LES    DI,[XMSFree]
                    MOV    ES:[DI],DX
                    MOV    SP,BP
                    POP    BP
                    RET
XMSMemory ENDP

;******************************************************************************
;*      truktra TVESABuf - buffer pre vloenie VESA informcie o SVGA       *
;******************************************************************************

TVESABuf STRUC
  DB 512 DUP (?)
ENDS

;******************************************************************************
;*                      Funkcia PresentVESA: Boolean;                         *
;*               Zist, i video karta podporuje VESA funkcie                 *
;******************************************************************************

PUBLIC PresentVESA
PresentVESA PROC FAR
 LOCAL VESABuf: TVESABuf = VESAVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,VESAVar
                    MOV    AX,SS
                    MOV    ES,AX
                    LEA    DI,[VESABuf]
                    MOV    AX,4F00H
                    INT    10H
                    CMP    AL,4FH
                    JNE    @PVBad
                    OR     AH,AH
                    JNZ    @PVBad
                    MOV    AL,1
                    MOV    SP,BP
                    POP    BP
                    RET
         @PVBad:    XOR    AL,AL
                    MOV    SP,BP
                    POP    BP
                    RET
PresentVESA ENDP

;******************************************************************************
;*              Procedra GetVESAInfo (Var VESABuffer: TVESABuf);             *
;*            Vrti pole informcii o VESA-kompatibilnej videokarte           *
;*                     truktra poa je uveden vo VESA.TXT                  *
;******************************************************************************

PUBLIC GetVESAInfo
GetVESAInfo PROC FAR
 ARG VESABuffer: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    DI,[VESABuffer]
                    MOV    AX,4F00H
                    INT    10H
                    POP    BP
                    RET    4
GetVESAInfo ENDP

AdLibWrite PROC NEAR
                    PUSH   CX
                    OUT    DX,AL
                    MOV    CX,6
      @AdLibIn1:    IN     AL,DX
                    LOOP   @AdLibIn1
                    INC    DX
                    MOV    AL,AH
                    OUT    DX,AL
                    MOV    CX,36
      @AdLibIn2:    IN     AL,DX
                    LOOP   @AdLibIn2
                    DEC    DX
                    POP    CX
                    RET
AdLibWrite ENDP

PUBLIC DetectAdLib
DetectAdLib PROC FAR
                    MOV    SI,Offset AdLibPort     ;Port moze byt 218H,288H,318H a 388H
                    MOV    CX,4                    ;4-krat zistujeme kartu
     @DAStart:      MOV    AX,DS:[SI]              ;Nacitanie adresy
                    ADD    SI,2                    ;Dalsia adresa je pripravena
                    MOV    DX,AX                   ;do DX
                    MOV    AX,6004H
                    CALL   AdLibWrite
                    MOV    AX,8004H
                    CALL   AdLibWrite
                    IN     AL,DX
                    MOV    BL,AL
                    MOV    AX,0FF02H
                    CALL   AdLibWrite
                    MOV    AX,02104H
                    CALL   AdLibWrite
                    PUSH   CX
                    MOV    CX,01000H
       @DANothing:  LOOP   @DANothing
                    POP    CX
                    IN     AL,DX
                    MOV    BH,AL
                    MOV    AX,6004H
                    CALL   AdLibWrite
                    MOV    AX,8004H
                    CALL   AdLibWrite
                    AND    BH,0E0H
                    AND    BL,0E0H
                    OR     BL,BL
                    JZ     @Try2nd
                    LOOP   @DAStart
                    JMP    @AdLibEnd
       @Try2nd:     CMP    BH,0C0H
                    JE     @AdLibEnd
                    LOOP   @DAStart
       @AdLibEnd:   MOV    AL,CL
                    RET
DetectAdLib ENDP

PUBLIC DetectMPU401
DetectMPU401 PROC FAR
                    MOV    DX,330H                 ;MPU 401 na 330H ?
                    MOV    BX,DX
                    IN     AL,DX
                    CMP    AL,0FFH                 ;Je na porte -1 ?
                    JNZ    @MPUPresent             ;Ak je, skusime 300H
                    MOV    DX,300H                 ;MPU 401 na 300H ?
                    MOV    BX,DX
                    IN     AL,DX
                    CMP    AL,0FFH                 ;Je na porte -1 ?
                    JNZ    @MPUPresent
                    XOR    AL,AL                   ;Ak nie je
                    JMP    @DMPUEnd
       @MPUPresent: MOV    AL,1                    ;Inak mame MPU 401 na porte v BX
       @DMPUEnd:    RET
DetectMPU401 ENDP

;******************************************************************************
;*           Funkcia DetectSoundCard (Var Port,IRQ,DMA,DMA16: Word);          *
;*                                    0 - bez zvukovej karty                  *
;*                                    1 - Ad Lib                              *
;*                                 @  2 - Sound Blaster                       *
;*                                 @  3 - Sound Blaster Pro                   *
;*                                 @  4 - Sound Blaster 16                    *
;*                                 @  5 - Sound Blaster AWE 32                *
;*                                 @  6 - Gravis UltraSound                   *
;*                                 @  7 - Gravis UltraSound Max               *
;*                                    8 - Roland MPU-401                      *
;*                                 @  9 - Roland MT-32                        *
;*                                 @ 10 - ESS AudioDrive                      *
;*                                 @ 11 - ESS AudioDrive 688                  *
;* @ - planovane                                                              *
;******************************************************************************

PUBLIC DetectSoundCard
DetectSoundCard PROC FAR
 ARG DMA16: DWord, DMA: DWord, IRQ: DWord, PPort: DWord
                    PUSH   BP
                    MOV    BP,SP
                    CALL   DetectAdLib
                    OR     AL,AL
                    JZ     @MPU401                 ;AL = 0, nemame Ad Lib
                    MOV    SI,Offset AdLibPort
                    LES    DI,[PPort]
                    MOV    AH,4
                    SUB    AL,AH
                    XOR    AH,AH
                    SHL    AX,1
                    ADD    SI,AX
                    MOV    BX,DS:[SI]              ;Nacitanie adresy, kde je port
                    MOV    ES:[DI],BX              ;Nacitanie portu
                    MOV    AL,1                    ;AL = 1 -> Ad Lib
                    MOV    BX,0FFFFH
                    LES    DI,[IRQ]                ;Bez IRQ
                    MOV    ES:[DI],BX
                    LES    DI,[DMA]                ;Bez DMA
                    MOV    ES:[DI],BX
                    LES    DI,[DMA16]              ;Bez 16b DMA
                    MOV    ES:[DI],BX
                    JMP    @DSCEnd
       @MPU401:     CALL   DetectMPU401            ;Mame Roland MPU-401 ?
                    OR     AL,AL
                    JZ     @DSCEnd                 ;Ak nemame
                    MOV    AL,8                    ;Mame ho
                    LES    DI,[PPort]
                    MOV    ES:[DI],BX
                    MOV    BX,0FFFFH
                    LES    DI,[IRQ]                ;Bez IRQ
                    MOV    ES:[DI],BX
                    LES    DI,[DMA]                ;Bez DMA
                    MOV    ES:[DI],BX
                    LES    DI,[DMA16]              ;Bez 16b DMA
                    MOV    ES:[DI],BX
       @DSCEnd:     POP    BP
                    RET    16
DetectSoundCard ENDP

END
