;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Font

MODEL Medium

LOCALS

.286

.DATA

CharSpace    DW    0               ;Medzera medzi psmenami
LineSpace    DB    10H             ;Medzera medzi riadkami
CharHeight   DB    10H             ;Vka psmen, pre 8x6, 8x8, 8x14 a 8x16
WritePage    DW    0A000H          ;Segment obrazovky

.CODE

;******************************************************************************
;*           Procedra WriteFont (PFont,PString: Pointer; X,Y: Word,          *
;*                                Color: Byte);                               *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
; *           na pozciu X,Y farbou Color, priom pouva .AFT font           *
;******************************************************************************

PUBLIC WriteFont
WriteFont PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFEnd
          @WFL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
         @WFBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFNothi
                    MOV    DS:[SI],CH
                    JMP    @WFNothg
         @WFNothi:  MOV    DS:[SI],CL
         @WFNothg:  INC    SI
                    DEC    AL
                    JNZ    @WFBegin
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFL1
         @WFEnd:    POP    BP
                    RET
WriteFont ENDP

;******************************************************************************
;*          Procedra WriteFontHI (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Color: Byte);                              *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font.           *
;*               Hodnota farby sa po kadom stpci zvyuje o 1                *
;******************************************************************************

PUBLIC WriteFontHI
WriteFontHI PROC FAR 
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFHIEnd
        @WFHIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
       @WFHIBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFHINothi
                    MOV    DS:[SI],CH
                    JMP    @WFHINothg
       @WFHINothi:  MOV    DS:[SI],CL
       @WFHINothg:  INC    SI
                    INC    CH
                    DEC    AL
                    JNZ    @WFHIBegin
                    SUB    CH,8
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFHIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFHIL1
       @WFHIEnd:    POP    BP
                    RET    14
WriteFontHI ENDP

;******************************************************************************
;*          Procedra WriteFontHD (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Color: Byte);                              *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font.           *
;*               Hodnota farby sa po kadom stpci zniuje o 1                *
;******************************************************************************

PUBLIC WriteFontHD
WriteFontHD PROC FAR 
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFHDEnd
        @WFHDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
       @WFHDBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFHDNothi
                    MOV    DS:[SI],CH
                    JMP    @WFHDNothg
       @WFHDNothi:  MOV    DS:[SI],CL
       @WFHDNothg:  INC    SI
                    DEC    CH
                    DEC    AL
                    JNZ    @WFHDBegin
                    ADD    CH,8
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFHDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFHDL1
       @WFHDEnd:    POP    BP
                    RET    14
WriteFontHD ENDP

;******************************************************************************
;*          Procedra WriteFontVI (PFont,PString: Pointer; X,Y: Word,         *
;*                                Color: Byte);                               *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font.           *
;*               Hodnota farby sa po kadom riadku zvyuje o 1                *
;******************************************************************************

PUBLIC WriteFontVI
WriteFontVI PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFVIEnd
        @WFVIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
       @WFVIBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFVINothi
                    MOV    DS:[SI],CH
                    JMP    @WFVINothg
       @WFVINothi:  MOV    DS:[SI],CL
       @WFVINothg:  INC    SI
                    DEC    AL
                    JNZ    @WFVIBegin
                    INC    CH
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFVIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFVIL1
       @WFVIEnd:    POP    BP
                    RET    14
WriteFontVI ENDP

;******************************************************************************
;*          Procedra WriteFontVD (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Color: Byte);                              *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font.           *
;*               Hodnota farby sa po kadom riadku zniuje o 1                *
;******************************************************************************

PUBLIC WriteFontVD
WriteFontVD PROC FAR 
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFVDEnd
        @WFVDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
       @WFVDBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFVDNothi
                    MOV    DS:[SI],CH
                    JMP    @WFVDNothg
       @WFVDNothi:  MOV    DS:[SI],CL
       @WFVDNothg:  INC    SI
                    DEC    AL
                    JNZ    @WFVDBegin
                    DEC    CH
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFVDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFVDL1
       @WFVDEnd:    POP    BP
                    RET    14
WriteFontVD ENDP

;******************************************************************************
;*         Procedra WriteFontOver (PFont,PString: Pointer; X,Y: Word,        *
;*                                  Color: Byte);                             *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font,           *
;*                        nevykresuje body s farbou 0.                       *
;******************************************************************************

PUBLIC WriteFontOver
WriteFontOver PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFOEnd
         @WFOL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
        @WFOBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFONothg
                    MOV    DS:[SI],CH
        @WFONothg:  INC    SI
                    DEC    AL
                    JNZ    @WFOBegin
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFOBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFOL1
        @WFOEnd:    POP    BP
                    RET    14
WriteFontOver ENDP

;******************************************************************************
;*        Procedra WriteFontOverHI (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Color: Byte);                            *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font,           *
;*                       nevykresuje body s farbou 0.                        *
;*               Hodnota farby sa po kadom stpci zvyuje o 1                *
;******************************************************************************

PUBLIC WriteFontOverHI
WriteFontOverHI PROC FAR 
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFOHIEnd
       @WFOHIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
      @WFOHIBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFOHINothg
                    MOV    DS:[SI],CH
      @WFOHINothg:  INC    SI
                    INC    CH
                    DEC    AL
                    JNZ    @WFOHIBegin
                    SUB    CH,8
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFOHIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFOHIL1
      @WFOHIEnd:    POP    BP
                    RET    14
WriteFontOverHI ENDP

;******************************************************************************
;*        Procedra WriteFontOverHD (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Color: Byte);                            *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font,           *
;*                       nevykresuje body s farbou 0.                        *
;*               Hodnota farby sa po kadom stpci zniuje o 1                *
;******************************************************************************

PUBLIC WriteFontOverHD
WriteFontOverHD PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFOHDEnd
       @WFOHDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
      @WFOHDBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFOHDNothg
                    MOV    DS:[SI],CH
      @WFOHDNothg:  INC    SI
                    DEC    CH
                    DEC    AL
                    JNZ    @WFOHDBegin
                    ADD    CH,8
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFOHDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFOHDL1
      @WFOHDEnd:    POP    BP
                    RET    14
WriteFontOverHD ENDP

;******************************************************************************
;*        Procedra WriteFontOverVD (PFont,PString: Pointer; X,Y: Word,       *
;*                                  Color: Byte);                             *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font,           *
;*                       nevykresuje body s farbou 0.                        *
;*               Hodnota farby sa po kadom riadku zniuje o 1                *
;******************************************************************************

PUBLIC WriteFontOverVD
WriteFontOverVD PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFOVDEnd
       @WFOVDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
      @WFOVDBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFOVDNothg
                    MOV    DS:[SI],CH
      @WFOVDNothg:  INC    SI
                    DEC    AL
                    JNZ    @WFOVDBegin
                    DEC    CH
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFOVDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFOVDL1
      @WFOVDEnd:    POP    BP
                    RET    14
WriteFontOverVD ENDP

;******************************************************************************
;*        Procedra WriteFontOverVI (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Color: Byte);                            *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*           na pozciu X,Y farbou Color, priom pouva .AFT font,           *
;*                       nevykresuje body s farbou 0.                        *
;*               Hodnota farby sa po kadom riadku zvyuje o 1                *
;******************************************************************************

PUBLIC WriteFontOverVI
WriteFontOverVI PROC FAR 
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
                    PUSH   BP
                    MOV    BP,SP
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @WFOVIEnd
       @WFOVIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    SUB    AL,32
                    SHL    AX,6
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AX,0808H
      @WFOVIBegin:  MOV    CL,ES:[BX]
                    INC    BX
                    OR     CL,CL
                    JZ     @WFOVINothg
                    MOV    DS:[SI],CH
      @WFOVINothg:  INC    SI
                    DEC    AL
                    JNZ    @WFOVIBegin
                    INC    CH
                    ADD    SI,312
                    MOV    AL,8
                    DEC    AH
                    JNZ    @WFOVIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @WFOVIL1
      @WFOVIEnd:    POP    BP
                    RET    14
WriteFontOverVI ENDP

;******************************************************************************
;*           Procedra PrintFont (PFont,PString: Pointer; X,Y: Word,          *
;*                                Height,Color: Byte);                        *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*                        rka a Heigth vka fontu.                         *
;******************************************************************************

PUBLIC PrintFont
PrintFont PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFEnd
          @PFL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
         @PFBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFNothi
                    MOV    DS:[SI],CH
                    JMP    @PFNothg
         @PFNothi:  MOV    DS:[SI],CL
         @PFNothg:  INC    SI
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFBegin
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFL1
         @PFEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFont ENDP

;******************************************************************************
;*         Procedra PrintFontOver (PFont,PString: Pointer; X,Y: Word,        *
;*                                  Height,Color: Byte);                      *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*         rka a Heigth vka fontu, nevykresuje body s farbou 0.          *
;******************************************************************************

PUBLIC PrintFontOver
PrintFontOver PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFOEnd
         @PFOL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
        @PFOBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFONothg
                    MOV    DS:[SI],CH
        @PFONothg:  INC    SI
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFOBegin
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFOBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFOL1
        @PFOEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontOver ENDP

;******************************************************************************
;*          Procedra PrintFontHI (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Height,Color: Byte);                       *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*                        rka a Heigth vka fontu.                         *
;*               Hodnota farby sa po kadom stpci zvyuje o 1                *
;******************************************************************************

PUBLIC PrintFontHI
PrintFontHI PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFHIEnd
        @PFHIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
       @PFHIBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFHINothi
                    MOV    DS:[SI],CH
                    JMP    @PFHINothg
       @PFHINothi:  MOV    DS:[SI],CL
       @PFHINothg:  INC    SI
                    INC    CH
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFHIBegin
                    MOV    CH,[Color]
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFHIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFHIL1
       @PFHIEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontHI ENDP

;******************************************************************************
;*          Procedra PrintFontHD (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Height,Color: Byte);                       *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*                        rka a Heigth vka fontu.                         *
;*               Hodnota farby sa po kadom stpci zniuje o 1                *
;******************************************************************************

PUBLIC PrintFontHD
PrintFontHD PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Scale: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFHDEnd
        @PFHDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
       @PFHDBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFHDNothi
                    MOV    DS:[SI],CH
                    JMP    @PFHDNothg
       @PFHDNothi:  MOV    DS:[SI],CL
       @PFHDNothg:  INC    SI
                    DEC    CH
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFHDBegin
                    MOV    CH,[Color]
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFHDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFHDL1
       @PFHDEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontHD ENDP

;******************************************************************************
;*          Procedra PrintFontVI (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Height,Color: Byte);                       *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*                        rka a Heigth vka fontu.                         *
;*               Hodnota farby sa po kadom riadku zvyuje o 1                *
;******************************************************************************

PUBLIC PrintFontVI
PrintFontVI PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFVIEnd
        @PFVIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
       @PFVIBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFVINothi
                    MOV    DS:[SI],CH
                    JMP    @PFVINothg
       @PFVINothi:  MOV    DS:[SI],CL
       @PFVINothg:  INC    SI
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFVIBegin
                    MOV    DL,80H
                    INC    CH
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFVIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFVIL1
       @PFVIEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontVI ENDP

;******************************************************************************
;*          Procedra PrintFontVD (PFont,PString: Pointer; X,Y: Word,         *
;*                                 Height,Color: Byte);                       *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*                        rka a Heigth vka fontu.                         *
;*               Hodnota farby sa po kadom riadku zniuje o 1                *
;******************************************************************************

PUBLIC PrintFontVD
PrintFontVD PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Scale: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFVDEnd
        @PFVDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
       @PFVDBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFVDNothi
                    MOV    DS:[SI],CH
                    JMP    @PFVDNothg
       @PFVDNothi:  MOV    DS:[SI],CL
       @PFVDNothg:  INC    SI
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFVDBegin
                    MOV    DL,80H
                    DEC    CH
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFVDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFVDL1
       @PFVDEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontVD ENDP

;******************************************************************************
;*        Procedra PrintFontOverHI (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Height,Color: Byte);                     *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*         rka a Heigth vka fontu, nevykresuje body s farbou 0.          *
;*               Hodnota farby sa po kadom stpci zvyuje o 1                *
;******************************************************************************

PUBLIC PrintFontOverHI
PrintFontOverHI PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFOHIEnd
       @PFOHIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
      @PFOHIBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFOHINothg
                    MOV    DS:[SI],CH
      @PFOHINothg:  INC    SI
                    SHR    DL,1
                    INC    CH
                    DEC    AL
                    JNZ    @PFOHIBegin
                    MOV    CH,[Color]
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFOHIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFOHIL1
      @PFOHIEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontOverHI ENDP

;******************************************************************************
;*        Procedra PrintFontOverHD (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Height,Color: Byte);                     *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*         rka a Heigth vka fontu, nevykresuje body s farbou 0.          *
;*               Hodnota farby sa po kadom stpci zniuje o 1                *
;******************************************************************************

PUBLIC PrintFontOverHD
PrintFontOverHD PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFOHDEnd
       @PFOHDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
      @PFOHDBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFOHDNothg
                    MOV    DS:[SI],CH
      @PFOHDNothg:  INC    SI
                    SHR    DL,1
                    DEC    CH
                    DEC    AL
                    JNZ    @PFOHDBegin
                    MOV    CH,[Color]
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFOHDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFOHDL1
      @PFOHDEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontOverHD ENDP

;******************************************************************************
;*        Procedra PrintFontOverVI (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Height,Color: Byte);                     *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*         rka a Heigth vka fontu, nevykresuje body s farbou 0.          *
;*               Hodnota farby sa po kadom riadku zvyuje o 1                *
;******************************************************************************

PUBLIC PrintFontOverVI
PrintFontOverVI PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFOVIEnd
       @PFOVIL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
      @PFOVIBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFOVINothg
                    MOV    DS:[SI],CH
      @PFOVINothg:  INC    SI
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFOVIBegin
                    INC    CH
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFOVIBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFOVIL1
      @PFOVIEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontOverVI ENDP

;******************************************************************************
;*        Procedra PrintFontOverVD (PFont,PString: Pointer; X,Y: Word,       *
;*                                   Height,Color: Byte);                     *
;*   Vype text, na ktor ukazuje PString fontom, na ktor ukazuje PFont,    *
;*   na pozciu X,Y farbou Color, priom font m rozmer 8xHeight, kde 8 je    *
;*         rka a Heigth vka fontu, nevykresuje body s farbou 0.          *
;*               Hodnota farby sa po kadom riadku zniuje o 1                *
;******************************************************************************

PUBLIC PrintFontOverVD
PrintFontOverVD PROC FAR
 ARG Color: Byte, Y: Word, X: Word, PString: DWord, PFont: DWord
 LOCAL Height: Byte, Space: Word = PrintVar
                    PUSH   BP
                    MOV    BP,SP
                    SUB    SP,PrintVar
                    MOV    AX,[CharSpace]
                    MOV    [Space],AX
                    MOV    AL,[CharHeight]
                    MOV    [Height],AL
                    LES    BX,[PString]
                    MOV    CL,ES:[BX]
                    XOR    CH,CH
                    OR     CL,CL
                    JZ     @PFOVDEnd
       @PFOVDL1:    PUSH   CX
                    INC    BX
                    XOR    AH,AH
                    MOV    AL,ES:[BX]
                    MUL    [Height]
                    PUSH   ES
                    PUSH   BX
                    LES    BX,[PFont]
                    ADD    BX,AX
                    MOV    AX,[Y]
                    MOV    DX,AX
                    SHL    AX,8
                    SHL    DX,6
                    ADD    AX,DX
                    MOV    CL,CH
                    XOR    CH,CH
                    MOV    DX,CX
                    SHL    CX,3
                    ADD    AX,CX
                    ADD    AX,[X]
                    MOV    SI,AX
                    XCHG   AX,DX
                    MUL    [Space]
                    ADD    SI,AX
                    MOV    CH,[Color]
                    PUSH   DS
                    MOV    AX,[WritePage]
                    MOV    DS,AX
                    MOV    AL,8
                    XOR    AH,AH
                    MOV    DI,320
                    SUB    DI,AX
                    MOV    AH,[Height]
                    MOV    DL,80H
      @PFOVDBegin:  MOV    CL,ES:[BX]
                    AND    CL,DL
                    JZ     @PFOVDNothg
                    MOV    DS:[SI],CH
      @PFOVDNothg:  INC    SI
                    SHR    DL,1
                    DEC    AL
                    JNZ    @PFOVDBegin
                    DEC    CH
                    MOV    DL,80H
                    INC    BX
                    ADD    SI,DI
                    MOV    AL,8
                    DEC    AH
                    JNZ    @PFOVDBegin
                    POP    DS
                    POP    BX
                    POP    ES
                    POP    CX
                    INC    CH
                    DEC    CL
                    JNZ    @PFOVDL1
      @PFOVDEnd:    MOV    SP,BP
                    POP    BP
                    RET    14
PrintFontOverVD ENDP

;******************************************************************************
;*                   Procedra SetCharSpace (Space: Word);                    *
;*        Nastav premenn CharSpace tak, aby urovala medzeru medzi          *
;*                   znakmi v procedrach PrintFontXXXXYY                     *
;******************************************************************************

PUBLIC SetCharSpace
SetCharSpace PROC FAR
 ARG Space: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[Space]
                    MOV    [CharSpace],AX
                    POP    BP
                    RET    2
SetCharSpace ENDP

;******************************************************************************
;*                        Funkcia GetCharSpace : Word;                        *
;*         Vrti hodnotu premennej CharSpace, medzery medzi psmenami         *
;******************************************************************************

PUBLIC GetCharSpace
GetCharSpace PROC FAR
                    MOV    AX,[CharSpace]
                    RET
GetCharSpace ENDP

;******************************************************************************
;*                   Procedra SetLineSpace (Space: Byte);                    *
;*    Nastav premenn LineSpace tak, aby urovala medzeru medzi riadkami     *
;******************************************************************************

PUBLIC SetLineSpace
SetLineSpace PROC FAR
 ARG Space: Byte
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,[Space]
                    MOV    [LineSpace],AL
                    POP    BP
                    RET    2
SetLineSpace ENDP

;******************************************************************************
;*                        Funkcia GetLineSpace : Byte;                        *
;*         Vrti hodnotu premennej LineSpace, medzery medzi riadkami          *
;******************************************************************************

PUBLIC GetLineSpace
GetLineSpace PROC FAR
                    MOV    AL,[LineSpace]
                    RET
GetLineSpace ENDP

;******************************************************************************
;*                   Procedra SetCharHeight (Space: Byte);                   *
;*         Nastav premenn CharHeight tak, aby urovala vku fontu          *
;*          v procedrach PrintFontXXXXYY (8x6, 8x8, 8x14, 8x16...)           *
;******************************************************************************

PUBLIC SetCharHeight
SetCharHeight PROC FAR
 ARG Height: Byte
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AL,[Height]
                    MOV    [CharHeight],AL
                    POP    BP
                    RET    2
SetCharHeight ENDP

;******************************************************************************
;*                        Funkcia GetCharHeight : Byte;                       *
;*         Vrti hodnotu premennej CharHeight, vky psmen vo fonte          *
;******************************************************************************

PUBLIC GetCharHeight
GetCharHeight PROC FAR
                    MOV    AL,[CharHeight]
                    RET
GetCharHeight ENDP

;******************************************************************************
;*                   Procedra SetWritePage (WPage: Word);                    *
;*      Nastav premenn WritePage tak, aby urovala segment obrazovky,       *
;*                          do ktorej chceme psa                            *
;******************************************************************************

PUBLIC SetWritePage
SetWritePage PROC FAR
 ARG WPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[WPage]
                    MOV    [WritePage],AX
                    POP    BP
                    RET    2
SetWritePage ENDP

;******************************************************************************
;*                        Funkcia GetWritePage : Word;                        *
;*     Vrti hodnotu premennej WritePage, obrazovky, do ktorej zapisujeme     *
;******************************************************************************

PUBLIC GetWritePage
GetWritePage PROC FAR
                    MOV    AX,[WritePage]
                    RET
GetWritePage ENDP

END