;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Circle

MODEL Medium

LOCALS

.286

.DATA

CirclePage   DW    0A000H
ClipMinX     DW    0
ClipMaxX     DW    319
ClipMinY     DW    0
ClipMaxY     DW    199

.CODE

;******************************************************************************
;*     Makro Point - vykresuje bod v procedrach Circle a CircleVirtual      *
;******************************************************************************

POINT MACRO
                    MOV    SI,BX
                    MOV    DI,SI
                    SHL    SI,8
                    SHL    DI,6
                    ADD    DI,SI
                    ADD    DI,AX
                    MOV    AL,[Color]
                    MOV    ES:[DI],AL
      ENDM

;******************************************************************************
;*      Makro Line - vykresuje vodorovn iaru v procedre FilledCircle      *
;******************************************************************************

LINE MACRO
                    MOV    SI,BX
                    MOV    DI,SI
                    SHL    SI,8
                    SHL    DI,6
                    ADD    DI,SI
                    ADD    DI,AX
                    MOV    BX,CX
                    AND    BX,1
                    SHR    CX,1
                    MOV    AL,[Color]
                    MOV    AH,AL
                    REP    STOSW
                    MOV    CX,BX
                    STOSB
                    POP    CX
     ENDM

;******************************************************************************
;*                Procedra Circle (X,Y,R: Word; Color: Byte);                *
;*       Vykresl krunicu so stredom v X,Y a polomerom R farbou Color        *
;******************************************************************************

PUBLIC Circle
Circle PROC FAR
 ARG Color: Byte, R: Word, Y: Word, X: Word
 LOCAL XD: Word, YD: Word = CircleVar
                    PUSH   BP               ;CX = X, DX = Y, BX = P
                    MOV    BP,SP
                    SUB    SP,CircleVar
                    MOV    AX,[CirclePage]
                    MOV    ES,AX
                    XOR    CX,CX
                    MOV    DX,[R]
                    MOV    BX,1
                    SUB    BX,[R]
                    MOV    [XD],3
                    MOV    AX,[R]
                    SHL    AX,1
                    SUB    AX,2
                    MOV    [YD],AX
        @CRepeat:   PUSH   BX
                    MOV    AX,[X]
                    ADD    AX,CX
                    MOV    BX,[Y]
                    ADD    BX,DX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[Y]
                    ADD    BX,DX
                    POINT
                    MOV    AX,[X]
                    ADD    AX,CX
                    MOV    BX,[Y]
                    SUB    BX,DX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[Y]
                    SUB    BX,DX
                    POINT
                    MOV    AX,[X]
                    ADD    AX,DX
                    MOV    BX,[Y]
                    ADD    BX,CX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[Y]
                    ADD    BX,CX
                    POINT
                    MOV    AX,[X]
                    ADD    AX,DX
                    MOV    BX,[Y]
                    SUB    BX,CX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[Y]
                    SUB    BX,CX
                    POINT
                    POP    BX
                    MOV    AX,BX
                    AND    AX,8000H
                    JNZ    @CNext
                    SUB    BX,[YD]
                    SUB    [YD],2
                    DEC    DX
          @CNext:   ADD    BX,[XD]
                    ADD    [XD],2
                    INC    CX
                    MOV    AX,DX
                    AND    AX,8000H
                    JNZ    @CEnd
          @CSign:   CMP    CX,DX
          @CEnd:    JA     @CRet
                    JMP    @CRepeat
          @CRet:    MOV    SP,BP
                    POP    BP
                    RET    8
Circle ENDP

;******************************************************************************
;*       Procedra CircleVirtual (SegVirtual,X,Y,R: Word; Color: Byte);       *
;*       Vykresl krunicu so stredom v X,Y a polomerom R farbou Color        *
;*                    na obrazovku na segmente SegVirtual                     *
;******************************************************************************

PUBLIC CircleVirtual
CircleVirtual PROC FAR
 ARG Color: Byte, R: Word, Y: Word, X: Word, SegVirtual: Word
 LOCAL XD: Word, YD: Word = CircleVar
                    PUSH   BP               ;CX = X, DX = Y, BX = P
                    MOV    BP,SP
                    SUB    SP,CircleVar
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    XOR    CX,CX
                    MOV    DX,[R]
                    MOV    BX,1
                    SUB    BX,[R]
                    MOV    [XD],3
                    MOV    AX,[R]
                    SHL    AX,1
                    SUB    AX,2
                    MOV    [YD],AX
        @CVRepeat:  PUSH   BX
                    MOV    AX,[X]
                    ADD    AX,CX
                    MOV    BX,[Y]
                    ADD    BX,DX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[Y]
                    ADD    BX,DX
                    POINT
                    MOV    AX,[X]
                    ADD    AX,CX
                    MOV    BX,[Y]
                    SUB    BX,DX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[Y]
                    SUB    BX,DX
                    POINT
                    MOV    AX,[X]
                    ADD    AX,DX
                    MOV    BX,[Y]
                    ADD    BX,CX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[Y]
                    ADD    BX,CX
                    POINT
                    MOV    AX,[X]
                    ADD    AX,DX
                    MOV    BX,[Y]
                    SUB    BX,CX
                    POINT
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[Y]
                    SUB    BX,CX
                    POINT
                    POP    BX
                    MOV    AX,BX
                    AND    AX,8000H
                    JNZ    @CVNext
                    SUB    BX,[YD]
                    SUB    [YD],2
                    DEC    DX
          @CVNext:  ADD    BX,[XD]
                    ADD    [XD],2
                    INC    CX
                    MOV    AX,DX
                    AND    AX,8000H
                    JNZ    @CVEnd
          @CVSign:  CMP    CX,DX
          @CVEnd:   JA     @CVRet
                    JMP    @CVRepeat
          @CVRet:   MOV    SP,BP
                    POP    BP
                    RET    10
CircleVirtual ENDP

;******************************************************************************
;*            Procedra FilledCircle (X,Y,R: Word; Color: Byte);              *
;*         Vykresl kruh so stredom X,Y a polomerom R farbou Color            *
;******************************************************************************

PUBLIC FilledCircle
FilledCircle PROC FAR
 ARG Color: Byte, R: Word, Y: Word, X: Word
 LOCAL XD: Word, YD: Word = CircleVar
                    PUSH   BP               ;CX = X, DX = Y, BX = P
                    MOV    BP,SP
                    SUB    SP,CircleVar
                    MOV    AX,[CirclePage]
                    MOV    ES,AX
                    XOR    CX,CX
                    MOV    DX,[R]
                    MOV    BX,1
                    SUB    BX,[R]
                    MOV    [XD],3
                    MOV    AX,[R]
                    SHL    AX,1
                    SUB    AX,2
                    MOV    [YD],AX
        @FCRepeat:  PUSH   BX
                    PUSH   CX
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[X]
                    ADD    BX,CX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    ADD    BX,DX
                    LINE
                    PUSH   CX
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[X]
                    ADD    BX,CX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    SUB    BX,DX
                    LINE
                    PUSH   CX
                    MOV    DI,CX
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[X]
                    ADD    BX,DX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    ADD    BX,DI
                    LINE
                    PUSH   CX
                    MOV    DI,CX
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[X]
                    ADD    BX,DX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    SUB    BX,DI
                    LINE
                    POP    BX
                    MOV    AX,BX
                    AND    AX,8000H
                    JNZ    @FCNext
                    SUB    BX,[YD]
                    SUB    [YD],2
                    DEC    DX
          @FCNext:  ADD    BX,[XD]
                    ADD    [XD],2
                    INC    CX
                    MOV    AX,DX
                    AND    AX,8000H
                    JNZ    @FCEnd
          @FCSign:  CMP    CX,DX
          @FCEnd:   JA     @FCRet
                    JMP    @FCRepeat
          @FCRet:   MOV    SP,BP
                    POP    BP
                    RET    8
FilledCircle ENDP

;******************************************************************************
;*    Procedra FilledCircleVirtual (SegVirtual,X,Y,R: Word; Color: Byte);    *
;*         Vykresl kruh so stredom X,Y a polomerom R farbou Color            *
;*                    na obrazovku na segmente SegVirtual                     *
;******************************************************************************

PUBLIC FilledCircleVirtual
FilledCircleVirtual PROC FAR
 ARG Color: Byte, R: Word, Y: Word, X: Word, SegVirtual: Word
 LOCAL XD: Word, YD: Word = CircleVar
                    PUSH   BP               ;CX = X, DX = Y, BX = P
                    MOV    BP,SP
                    SUB    SP,CircleVar
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    XOR    CX,CX
                    MOV    DX,[R]
                    MOV    BX,1
                    SUB    BX,[R]
                    MOV    [XD],3
                    MOV    AX,[R]
                    SHL    AX,1
                    SUB    AX,2
                    MOV    [YD],AX
        @FCVRepeat: PUSH   BX
                    PUSH   CX
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[X]
                    ADD    BX,CX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    ADD    BX,DX
                    LINE
                    PUSH   CX
                    MOV    AX,[X]
                    SUB    AX,CX
                    MOV    BX,[X]
                    ADD    BX,CX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    SUB    BX,DX
                    LINE
                    PUSH   CX
                    MOV    DI,CX
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[X]
                    ADD    BX,DX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    ADD    BX,DI
                    LINE
                    PUSH   CX
                    MOV    DI,CX
                    MOV    AX,[X]
                    SUB    AX,DX
                    MOV    BX,[X]
                    ADD    BX,DX
                    MOV    CX,BX
                    SUB    CX,AX
                    MOV    BX,[Y]
                    SUB    BX,DI
                    LINE
                    POP    BX
                    MOV    AX,BX
                    AND    AX,8000H
                    JNZ    @FCVNext
                    SUB    BX,[YD]
                    SUB    [YD],2
                    DEC    DX
        @FCVNext:   ADD    BX,[XD]
                    ADD    [XD],2
                    INC    CX
                    MOV    AX,DX
                    AND    AX,8000H
                    JNZ    @FCVEnd
        @FCVSign:   CMP    CX,DX
        @FCVEnd:    JA     @FCVRet
                    JMP    @FCVRepeat
        @FCVRet:    MOV    SP,BP
                    POP    BP
                    RET    10
FilledCircleVirtual ENDP

;******************************************************************************
;*          Procedra FilledCircleClip (X,Y,R: Word; Color: Byte);            *
;*         Vykresl kruh so stredom X,Y a polomerom R farbou Color            *
;******************************************************************************

PUBLIC FilledCircleClip
FilledCircleClip PROC FAR
 ARG Color: Byte, R: Word, YS: Word, XS: Word
 LOCAL DiX: Word, DiY: Word, X: Word, Y: Word = CircleVar
                    PUSH BP               ;CX = X, DX = Y, BX = P
                    MOV  BP,SP
                    SUB  SP,CircleVar
                    MOV  AX,[CirclePage]
                    MOV  ES,AX
                    XOR  CX,CX
                    MOV  DX,[R]
                    OR   DX,DX
                    JNZ  @ML
                    JMP  @FCCPoint
	 @ML:       MOV  SI,1
                    SUB  SI,DX
                    MOV  AX,3
                    MOV  BX,[R]
                    SHL  BX,1
                    SUB  BX,2
         @LoopLine: MOV  [X],CX
                    MOV  [Y],DX
                    MOV  [DiX],AX
                    MOV  [DiY],BX
                    MOV  DX,[XS]
                    SUB  DX,[X]
                    CMP  DX,[ClipMinX]
                    JNB  @Te11
                    MOV  DX,[ClipMinX]
         @Te11:     OR   DX,DX
                    JNS  @Te12
                    MOV  DX,[ClipMinX]
         @Te12:     ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
		    JNA  @Te13
                    MOV  CX,[ClipMaxX]
         @Te13:     CMP  CX,DX
                    JB   @No11
                    MOV  BX,[YS]
                    ADD  BX,[Y]
                    CMP  BX,[ClipMinY]
                    JB   @No11
                    CMP  BX,[ClipMaxY]
                    JA   @No11
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
                    MOV  DI,BX
                    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
                    AND  BX,1
		    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No11:     MOV  CX,[X]
                    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    MOV  DX,[XS]
                    SUB  DX,[X]
                    CMP  DX,[ClipMinX]
                    JNB  @Te21
                    MOV  DX,[ClipMinX]
         @Te21:     OR   DX,DX
                    JNS  @Te22
                    MOV  DX,[ClipMinX]
         @Te22:     ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
		    JNA  @Te23
                    MOV  CX,[ClipMaxX]
         @Te23:     CMP  CX,DX
                    JB   @No21
                    MOV  BX,[YS]
                    SUB  BX,[Y]
                    CMP  BX,[ClipMinY]
                    JB   @No21
                    CMP  BX,[ClipMaxY]
                    JA   @No21
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
                    MOV  DI,BX
                    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
                    AND  BX,1
		    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No21:     MOV  CX,[X]
                    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    MOV  DX,[XS]
                    SUB  DX,[Y]
                    CMP  DX,[ClipMinX]
                    JNB  @Te31
                    MOV  DX,[ClipMinX]
         @Te31:     OR   DX,DX
                    JNS  @Te32
                    MOV  DX,[ClipMinX]
         @Te32:     MOV  CX,[Y]
                    ADD  CX,[XS]
		    CMP  CX,[ClipMaxX]
                    JNA  @Te33
                    MOV  CX,[ClipMaxX]
         @Te33:     CMP  CX,DX
                    JB   @No31
                    MOV  BX,[YS]
                    SUB  BX,[X]
                    CMP  BX,[ClipMinY]
                    JB   @No31
                    CMP  BX,[ClipMaxY]
                    JA   @No31
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
                    MOV  DI,BX
                    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
		    AND  BX,1
                    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No31:     MOV  CX,[X]
                    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    MOV  DX,[XS]
                    SUB  DX,[Y]
                    CMP  DX,[ClipMinX]
                    JNB  @Te41
                    MOV  DX,[ClipMinX]
         @Te41:     OR   DX,DX
                    JNS  @Te42
                    MOV  DX,[ClipMinX]
         @Te42:     MOV  CX,[Y]
		    ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
                    JNA  @Te43
                    MOV  CX,[ClipMaxX]
         @Te43:     CMP  CX,DX
                    JB   @No41
                    MOV  BX,[YS]
                    ADD  BX,[X]
                    CMP  BX,[ClipMinY]
                    JB   @No41
                    CMP  BX,[ClipMaxY]
                    JA   @No41
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
                    MOV  DI,BX
                    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
		    MOV  BX,CX
                    AND  BX,1
                    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No41:     MOV  CX,[X]
                    MOV  DX,[Y]
		    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    OR   SI,SI
                    JS   @SkipAdd
                    SUB  SI,BX
                    SUB  BX,2
                    DEC  DX
         @SkipAdd:  ADD  SI,AX
                    ADD  AX,2
                    INC  CX
		    CMP  CX,DX
                    JA   @FCCEnd
                    JMP  @LoopLine
         @FCCEnd:   MOV  SP,BP
                    POP  BP
                    RET  8
         @FCCPoint: MOV  AX,[YS]
                    MOV  DI,AX
                    SHL  AX,8
                    SHL  DI,6
		    ADD  DI,AX
		    ADD  DI,[XS]
		    MOV  AL,[Color]
		    STOSB
		    JMP  @FCCEnd
FilledCircleClip ENDP

;******************************************************************************
;*  Procedra FilledCircleClipVirtual (SegVirtual,X,Y,R: Word; Color: Byte);  *
;*         Vykresl kruh so stredom X,Y a polomerom R farbou Color            *
;******************************************************************************

PUBLIC FilledCircleClipVirtual
FilledCircleClipVirtual PROC FAR
 ARG Color: Byte, R: Word, YS: Word, XS: Word, SegVirtual: Word
 LOCAL DiX: Word, DiY: Word, X: Word, Y: Word = CircleVar
                    PUSH BP               ;CX = X, DX = Y, BX = P
                    MOV  BP,SP
                    SUB  SP,CircleVar
                    MOV  AX,[SegVirtual]
		    MOV  ES,AX
                    XOR  CX,CX
                    MOV  DX,[R]
                    OR   DX,DX
                    JNZ  @MLV
                    JMP  @FCLPoint
         @MLV:      MOV  SI,1
                    SUB  SI,DX
                    MOV  AX,3
                    MOV  BX,[R]
                    SHL  BX,1
                    SUB  BX,2
        @LoopLineV: MOV  [X],CX
		    MOV  [Y],DX
                    MOV  [DiX],AX
                    MOV  [DiY],BX
                    MOV  DX,[XS]
                    SUB  DX,[X]
                    CMP  DX,[ClipMinX]
                    JNB  @Te11V
		    MOV  DX,[ClipMinX]
         @Te11V:    OR   DX,DX
                    JNS  @Te12V
                    MOV  DX,[ClipMinX]
         @Te12V:    ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
                    JNA  @Te13V
                    MOV  CX,[ClipMaxX]
         @Te13V:    CMP  CX,DX
                    JB   @No11V
                    MOV  BX,[YS]
                    ADD  BX,[Y]
                    CMP  BX,[ClipMinY]
		    JB   @No11V
                    CMP  BX,[ClipMaxY]
                    JA   @No11V
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
                    MOV  DI,BX
		    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
                    AND  BX,1
                    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No11V:    MOV  CX,[X]
		    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    MOV  DX,[XS]
                    SUB  DX,[X]
                    CMP  DX,[ClipMinX]
                    JNB  @Te21V
		    MOV  DX,[ClipMinX]
         @Te21V:    OR   DX,DX
                    JNS  @Te22V
                    MOV  DX,[ClipMinX]
         @Te22V:    ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
                    JNA  @Te23V
                    MOV  CX,[ClipMaxX]
         @Te23V:    CMP  CX,DX
                    JB   @No21V
                    MOV  BX,[YS]
                    SUB  BX,[Y]
                    CMP  BX,[ClipMinY]
                    JB   @No21V
                    CMP  BX,[ClipMaxY]
                    JA   @No21V
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
                    MOV  DI,BX
		    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
                    AND  BX,1
                    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No21V:    MOV  CX,[X]
                    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    MOV  DX,[XS]
                    SUB  DX,[Y]
                    CMP  DX,[ClipMinX]
                    JNB  @Te31V
		    MOV  DX,[ClipMinX]
         @Te31V:    OR   DX,DX
                    JNS  @Te32V
                    MOV  DX,[ClipMinX]
         @Te32V:    MOV  CX,[Y]
                    ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
                    JNA  @Te33V
                    MOV  CX,[ClipMaxX]
         @Te33V:    CMP  CX,DX
                    JB   @No31V
                    MOV  BX,[YS]
                    SUB  BX,[X]
                    CMP  BX,[ClipMinY]
                    JB   @No31V
                    CMP  BX,[ClipMaxY]
                    JA   @No31V
                    MOV  AX,DX
                    SUB  CX,DX
                    INC  CX
		    MOV  DI,BX
                    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
                    AND  BX,1
                    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No31V:    MOV  CX,[X]
                    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    MOV  DX,[XS]
                    SUB  DX,[Y]
                    CMP  DX,[ClipMinX]
		    JNB  @Te41V
                    MOV  DX,[ClipMinX]
         @Te41V:    OR   DX,DX
                    JNS  @Te42V
                    MOV  DX,[ClipMinX]
         @Te42V:    MOV  CX,[Y]
                    ADD  CX,[XS]
                    CMP  CX,[ClipMaxX]
                    JNA  @Te43V
                    MOV  CX,[ClipMaxX]
         @Te43V:    CMP  CX,DX
                    JB   @No41V
                    MOV  BX,[YS]
                    ADD  BX,[X]
                    CMP  BX,[ClipMinY]
                    JB   @No41V
                    CMP  BX,[ClipMaxY]
                    JA   @No41V
                    MOV  AX,DX
                    SUB  CX,DX
		    INC  CX
                    MOV  DI,BX
                    SHL  BX,6
                    SHL  DI,8
                    ADD  DI,BX
                    ADD  DI,AX
                    MOV  BX,CX
                    AND  BX,1
                    SHR  CX,1
                    MOV  AL,[Color]
                    MOV  AH,AL
                    REP  STOSW
                    MOV  CX,BX
                    REP  STOSB
         @No41V:    MOV  CX,[X]
                    MOV  DX,[Y]
                    MOV  AX,[DiX]
                    MOV  BX,[DiY]
                    OR   SI,SI
                    JS   @SkipAddV
		    SUB  SI,BX
                    SUB  BX,2
                    DEC  DX
         @SkipAddV: ADD  SI,AX
                    ADD  AX,2
                    INC  CX
                    CMP  CX,DX
                    JA   @FCLEnd
                    JMP  @LoopLineV
         @FCLEnd:   MOV  SP,BP
                    POP  BP
                    RET  8
         @FCLPoint: MOV  AX,[YS]
                    MOV  DI,AX
                    SHL  AX,8
                    SHL  DI,6
                    ADD  DI,AX
                    ADD  DI,[XS]
                    MOV  AL,[Color]
                    STOSB
		    JMP  @FCLEnd
FilledCircleClipVirtual ENDP

;******************************************************************************
;*                   Procedra SetCirclePage (CPage: Word);                   *
;*      Nastav premenn CirclePage tak, aby urovala segment obrazovky,      *
;*                          do ktorej chceme kresli                          *
;******************************************************************************

PUBLIC SetCirclePage
SetCirclePage PROC FAR
 ARG CPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[CPage]
                    MOV    [CirclePage],AX
                    POP    BP
                    RET    2
SetCirclePage ENDP

;******************************************************************************
;*                        Funkcia GetCirclePage : Word;                       *
;*     Vrti hodnotu premennej CirclePage, obrazovky, do ktorej kreslme      *
;******************************************************************************

PUBLIC GetCirclePage
GetCirclePage PROC FAR
		    MOV    AX,[CirclePage]
		    RET
GetCirclePage ENDP

PUBLIC SetCircleClipRegion
SetCircleClipRegion PROC FAR
 ARG nMaxY: Word, nMinY: Word, nMaxX: Word, nMinX: Word
		    PUSH   BP
		    MOV    BP,SP
		    MOV    AX,[nMinX]
		    MOV    [ClipMinX],AX
		    MOV    AX,[nMaxX]
		    MOV    [ClipMaxX],AX
		    MOV    AX,[nMinY]
		    MOV    [ClipMinY],AX
		    MOV    AX,[nMaxY]
		    MOV    [ClipMaxY],AX
		    POP    BP
		    RET    8
SetCircleClipRegion ENDP

END